header {
   package com.sanrad.nms.server.cli;
   import com.sanrad.util.NetUtil;
}

// ---------------------------------
// LEXER
// ---------------------------------

class SpCliLexer extends Lexer;

DOT		:	'.'
		;

NUMBER	:	 ('0'..'9')+;

WORD	:	 ('a'..'z' | 'A'..'Z' | '$' | '-' | '_')+ ;

// New line
NEWLINE
    : '\n'
    ;

// White spaces
WS
    : (' '|'\t'|'\f'|'\r'|'\n')+ { $setType(Token.SKIP);}
    ;
    
// The character "
QUOTATION
	:	'"';
	

	



// ---------------------------------
// PARSER
// ---------------------------------
	
class SpCliParser extends Parser;

options {
        buildAST=true;
}

tokens {
    IP_PARAM = "-ip"; 
    VOL_PARAM = "-vol";
    CLI_PARAM = "-cli";
    VOLUME_KEYWORD = "volume";
    SNAPSHOT_KEYWORD = "snapshot";
    ACTIVATE_KEYWORD = "activate";
    DEACTIVATE_KEYWORD = "deactivate";
    QOS_KEYWORD = "QOS";
    QOS_ENABLE_KEYWORD = "enable";
    QOS_DISABLE_KEYWORD = "disable";
    QOS_LIMIT_KEYWORD = "limit";
}

{
    // Initially create an errornous command because of the command type 
	// until the type could be figured out. 
    private CliCommand result = new CliCommand(CliCommand.CliCommandType.UNKNOWN_TYPE_COMMAND, null);
    
    // Will hold the command type until the object is created.
    private CliCommand.CliCommandType myType = null;
    	
    // Will hold the volume name.
    private String myVolName = null;
    
    // Will hold the IP.
    private String myIp = null;
    
    // Will hold the QOS limit;
    private String myLimit = null;
    
    /**
     * This method will return the result.
     *
     * @return 
     *		The result.
     */
    
    public CliCommand getResult() {
    	return result;
    } 
}

cliCommand
	:	(WS)* ipSection (WS)* CLI_PARAM (WS)* (volumeCommand | qosCommand) (WS)* EOF! 
		{
			// Create the result object.
			if (myType != null) {
				result.setType(myType);
				result.setIp(myIp);
			}
			
			// Add the parameters to the result object.
			result.addParameter(new CliCommandParameter(
				CliCommandParameterType.VOLUME, myVolName));
			result.addParameter(new CliCommandParameter(
				CliCommandParameterType.COMMAND_TYPE, myType));	
		};
		

ipSection
	:	IP_PARAM (WS)* ip
	;

ip	:	NUMBER DOT NUMBER DOT NUMBER DOT NUMBER
	{
		if (#ip != null) {
			// Concatenate all the IP segments. 
			AST curAST = #ip;
			StringBuilder ipStr = new StringBuilder();
			while (curAST != null) {
				ipStr.append(curAST.getText());
				curAST = curAST.getNextSibling();
			}
			
			String ipString = ipStr.toString();
			if (NetUtil.isNetworkIpValid(ipString)) {
				myIp = ipString;
			}
		}
	}
	;


qosCommand
	:	QOS_KEYWORD (WS)* (qosSpecificCommand);
	
qosSpecificCommand
	:	(QOS_ENABLE_KEYWORD
	{
		myType = CliCommand.CliCommandType.QOS_ENABLE_COMMNAD;
	}
	|	QOS_DISABLE_KEYWORD
	{
		myType = CliCommand.CliCommandType.QOS_DISABLE_COMMNAD;
	}
	)
	|	QOS_LIMIT_KEYWORD (WS)* (limit)
	{
		myType = CliCommand.CliCommandType.QOS_LIMIT_COMMNAD;
		result.addParameter(new CliCommandParameter(CliCommandParameterType.QOS_LIMIT, myLimit));
	}
	;
	
limit
	:	NUMBER
	{
		if (#limit != null) {
			myLimit = #limit.getText();
		}
	}
	;

volumeCommand
	:	VOLUME_KEYWORD (WS)* (snapshotCommand);
	
snapshotCommand 
	:	snapshotCommandName (WS)* VOL_PARAM (WS)* volName
	;


snapshotCommandName 
	:	SNAPSHOT_KEYWORD (WS)* (ACTIVATE_KEYWORD
	{
		myType = CliCommand.CliCommandType.SNAPSHOT_ACTIVATE_COMMNAD;
	} 
	| DEACTIVATE_KEYWORD
	{
		myType = CliCommand.CliCommandType.SNAPSHOT_DEACTIVATE_COMMNAD;
	}
	)
	;

volName
	:	text
	{
		if (#volName != null) {
			myVolName = #volName.getText();
		}
	}
	;

text	:	 (WORD)+;
