import zlib
import zipfile, os

ERROR_STR= """Error removing %(path)s, %(error)s """
ANALYSIS_DIR_NAME = '/analysis'
DETAILS_DIR_NAME = '/details'

"""------------------------------------------------------------------------------------------------"""

def rmgeneric(path, __func__):
    """   Clean up a directory tree from root. The directory need not be empty.
    The starting directory is not deleted.
    """

    try:
        __func__(path)
    except OSError, (errno, strerror):
        print ERROR_STR % {'path' : path, 'error': strerror }

"""-----------------------------------------------------------------------------------------------"""            

def removeall(path):

    if not os.path.isdir(path):
        return
    
    files=os.listdir(path)

    for x in files:
        fullpath=os.path.join(path, x)
        if os.path.isfile(fullpath):
            f=os.remove
            rmgeneric(fullpath, f)
        elif os.path.isdir(fullpath):
            removeall(fullpath)
            f=os.rmdir
            rmgeneric(fullpath, f)

"""-----------------------------------------------------------------------------------------------"""

def _mkdir(newdir):
    """    This method will create the given dir if it does not
    already exist.
    
    works the way a good mkdir should :)
    - already exists, silently complete
    - regular file in the way, raise an exception
    - parent directory(ies) does not exist, make them as well
    """

    if os.path.isdir(newdir):
        pass
    elif os.path.isfile(newdir):
        raise OSError("a file with the same name as the desired dir, '%s', already exists." % newdir)
    else:
        head, tail = os.path.split(newdir)
        if head and not os.path.isdir(head):
            _mkdir(head)
        if tail:
            os.mkdir(newdir)

"""-----------------------------------------------------------------------------------------------"""

# This method will find all the files in the given path, which contain the given 
# prefix and end with the given extension.

def findFiles(path, prefix, extension):
    allFiles = os.listdir(path)
    retVal = []
    for file in allFiles:
        if (file.name().find(prefix) != -1) & (file.name().find(extension) != -1):
            retVal += [file]
            
    return retVal

"""-----------------------------------------------------------------------------------------------"""

def unzip(zip, dir):
    for name in zip.namelist():
        file(dir + '/' + name, 'wb').write(zip.read(name)) 

"""-----------------------------------------------------------------------------------------------"""
def prepareDir(path):
    """This method will create the directory for the zip files.
If such a directory or file exists it will be deleted. 

@param path: The directory to prepare."""
    
    if (os.path.isdir(path + ANALYSIS_DIR_NAME)):
        removeall(path + ANALYSIS_DIR_NAME)

    if (os.path.isfile(path + ANALYSIS_DIR_NAME)):
        os.remove(path + ANALYSIS_DIR_NAME)
        
"""-----------------------------------------------------------------------------------------------"""    

#This method will return an array containing all the elements in the given array, which contain
#the wanted string, and do not contain the unwanted string. If the unwanted string is '' there
#will be no check against an unwanted string. 

def filterArray(aOrigArr, aWantedStr, aUnwantedStr):
    retArr = []
    for curElem in aOrigArr:
        # If the user specified an unwanted string.
        if (aUnwantedStr != ''):
            if (curElem.find(aWantedStr) != -1) & (curElem.find(aUnwantedStr) == -1):
                retArr.append(curElem)
        # If the user did not specified an unwanted string.
        elif (curElem.find(aWantedStr) != -1):
            retArr.append(curElem)

    return retArr

"""-----------------------------------------------------------------------------------------------"""

# This method returns all the exceptions from the given file.

def getExceptionsFromFile(fileName):
    curFile = file(fileName, 'r')
    lines = curFile.readlines()
    curFile.close()
    
    # Create an array of exceptions, and add the exceptions.
    retArr = []
    curException = ''
    errExist = 0
    for i in range(len(lines)):
        # If the |ERROR| appears in the line, we are dealing with a new exception.
        errExist = lines[i].find('|ERROR|')
        if errExist != -1:
            if curException != '':
                retArr.append(curException)
            curException = lines[i]
        else:
            curException += lines[i]   
    
    # Add the last exception.
    if curException != '':
        retArr.append(curException)
    
    return retArr       

"""-----------------------------------------------------------------------------------------------"""

# This method will find all the files in the given path, which contain the given 
# prefix and end with the given extension.

def findFiles(path, prefix, extension):
    allFiles = os.listdir(path)
    retVal = []
    for file in allFiles:
        if ((file.endswith(extension)) & (file.startswith(prefix))):
            retVal += [file]
            
    return retVal

"""-----------------------------------------------------------------------------------------------"""


def printExpSummary(path, fileName, expArr):
    """    This method will print the exception summary for the
    file.
    
    @param path: The path to create the file in.
    @param fileName: The name of the file the summary data relates to.
    @param expArr: The data to write in the file.
    """
    
    # Create the directory.
    newPath = path
    _mkdir(newPath)

    # Create the new file and save the summary information in it.
    newFileName = newPath + '/' + fileName + ' - summary.txt'
    f = open(newFileName, 'w')
     
    # Print the header.
    f.write('\n')
    f.write('File: ' + fileName + '\n')
    f.write('-' * len(fileName) + '\n')
    f.write('\n')

    
    # Go over the array and print the details.
    for expType in expArr.keys():
        # If there are no exceptions do not create the file.
        if (len(expArr[expType]) > 0):
            f.write('Number of ' + expType + ' exceptions found: ' + str(len(expArr[expType])) + '\n')
        
    f.flush()
    f.close()

"""-----------------------------------------------------------------------------------------------"""

# This method will print the exceptions in the array to the given file.
def printExpDetail(path, fileName, expArr):
    # Create the dir.
    newPath = path + DETAILS_DIR_NAME
    _mkdir(newPath)
    
    # Create the new file and save the exception information in it.
    newFileName = newPath + '/' + fileName + ' - analysis.txt'
    f = open(newFileName, 'w')
    
    for curExp in expArr:
        f.write(curExp)
        f.write('\n')
        f.write('*' * 120)
        f.write('\n')
        curExp = None
        f.flush()

    f.close()
    
"""-----------------------------------------------------------------------------------------------"""

# This method will print the exceptions in the array to the analysis files.
def printExpArrDetails(path, fileName, expArr):
    for curType in expArr.keys():
        printExpDetail(path, fileName + ' - ' + curType, expArr[curType])

"""-----------------------------------------------------------------------------------------------"""

def removeFiles(path, prefix, extension):
    """   This method will remove all the files starting
    with the given prefix and ending with the given 
    extension in the given path.
     
    @param path: The path to remove the files from .
    @param prefix: The prefix of the file name to remove.
    @param extension: The extension of the file to remove.
    """   
    
    # Find all the files and remove them one by one.
    allFiles = findFiles(path, prefix, extension)
    
    for fileName in allFiles:
        fullpath = path + '/' + fileName
        
        if os.path.isfile(fullpath):
            f=os.remove
            rmgeneric(fullpath, f)

"""-----------------------------------------------------------------------------------------------"""

def analyzeUnzippedExpLogs(path):
    analyzeCurrentUnzippedExpLogs(path, path,'exceptions')
    
"""-----------------------------------------------------------------------------------------------"""

"""-----------------------------------------------------------------------------------------------"""

def analyzeUnzippedClientExpLogs(path):
    analyzeCurrentUnzippedExpLogs(path, path,'client')
    
"""-----------------------------------------------------------------------------------------------"""


def analyzeCurrentUnzippedExpLogs(path, targetPath,prefix):
    """   This method will analyze the unzipped exception log
    files which exist in the given path.
    
    @param path: The path to search the exception logs in.
    @param targetPath: The path to write the files to.
    """
   

    clientFiles = findFiles(path,prefix,'log')
    # Go over each file and find the exceptions.
    for fileName in clientFiles:
    
        # Get all the exceptions
        exceptionArr = getExceptionsFromFile(path + '/' + fileName)
      
        # Go over the array and leave only the selected exceptions.
        Exp1 = filterArray(exceptionArr, 'monfox.toolkit.snmp.mgr.SnmpErrorException: Snmp Error(status=', 'Caused by:')
        Exp2 = filterArray(exceptionArr, 'NullPointerException', 'Caused by:')
        Exp3 = filterArray(exceptionArr, 'ClassCast', 'Caused by:')
        Exp4 = filterArray(exceptionArr, 'BufferOverflow', 'Caused by:')
        Exp5 = filterArray(exceptionArr, 'ClassFormat', 'Caused by:')
        Exp6 = filterArray(exceptionArr, 'ConcurrentModification', 'Caused by:')
        Exp7 = filterArray(exceptionArr, 'IllegalArgument', 'Caused by:')
        Exp8 = filterArray(exceptionArr, 'IllegalOperation', 'Caused by:')
        Exp9 = filterArray(exceptionArr, 'IllegalState', 'Caused by:')
        Exp10 = filterArray(exceptionArr, 'IndexOutOfBounds', 'Caused by:')
        Exp11 = filterArray(exceptionArr, 'NoSuchElement', 'Caused by:')
        Exp12 = filterArray(exceptionArr, 'Range', 'Caused by:')
        Exp13 = filterArray(exceptionArr, 'RejectedExecution', 'Caused by:')
        Exp14 = filterArray(exceptionArr, 'Security', 'Caused by:')
        Exp15 = filterArray(exceptionArr, 'SrSnmpConversion', 'Caused by:')
        Exp16 = filterArray(exceptionArr, 'SrSnmpInit', 'Caused by:')
        Exp17 = filterArray(exceptionArr, 'TypeMismatch', 'Caused by:')
        Exp18 = filterArray(exceptionArr, 'UnsupportedOperation', 'Caused by:')
        Exp19 = filterArray(exceptionArr, 'XMLParse', 'Caused by:')
        Exp20 = filterArray(exceptionArr, 'FileNotFound', 'Caused by:')
        # Output the summary, and create the detail files.
        expArr = {}
        expArr['EMM'] = Exp1
        expArr['NullPointer'] = Exp2
        expArr['ClassCast'] = Exp3
        expArr['BufferOverflow'] = Exp4
        expArr['ClassFormat'] = Exp5
        expArr['ConcurrentModification'] = Exp6
        expArr['IllegalArgument'] = Exp7
        expArr['IllegalOperation'] = Exp8
        expArr['IllegalState'] = Exp9
        expArr['IndexOutOfBounds'] = Exp10
        expArr['NoSuchElement'] = Exp11
        expArr['Range'] = Exp12
        expArr['RejectedExecution'] = Exp13
        expArr['Security'] = Exp14
        expArr['SrSnmpConversion'] = Exp15
        expArr['SrSnmpInit'] = Exp16
        expArr['TypeMismatch'] = Exp17
        expArr['UnsupportedOperation'] = Exp18
        expArr['XMLParse'] = Exp19
        expArr['FileNotFound'] = Exp20
        
        # Print the results    
        printExpSummary(targetPath, fileName, expArr)
        printExpArrDetails(targetPath, fileName, expArr)

"""-----------------------------------------------------------------------------------------------"""

def convertPathToLinuxFormat(windowsPath):
    """   This method takes a path in windows format and translates it into linux format 
    @param windowsPath: The path to search the exception logs in.

    """
    tmp=str(windowsPath).lstrip("C:")
    linuxPath= str(tmp).replace('\\', '/')
    return linuxPath
"""----------------------------------------------------------------------------------------"""

    
    
    
    
    
    
    
# MAIN
#Server analysis stage start
#path = 'C:/Project/revision/Vintage/Server/log'
path = '../log'
#path = '../../../../../../../../Project/revision/Vintage/Server/log'

# Remove the old analysis directory
prepareDir(path)

# Analyze the unzipped exceptions.
print('Analyzing current exceptions.')
_mkdir(path + ANALYSIS_DIR_NAME)
analyzeCurrentUnzippedExpLogs(path, path + '/analysis/current','exceptions')


# Get the potential zip files.
zipFiles = findFiles(path, 'exceptions', 'zip')


# Go over each potential file and find the exceptions.
for fileName in zipFiles:
    if (zipfile.is_zipfile(path + '/' + fileName) == False):
        continue

    # Create the new directory.
    newDir = path + ANALYSIS_DIR_NAME + '/' + fileName
    
    # Remove the '.zip' extension from the dir name.
    newDir = newDir[0:len(newDir) - 4]
    print 'Analyzing ' + fileName
    
    _mkdir(newDir)

    # Unzip the file
    curZip = zipfile.ZipFile(path + '/' + fileName, 'r')
    
    unzip(curZip, newDir)
    curZip.close

    # Analyze the exception logs.
    analyzeUnzippedExpLogs(newDir)
    
    # Remove the unnecessary files.
    removeFiles(newDir, 'exception', 'log')
    
#Client logs analysis 
#Get home directory
homePath= os.path.expanduser("~")
clientPath=convertPathToLinuxFormat(homePath) + '/' + 'nms_log'
#path=clientPath
# Analyze the unzipped exceptions.
print('Analyzing client current exceptions.')
analyzeCurrentUnzippedExpLogs(clientPath, path + '/analysis/current','client')


# Get the potential zip files.
zipFiles = findFiles(clientPath, 'client', 'zip')


# Go over each potential file and find the exceptions.
for fileName in zipFiles:
    if (zipfile.is_zipfile(clientPath + '/' + fileName) == False):
        continue

    # Create the new directory.
    newDir = path + ANALYSIS_DIR_NAME + '/' + fileName
    
    # Remove the '.zip' extension from the dir name.
    newDir = newDir[0:len(newDir) - 4]
    print 'Analyzing ' + fileName 
    
    _mkdir(newDir)

    # Unzip the file
    curZip = zipfile.ZipFile(clientPath + '/' + fileName, 'r')
    
    unzip(curZip, newDir)
    curZip.close

    # Analyze the exception logs.
    analyzeUnzippedClientExpLogs(newDir)
    
    # Remove the unnecessary files.
    removeFiles(newDir, 'client', 'log')
    