<?xml version="1.0"?>

<!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
<!-- Copyright (c) 2003, Monfox, LLC. All Rights Reserved              -->
<!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->

<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;"><!ENTITY copy "&#169;"><!ENTITY reg "&#174;">]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:output method="html" indent="yes"/>
  <xsl:variable name="nl">
<xsl:text>
</xsl:text>
  </xsl:variable>

<xsl:param name="indent" select="30"/>

<xsl:param name="c1" select="30"/>
<xsl:param name="c2" select="30"/>
<xsl:param name="c3" select="30"/>
<xsl:param name="c4" select="30"/>
<xsl:param name="c5" select="280"/>
<xsl:param name="c6" select="400"/>

<xsl:param name="pagewidth" select="800"/>
<xsl:param name="talign">center</xsl:param>

<xsl:param name="border" select="0"/>

<xsl:template match="ModuleList">

   <html>

   <head>
     <title>Generated MIB Module Index&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;(Generated by Monfox DynamicSNMP&reg;)</title>
     <link rel="stylesheet" type="text/css" href="snmp.css"/>
   </head>

   <body align="left" valign="top"> 

   <table summary="-" width="{$pagewidth}" border="{$border}" align="{$talign}" cellpadding="0" cellspacing="0" valign="top" topmargin="0">
      <tr>
	 <td width="{$c1}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
	 <td width="{$c2}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
	 <td width="{$c3}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
	 <td width="{$c4}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
	 <td width="{$c5}">&nbsp;</td>
	 <td width="{$c6}">&nbsp;</td>
      </tr>
      <tr>
	 <td class="module-header" align="left" colspan="6">
	    <span class="name">Module&nbsp;Summary</span>
	 </td>
      </tr>

      <tr>
	 <td align="left" colspan="6">
	    <ul class="name">
	       <li><a href="index-by-oid.html">Summary Index By OID</a></li>
	       <li><a href="index-by-name.html">Summary Index By Name</a></li>
	       <li><a href="index-by-construct.html">Summary Index By Construct</a></li>
	    </ul>
	 </td>
      </tr>
      <tr><td colspan="6">&nbsp;</td></tr>

      <tr>
	 <td class="module-header" align="left" colspan="6">
	    <span class="name">Available&nbsp;Modules</span>
	 </td>
      </tr>
      <xsl:for-each select="ModuleRef">
	 <tr>
	    <td>&nbsp;</td>
	    <td align="right" class="keyword">&nbsp;<xsl:value-of select="position()"/>)</td>
	    <td colspan="5">
	       <span class="name">
		  <xsl:call-template name="link">&nbsp;&nbsp;&nbsp;
		     <xsl:with-param name="module" select="@name"/>
		     <xsl:with-param name="text"><xsl:value-of select="@name"/></xsl:with-param>
		  </xsl:call-template> 
	       </span>
	     </td>
	  </tr>
       </xsl:for-each>

       </table>


<br/><br/>
<table summary="-" width="{$pagewidth}" border="{$border}" align="{$talign}" cellpadding="0" cellspacing="0" valign="top" topmargin="0">
   <tr class="body-footer">
     <td align="left" class="body-footer">Generated by the DynamicSNMP&reg; SDK</td>
     <td align="center" class="body-footer"><a href="http://www.monfox.com">www.monfox.com</a></td>
     <td align="right" class="body-footer">HTML Copyright &copy; 2003 Monfox, LLC.</td>
   </tr>

</table> 
<br/><br/>

   </body>
   </html>

</xsl:template>

<xsl:template name="link">
   <xsl:param name="elem"/>
   <xsl:param name="module" select=""/>
   <xsl:param name="text" select="" />

   <nobr>
   <xsl:choose>
   <xsl:when test="contains($elem,':')">
      <xsl:param name="t_mod"  select="substring-before($elem,':')"/>
      <xsl:param name="t_elem" select="substring-after($elem,':')"/>
      <a href="{$t_mod}.html#{$t_elem}"><xsl:value-of select="$t_mod"/>.<xsl:value-of select="$t_elem"/></a>
   </xsl:when>
   <xsl:when test="string-length($module)>0 and string-length($elem)>0 and string-length($text)>0">
      <a href="{$module}.html#{$elem}"><xsl:value-of select="$text"/></a>
   </xsl:when>
   <xsl:when test="string-length($elem)>0 and string-length($text)>0">
      <a href="#{$elem}"><xsl:value-of select="$text"/></a>
   </xsl:when>
   <xsl:when test="string-length($elem)>0">
      <a href="#{$elem}"><xsl:value-of select="$elem"/></a>
   </xsl:when>
   <xsl:when test="string-length($module)>0">
      <a href="{$module}.html"><xsl:value-of select="$module"/></a>
   </xsl:when>
   </xsl:choose>
   </nobr>

</xsl:template>
</xsl:stylesheet>
