<?xml version="1.0"?>

<!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
<!-- Copyright (c) 2003, Monfox, LLC. All Rights Reserved              -->
<!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->

<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;"><!ENTITY copy "&#169;"><!ENTITY reg "&#174;">]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:output method="html" indent="yes"/>
  <xsl:variable name="nl">
<xsl:text>
</xsl:text>
  </xsl:variable>

<xsl:param name="indent" select="30"/>

<xsl:param name="c1" select="30"/>
<xsl:param name="c2" select="100"/>
<xsl:param name="c3" select="100"/>
<xsl:param name="c4" select="100"/>
<xsl:param name="c5" select="70"/>
<xsl:param name="c6" select="400"/>

<xsl:param name="pagewidth" select="800"/>
<xsl:param name="talign">center</xsl:param>

<xsl:param name="border" select="0"/>

<xsl:param name="index" select="index.html"/>

<xsl:template match="OidList">

   <html>

   <head>
     <title>MIB Component Index (By Name)&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;(Generated by Monfox DynamicSNMP&reg;)</title>
     <link rel="stylesheet" type="text/css" href="snmp.css"/>
   </head>

   <body align="left" valign="top"> 

   <table summary="-" width="{$pagewidth}" border="{$border}" align="{$talign}" cellpadding="0" cellspacing="0" valign="top" topmargin="0">
      <tr>
	 <td width="{$c1}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
	 <td width="{$c2}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
	 <td width="{$c3}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
	 <td width="{$c4}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
	 <td width="{$c5}">&nbsp;</td>
	 <td width="{$c6}">&nbsp;</td>
      </tr>
      <tr>
	 <td class="module-header" align="left" colspan="3">
	    <span class="name">MIB&nbsp;Components&nbsp;By&nbsp;Name&nbsp;</span>
	 </td>
	 <td class="module-header" align="right" colspan="3">
	    <span class="text"><a href="index.html">Main&nbsp;Index</a></span>
	 </td>
      </tr>
      <tr colspan="6"><td>&nbsp;</td></tr>
   </table>

   <table summary="-" width="{$pagewidth}" border="{$border}" align="{$talign}" cellpadding="0" cellspacing="0" valign="top" topmargin="0">
      <tr>
	 <td class="section-header" align="center"><span class="keyword">Name</span></td>
	 <td class="section-header" align="center"><span class="keyword">OID</span></td>
	 <td class="section-header" align="center"><span class="keyword">Module</span></td>
	 <td class="section-header" align="center"><span class="keyword">Construct</span></td>
<!--
	 <td class="section-header" align="center"><span class="keyword">Syntax</span></td>
	 <td class="section-header" align="center"><span class="keyword">Access</span></td>
	 <td class="section-header" align="center"><span class="keyword">Status</span></td>
-->
      </tr>

      <xsl:for-each select="OidRef">

	 <xsl:variable name="rowstyle">
	    <xsl:choose>
	       <xsl:when test="@form = 'oid'">row-oid</xsl:when>
	       <xsl:when test="@form = 'table'">row-table</xsl:when>
	       <xsl:when test="@form = 'column'">row-column</xsl:when>
	       <xsl:when test="@form = 'entry'">row-entry</xsl:when>
	       <xsl:when test="@form = 'scalar'">row-scalar</xsl:when>
	       <xsl:when test="@form = 'notification'">row-notification</xsl:when>
	       <xsl:when test="@form = 'trap'">row-trap</xsl:when>
	       <xsl:when test="@form = 'objectgroup'">row-og</xsl:when>
	       <xsl:when test="@form = 'notificationgroup'">row-ng</xsl:when>
	       <xsl:when test="@form = 'moduleidentity'">row-mi</xsl:when>
	       <xsl:when test="@form = 'agentcapabilities'">row-ac</xsl:when>
	       <xsl:when test="@form = 'modulecompliance'">row-mc</xsl:when>
	       <xsl:when test="@agent = 'oid'">row-oid</xsl:when>
	       <xsl:otherwise>row-normal</xsl:otherwise>
	    </xsl:choose>
	 </xsl:variable>

	 <tr>
	    <td  align="left" class="{$rowstyle}">
	       <span class="name">&nbsp;&nbsp;&nbsp;<xsl:call-template name="link">
		    <xsl:with-param name="module" select="@module"/>
		    <xsl:with-param name="elem"   select="@name"/>
		    <xsl:with-param name="text"   select="@name"/>
		  </xsl:call-template></span>&nbsp;</td>
	    <td  align="left" class="{$rowstyle}"><span class="name"><xsl:value-of select="@oid"/>&nbsp;</span></td>
	     <td align="left" class="{$rowstyle}"><span class="name">&nbsp;&nbsp;&nbsp;<xsl:call-template name="link">
		  <xsl:with-param name="module" select="@module"/>
		  <xsl:with-param name="text"   select="@module"/>
	       </xsl:call-template>&nbsp;</span></td>
	     <td align="left" class="{$rowstyle}"><span class="name">&nbsp;<xsl:call-template name="convert-form">
		     <xsl:with-param name="form" select="@form"/>
		 </xsl:call-template>&nbsp;</span></td>
<!--
	     <td align="left" class="{$rowstyle}"><span class="name">&nbsp;<xsl:call-template name="convert-short-type">
		     <xsl:with-param name="type" select="@smitype"/>
		 </xsl:call-template>&nbsp;</span></td>
	     <td align="left" class="{$rowstyle}"><span class="name">&nbsp;<xsl:call-template name="convert-access">
		     <xsl:with-param name="access" select="@access"/>
		 </xsl:call-template>&nbsp;</span></td>
	     <td align="left" class="{$rowstyle}"><span class="name">&nbsp;<xsl:call-template name="convert-status">
		     <xsl:with-param name="status" select="@status"/>
		 </xsl:call-template>&nbsp;</span></td>
-->
	  </tr>
       </xsl:for-each>

      </table>


<br/><br/>
<table summary="-" width="{$pagewidth}" border="{$border}" align="{$talign}" cellpadding="0" cellspacing="0" valign="top" topmargin="0">
   <tr class="body-footer">
     <td align="left" class="body-footer">Generated by the DynamicSNMP&reg; SDK</td>
     <td align="center" class="body-footer"><a href="http://www.monfox.com">www.monfox.com</a></td>
     <td align="right" class="body-footer">HTML Copyright &copy; 2003 Monfox, LLC.</td>
   </tr>

</table> 
<br/><br/>

   </body>
   </html>

</xsl:template>

<xsl:template name="convert-short-type">
   <xsl:param name="type"/>
   <xsl:choose>
     <xsl:when test="$type = 's'">
       <xsl:text>OCTET&nbsp;STRING</xsl:text>
     </xsl:when>
     <xsl:when test="$type = 'c'">
       <xsl:text>Counter</xsl:text>
     </xsl:when>
     <xsl:when test="$type = 'c32'">
       <xsl:text>Counter32</xsl:text>
     </xsl:when>
     <xsl:when test="$type = 'c64'">
       <xsl:text>Counter64</xsl:text>
     </xsl:when>
     <xsl:when test="$type = 'i'">
       <xsl:text>INTEGER</xsl:text>
     </xsl:when>
     <xsl:when test="$type = 'i32'">
       <xsl:text>Integer32</xsl:text>
     </xsl:when>
     <xsl:when test="$type = 'u32'">
       <xsl:text>Unsigned32</xsl:text>
     </xsl:when>
     <xsl:when test="$type = 'g'">
       <xsl:text>Gauge</xsl:text>
     </xsl:when>
     <xsl:when test="$type = 'g32'">
       <xsl:text>Gauge32</xsl:text>
     </xsl:when>
     <xsl:when test="$type = 'ip'">
       <xsl:text>IpAddress</xsl:text>
     </xsl:when>
     <xsl:when test="$type = 't'">
       <xsl:text>TimeTicks</xsl:text>
     </xsl:when>
     <xsl:when test="$type = 'b'">
       <xsl:text>BITS</xsl:text>
     </xsl:when>
     <xsl:when test="$type = 'entry'">
       <xsl:text>SEQUENCE</xsl:text>
     </xsl:when>
     <xsl:when test="$type = 'o'">
       <xsl:text>OBJECT&nbsp;IDENTIFIER</xsl:text>
     </xsl:when>
     <xsl:otherwise>&nbsp;</xsl:otherwise>
   </xsl:choose>
</xsl:template>

<xsl:template name="convert-access">
   <xsl:param name="access"/>
   <xsl:choose>
     <xsl:when test="$access = 'ro'">
       <xsl:text><span class="ro">read-only</span></xsl:text>
     </xsl:when>
     <xsl:when test="$access = 'rw'">
       <xsl:text><span class="rw">read-write</span></xsl:text>
     </xsl:when>
     <xsl:when test="$access = 'wo'">
       <xsl:text><span class="wo">write-only</span></xsl:text>
     </xsl:when>
     <xsl:when test="$access = 'rc'">
       <xsl:text><span class="rc">read-create</span></xsl:text>
     </xsl:when>
     <xsl:when test="$access = 'na'">
       <xsl:text><span class="na">not-accessible</span></xsl:text>
     </xsl:when>
     <xsl:when test="$access = 'ni'">
       <xsl:text><span class="ni">not-implemented</span></xsl:text>
     </xsl:when>
     <xsl:when test="$access = 'no'">
       <xsl:text><span class="no">accessible-for-notify</span></xsl:text>
     </xsl:when>
     <xsl:otherwise>&nbsp;</xsl:otherwise>
   </xsl:choose>
</xsl:template>

<xsl:template name="convert-status">
   <xsl:param name="status"/>
   <xsl:choose>
     <xsl:when test="$status = 'current'">
       <xsl:text><span class="current">current</span></xsl:text>
     </xsl:when>
     <xsl:when test="$status = 'obsolete'">
       <xsl:text><span class="obsolete">obsolete</span></xsl:text>
     </xsl:when>
     <xsl:when test="$status = 'deprecated'">
       <xsl:text><span class="deprecated">deprecated</span></xsl:text>
     </xsl:when>
     <xsl:when test="$status = 'optional'">
       <xsl:text><span class="optional">optional</span></xsl:text>
     </xsl:when>
     <xsl:when test="$status = 'mandatory'">
       <xsl:text><span class="mandatory">mandatory</span></xsl:text>
     </xsl:when>
     <xsl:otherwise>&nbsp;</xsl:otherwise>
   </xsl:choose>
</xsl:template>

<xsl:template name="convert-form">
   <xsl:param name="form"/>
   <xsl:choose>
     <xsl:when test="$form = 'oid'">OID</xsl:when>
     <xsl:when test="$form = 'table'">Table&nbsp;Object</xsl:when>
     <xsl:when test="$form = 'entry'">Entry&nbsp;Object</xsl:when>
     <xsl:when test="$form = 'scalar'">Scalar&nbsp;Object</xsl:when>
     <xsl:when test="$form = 'column'">Column&nbsp;Object</xsl:when>
     <xsl:when test="$form = 'moduleidentity'">Module&nbsp;Identity</xsl:when>
     <xsl:when test="$form = 'notification'">Notification</xsl:when>
     <xsl:when test="$form = 'trap'">Trap</xsl:when>
     <xsl:when test="$form = 'objectgroup'">Object&nbsp;Group</xsl:when>
     <xsl:when test="$form = 'notificationgroup'">Notification&nbsp;Group</xsl:when>
     <xsl:when test="$form = 'agentcapabilities'">Agent&nbsp;Capabilities</xsl:when>
     <xsl:when test="$form = 'modulecompliance'">Module&nbsp;Compliance</xsl:when>
     <xsl:otherwise>&nbsp;</xsl:otherwise>
   </xsl:choose>
</xsl:template>


<xsl:template name="link">
   <xsl:param name="elem"/>
   <xsl:param name="module" select=""/>
   <xsl:param name="text" select="" />

   <nobr>
   <xsl:choose>
   <xsl:when test="contains($elem,':')">
      <xsl:param name="t_mod"  select="substring-before($elem,':')"/>
      <xsl:param name="t_elem" select="substring-after($elem,':')"/>
      <a href="{$t_mod}.html#{$t_elem}"><xsl:value-of select="$t_mod"/>.<xsl:value-of select="$t_elem"/></a>
   </xsl:when>
   <xsl:when test="string-length($module)>0 and string-length($elem)>0 and string-length($text)>0">
      <a href="{$module}.html#{$elem}"><xsl:value-of select="$text"/></a>
   </xsl:when>
   <xsl:when test="string-length($elem)>0 and string-length($text)>0">
      <a href="#{$elem}"><xsl:value-of select="$text"/></a>
   </xsl:when>
   <xsl:when test="string-length($elem)>0">
      <a href="#{$elem}"><xsl:value-of select="$elem"/></a>
   </xsl:when>
   <xsl:when test="string-length($module)>0">
      <a href="{$module}.html"><xsl:value-of select="$module"/></a>
   </xsl:when>
   </xsl:choose>
   </nobr>

</xsl:template>
</xsl:stylesheet>
