<?xml version="1.0"?>

<!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
<!-- Copyright (c) 2003, Monfox, LLC. All Rights Reserved              -->
<!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->

<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;"><!ENTITY copy "&#169;"><!ENTITY reg "&#174;">]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:output method="html" indent="yes"/>
  <xsl:variable name="nl">
<xsl:text>
</xsl:text>
  </xsl:variable>

<xsl:param name="indent" select="30"/>

<xsl:param name="c1" select="30"/>
<xsl:param name="c2" select="30"/>
<xsl:param name="c3" select="30"/>
<xsl:param name="c4" select="30"/>
<xsl:param name="c5" select="280"/>
<xsl:param name="c6" select="400"/>

<xsl:param name="pagewidth" select="800"/>
<xsl:param name="talign">center</xsl:param>

<xsl:param name="border" select="0"/>

<xsl:template match="Module">

<html>

<head>
  <title>MIB Module: <xsl:value-of select="@name"/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;(Generated by Monfox DynamicSNMP&reg;)</title>
  <link rel="stylesheet" type="text/css" href="snmp.css"/>
</head>

<body align="left" valign="top"> 

<table summary="-" width="{$pagewidth}" border="{$border}" align="{$talign}" cellpadding="0" cellspacing="0" valign="top" topmargin="0">
   <tr>
      <td width="{$c1}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c2}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c3}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c4}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c5}">&nbsp;</td>
      <td width="{$c6}">&nbsp;</td>
   </tr>
   <tr>
      <td class="module-header" align="left" colspan="5">
         <span class="keyword"><a name="top">MIB:</a>&nbsp;&nbsp;&nbsp;</span>
         <span class="name"><xsl:value-of select="@name"/></span>
      </td>
      <td class="module-header" align="right" colspan="3">
	 <span class="text"><a href="index.html">Main&nbsp;Index</a></span>
      </td>
<!--
      <td class="module-header" align="right">
         <span class="keyword"><a name="top">MIB:</a>&nbsp;&nbsp;&nbsp;</span>
         <span class="name"><xsl:value-of select="@name"/></span>
      </td>
-->
   </tr>
   <tr>
      <td colspan="6"> <!-- Main -->
	 <table summary="-" width="100%" border="{$border}">
	 <tr> 
	    <td width="{$indent}">&nbsp;&nbsp;&nbsp;</td> 
	    <td width="35%">&nbsp;</td>
	    <td width="10%">&nbsp;</td>
	    <td width="{$indent}">&nbsp;&nbsp;&nbsp;</td> 
	    <td width="35%">&nbsp;</td>
	    <td width="10%">&nbsp;</td>
	 </tr>
	 <tr>
	    <td>&nbsp;</td>
	    <td class="name">
	       &nbsp;-&nbsp;<a href="#typeDefs">Textual&nbsp;Convention/Type&nbsp;Defs</a>&nbsp;&nbsp;</td><td class="name">(<xsl:value-of select="count(Type[@name!='' and @objtype!='entry'])"/>)</td> 
	    <td>&nbsp;</td>
	    <td class="name">
	      &nbsp;-&nbsp;<a href="#notificationDefs">Notification/Trap&nbsp;Definitions</a>&nbsp;&nbsp;</td><td class="name">(<xsl:value-of select="count(Notification)+count(Trap)"/>)</td>
	 </tr>
	 <tr>
	    <td>&nbsp;</td>
	    <td class="name">
	      &nbsp;-&nbsp;<a href="#oidDefs">Object&nbsp;Identifier&nbsp;Definitions</a>&nbsp;&nbsp;</td><td class="name">(<xsl:value-of select="count(Oid)"/>)</td>
	    <td>&nbsp;</td>
	    <td class="name">
	      &nbsp;-&nbsp;<a href="#objectGroupDefs">Object&nbsp;Group&nbsp;Definitions</a>&nbsp;&nbsp;</td><td class="name">(<xsl:value-of select="count(ObjectGroup)"/>)</td>
	 </tr>
	 <tr>
	    <td>&nbsp;</td>
	    <td class="name">
	       &nbsp;-&nbsp;<a href="#tableDefs">Table&nbsp;Definitions</a>&nbsp;&nbsp;</td><td class="name">(<xsl:value-of select="count(Table)"/>)</td>
	    <td>&nbsp;</td>
	    <td class="name">
	      &nbsp;-&nbsp;<a href="#notificationGroupDefs">Notification&nbsp;Group&nbsp;Definitions</a>&nbsp;&nbsp;</td><td class="name">(<xsl:value-of select="count(NotificationGroup)"/>)</td>
	 </tr>
	 <tr>
	    <td>&nbsp;</td>
	    <td class="name">
	       &nbsp;-&nbsp;<a href="#entryDefs">Table&nbsp;Entry/Row&nbsp;Definitions</a>&nbsp;&nbsp;</td><td class="name">(<xsl:value-of select="count(Object[@form='entry'])"/>)</td>
	    <td>&nbsp;</td>
	    <td class="name">
	      &nbsp;-&nbsp;<a href="#agentCapabilitiesDefs">Agent&nbsp;Capabilities&nbsp;Definitions</a>&nbsp;&nbsp;</td><td class="name">(<xsl:value-of select="count(AgentCapabilities)"/>)
	    </td>
	 </tr>
	 <tr>
	    <td>&nbsp;</td>
	    <td class="name">
	       &nbsp;-&nbsp;<a href="#columnDefs">Column&nbsp;Object&nbsp;Definitions</a>&nbsp;&nbsp;</td><td class="name">(<xsl:value-of select="count(Object[@form='column'])"/>)</td>
	    <td>&nbsp;</td>
	    <td class="name">
	       &nbsp;-&nbsp;<a href="#moduleComplianceDefs">Module&nbsp;Compliance&nbsp;Definitions</a>&nbsp;&nbsp;</td><td class="name">(<xsl:value-of select="count(ModuleCompliance)"/>)</td>
	 </tr>
	 <tr>
	    <td>&nbsp;</td>
	    <td class="name">
	       &nbsp;-&nbsp;<a href="#scalarDefs">Scalar&nbsp;Object&nbsp;Definitions</a>&nbsp;&nbsp;</td><td class="name">(<xsl:value-of select="count(Object[@form='scalar'])"/>)</td>
	    <td>&nbsp;</td>
	    <td class="name">
	       &nbsp;
	    </td>
	    <td>&nbsp;</td>
	 </tr>
	 </table>
      </td> <!-- Main -->
   </tr>
</table>
<table summary="-" width="{$pagewidth}" border="{$border}" align="{$talign}" cellpadding="0" cellspacing="0" valign="top" topmargin="0">
   <tr>
      <td width="{$c1}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c2}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c3}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c4}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c5}">&nbsp;</td>
      <td width="{$c6}">&nbsp;</td>
   </tr>
   <xsl:apply-templates select="Requires"/>
</table>
<table summary="-" width="{$pagewidth}" border="{$border}" align="{$talign}" cellpadding="0" cellspacing="0" valign="top" topmargin="0">
   <tr>
      <td width="{$c1}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c2}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c3}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c4}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c5}">&nbsp;</td>
      <td width="{$c6}">&nbsp;</td>
   </tr>
   <xsl:apply-templates select="ModuleIdentity"/>
</table>
<table summary="-" width="{$pagewidth}" border="{$border}" align="{$talign}" cellpadding="0" cellspacing="0" valign="top" topmargin="0">
   <tr>
      <td width="{$c1}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c2}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c3}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c4}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c5}">&nbsp;</td>
      <td width="{$c6}">&nbsp;</td>
   </tr>
   <xsl:call-template name="process-types"/>
</table>
<table summary="-" width="{$pagewidth}" border="{$border}" align="{$talign}" cellpadding="0" cellspacing="0" valign="top" topmargin="0">
   <tr>
      <td width="{$c1}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c2}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c3}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c4}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c5}">&nbsp;</td>
      <td width="{$c6}">&nbsp;</td>
   </tr>
   <xsl:call-template name="process-oids"/>
</table>
<table summary="-" width="{$pagewidth}" border="{$border}" align="{$talign}" cellpadding="0" cellspacing="0" valign="top" topmargin="0">
   <tr>
      <td width="{$c1}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c2}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c3}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c4}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c5}">&nbsp;</td>
      <td width="{$c6}">&nbsp;</td>
   </tr>
   <xsl:call-template name="process-tables"/>
</table>
<table summary="-" width="{$pagewidth}" border="{$border}" align="{$talign}" cellpadding="0" cellspacing="0" valign="top" topmargin="0">
   <tr>
      <td width="{$c1}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c2}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c3}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c4}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c5}">&nbsp;</td>
      <td width="{$c6}">&nbsp;</td>
   </tr>
   <xsl:call-template name="process-objects">
      <xsl:with-param name="title">Table Row/Entry Object Definitions</xsl:with-param>
      <xsl:with-param name="tag">entryDefs</xsl:with-param>
      <xsl:with-param name="form">entry</xsl:with-param>
      <xsl:with-param name="otype">Entry</xsl:with-param>
   </xsl:call-template>
</table>
<table summary="-" width="{$pagewidth}" border="{$border}" align="{$talign}" cellpadding="0" cellspacing="0" valign="top" topmargin="0">
   <tr>
      <td width="{$c1}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c2}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c3}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c4}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c5}">&nbsp;</td>
      <td width="{$c6}">&nbsp;</td>
   </tr>
   <xsl:call-template name="process-objects">
      <xsl:with-param name="title">Table Column Object Definitions</xsl:with-param>
      <xsl:with-param name="tag">columnDefs</xsl:with-param>
      <xsl:with-param name="form">column</xsl:with-param>
      <xsl:with-param name="otype">Column</xsl:with-param>
   </xsl:call-template>
</table>
<table summary="-" width="{$pagewidth}" border="{$border}" align="{$talign}" cellpadding="0" cellspacing="0" valign="top" topmargin="0">
   <tr>
      <td width="{$c1}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c2}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c3}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c4}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c5}">&nbsp;</td>
      <td width="{$c6}">&nbsp;</td>
   </tr>
</table>
<table summary="-" width="{$pagewidth}" border="{$border}" align="{$talign}" cellpadding="0" cellspacing="0" valign="top" topmargin="0">
   <tr>
      <td width="{$c1}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c2}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c3}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c4}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c5}">&nbsp;</td>
      <td width="{$c6}">&nbsp;</td>
   </tr>
   <xsl:call-template name="process-objects">
      <xsl:with-param name="title">Scalar Object Definitions</xsl:with-param>
      <xsl:with-param name="tag">scalarDefs</xsl:with-param>
      <xsl:with-param name="form">scalar</xsl:with-param>
      <xsl:with-param name="otype">Scalar</xsl:with-param>
   </xsl:call-template>
</table>
<table summary="-" width="{$pagewidth}" border="{$border}" align="{$talign}" cellpadding="0" cellspacing="0" valign="top" topmargin="0">
   <tr>
      <td width="{$c1}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c2}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c3}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c4}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c5}">&nbsp;</td>
      <td width="{$c6}">&nbsp;</td>
   </tr>
   <xsl:call-template name="process-traps-notifications">
      <xsl:with-param name="title">Notification/Trap Definitions</xsl:with-param>
      <xsl:with-param name="tag">notificationDefs</xsl:with-param>
   </xsl:call-template>
</table>
<table summary="-" width="{$pagewidth}" border="{$border}" align="{$talign}" cellpadding="0" cellspacing="0" valign="top" topmargin="0">
   <tr>
      <td width="{$c1}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c2}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c3}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c4}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c5}">&nbsp;</td>
      <td width="{$c6}">&nbsp;</td>
   </tr>
   <xsl:call-template name="process-object-groups">
      <xsl:with-param name="title">Object Group Definitions</xsl:with-param>
      <xsl:with-param name="tag">objectGroupDefs</xsl:with-param>
   </xsl:call-template>
</table>
<table summary="-" width="{$pagewidth}" border="{$border}" align="{$talign}" cellpadding="0" cellspacing="0" valign="top" topmargin="0">
   <tr>
      <td width="{$c1}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c2}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c3}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c4}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c5}">&nbsp;</td>
      <td width="{$c6}">&nbsp;</td>
   </tr>
   <xsl:call-template name="process-notification-groups">
      <xsl:with-param name="title">Notification Group Definitions</xsl:with-param>
      <xsl:with-param name="tag">notificationGroupDefs</xsl:with-param>
   </xsl:call-template>
</table>
<table summary="-" width="{$pagewidth}" border="{$border}" align="{$talign}" cellpadding="0" cellspacing="0" valign="top" topmargin="0">
   <tr>
      <td width="{$c1}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c2}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c3}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c4}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c5}">&nbsp;</td>
      <td width="{$c6}">&nbsp;</td>
   </tr>
</table>
<table summary="-" width="{$pagewidth}" border="{$border}" align="{$talign}" cellpadding="0" cellspacing="0" valign="top" topmargin="0">
   <tr>
      <td width="{$c1}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c2}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c3}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c4}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c5}">&nbsp;</td>
      <td width="{$c6}">&nbsp;</td>
   </tr>
   <xsl:call-template name="process-agent-capabilities">
      <xsl:with-param name="title">Agent Capabilities Definitions</xsl:with-param>
      <xsl:with-param name="tag">agentCapabilitiesDefs</xsl:with-param>
   </xsl:call-template>
</table>
<table summary="-" width="{$pagewidth}" border="{$border}" align="{$talign}" cellpadding="0" cellspacing="0" valign="top" topmargin="0">
   <tr>
      <td width="{$c1}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c2}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c3}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c4}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td width="{$c5}">&nbsp;</td>
      <td width="{$c6}">&nbsp;</td>
   </tr>
   <xsl:call-template name="process-module-compliances">
      <xsl:with-param name="title">Module Compliance Definitions</xsl:with-param>
      <xsl:with-param name="tag">moduleComplianceDefs</xsl:with-param>
   </xsl:call-template>
</table> 

<br/><br/>
<table summary="-" width="{$pagewidth}" border="{$border}" align="{$talign}" cellpadding="0" cellspacing="0" valign="top" topmargin="0">
   <tr class="body-footer">
     <td align="left" class="body-footer">Generated by the DynamicSNMP&reg; SDK</td>
     <td align="center" class="body-footer"><a href="http://www.monfox.com">www.monfox.com</a></td>
     <td align="right" class="body-footer">HTML Copyright &copy; 2003 Monfox, LLC.</td>
   </tr>

</table> 
<br/><br/>

</body>
</html>
</xsl:template>

<!-- ************************************************************** -->
<!-- Required Module Processing                                     -->
<!-- ************************************************************** -->

<xsl:template match="Requires">

   <xsl:call-template name="print-section-header">
      <xsl:with-param name="title">Module Dependencies</xsl:with-param>
      <xsl:with-param name="tag">moduleDependencies</xsl:with-param>
   </xsl:call-template>

   <tr><td colspan="6">&nbsp;</td></tr>

   <xsl:for-each select="ModuleRef">
      <tr>
	 <td>&nbsp;</td>
	 <td colspan="5">
	    <span class="name">
               <xsl:call-template name="link">&nbsp;&nbsp;&nbsp;
		  <xsl:with-param name="module" select="@name"/>
		  <xsl:with-param name="text"><xsl:value-of select="@name"/></xsl:with-param>
	       </xsl:call-template> 
	    </span>
	  </td>
       </tr>
    </xsl:for-each>

    <tr><td colspan="6">&nbsp;</td></tr>

</xsl:template>

<!-- ************************************************************** -->
<!-- Module Identity Processing                                     -->
<!-- ************************************************************** -->

<xsl:template match="ModuleIdentity">

   <tr>
      <td class="section-header" colspan="5">
	 <span class="keyword">Module&nbsp;Identity:&nbsp;</span>
	 <span class="name">
	   <xsl:value-of select="@name"/>
	 </span>
      </td>
      <td align="right" class="section-header">
	 <span class="oid"><xsl:value-of select="@oid"/></span>
      </td>
   </tr>

   <tr><td colspan="6">&nbsp;</td></tr>

   <xsl:call-template name="process-text-element">
      <xsl:with-param name="content" select="@lastUpdated"/>
      <xsl:with-param name="keyword">Last Updated</xsl:with-param>
   </xsl:call-template> 

   <xsl:call-template name="process-text-element">
      <xsl:with-param name="content" select="Organization"/>
      <xsl:with-param name="keyword">Organization</xsl:with-param>
   </xsl:call-template> 
   <xsl:call-template name="process-text-element">
      <xsl:with-param name="content" select="ContactInfo"/>
      <xsl:with-param name="keyword">Contact Info</xsl:with-param>
   </xsl:call-template> 
   <xsl:call-template name="process-text-element">
      <xsl:with-param name="content" select="Description"/>
      <xsl:with-param name="keyword">Description</xsl:with-param>
   </xsl:call-template> 

</xsl:template>


<!-- ************************************************************** -->
<!-- Object Identifier Processing                                   -->
<!-- ************************************************************** -->

<xsl:template name="process-oids">

   <xsl:call-template name="print-section-header">
     <xsl:with-param name="title">Object Identifier Definitions</xsl:with-param>
     <xsl:with-param name="tag">oidDefs</xsl:with-param>
   </xsl:call-template>

   <tr>
      <td>&nbsp;</td>
      <td colspan="5">
	 <table summary="-" width="100%" border="{$border}" cellspacing="0" cellpadding="0">
	    <tr>
	      <td width="100">&nbsp;</td>
	      <td width="30">&nbsp;</td>
	      <td>&nbsp;</td>
	      <td width="30%">&nbsp;</td>
	    </tr>

	    <xsl:variable name="rowstyle">row-norm</xsl:variable>

	    <xsl:for-each select="Oid">
	       <xsl:variable name="counter" select="position()"/>

	       <xsl:variable name="rowstyle">
		  <xsl:choose>
		     <xsl:when test="($counter mod 2) = 1">row-highlight</xsl:when>
		     <xsl:otherwise>row-normal</xsl:otherwise>
		  </xsl:choose>
	       </xsl:variable>

	       <tr class="{$rowstyle}">
		  <td class="name"><a name="{@name}"><xsl:value-of select="@name"/></a></td>
		  <td class="keyword">&nbsp;::=&nbsp;</td>
		  <td>
		     <span class="oid">
		     <xsl:choose>
		       <xsl:when test="string-length(@rawValue)>0">
			   <xsl:value-of select="@rawValue"/>
		       </xsl:when>
		       <xsl:otherwise>
			   <xsl:value-of select="@oid"/>
		       </xsl:otherwise>
		     </xsl:choose>
		     </span>
		  </td>
		  <td align="right">
		     <span class="oid"><xsl:value-of select="@oid"/></span>
		  </td>
	       </tr>
	    </xsl:for-each>

	 </table>
      </td>
   </tr>
</xsl:template>

<xsl:template name="process-types">

   <xsl:call-template name="print-section-header">
      <xsl:with-param name="title">Textual Convention (Type) Definitions</xsl:with-param>
      <xsl:with-param name="tag">typeDefs</xsl:with-param>
   </xsl:call-template>

   <xsl:variable name="search" select="Type[@name!='' and @objtype!='entry']"/>
   <xsl:call-template name="print-section-toc">
      <xsl:with-param name="search" select="$search"/>
      <xsl:with-param name="prefix">type.</xsl:with-param>
   </xsl:call-template>

   <tr>
      <td>&nbsp;</td>
      <td colspan="5">
	 <table summary="-" width="100%" border="{$border}" cellspacing="0" cellpadding="0">
	    <tr>
	      <td width="100">&nbsp;</td>
	      <td width="30">&nbsp;</td>
	      <td>&nbsp;</td>
	    </tr>

	    <xsl:variable name="rowstyle">row-norm</xsl:variable>

	    <xsl:for-each select="Type[@name!='' and @objtype!='entry']">
	       <xsl:variable name="counter" select="position()"/>

	       <xsl:variable name="rowstyle">
		  <xsl:choose>
		     <xsl:when test="($counter mod 2) = 1">row-highlight</xsl:when>
		     <xsl:otherwise>row-normal</xsl:otherwise>
		  </xsl:choose>
	       </xsl:variable>

		  <tr class="{$rowstyle}"><td colspan="3">&nbsp;</td></tr>

		  <tr class="{$rowstyle}" valign="top">
		  <td valign="top"><a name="type.{@name}"><span class="name"><xsl:value-of select="@name"/></span></a>
		  </td>
		  <td>
		     <span class="keyword">::=</span>
		  </td>
		  <td valign="top" class="typedef">
		     <xsl:call-template name="process-type">
			<xsl:with-param name="noname">true</xsl:with-param>
		     </xsl:call-template>
		  </td>
	       </tr>
	       <tr class="{$rowstyle}"><td colspan="3">&nbsp;</td></tr>
	    </xsl:for-each>

	  </table>
      </td>
   </tr>
</xsl:template>

<!-- ************************************************************** -->
<!-- Table Definition Processing                                    -->
<!-- ************************************************************** -->

<xsl:template name="process-tables">

   <xsl:call-template name="print-section-header">
      <xsl:with-param name="title">Table&nbsp;Definitions</xsl:with-param>
      <xsl:with-param name="tag">tableDefs</xsl:with-param>
   </xsl:call-template>

   <xsl:variable name="search" select="Table"/>
   <xsl:call-template name="print-section-toc">
      <xsl:with-param name="search" select="$search"/>
   </xsl:call-template>

   <xsl:apply-templates select="Table"/>

</xsl:template>

<xsl:template match="Table">

  <tr>
      <td colspan="1">&nbsp;</td>
      <td class="element-header" colspan="4">
	 <span class="keyword">Table:&nbsp;</span>
	 <span class="name">
	   <a name="{@name}"><xsl:value-of select="@name"/></a>
	 </span>
      </td>
      <td align="right" class="element-header" colspan="1">
	 <span class="oid"><xsl:value-of select="@oid"/></span>
      </td>
   </tr>

   <tr>
      <td>&nbsp;</td>
      <td>&nbsp;</td>
      <td colspan="3" class="small" align="left">
         (&nbsp;<a href="#{@name}.status">status</a>&nbsp;|&nbsp;<a href="#{@name}.indexes">indexes</a>&nbsp;|&nbsp;<a href="#{@name}.columns">columns</a>&nbsp;)
      </td>
      <td class="small" align="right">
	   (&nbsp;<a href="#tableDefs">section</a>&nbsp;|&nbsp;<a href="#top">top</a>&nbsp;)
      </td>
   </tr>

   <tr><td colspan="6">&nbsp;</td></tr>

   <xsl:call-template name="process-text-element">
      <xsl:with-param name="content" select="Description"/>
      <xsl:with-param name="keyword">Description</xsl:with-param>
      <xsl:with-param name="level">2</xsl:with-param>
   </xsl:call-template> 

   <tr>
      <td>&nbsp;</td>
      <td>&nbsp;</td>
      <td colspan="2" class="keyword">
	   <a name="{@name}.status">Status:&nbsp;&nbsp;&nbsp;</a></td>
      <td colspan="2" class="name">
	<xsl:call-template name="convert-status">
	    <xsl:with-param name="status"><xsl:value-of select="@status"/></xsl:with-param>
	</xsl:call-template>
       </td>
   </tr>

   <xsl:for-each select="Entry">
      <tr>
	 <td>&nbsp;</td>
	 <td>&nbsp;</td>
	 <td colspan="2" class="keyword">Row&nbsp;Entry:&nbsp;&nbsp;</td>
	 <td colspan="2" class="name">
            <xsl:call-template name="link">
	       <xsl:with-param name="module" select="../Module/@name"/>
	       <xsl:with-param name="elem"><xsl:value-of select="@name"/></xsl:with-param>
	       <xsl:with-param name="text"><xsl:value-of select="@name"/></xsl:with-param>
	    </xsl:call-template> 
	 </td>
      </tr>
   </xsl:for-each>

   <xsl:for-each select="Entry/Augments/ObjectRef">
      <tr>
	 <td>&nbsp;</td>
	 <td>&nbsp;</td>
	 <td colspan="2" class="keyword">Augments:&nbsp;&nbsp;</td>
	 <td colspan="2" class="name">
               <xsl:call-template name="link">
		  <xsl:with-param name="module" select="/Module/@name"/>
		  <xsl:with-param name="elem"><xsl:value-of select="@name"/></xsl:with-param>
		  <xsl:with-param name="text"><xsl:value-of select="@name"/></xsl:with-param>
	       </xsl:call-template> 
	 </td>
      </tr>
   </xsl:for-each>

   <!-- Begin: Indexes Table -->

   <xsl:if test="count(Entry/Indexes) > 0">

      <tr><td colspan="6">&nbsp;</td></tr>
      <tr>
	 <td>&nbsp;</td>
	 <td>&nbsp;</td>
	 <td colspan="4" class="keyword"><a name="{@name}.indexes">Indexes:&nbsp;&nbsp;&nbsp;</a></td>
      </tr>

      <tr> 
	<td>&nbsp;</td>
	<td>&nbsp;</td>
	<td>&nbsp;</td>
	<td colspan="3">

	<table  summary="-" border="{$border}" cellpadding="0" cellspacing="0" 
	       background="" class="element-header" width="60%"> 
	<tr>
	   <th class="keyword" width="10%">&nbsp;#&nbsp;</th>
	   <th class="keyword" width="40%">&nbsp;Object&nbsp;</th>
	   <th class="keyword" width="40%">&nbsp;Type&nbsp;</th>
	   <th class="keyword" width="10%">&nbsp;OID&nbsp;</th>
	</tr>

	<xsl:for-each select="Entry/Indexes/ObjectRef">
	   <xsl:variable name="counter" select="position()"/>

	   <xsl:variable name="rowstyle">
	      <xsl:choose>
		<xsl:when test="($counter mod 2) = 1">row-highlight</xsl:when>
		<xsl:otherwise>row-normal</xsl:otherwise>
	      </xsl:choose>
	   </xsl:variable>

	   <tr class="{$rowstyle}">
	      <td class="text" align="center">
		 <xsl:value-of select="position()"/>&nbsp;
	      </td>
	      <td class="name" align="left"><xsl:call-template name="link">
		     <xsl:with-param name="module" select="../Module/@name"/>
		     <xsl:with-param name="elem"><xsl:value-of select="@name"/></xsl:with-param>
		     <xsl:with-param name="text"><xsl:value-of select="@name"/></xsl:with-param>
		  </xsl:call-template>&nbsp;</td>

	      <td class="text" align="left">&nbsp;<xsl:call-template name="convert-short-type">
		     <xsl:with-param name="type" select="@smitype"/>
		 </xsl:call-template>&nbsp;<xsl:if test="@modifier = 'implied'">
			<i>(implied)</i>
		     </xsl:if></td>
	      <td class="oid" align="right">&nbsp;<xsl:value-of select="@oid"/></td>
	   </tr>
	</xsl:for-each>
	</table>
        </td>
      </tr>
   </xsl:if>
   <!-- End: Indexes Table -->

   <!-- Begin: Column Table -->

   <tr><td colspan="6">&nbsp;</td></tr>
   <tr>
      <td>&nbsp;</td>
      <td>&nbsp;</td>
      <td colspan="4" class="keyword"><a name="{@name}.columns">Columns:&nbsp;&nbsp;</a></td>
   </tr>

   <tr> 
     <td>&nbsp;</td>
     <td>&nbsp;</td>
     <td>&nbsp;</td>
     <td colspan="3">

     <table  summary="-" border="{$border}" cellpadding="0" cellspacing="0" 
	    background="" class="element-header" width="60%"> 
     <tr>
	<th class="keyword" width="10%">&nbsp;#&nbsp;</th>
	<th class="keyword" width="35%">&nbsp;Object&nbsp;</th>
	<th class="keyword" width="10%">&nbsp;Type&nbsp;</th>
	<th class="keyword" width="25%">&nbsp;Syntax&nbsp;</th>
	<th class="keyword" width="10">&nbsp;Access&nbsp;</th>
	<th class="keyword" width="10%">&nbsp;OID&nbsp;</th>
     </tr>

     <xsl:for-each select="Entry/Column">
	    <xsl:variable name="counter" select="position()"/>

	    <xsl:variable name="rowstyle">
	       <xsl:choose>
		  <xsl:when test="($counter mod 2) = 1">row-highlight</xsl:when>
		  <xsl:otherwise>row-normal</xsl:otherwise>
	       </xsl:choose>
	    </xsl:variable>

	   <xsl:variable name="name" select="@name"/>

       <tr class="{$rowstyle}">
	   <td class="text" align="center">
	   <xsl:value-of select="@column"/>&nbsp;
	   </td>

	   <td class="name" align="left"><xsl:call-template name="link">
	    <xsl:with-param name="module" select="../../Module/@name"/>
	    <xsl:with-param name="elem"><xsl:value-of select="@name"/></xsl:with-param>
	    <xsl:with-param name="text"><xsl:value-of select="@name"/></xsl:with-param>
	    </xsl:call-template></td>


	   <td class="text" align="center">&nbsp;<xsl:value-of select="../../../Object[@name=$name]/@smitype"/></td> 
<!--
	   <td class="text" align="left">&nbsp;<xsl:call-template name="convert-short-type">
		  <xsl:with-param name="type" select="@objtype"/>
	      </xsl:call-template>&nbsp;</td>
-->
<!-- SHK TEST -->
	      <td class="text" align="left">
		 <xsl:for-each select="../../../Object[@name=$name]">
		    <xsl:call-template name="process-syntax">
		      <xsl:with-param name="usemodule">false</xsl:with-param>
		      <xsl:with-param name="usesubtype">false</xsl:with-param>
		    </xsl:call-template>
		 </xsl:for-each>
	      </td>
	   <td class="text" align="center">&nbsp;<xsl:value-of select="../../../Object[@name=$name]/@access"/></td> 
	   <td class="oid" align="right">&nbsp;<xsl:value-of select="../../@oid"/>.1.<xsl:value-of select="@column"/></td>
	</tr>
     </xsl:for-each>
     </table>
    </td>
   </tr>
   <!-- End: Column Table -->
   <tr><td colspan="6">&nbsp;</td></tr>

</xsl:template>

<xsl:template name="process-objects">
   <xsl:param name="title"/>
   <xsl:param name="tag"/>
   <xsl:param name="form"/>
   <xsl:param name="otype"/>

   <xsl:call-template name="print-section-header">
      <xsl:with-param name="title"><xsl:value-of select="$title"/></xsl:with-param>
      <xsl:with-param name="tag"><xsl:value-of select="$tag"/></xsl:with-param>
   </xsl:call-template>

   <xsl:variable name="search" select="Object[@form=$form]"/>

   <xsl:call-template name="print-section-toc">
      <xsl:with-param name="search" select="$search"/>
   </xsl:call-template>

   <xsl:for-each select='Object[@form=$form]'>

      <tr>
	 <td colspan="1">&nbsp;</td>
	 <td class="element-header" colspan="4">
	    <a name="{@name}"/>
	    <span class="keyword"><xsl:value-of select="$otype"/>&nbsp;Object:&nbsp;&nbsp;&nbsp;</span><span class="name"><xsl:value-of select="@name"/></span>
	 </td>
	 <td align="right" class="element-header">
	    <span class="oid"><xsl:value-of select="@oid"/></span>
	 </td>
      </tr>

      <tr>
	 <td>&nbsp;</td>
	 <td>&nbsp;</td>
	 <td colspan="3" class="small" align="left">
	    (&nbsp;<a href="#{@name}.status">status</a>&nbsp;|&nbsp;<a href="#{@name}.access">access</a>&nbsp;|&nbsp;<a href="#{@name}.type">type</a>&nbsp;|&nbsp;<a href="#{@name}.syntax">syntax</a>&nbsp;)
	 </td>
	 <td class="small" align="right">
	      (&nbsp;<a href="#{$tag}">section</a>&nbsp;|&nbsp;<a href="#top">top</a>&nbsp;)
	 </td>
      </tr>


      <tr><td colspan="6">&nbsp;</td></tr>

      <xsl:call-template name="process-text-element">
	 <xsl:with-param name="content" select="Description"/>
	 <xsl:with-param name="keyword">Description</xsl:with-param>
	 <xsl:with-param name="level">2</xsl:with-param>
      </xsl:call-template> 


      <xsl:variable name="objName" select="@name"/>

      <!-- Begin Column From Table -->
      <xsl:if test="count(/*/*/Entry/Column[@name=$objName]) > 0">
	 <tr>
	    <td>&nbsp;</td>
	    <td>&nbsp;</td>
	    <td class="keyword" colspan="2">Table:&nbsp;</td>
	    <td class="name" colspan="2">
	    <xsl:for-each select="/*/*/Entry/Column[@name=$objName]">
	       <a href="#{../../@name}"><xsl:value-of select="../../@name"/></a>
	    </xsl:for-each>
	    </td>
	 </tr>
      </xsl:if>

      <!-- End Column From Table -->

      <!-- Begin Entry From Table -->
      <xsl:if test="count(/*/*/Entry[@name=$objName]) > 0">
      <tr>
	 <td>&nbsp;</td>
	 <td>&nbsp;</td>
	 <td class="keyword" colspan="2">Table:&nbsp;&nbsp;</td>
	 <td class="name" colspan="2"><xsl:for-each select="/*/*/Entry[@name=$objName]">
	    <a href="#{../@name}"><xsl:value-of select="../@name"/></a>
	    </xsl:for-each>
	 </td>
      </tr>
      </xsl:if>
      <!-- End Entry From Table -->

      <!-- Begin Index From Table -->
      <xsl:if test="count(/Module/Table/Entry/Indexes/ObjectRef[@name=$objName]) > 0">
       <tr>
	 <td>&nbsp;</td>
	 <td>&nbsp;</td>

	 <td class="keyword" colspan="2">Indexing:&nbsp;&nbsp;</td>
	 <td class="name" colspan="2">
	 <xsl:for-each select="/Module/Table/Entry/Indexes/ObjectRef[@name=$objName]">
	    <xsl:if test="position()>1">,&nbsp;</xsl:if>
	    <span class="name"><a href="#{../../../@name}"><xsl:value-of select="../../../@name"/></a></span>
	 </xsl:for-each>
	 </td>
       </tr>

      </xsl:if>
      <!-- End Index From Table -->


      <tr>
	 <td>&nbsp;</td>
	 <td>&nbsp;</td>
	 <td colspan="2" class="keyword"><a name="{@name}.status">Status:&nbsp;&nbsp;&nbsp;</a></td>
	 <td colspan="2" class="name">
	    <xsl:call-template name="convert-status">
	       <xsl:with-param name="status"><xsl:value-of select="@status"/></xsl:with-param>
	    </xsl:call-template>
	 </td>
      </tr>

      <tr>
	 <td>&nbsp;</td>
	 <td>&nbsp;</td>
	 <td colspan="2" class="keyword"><a name="{@name}.access">Access:&nbsp;&nbsp;&nbsp;</a></td>
	 <td colspan="2" class="name">
	    <xsl:call-template name="convert-access">
	      <xsl:with-param name="access" select="@access"/>
	    </xsl:call-template>
	 </td>
      </tr>

      <tr><td colspan="6">&nbsp;</td></tr>
      <tr>
	 <td>&nbsp;</td>
	 <td>&nbsp;</td>
	 <td colspan="2" class="keyword"><a name="{@name}.type">Type:&nbsp;&nbsp;&nbsp;</a></td>
	 <td colspan="2" class="typedef">
	   <xsl:call-template name="convert-short-type">
	      <xsl:with-param name="type" select="@smitype"/>
	   </xsl:call-template>
	 </td>
      </tr>

      <tr>
	 <td>&nbsp;</td>
	 <td>&nbsp;</td>
	 <td colspan="2" class="keyword"><a name="{@name}.syntax">Syntax:&nbsp;&nbsp;&nbsp;</a></td>
	 <td valign="top" class="typedef" colspan="2">
	   <xsl:call-template name="process-type"/>
	 </td>
      </tr>
      
      <tr><td colspan="6">&nbsp;</td></tr>
      </xsl:for-each>

</xsl:template>

<!-- Begin: Process Notifications -->
<xsl:template name="process-traps-notifications">
   <xsl:param name="title"/>
   <xsl:param name="tag"/>

   <xsl:choose>
   <xsl:when test="count(Trap)>0">
      <xsl:call-template name="process-traps">
         <xsl:with-param name="title" select="$title"/>
         <xsl:with-param name="tag" select="$tag"/>
      </xsl:call-template>
   </xsl:when>
   <xsl:otherwise>
      <xsl:call-template name="process-notifications">
         <xsl:with-param name="title" select="$title"/>
         <xsl:with-param name="tag" select="$tag"/>
      </xsl:call-template>
   </xsl:otherwise>
   </xsl:choose>
</xsl:template>

<!-- Begin: Process Notifications -->
<xsl:template name="process-notifications">
   <xsl:param name="title"/>
   <xsl:param name="tag"/>

   <xsl:call-template name="print-section-header">
      <xsl:with-param name="title"><xsl:value-of select="$title"/></xsl:with-param>
      <xsl:with-param name="tag"><xsl:value-of select="$tag"/></xsl:with-param>
   </xsl:call-template>

   <xsl:variable name="search" select="Notification"/>

   <xsl:call-template name="print-section-toc">
      <xsl:with-param name="search" select="$search"/>
   </xsl:call-template>

   <xsl:for-each select='Notification'>

      <tr>
	 <td>&nbsp;</td>
	 <td class="element-header" colspan="4">
	    <a name="{@name}"/>
	    <span class="keyword">Notification:&nbsp;&nbsp;&nbsp;</span>
	    <span class="name">
	      <xsl:value-of select="@name"/>
	    </span>
	 </td>
	 <td align="right" class="element-header">
	    <span class="oid"><xsl:value-of select="@oid"/></span>
	 </td>
      </tr>

      <tr><td colspan="6">&nbsp;</td></tr>

      <xsl:call-template name="process-text-element">
	 <xsl:with-param name="content" select="Description"/>
	 <xsl:with-param name="keyword">Description</xsl:with-param>
	 <xsl:with-param name="level">2</xsl:with-param>
      </xsl:call-template> 

      <tr>
         <td>&nbsp;</td>
         <td>&nbsp;</td>
         <td colspan="2" class="keyword">Status:&nbsp;&nbsp;&nbsp;</td>
         <td colspan="2" class="name">
            <xsl:call-template name="convert-status">
	       <xsl:with-param name="status"><xsl:value-of select="@status"/></xsl:with-param>
	    </xsl:call-template>
         </td>
      </tr>

      <!-- Begin: List of Objects -->
      <xsl:choose>
      <xsl:when test="count(Objects/ObjectRef)>0">
	 <tr><td colspan="6">&nbsp;</td></tr>
	 <tr> 
	   <td>&nbsp;</td>
	   <td>&nbsp;</td>
	   <td colspan="4" class="keyword">Objects:&nbsp;&nbsp;</td>
	 </tr>

      <tr> 
	<td>&nbsp;</td>
	<td>&nbsp;</td>
	<td>&nbsp;</td>
	<td colspan="3">

	<table  summary="-" border="{$border}" cellpadding="0" cellspacing="0" background="" class="element-header" width="60%"> 
	   <tr>
	      <th class="keyword">&nbsp;Object&nbsp;</th>
	      <th class="keyword">&nbsp;Type&nbsp;</th>
	      <th class="keyword">&nbsp;OID&nbsp;</th>
	   </tr>

	   <xsl:for-each select="Objects/ObjectRef">

	    <xsl:variable name="counter" select="position()"/>

	    <xsl:variable name="rowstyle">
	       <xsl:choose>
		  <xsl:when test="($counter mod 2) = 1">row-highlight</xsl:when>
		  <xsl:otherwise>row-normal</xsl:otherwise>
	       </xsl:choose>
	    </xsl:variable>

	     <tr class="{$rowstyle}">
		 <td class="name" align="left">&nbsp;<xsl:call-template name="link">
			<xsl:with-param name="module" select="../../..//@name"/>
			<xsl:with-param name="elem"><xsl:value-of select="@name"/></xsl:with-param>
			<xsl:with-param name="text"><xsl:value-of select="@name"/></xsl:with-param>
		   </xsl:call-template></td>

		 <td class="text" align="left">&nbsp;<xsl:call-template name="convert-short-type">
			<xsl:with-param name="type" select="@smitype"/>
		    </xsl:call-template>&nbsp;</td>

		 <td class="oid" align="right">&nbsp;<xsl:value-of select="@oid"/></td>
	      </tr>
	    </xsl:for-each>
	  </table>
        </td>
      </tr>

      </xsl:when>
      <xsl:otherwise>
	 <tr><td colspan="6">&nbsp;</td></tr>
	 <tr> 
	   <td>&nbsp;</td>
	   <td>&nbsp;</td>
	   <td colspan="2" class="keyword">Objects:&nbsp;&nbsp;</td>
	   <td colspan="2" class="name">none</td>
	 </tr>
      </xsl:otherwise>
      </xsl:choose>
      <!-- End: List of Objects -->

   <tr><td colspan="6">&nbsp;</td></tr>
   </xsl:for-each>

</xsl:template>
<!-- End: Process Notifications -->

<!-- Begin: Process Traps -->
<xsl:template name="process-traps">
   <xsl:param name="title"/>
   <xsl:param name="tag"/>

   <xsl:call-template name="print-section-header">
      <xsl:with-param name="title"><xsl:value-of select="$title"/></xsl:with-param>
      <xsl:with-param name="tag"><xsl:value-of select="$tag"/></xsl:with-param>
   </xsl:call-template>

   <xsl:variable name="search" select="Trap"/>

   <xsl:call-template name="print-section-toc">
      <xsl:with-param name="search" select="$search"/>
   </xsl:call-template>

   <xsl:for-each select='Trap'>

      <tr>
	 <td>&nbsp;</td>
	 <td class="element-header" colspan="4">
	    <a name="{@name}"/>
	    <span class="keyword">Trap:&nbsp;&nbsp;&nbsp;</span>
	    <span class="name">
	      <xsl:value-of select="@name"/>
	    </span>
	 </td>
	 <td align="right" class="element-header">
	    <span class="oid"><xsl:value-of select="@oid"/></span>
	 </td>
      </tr>

      <tr><td colspan="6">&nbsp;</td></tr>

      <xsl:call-template name="process-text-element">
	 <xsl:with-param name="content" select="Description"/>
	 <xsl:with-param name="keyword">Description</xsl:with-param>
	 <xsl:with-param name="level">2</xsl:with-param>
      </xsl:call-template> 

      <tr>
         <td>&nbsp;</td>
         <td>&nbsp;</td>
         <td colspan="2" class="keyword">Enterprise:&nbsp;&nbsp;&nbsp;</td>
         <td colspan="2" class="name"><xsl:value-of select="@enterprise"/></td>
      </tr>

      <tr>
         <td>&nbsp;</td>
         <td>&nbsp;</td>
         <td colspan="2" class="keyword">Trap Id:&nbsp;&nbsp;&nbsp;</td>
         <td colspan="2" class="name"><xsl:value-of select="@id"/></td>
      </tr>

      <!-- Begin: List of Objects -->
      <xsl:choose>
      <xsl:when test="count(Variables/ObjectRef)>0">
	 <tr><td colspan="6">&nbsp;</td></tr>
	 <tr> 
	   <td>&nbsp;</td>
	   <td>&nbsp;</td>
	   <td colspan="4" class="keyword">Variables:&nbsp;&nbsp;</td>
	 </tr>

      <tr> 
	<td>&nbsp;</td>
	<td>&nbsp;</td>
	<td>&nbsp;</td>
	<td colspan="3">

	<table  summary="-" border="{$border}" cellpadding="0" cellspacing="0" background="" class="element-header" width="60%"> 
	   <tr>
	      <th class="keyword">&nbsp;Object&nbsp;</th>
	      <th class="keyword">&nbsp;Type&nbsp;</th>
	      <th class="keyword">&nbsp;OID&nbsp;</th>
	   </tr>

	   <xsl:for-each select="Variables/ObjectRef">

	    <xsl:variable name="counter" select="position()"/>

	    <xsl:variable name="rowstyle">
	       <xsl:choose>
		  <xsl:when test="($counter mod 2) = 1">row-highlight</xsl:when>
		  <xsl:otherwise>row-normal</xsl:otherwise>
	       </xsl:choose>
	    </xsl:variable>

	     <tr class="{$rowstyle}">
		 <td class="name" align="left">&nbsp;<xsl:call-template name="link">
			<xsl:with-param name="module" select="../../..//@name"/>
			<xsl:with-param name="elem"><xsl:value-of select="@name"/></xsl:with-param>
			<xsl:with-param name="text"><xsl:value-of select="@name"/></xsl:with-param>
		   </xsl:call-template></td>

		 <td class="text" align="left">&nbsp;<xsl:call-template name="convert-short-type">
			<xsl:with-param name="type" select="@smitype"/>
		    </xsl:call-template>&nbsp;</td>

		 <td class="oid" align="right">&nbsp;<xsl:value-of select="@oid"/></td>
	      </tr>
	    </xsl:for-each>
	  </table>
        </td>
      </tr>

      </xsl:when>
      <xsl:otherwise>
	 <tr><td colspan="6">&nbsp;</td></tr>
	 <tr> 
	   <td>&nbsp;</td>
	   <td>&nbsp;</td>
	   <td colspan="2" class="keyword">Variables:&nbsp;&nbsp;</td>
	   <td colspan="2" class="name">none</td>
	 </tr>
      </xsl:otherwise>
      </xsl:choose>
      <!-- End: List of Objects -->

   <tr><td colspan="6">&nbsp;</td></tr>
   </xsl:for-each>

</xsl:template>
<!-- End: Process Traps -->

<!-- Begin: Process Object Groups -->
<xsl:template name="process-object-groups">
   <xsl:param name="title"/>
   <xsl:param name="tag"/>

   <xsl:call-template name="print-section-header">
      <xsl:with-param name="title"><xsl:value-of select="$title"/></xsl:with-param>
      <xsl:with-param name="tag"><xsl:value-of select="$tag"/></xsl:with-param>
   </xsl:call-template>

   <xsl:variable name="search" select="ObjectGroup"/>

   <xsl:call-template name="print-section-toc">
      <xsl:with-param name="search" select="$search"/>
   </xsl:call-template>

   <xsl:for-each select='ObjectGroup'>

      <tr>
	 <td>&nbsp;</td>
	 <td class="element-header" colspan="4">
	    <a name="{@name}"/>
	    <span class="keyword">ObjectGroup:&nbsp;&nbsp;&nbsp;</span>
	    <span class="name">
	      <xsl:value-of select="@name"/>
	    </span>

	 </td>
	 <td align="right" class="element-header">
	    <span class="oid"><xsl:value-of select="@oid"/></span>
	 </td>
      </tr>

      <tr><td colspan="6">&nbsp;</td></tr>

      <xsl:call-template name="process-text-element">
	 <xsl:with-param name="content" select="Description"/>
	 <xsl:with-param name="keyword">Description</xsl:with-param>
	 <xsl:with-param name="level">2</xsl:with-param>
      </xsl:call-template> 

      <tr>
         <td>&nbsp;</td>
         <td>&nbsp;</td>
         <td colspan="2" class="keyword">Status:&nbsp;&nbsp;&nbsp;</td>
         <td colspan="2" class="name">
            <xsl:call-template name="convert-status">
	       <xsl:with-param name="status"><xsl:value-of select="@status"/></xsl:with-param>
	    </xsl:call-template>
         </td>
      </tr>

      <!-- Begin: List of Objects -->

      <tr><td colspan="6">&nbsp;</td></tr>
      <tr> 
	<td>&nbsp;</td>
	<td>&nbsp;</td>
	<td colspan="4" class="keyword">Objects:&nbsp;&nbsp;</td>
      </tr>

      <tr> 
	<td>&nbsp;</td>
	<td>&nbsp;</td>
	<td>&nbsp;</td>
	<td colspan="3">

	<table  summary="-" border="{$border}" cellpadding="0" cellspacing="0" background="" class="element-header" width="60%"> 
	<tr>
	   <th class="keyword">&nbsp;Object&nbsp;</th>
	   <th class="keyword">&nbsp;Type&nbsp;</th>
	   <th class="keyword">&nbsp;OID&nbsp;</th>
	</tr>

	<xsl:for-each select="Objects/ObjectRef">
	 <xsl:variable name="counter" select="position()"/>

	 <xsl:variable name="rowstyle">
	    <xsl:choose>
	       <xsl:when test="($counter mod 2) = 1">row-highlight</xsl:when>
	       <xsl:otherwise>row-normal</xsl:otherwise>
	    </xsl:choose>
	 </xsl:variable>

	  <tr class="{$rowstyle}">
	      <td class="name" align="left">&nbsp;<xsl:call-template name="link">
		  <xsl:with-param name="module" select="../../../@name"/>
		  <xsl:with-param name="elem"><xsl:value-of select="@name"/></xsl:with-param>
		  <xsl:with-param name="text"><xsl:value-of select="@name"/></xsl:with-param>
		  </xsl:call-template>&nbsp;</td>

	      <td class="text" align="left">&nbsp;<xsl:call-template name="convert-short-type">
		     <xsl:with-param name="type" select="@smitype"/>
		 </xsl:call-template>&nbsp;</td>
	      <td class="oid" align="right">&nbsp;<xsl:value-of select="@oid"/></td>
	   </tr>
	  </xsl:for-each>
 	  </table>
        </td>
      </tr>

      <!-- End: List of Objects -->

	       <!-- Begin: List of Contained Groups -->
	       <!-- End: List of Contained Groups -->

   <tr><td colspan="6">&nbsp;</td></tr>

   </xsl:for-each>

</xsl:template>
<!-- End: Process ObjectGroups -->

<!-- Begin: Process Notification Groups -->
<xsl:template name="process-notification-groups">
   <xsl:param name="title"/>
   <xsl:param name="tag"/>

   <xsl:variable name="search" select="NotificationGroup"/>

   <xsl:call-template name="print-section-header">
      <xsl:with-param name="title"><xsl:value-of select="$title"/></xsl:with-param>
      <xsl:with-param name="tag"><xsl:value-of select="$tag"/></xsl:with-param>
   </xsl:call-template>

   <xsl:call-template name="print-section-toc">
      <xsl:with-param name="search" select="$search"/>
   </xsl:call-template>

   <xsl:for-each select='NotificationGroup'>
      <tr>
	 <td>&nbsp;</td>
	 <td class="element-header" colspan="4">
	    <a name="{@name}"/>
	    <span class="keyword">NotificationGroup:&nbsp;&nbsp;&nbsp;</span>
	    <span class="name">
	      <xsl:value-of select="@name"/>
	    </span>

	 </td>
	 <td align="right" class="element-header">
	    <span class="oid"><xsl:value-of select="@oid"/></span>
	 </td>
      </tr>

      <tr><td colspan="6">&nbsp;</td></tr>

      <xsl:call-template name="process-text-element">
	 <xsl:with-param name="content" select="Description"/>
	 <xsl:with-param name="keyword">Description</xsl:with-param>
	 <xsl:with-param name="level">2</xsl:with-param>
      </xsl:call-template> 

      <tr>
         <td>&nbsp;</td>
         <td>&nbsp;</td>
         <td colspan="2" class="keyword">Status:&nbsp;&nbsp;&nbsp;</td>
         <td colspan="2" class="name">
            <xsl:call-template name="convert-status">
	       <xsl:with-param name="status"><xsl:value-of select="@status"/></xsl:with-param>
	    </xsl:call-template>
         </td>
      </tr>



     <!-- Begin: List of Objects -->
     <tr><td colspan="6">&nbsp;</td></tr>
     <tr>
         <td>&nbsp;</td>
         <td>&nbsp;</td>
         <td colspan="4" class="keyword">Notifications:&nbsp;&nbsp;&nbsp;</td>
     </tr>

     <tr> 
	<td>&nbsp;</td>
	<td>&nbsp;</td>
	<td>&nbsp;</td>
	<td colspan="3">
	   <table  summary="-" border="{$border}" cellpadding="0" cellspacing="0" background="" class="element-header" width="60%"> 
	   <tr>
	      <th class="keyword">&nbsp;Notification&nbsp;</th>
	      <th class="keyword">&nbsp;OID&nbsp;</th>
	   </tr>

	   <xsl:for-each select="Notifications/NotificationRef">
	    <xsl:variable name="counter" select="position()"/>

	    <xsl:variable name="rowstyle">
	       <xsl:choose>
		  <xsl:when test="($counter mod 2) = 1">row-highlight</xsl:when>
		  <xsl:otherwise>row-normal</xsl:otherwise>
	       </xsl:choose>
	    </xsl:variable>

	     <tr class="{$rowstyle}" align="left">
		<td class="name">&nbsp;<xsl:call-template name="link">
		      <xsl:with-param name="module" select="../../../@module"/>
		      <xsl:with-param name="elem"><xsl:value-of select="@name"/></xsl:with-param>
		      <xsl:with-param name="text"><xsl:value-of select="@name"/></xsl:with-param>
		  </xsl:call-template>&nbsp;</td>

	        <td class="oid" align="right">&nbsp;<xsl:value-of select="@oid"/></td>
	      </tr>
	   </xsl:for-each>
	   </table>
         </td>
       </tr>
      <!-- End: List of Objects -->

    <tr><td colspan="6">&nbsp;</td></tr>

    </xsl:for-each>

</xsl:template>
<!-- End: Process NotificationGroups -->

<!-- Begin: Process Agent Capabilities -->
<xsl:template name="process-agent-capabilities">
   <xsl:param name="title"/>
   <xsl:param name="tag"/>

   <xsl:call-template name="print-section-header">
      <xsl:with-param name="title"><xsl:value-of select="$title"/></xsl:with-param>
      <xsl:with-param name="tag"><xsl:value-of select="$tag"/></xsl:with-param>
   </xsl:call-template>

   <xsl:variable name="search" select="AgentCapabilities"/>

   <xsl:call-template name="print-section-toc">
      <xsl:with-param name="search" select="$search"/>
   </xsl:call-template>

   <xsl:for-each select='AgentCapabilities'>
      <tr>
	 <td>&nbsp;</td>
	 <td class="element-header" colspan="4">
	    <a name="{@name}"/>
	    <span class="keyword">AgentCapabilities:&nbsp;&nbsp;&nbsp;</span>
	    <span class="name">
	      <xsl:value-of select="@name"/>
	    </span>
	 </td>

	 <td align="right" class="element-header">
	    <span class="oid"><xsl:value-of select="@oid"/></span>
	 </td>
      </tr>

      <xsl:call-template name="process-text-element">
	 <xsl:with-param name="content" select="ProductRelease"/>
	 <xsl:with-param name="keyword">Product&nbsp;Release</xsl:with-param>
	 <xsl:with-param name="level">2</xsl:with-param>
      </xsl:call-template> 

      <xsl:call-template name="process-text-element">
	 <xsl:with-param name="content" select="Description"/>
	 <xsl:with-param name="keyword">Description</xsl:with-param>
	 <xsl:with-param name="level">2</xsl:with-param>
      </xsl:call-template> 

      <xsl:call-template name="process-text-element">
	 <xsl:with-param name="content" select="Reference"/>
	 <xsl:with-param name="keyword">Reference</xsl:with-param>
	 <xsl:with-param name="level">2</xsl:with-param>
      </xsl:call-template> 

      <tr>
         <td>&nbsp;</td>
         <td>&nbsp;</td>
         <td colspan="2" class="keyword">Status:&nbsp;&nbsp;&nbsp;</td>
         <td colspan="2" class="name">
            <xsl:call-template name="convert-status">
	       <xsl:with-param name="status"><xsl:value-of select="@status"/></xsl:with-param>
	    </xsl:call-template>
         </td>
      </tr>

      <!-- Begin: List of Supports -->
      <xsl:for-each select="Supports"> <!-- Supports -->

        <tr>
	   <td>&nbsp;</td>
	   <td>&nbsp;</td>
	   <td colspan="2" class="sub-header"><span class="keyword">Supports:&nbsp;&nbsp;</span></td>
	   <td colspan="2" class="sub-header"><span class="name">
	       <xsl:call-template name="link">
		  <xsl:with-param name="module" select="@module"/>
		  <xsl:with-param name="text"><xsl:value-of select="@module"/></xsl:with-param>
	       </xsl:call-template> 
	   </span>
	   </td>
	</tr>

	<!-- Begin: Includes -->
	<xsl:for-each select="Includes"> <!-- Includes -->

	<tr><td colspan="6">&nbsp;</td></tr> 

	<tr> 
	   <td>&nbsp;</td>
	   <td>&nbsp;</td>
	   <td>&nbsp;</td>
	   <td colspan="3">

	      <table  summary="-" border="{$border}" cellpadding="0" cellspacing="0" background="" class="element-header" width="70%"> 
	      <tr>
		 <th class="keyword" width="90%">Includes&nbsp;Group&nbsp;</th>
		 <th class="keyword">&nbsp;OID&nbsp;</th>
	      </tr>

	      <xsl:for-each select="GroupRef"> <!-- Groups -->
	       <xsl:variable name="counter" select="position()"/>

	       <xsl:variable name="rowstyle">
		  <xsl:choose>
		     <xsl:when test="($counter mod 2) = 1">row-highlight</xsl:when>
		     <xsl:otherwise>row-normal</xsl:otherwise>
		  </xsl:choose>
	       </xsl:variable>

		<tr class="{$rowstyle}">
		    <td class="name">&nbsp;
			<xsl:call-template name="link">&nbsp;&nbsp;&nbsp;
			   <xsl:with-param name="module" select="../../@module"/>
			   <xsl:with-param name="elem"><xsl:value-of select="@name"/></xsl:with-param>
			   <xsl:with-param name="text"><xsl:value-of select="@name"/></xsl:with-param>
			</xsl:call-template> 
		     </td>

		    <td class="oid">&nbsp;<xsl:value-of select="@oid"/></td>
		 </tr>
	      </xsl:for-each> <!-- Groups -->
	      </table>
	    </td>
	 </tr>
      </xsl:for-each> <!-- Includes -->

      <!-- Begin: Variation List -->
      <xsl:if test="count(Variation)>0">

	<tr> <td colspan="6">&nbsp;</td> </tr> 

	<xsl:for-each select="Variation"> <!-- Includes -->
	   <tr> 
	     <td>&nbsp;</td>
	     <td>&nbsp;</td>
	     <td>&nbsp;</td>
	      <td class="sub-header" colspan="2">
		 <span class="keyword">Variation:&nbsp;&nbsp;&nbsp;</span>
		    <span class="name"><xsl:call-template name="link">
			<xsl:with-param name="module" select="../@module"/>
			<xsl:with-param name="elem"><xsl:value-of select="@name"/></xsl:with-param>
			<xsl:with-param name="text"><xsl:value-of select="@name"/></xsl:with-param>
		     </xsl:call-template> </span>
	      </td>

	      <td class="sub-header" align="right"><span class="oid"><xsl:value-of select="@oid"/></span></td>
	   </tr>

	   <tr><td colspan="6">&nbsp;</td></tr>

	   <xsl:call-template name="process-text-element">
	       <xsl:with-param name="content" select="Description"/>
	       <xsl:with-param name="keyword">Description</xsl:with-param>
	       <xsl:with-param name="level">3</xsl:with-param>
	    </xsl:call-template> 

	    <tr> <td colspan="6">&nbsp;</td> </tr>

	    <xsl:if test="string-length(@access)>0">
	      <tr>
		<td>&nbsp;</td>
		<td>&nbsp;</td>
		<td>&nbsp;</td>

		<td colspan="1" class="keyword">Access:&nbsp;&nbsp;&nbsp;</td>
		<td colspan="2" class="name">
		    <xsl:call-template name="convert-access">
		      <xsl:with-param name="access" 
				      select="@access"/>
		    </xsl:call-template>
		</td>
	      </tr>
	    </xsl:if>

	    <xsl:if test="string-length(@status)>0">
	      <tr>
		<td>&nbsp;</td>
		<td>&nbsp;</td>
		<td>&nbsp;</td>

		<td colspan="1" class="keyword">Status:&nbsp;&nbsp;&nbsp;</td>
		<td colspan="2" class="name">
		    <xsl:call-template name="convert-status">
		      <xsl:with-param name="status" select="@status"/>
		    </xsl:call-template>
		</td>
	      </tr>
	    </xsl:if>

	    <xsl:if test="string-length(@defval)>0">
	      <tr>
		<td>&nbsp;</td>
		<td>&nbsp;</td>
		<td>&nbsp;</td>

		<td colspan="1" class="keyword">DefVal:&nbsp;&nbsp;&nbsp;</td>
		<td colspan="2" class="name">
		      <xsl:value-of select="@defval"/>
		</td>
	      </tr>
	    </xsl:if>

	    <xsl:if test="count(Syntax)>0">
	      <tr>
		<td>&nbsp;</td>
		<td>&nbsp;</td>
		<td>&nbsp;</td>

		<td colspan="1" valign="top" class="keyword">Syntax:&nbsp;&nbsp;&nbsp;</td>
		<td colspan="2" class="typedef" valign="top">
		    <xsl:for-each select="Syntax/Type">
		       <xsl:call-template name="process-type"/>
		    </xsl:for-each>
		</td>
	      </tr>
	    </xsl:if>

	    <xsl:if test="count(WriteSyntax)>0">
	      <tr>
		<td>&nbsp;</td>
		<td>&nbsp;</td>
		<td>&nbsp;</td>

		<td valign="top" class="keyword">Write&nbsp;Syntax:&nbsp;&nbsp;&nbsp;</td>
		<td colspan="2" class="typedef" valign="top">
		    <xsl:for-each select="WriteSyntax/Type">
		       <xsl:call-template name="process-type"/>
		    </xsl:for-each>
		</td>
	      </tr>
	    </xsl:if>

	    <xsl:if test="count(CreationRequires)>0">
	       <tr>
		  <td>&nbsp;</td>
		  <td>&nbsp;</td>
		  <td>&nbsp;</td>
		  <td colspan="3">
		     <span class="keyword">Creation&nbsp;Requires:&nbsp;&nbsp;</span>
		  </td>
	       </tr>

	       <tr>
		  <td>&nbsp;</td>
		  <td>&nbsp;</td>
		  <td>&nbsp;</td>
		  <td>&nbsp;</td>
		  <td colspan="2">

		     <table  summary="-" border="{$border}" cellpadding="0" cellspacing="0" 
		   	     background="" class="element-header" width="60%"> 
		     <tr>
			<th class="keyword">&nbsp;Object&nbsp;</th>
			<th class="keyword">&nbsp;Type&nbsp;</th>
			<th class="keyword">&nbsp;OID&nbsp;</th>
		     </tr>

		     <xsl:for-each select="CreationRequires/ObjectRef">
			<xsl:variable name="counter" select="position()"/>

			<xsl:variable name="rowstyle">
			   <xsl:choose>
			      <xsl:when test="($counter mod 2) = 1">row-highlight</xsl:when>
			      <xsl:otherwise>row-normal</xsl:otherwise>
			   </xsl:choose>
			</xsl:variable>

		        <tr class="{$rowstyle}">
		          <td class="name">&nbsp;<xsl:call-template name="link">
			      <xsl:with-param name="module" select="../../../@module"/>
			      <xsl:with-param name="elem"><xsl:value-of select="@name"/></xsl:with-param>
			      <xsl:with-param name="text"><xsl:value-of select="@name"/></xsl:with-param>
			    </xsl:call-template> 
			  </td>
			  <td class="text">
			     &nbsp;<xsl:call-template name="convert-short-type"><xsl:with-param name="type" select="@smitype"/></xsl:call-template>&nbsp; 
			  </td>
			  <td class="oid" align="right">&nbsp;<xsl:value-of select="@oid"/></td>
			</tr>
		     </xsl:for-each>
		  </table>
	         </td>
	      </tr>
	    </xsl:if>

      <tr><td colspan="6">&nbsp;</td></tr>

      </xsl:for-each> <!-- Variation List -->
      </xsl:if>

   </xsl:for-each> <!-- Supports -->

   </xsl:for-each> <!-- AgentCapabilities -->

</xsl:template>
<!-- End: Process AgentCapabilities -->

<!-- Begin: Process Module Compliances -->
<xsl:template name="process-module-compliances">
   <xsl:param name="title"/>
   <xsl:param name="tag"/>

   <xsl:call-template name="print-section-header">
      <xsl:with-param name="title"><xsl:value-of select="$title"/></xsl:with-param>
      <xsl:with-param name="tag"><xsl:value-of select="$tag"/></xsl:with-param>
   </xsl:call-template>

   <xsl:variable name="search" select="ModuleCompliance"/>

   <xsl:call-template name="print-section-toc">
      <xsl:with-param name="search" select="$search"/>
   </xsl:call-template>

   <xsl:for-each select='ModuleCompliance'>

      <tr>
 	 <td>&nbsp;</td>
	 <td class="element-header" colspan="4">
	    <a name="{@name}"/>
	    <span class="keyword">ModuleCompliance:&nbsp;&nbsp;&nbsp;</span>
	    <span class="name">
	      <xsl:value-of select="@name"/>
	    </span>
	 </td>
	 <td align="right" class="element-header">
	    <span class="oid"><xsl:value-of select="@oid"/></span>
	 </td>
      </tr>

      <tr><td colspan="6">&nbsp;</td></tr>

      <xsl:call-template name="process-text-element">
	 <xsl:with-param name="content" select="Description"/>
	 <xsl:with-param name="keyword">Description</xsl:with-param>
	 <xsl:with-param name="level">2</xsl:with-param>
      </xsl:call-template> 

      <xsl:call-template name="process-text-element">
	 <xsl:with-param name="content" select="Reference"/>
	 <xsl:with-param name="keyword">Reference</xsl:with-param>
	 <xsl:with-param name="level">2</xsl:with-param>
      </xsl:call-template> 

      <tr>
         <td>&nbsp;</td>
         <td>&nbsp;</td>
         <td colspan="2" class="keyword">Status:&nbsp;&nbsp;&nbsp;</td>
         <td colspan="2" class="name">
            <xsl:call-template name="convert-status">
	       <xsl:with-param name="status" select="@status"/>
	    </xsl:call-template>
         </td>
      </tr>

      <tr><td colspan="6">&nbsp;</td></tr>

      <!-- Begin: List of McModule -->
      <xsl:for-each select="McModule"> <!-- Supports -->
	 <tr>
           <td>&nbsp;</td>
           <td>&nbsp;</td>

	   <td colspan="2" class="sub-header"> 
	     <span class="keyword">Module:</span>
	   </td>

	   <td colspan="2" class="sub-header"> 
	     <span class="name">
	         <xsl:call-template name="link">
		     <xsl:with-param name="module" select="@module"/>
		     <xsl:with-param name="text" select="@module"/>
		 </xsl:call-template> 
	     </span>
	     &nbsp;
	   </td>
	 </tr>
	
	<!-- Begin: MandatoryGroups -->
	<xsl:for-each select="MandatoryGroups"> <!-- Includes -->
	   <tr><td colspan="6">&nbsp;</td></tr> 

	   <tr> 
	      <td>&nbsp;</td>
	      <td>&nbsp;</td>
	      <td>&nbsp;</td>
	      <td colspan="3">
		 <table summary="-" border="{$border}" cellpadding="0" cellspacing="0" 
		        background="" class="element-header" width="60%"> 
		    <tr>
		       <th class="keyword" width="90%">Mandatory&nbsp;Group&nbsp;</th>
		       <th class="keyword">&nbsp;OID&nbsp;</th>
		    </tr>

		    <xsl:for-each select="GroupRef"> <!-- Groups -->
		     <xsl:variable name="counter" select="position()"/>

		     <xsl:variable name="rowstyle">
			<xsl:choose>
			   <xsl:when test="($counter mod 2) = 1">row-highlight</xsl:when>
			   <xsl:otherwise>row-normal</xsl:otherwise>
			</xsl:choose>
		     </xsl:variable>

		      <tr class="{$rowstyle}">
			  <td class="name">&nbsp;
			      <xsl:call-template name="link">&nbsp;&nbsp;&nbsp;
			      <xsl:with-param name="module" select="../../@module"/>
			      <xsl:with-param name="elem"><xsl:value-of select="@name"/></xsl:with-param>
			      <xsl:with-param name="text"><xsl:value-of select="@name"/></xsl:with-param>
			      </xsl:call-template> 
			   </td>

			  <td class="oid">&nbsp;<xsl:value-of select="@oid"/></td>
		       </tr>
		    </xsl:for-each> <!-- Groups -->
	      </table>
	     </td>
	   </tr>
      </xsl:for-each> <!-- MandatoryGroups -->

      <!-- Begin: Group List -->
      <xsl:if test="count(McGroup)>0">

	<tr><td colspan="6">&nbsp;</td></tr> 

	<xsl:for-each select="McGroup"> 

	<tr> 
	 <td>&nbsp;</td>
	 <td>&nbsp;</td>
	 <td>&nbsp;</td>
	 <td class="sub-header"><span class="keyword">Group:</span></td>
	 <td class="sub-header"><span class="name">
	       <xsl:call-template name="link">
		  <xsl:with-param name="module" select="../@module"/>
		  <xsl:with-param name="elem"><xsl:value-of select="@name"/></xsl:with-param>
		  <xsl:with-param name="text"><xsl:value-of select="@name"/></xsl:with-param>
	       </xsl:call-template></span> 
	  </td>
	  <td class="sub-header" align="right"><span class="oid"><xsl:value-of select="@oid"/></span></td>
	 </tr>

	 <tr><td colspan="6">&nbsp;</td></tr>

	<xsl:call-template name="process-text-element">
	    <xsl:with-param name="content" select="Description"/>
	    <xsl:with-param name="keyword">Description</xsl:with-param>
	    <xsl:with-param name="level">3</xsl:with-param>
	</xsl:call-template> 

	 <tr> <td colspan="6">&nbsp;</td> </tr>

      </xsl:for-each> 
      </xsl:if>

     <!-- Begin: McObject List -->

     <xsl:if test="count(McObject)>0">

     <xsl:for-each select="McObject"> 
	<tr> 
	 <td>&nbsp;</td>
	 <td>&nbsp;</td>
	 <td>&nbsp;</td>
	 <td class="sub-header" colspan="1"><span class="keyword">Exception:</span></td>
	 <td class="sub-header"><span class="name">
	       <xsl:call-template name="link">
		  <xsl:with-param name="module" select="../@module"/>
		  <xsl:with-param name="elem"><xsl:value-of select="@name"/></xsl:with-param>
		  <xsl:with-param name="text"><xsl:value-of select="@name"/></xsl:with-param>
	       </xsl:call-template></span> 
	   </td>
	   <td class="sub-header" align="right"><span class="oid"><xsl:value-of select="@oid"/></span></td>
	</tr>

	<tr><td colspan="6">&nbsp;</td></tr>

	<xsl:call-template name="process-text-element">
	    <xsl:with-param name="content" select="Description"/>
	    <xsl:with-param name="keyword">Description</xsl:with-param>
	    <xsl:with-param name="level">3</xsl:with-param>
	 </xsl:call-template> 

	 <xsl:if test="string-length(@access)>0">
	   <tr>
	     <td>&nbsp;</td>
	     <td>&nbsp;</td>
	     <td>&nbsp;</td>

	     <td colspan="1" class="keyword">Access:&nbsp;&nbsp;&nbsp;</td>
	     <td colspan="2" class="name">
		 <xsl:call-template name="convert-access">
		   <xsl:with-param name="access" 
				   select="@access"/>
		 </xsl:call-template>
	     </td>
	   </tr>
	 </xsl:if>

	 <xsl:if test="count(Syntax)>0">
	   <tr>
	     <td>&nbsp;</td>
	     <td>&nbsp;</td>
	     <td>&nbsp;</td>

	     <td colspan="1" valign="top" class="keyword">Syntax:&nbsp;&nbsp;&nbsp;</td>
	     <td colspan="2" class="typedef" valign="top">
		 <xsl:for-each select="Syntax/Type">
		    <xsl:call-template name="process-type"/>
		 </xsl:for-each>
	     </td>
	   </tr>
	 </xsl:if>

	 <xsl:if test="count(WriteSyntax)>0">
	   <tr>
	     <td>&nbsp;</td>
	     <td>&nbsp;</td>
	     <td>&nbsp;</td>

	     <td valign="top" class="keyword">Write&nbsp;Syntax:&nbsp;</td>
	     <td colspan="2" class="typedef" valign="top">
		 <xsl:for-each select="WriteSyntax/Type">
		    <xsl:call-template name="process-type"/>
		 </xsl:for-each>
	     </td>
	   </tr>
	 </xsl:if>

         <tr><td colspan="6">&nbsp;</td></tr>
   </xsl:for-each> 
   </xsl:if>

   <!-- McObject List -->

   </xsl:for-each> <!-- McGroup -->

   </xsl:for-each>
</xsl:template>
<!-- End: Process AgentCapabilities -->

<!-- ************************************************************** -->
<!-- Subroutines for generic processing                              -->
<!-- ************************************************************** -->

<xsl:template name="process-type">
  <xsl:param name="noname" select="false"/>
  <xsl:if test="string-length(@name)>0 and $noname='false'"> 
     <xsl:value-of select="@name"/>&nbsp;::=&nbsp;
  </xsl:if>

  <xsl:choose>
     <xsl:when test=" (local-name() = 'Type') and (count(Description)>0)"> 
	<xsl:call-template name="process-textual-convention"/>
     </xsl:when>
     <xsl:otherwise>
	<xsl:call-template name="process-syntax"/>
     </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template name="process-textual-convention">
  
  <span class="keyword">TEXTUAL&nbsp;CONVENTION</span><br/>
  <table summary="-" border="{$border}" cellspacing="0" cellpadding="0" width="100%">
     <tr>
       <td width="{$indent}">&nbsp;&nbsp;&nbsp;</td>
       <td width="{$indent}">&nbsp;&nbsp;&nbsp;</td>
       <td width="5%">&nbsp;&nbsp;&nbsp;</td>
       <td width="5%">&nbsp;&nbsp;&nbsp;&nbsp;</td>
       <td width="20%">&nbsp;&nbsp;&nbsp;&nbsp;</td>
       <td width="60%">&nbsp;</td>
     </tr>

     <xsl:call-template name="process-text-element">
	 <xsl:with-param name="content" select="Description"/>
	 <xsl:with-param name="keyword">Description:</xsl:with-param>
	 <xsl:with-param name="level">0</xsl:with-param>
     </xsl:call-template> 

     <xsl:call-template name="process-text-element">
	 <xsl:with-param name="content" select="Reference"/>
	 <xsl:with-param name="keyword">Reference:</xsl:with-param>
	 <xsl:with-param name="level">0</xsl:with-param>
     </xsl:call-template> 

     <xsl:if test="string-length(@displayHint)>0"> 
       <tr>
	 <td class="keyword" colspan="2">Display&nbsp;Hint:&nbsp;</td>
	 <td class="typedef" colspan="4">"<xsl:value-of select="@displayHint"/>"</td>
       </tr>
     </xsl:if>

     <xsl:if test="string-length(@status)>0"> 
       <tr>
	 <td class="keyword" colspan="2">Status:&nbsp;&nbsp;&nbsp;</td>
	 <td class="name" colspan="4">
	   <xsl:call-template name="convert-status">
	       <xsl:with-param name="status"><xsl:value-of select="@status"/></xsl:with-param>
	   </xsl:call-template>
	 </td>
       </tr>
     </xsl:if>

     <tr>
       <td class="keyword" valign="top" colspan="2">Syntax:&nbsp;&nbsp;&nbsp;</td>
       <td class="typedef" colspan="4" valign="top">
	<xsl:call-template name="process-syntax"/>
       </td>
     </tr>
  </table>
</xsl:template>

<xsl:template name="process-syntax">
  <xsl:param name="usemodule" select=""/>
  <xsl:param name="usesubtype" select=""/>
  <xsl:choose>
     <xsl:when test="@smitype='entry'">SEQUENCE</xsl:when>
     <xsl:when test="string-length(@typeref)>0"> 
	<xsl:call-template name="link">
	    <xsl:with-param name="usemodule" select="$usemodule"/>
	    <xsl:with-param name="module" select="/Module/@name"/>
	    <xsl:with-param name="pre">type.</xsl:with-param>
	    <xsl:with-param name="elem"><xsl:value-of select="@typeref"/></xsl:with-param>
	    <xsl:with-param name="text"><xsl:value-of select="@typeref"/></xsl:with-param>
	 </xsl:call-template> 
     </xsl:when>
     <xsl:when test="string-length(@smitype)>0"> 
	<xsl:call-template name="convert-short-type">
	    <xsl:with-param name="type" select="@smitype"/>
	</xsl:call-template>
     </xsl:when>
     <xsl:otherwise>
	<xsl:value-of select="@type"/> 
     </xsl:otherwise>
  </xsl:choose>
  <xsl:if test="$usesubtype != 'false'">
  <xsl:choose>
     <xsl:when test="count(NamedNumberList)>0">
	<xsl:call-template name="process-named-number-list"/>
     </xsl:when>
     <xsl:when test="count(Size)>0"><xsl:call-template name="process-size"/></xsl:when>
     <xsl:when test="count(RangeSpec)>0"><xsl:call-template name="process-rangespec"/></xsl:when>
  </xsl:choose>
  </xsl:if>
</xsl:template>

<xsl:template name="process-named-number-list">
   <xsl:for-each select="NamedNumberList">
      <xsl:param name="cnt"><xsl:value-of select="count(nn)"/></xsl:param>
      <table  summary="-" border="{$border}" cellspacing="0" cellpadding="0">
        <tr><td class="typedef">{&nbsp;&nbsp;</td>
	                    <td class="typedef">&nbsp;</td></tr>
	 <xsl:for-each select="nn">

	   <tr><td class="typedef">&nbsp;</td>
	       <td class="typedef"><xsl:value-of select="@name"/>(<xsl:value-of select="@value"/>)<xsl:if test='position()&lt;$cnt'>,</xsl:if></td>
           </tr>
	 </xsl:for-each>
        <tr><td class="typedef">}</td>
	<td class="typedef">&nbsp;</td></tr>
      </table>
   </xsl:for-each>
</xsl:template>

<xsl:template name="process-size">
   <xsl:for-each select="Size">
      (SIZE<xsl:call-template name="process-rangespec"/>)
   </xsl:for-each>
</xsl:template>

<xsl:template name="process-rangespec">
   (<xsl:for-each select="RangeSpec/RangeItem">
      <xsl:if test="position()>1">|</xsl:if>
      <xsl:if test="string-length(@single)">
         <xsl:value-of select="@single"/>
      </xsl:if>
      <xsl:if test="string-length(@lower)"><xsl:value-of select="@lower"/>..</xsl:if>
      <xsl:if test="string-length(@upper)"><xsl:value-of select="@upper"/></xsl:if>
   </xsl:for-each>)
</xsl:template>

<xsl:template name="process-text-element">
   <xsl:param name="content"/>
   <xsl:param name="keyword"/>
   <xsl:param name="level" select="1"/>

   <xsl:variable name="lremain" select="6-number($level)"/>
   <xsl:variable name="tlevel"  select="number($level)+1"/>
   <xsl:variable name="tremain" select="6-number($tlevel)"/>

      <xsl:if test="$content != ''">

	 <tr>
	    <xsl:if test="number($level)>0">
	       <td colspan="{$level}">&nbsp;</td>
	    </xsl:if>
	    <td class="keyword" colspan="{$lremain}">
	       <span class="keyword"><xsl:value-of select="$keyword"/></span>
	    </td>
	 </tr>
	 <tr> 
	    <td colspan="{$tlevel}">&nbsp;</td>
	    <td colspan="{$tremain}"><pre class="text"><xsl:value-of select="$content"/></pre></td>
	  </tr>
          <tr><td colspan="6">&nbsp;</td></tr>
       </xsl:if>

</xsl:template>

<xsl:template name="print-section-header">
   <xsl:param name="title"/>
   <xsl:param name="tag"/>
      <tr>
	 <td class="section-header" colspan="5">
	    <a name="{$tag}"><span class="keyword"><xsl:value-of select="$title"/></span></a>
	 </td>
	 <td class="section-header" align="right">
	    <span class="keyword">MIB:&nbsp;&nbsp;</span>
	    <span class="keyword"><a href="#top"><xsl:value-of select="/Module/@name"/></a></span>
	 </td>
      </tr>
</xsl:template>

<xsl:template name="print-section-toc">
   <xsl:param name="search"/>
   <xsl:param name="prefix"/>
   <xsl:param name="colsize" select="floor((count($search)+2) div 3)"/>

   <tr><td colspan="6">&nbsp;</td></tr>
   <tr>
     <td colspan="2">&nbsp;</td>
     <td colspan="4">
   <table summary="-" border="{$border}" cellpadding="0" cellspacing="0">
      <tr>
 	 <td class="toc" valign="top" align="left">
	    <table summary="-" border="{$border}" cellpadding="0" cellspacing="0">
	      <xsl:for-each select="$search">
		 <xsl:param name="nm"><xsl:value-of select="$prefix"/><xsl:value-of select="@name"/></xsl:param>
		    <tr>
		       <td class="toc" align="right">&nbsp;&nbsp;<xsl:value-of select="position()"/>)</td> 
		    <td class="toc" align="left">&nbsp;<a href="#{$nm}"><xsl:value-of select="@name"/></a>&nbsp;&nbsp;</td></tr>

		    <xsl:if test=" (position() mod $colsize) = 0"> <xsl:text disable-output-escaping="yes">&lt;/table&gt;&lt;/td&gt;&lt;td class="toc" align="left" valign="top"&gt;&lt;table  border="0" cellpadding="0" cellspacing="0" summary="-"&gt;</xsl:text></xsl:if>
	        </xsl:for-each>
	    </table>
	 </td>
      </tr>
   </table>
     </td>
   </tr>
   <tr><td colspan="6">&nbsp;</td></tr>
</xsl:template>

<xsl:template name="convert-short-type">
   <xsl:param name="type"/>
   <xsl:choose>
     <xsl:when test="$type = 's'">
       <xsl:text>OCTET&nbsp;STRING</xsl:text>
     </xsl:when>
     <xsl:when test="$type = 'c'">
       <xsl:text>Counter</xsl:text>
     </xsl:when>
     <xsl:when test="$type = 'c32'">
       <xsl:text>Counter32</xsl:text>
     </xsl:when>
     <xsl:when test="$type = 'c64'">
       <xsl:text>Counter64</xsl:text>
     </xsl:when>
     <xsl:when test="$type = 'i'">
       <xsl:text>INTEGER</xsl:text>
     </xsl:when>
     <xsl:when test="$type = 'i32'">
       <xsl:text>Integer32</xsl:text>
     </xsl:when>
     <xsl:when test="$type = 'u32'">
       <xsl:text>Unsigned32</xsl:text>
     </xsl:when>
     <xsl:when test="$type = 'g'">
       <xsl:text>Gauge</xsl:text>
     </xsl:when>
     <xsl:when test="$type = 'g32'">
       <xsl:text>Gauge32</xsl:text>
     </xsl:when>
     <xsl:when test="$type = 'ip'">
       <xsl:text>IpAddress</xsl:text>
     </xsl:when>
     <xsl:when test="$type = 't'">
       <xsl:text>TimeTicks</xsl:text>
     </xsl:when>
     <xsl:when test="$type = 'b'">
       <xsl:text>BITS</xsl:text>
     </xsl:when>
     <xsl:when test="$type = 'entry'">
       <xsl:text>SEQUENCE</xsl:text>
     </xsl:when>
     <xsl:when test="$type = 'o'">
       <xsl:text>OBJECT&nbsp;IDENTIFIER</xsl:text>
     </xsl:when>
     <xsl:otherwise>
       <xsl:text>Unknown</xsl:text>
     </xsl:otherwise>
   </xsl:choose>
</xsl:template>

<xsl:template name="convert-access">
   <xsl:param name="access"/>
   <xsl:choose>
     <xsl:when test="$access = 'ro'">
       <xsl:text><span class="ro">read-only</span></xsl:text>
     </xsl:when>
     <xsl:when test="$access = 'rw'">
       <xsl:text><span class="rw">read-write</span></xsl:text>
     </xsl:when>
     <xsl:when test="$access = 'wo'">
       <xsl:text><span class="wo">write-only</span></xsl:text>
     </xsl:when>
     <xsl:when test="$access = 'rc'">
       <xsl:text><span class="rc">read-create</span></xsl:text>
     </xsl:when>
     <xsl:when test="$access = 'na'">
       <xsl:text><span class="na">not-accessible</span></xsl:text>
     </xsl:when>
     <xsl:when test="$access = 'ni'">
       <xsl:text><span class="ni">not-implemented</span></xsl:text>
     </xsl:when>
     <xsl:when test="$access = 'no'">
       <xsl:text><span class="no">accessible-for-notify</span></xsl:text>
     </xsl:when>
     <xsl:otherwise>
       <xsl:text>undefined</xsl:text>
     </xsl:otherwise>
   </xsl:choose>
</xsl:template>

<xsl:template name="convert-status">
   <xsl:param name="status"/>
   <xsl:choose>
     <xsl:when test="$status = 'current'">
       <xsl:text><span class="current">current</span></xsl:text>
     </xsl:when>
     <xsl:when test="$status = 'obsolete'">
       <xsl:text><span class="obsolete">obsolete</span></xsl:text>
     </xsl:when>
     <xsl:when test="$status = 'deprecated'">
       <xsl:text><span class="deprecated">deprecated</span></xsl:text>
     </xsl:when>
     <xsl:when test="$status = 'optional'">
       <xsl:text><span class="optional">optional</span></xsl:text>
     </xsl:when>
     <xsl:when test="$status = 'mandatory'">
       <xsl:text><span class="mandatory">mandatory</span></xsl:text>
     </xsl:when>
     <xsl:otherwise>
       <xsl:text>undefined</xsl:text>
     </xsl:otherwise>
   </xsl:choose>
</xsl:template>


<xsl:template name="link">
   <xsl:param name="elem"/>
   <xsl:param name="module" select=""/>
   <xsl:param name="text" select="" />
   <xsl:param name="pre" select="" />
   <xsl:param name="usemodule" select="" />

   <nobr>
   <xsl:choose>
   <xsl:when test="contains($elem,':') and $usemodule = 'false'">
      <xsl:param name="xt_mod"  select="substring-before($elem,':')"/>
      <xsl:param name="xt_elem" select="substring-after($elem,':')"/>
      <a href="{$xt_mod}.html#{$pre}{$xt_elem}"><xsl:value-of select="$xt_elem"/></a>
   </xsl:when>
   <xsl:when test="contains($elem,':')">
      <xsl:param name="t_mod"  select="substring-before($elem,':')"/>
      <xsl:param name="t_elem" select="substring-after($elem,':')"/>
      <a href="{$t_mod}.html#{$pre}{$t_elem}"><xsl:value-of select="$t_mod"/>.<xsl:value-of select="$t_elem"/></a>
   </xsl:when>
   <xsl:when test="string-length($module)>0 and string-length($elem)>0 and string-length($text)>0">
      <a href="{$module}.html#{$pre}{$elem}"><xsl:value-of select="$text"/></a>
   </xsl:when>
   <xsl:when test="string-length($elem)>0 and string-length($text)>0">
      <a href="#{$pre}{$elem}"><xsl:value-of select="$text"/></a>
   </xsl:when>
   <xsl:when test="string-length($elem)>0">
      <a href="#{$pre}{$elem}"><xsl:value-of select="$elem"/></a>
   </xsl:when>
   <xsl:when test="string-length($module)>0">
      <a href="{$module}.html"><xsl:value-of select="$module"/></a>
   </xsl:when>
   </xsl:choose>
   </nobr>

</xsl:template>

</xsl:stylesheet>

