/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.plugin;

import contrib.ch.randelshofer.quaqua.ButtonStateIcon;
import contrib.ch.randelshofer.quaqua.util.Images;
import contrib.com.jgoodies.looks.common.FontSet;
import java.awt.Image;
import java.awt.Toolkit;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.UIDefaults;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.InsetsUIResource;
import org.jvnet.lafplugin.LafComponentPlugin;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.SubstanceSizeUtils;
import org.jvnet.substance.utils.icon.SubstanceIconFactory;

public class BasePlugin
implements LafComponentPlugin {
    protected static final String commonDir = "/contrib/ch/randelshofer/quaqua/images/";
    protected static final String quaquaColorChooserClassName = "contrib.ch.randelshofer.quaqua.Quaqua14ColorChooserUI";
    protected boolean hasQuaquaColorChooser;

    public BasePlugin() {
        try {
            Class.forName(quaquaColorChooserClassName);
            this.hasQuaquaColorChooser = true;
        }
        catch (ClassNotFoundException cnfe) {
            this.hasQuaquaColorChooser = false;
        }
    }

    protected Icon createButtonStateIcon(String location, int states) {
        Image[] images = Images.split(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource(location)), states, true);
        return new ButtonStateIcon(images);
    }

    protected Object makeImage(String location) {
        return new UIDefaults.ProxyLazyValue("contrib.ch.randelshofer.quaqua.QuaquaIconFactory", "createImage", new Object[]{location});
    }

    protected static Object makeButtonStateIcon(String location, int states) {
        return new UIDefaults.ProxyLazyValue("contrib.ch.randelshofer.quaqua.QuaquaIconFactory", "createButtonStateIcon", new Object[]{location, new Integer(states)});
    }

    protected Object makeBufferedImage(String location) {
        return new UIDefaults.ProxyLazyValue("contrib.ch.randelshofer.quaqua.QuaquaIconFactory", "createBufferedImage", new Object[]{location});
    }

    public static Object makeIcon(Class baseClass, String location) {
        return new UIDefaults.ProxyLazyValue("contrib.ch.randelshofer.quaqua.QuaquaIconFactory", "createIcon", new Object[]{baseClass, location});
    }

    public Object[] getDefaults(Object mTheme) {
        if (this.hasQuaquaColorChooser) {
            SubstanceTheme theme = (SubstanceTheme)mTheme;
            InsetsUIResource visualMargin = new InsetsUIResource(0, 0, 0, 0);
            ColorScheme colorScheme = theme.getColorScheme();
            ColorUIResource foregroundColor = new ColorUIResource(colorScheme.getForegroundColor());
            Object[] mainDefaults = new Object[]{"Slider.upThumbSmall", new UIDefaults.LazyValue(){

                public Object createValue(UIDefaults table) {
                    return SubstanceIconFactory.getSliderHorizontalIcon(SubstanceSizeUtils.getSliderIconSize() - 2, true);
                }
            }, "Slider.leftThumbSmall", new UIDefaults.LazyValue(){

                public Object createValue(UIDefaults table) {
                    return SubstanceIconFactory.getSliderVerticalIcon(SubstanceSizeUtils.getSliderIconSize() - 2, true);
                }
            }, "Component.visualMargin", visualMargin, "ColorChooser.foreground", foregroundColor, "ColorChooser.defaultChoosers", new String[]{"contrib.ch.randelshofer.quaqua.colorchooser.ColorWheelChooser", "contrib.ch.randelshofer.quaqua.colorchooser.ColorSlidersChooser", "contrib.ch.randelshofer.quaqua.colorchooser.ColorPalettesChooser", "contrib.ch.randelshofer.quaqua.colorchooser.SwatchesChooser", "contrib.ch.randelshofer.quaqua.colorchooser.CrayonsChooser", "contrib.ch.randelshofer.quaqua.colorchooser.Quaqua15ColorPicker", "contrib.net.xoetrope.editor.color.ColorWheelPanel"}, "ColorChooser.swatchesSwatchSize", new DimensionUIResource(5, 5), "ColorChooser.resetMnemonic", new Integer(-1), "ColorChooser.crayonsImage", this.makeImage("/contrib/ch/randelshofer/quaqua/images/ColorChooser.crayons.png"), "ColorChooser.textSliderGap", new Integer(0), "ColorChooser.colorPalettesIcon", BasePlugin.makeButtonStateIcon("/contrib/ch/randelshofer/quaqua/images/ColorChooser.colorPalettesIcons.png", 3), "ColorChooser.colorSlidersIcon", BasePlugin.makeButtonStateIcon("/contrib/ch/randelshofer/quaqua/images/ColorChooser.colorSlidersIcons.png", 3), "ColorChooser.colorSwatchesIcon", BasePlugin.makeButtonStateIcon("/contrib/ch/randelshofer/quaqua/images/ColorChooser.colorSwatchesIcons.png", 3), "ColorChooser.colorWheelIcon", BasePlugin.makeButtonStateIcon("/contrib/ch/randelshofer/quaqua/images/ColorChooser.colorWheelIcons.png", 3), "ColorChooser.crayonsIcon", BasePlugin.makeButtonStateIcon("/contrib/ch/randelshofer/quaqua/images/ColorChooser.crayonsIcons.png", 3), "ColorChooser.imagePalettesIcon", BasePlugin.makeButtonStateIcon("/contrib/ch/randelshofer/quaqua/images/ColorChooser.imagePalettesIcons.png", 3), "ColorChooser.colorPickerIcon", BasePlugin.makeIcon(this.getClass(), "/contrib/ch/randelshofer/quaqua/images/ColorChooser.colorPickerIcon.png"), "ColorChooser.colorPickerMagnifier", this.makeBufferedImage("/contrib/ch/randelshofer/quaqua/images/ColorChooser.colorPickerMagnifier.png"), "ColorChooser.colorPickerHotSpot", new UIDefaults.ProxyLazyValue("java.awt.Point", new Object[]{new Integer(29), new Integer(29)}), "ColorChooser.colorPickerPickOffset", new UIDefaults.ProxyLazyValue("java.awt.Point", new Object[]{new Integer(-13), new Integer(-13)}), "ColorChooser.colorPickerGlassRect", new UIDefaults.ProxyLazyValue("java.awt.Rectangle", new Object[]{new Integer(2), new Integer(2), new Integer(29), new Integer(29)}), "ColorChooser.colorPickerCaptureRect", new UIDefaults.ProxyLazyValue("java.awt.Rectangle", new Object[]{new Integer(-15), new Integer(-15), new Integer(5), new Integer(5)}), "ColorChooser.colorPickerZoomRect", new UIDefaults.ProxyLazyValue("java.awt.Rectangle", new Object[]{new Integer(4), new Integer(4), new Integer(25), new Integer(25)})};
            Object[] colorDefaults = null;
            if (this.hasQuaquaColorChooser) {
                FontSet substanceFontSet = SubstanceLookAndFeel.getFontPolicy().getFontSet("Substance", null);
                FontUIResource controlFont = substanceFontSet.getControlFont();
                FontUIResource fontBoldBaseP1 = new FontUIResource(controlFont.deriveFont(1, controlFont.getSize() + 1));
                FontUIResource fontPlainBaseM2 = new FontUIResource(controlFont.deriveFont((float)(controlFont.getSize() - 2)));
                colorDefaults = new Object[]{"ColorChooserUI", "org.jvnet.substance.SubstanceColorChooserUI", "ColorChooser.font", controlFont, "ColorChooser.smallFont", fontPlainBaseM2, "ColorChooser.crayonsFont", fontBoldBaseP1};
            }
            ResourceBundle bundle = ResourceBundle.getBundle("contrib.ch.randelshofer.quaqua.Labels");
            LinkedList<Object> labelsList = new LinkedList<Object>();
            Enumeration<String> i = bundle.getKeys();
            while (i.hasMoreElements()) {
                String key = i.nextElement();
                labelsList.add(key);
                labelsList.add(bundle.getObject(key));
            }
            Object[] labelDefaults = new Object[mainDefaults.length + labelsList.size()];
            for (int i2 = 0; i2 < mainDefaults.length; ++i2) {
                labelDefaults[i2] = mainDefaults[i2];
            }
            int start = mainDefaults.length;
            for (int i3 = 0; i3 < labelsList.size(); ++i3) {
                labelDefaults[start + i3] = labelsList.get(i3);
            }
            mainDefaults = labelDefaults;
            if (colorDefaults != null) {
                int i4;
                Object[] defaults = new Object[mainDefaults.length + colorDefaults.length];
                for (i4 = 0; i4 < mainDefaults.length; ++i4) {
                    defaults[i4] = mainDefaults[i4];
                }
                start = mainDefaults.length;
                for (i4 = 0; i4 < colorDefaults.length; ++i4) {
                    defaults[start + i4] = colorDefaults[i4];
                }
                return defaults;
            }
            return mainDefaults;
        }
        return new Object[0];
    }

    public void uninitialize() {
    }

    public void initialize() {
        try {
            if (System.getProperty("substancelaf.useDecorations") != null) {
                JFrame.setDefaultLookAndFeelDecorated(true);
                JDialog.setDefaultLookAndFeelDecorated(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

