/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class SubstanceDefaultListCellRenderer
extends DefaultListCellRenderer {
    protected static final Border noFocusBorder = new EmptyBorder(1, 4, 1, 4);

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.setComponentOrientation(list.getComponentOrientation());
        if (isSelected) {
            this.setForeground(list.getSelectionForeground());
        } else {
            int r = list.getBackground().getRed();
            int g = list.getBackground().getGreen();
            int b = list.getBackground().getBlue();
            double coef = SubstanceCoreUtilities.isThemeDark(SubstanceLookAndFeel.getTheme()) ? 0.8 : 0.96;
            ColorUIResource darkerColor = new ColorUIResource((int)(coef * (double)r), (int)(coef * (double)g), (int)(coef * (double)b));
            if (index % 2 == 0) {
                this.setBackground(list.getBackground());
            } else {
                this.setBackground(darkerColor);
            }
            this.setForeground(list.getForeground());
        }
        if (value instanceof Icon) {
            this.setIcon((Icon)value);
            this.setText("");
        } else {
            this.setIcon(null);
            this.setText(value == null ? "" : value.toString());
        }
        this.setEnabled(list.isEnabled());
        this.setFont(list.getFont());
        this.setBorder(noFocusBorder);
        this.setOpaque(true);
        return this;
    }

    public static class SubstanceUIResource
    extends SubstanceDefaultListCellRenderer
    implements UIResource {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            return super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }
    }
}

