/*
 * Decompiled with CFR 0.152.
 */
package de.mud.terminal;

import de.mud.terminal.VDUBuffer;
import de.mud.terminal.VDUInput;
import java.awt.event.KeyEvent;
import java.util.Properties;

public abstract class vt320
extends VDUBuffer
implements VDUInput {
    public static final String ID = "$Id: vt320.java 507 2005-10-25 10:14:52Z marcus $";
    private static final int debug = 0;
    private boolean localecho = false;
    private String terminalID = "vt320";
    private String answerBack = "Use Terminal.answerback to set ...\n";
    int R;
    int C;
    int attributes = 0;
    int Sc;
    int Sr;
    int Sa;
    int Stm;
    int Sbm;
    char Sgr;
    char Sgl;
    char[] Sgx;
    int insertmode = 0;
    int statusmode = 0;
    boolean vt52mode = false;
    boolean keypadmode = false;
    boolean output8bit = false;
    int normalcursor = 0;
    boolean moveoutsidemargins = true;
    boolean wraparound = true;
    boolean sendcrlf = true;
    boolean capslock = false;
    boolean numlock = false;
    int mouserpt = 0;
    byte mousebut = 0;
    boolean useibmcharset = false;
    int lastwaslf = 0;
    boolean usedcharsets = false;
    private static final char ESC = '\u001b';
    private static final char IND = '\u0084';
    private static final char NEL = '\u0085';
    private static final char RI = '\u008d';
    private static final char SS2 = '\u008e';
    private static final char SS3 = '\u008f';
    private static final char DCS = '\u0090';
    private static final char HTS = '\u0088';
    private static final char CSI = '\u009b';
    private static final char OSC = '\u009d';
    private static final int TSTATE_DATA = 0;
    private static final int TSTATE_ESC = 1;
    private static final int TSTATE_CSI = 2;
    private static final int TSTATE_DCS = 3;
    private static final int TSTATE_DCEQ = 4;
    private static final int TSTATE_ESCSQUARE = 5;
    private static final int TSTATE_OSC = 6;
    private static final int TSTATE_SETG0 = 7;
    private static final int TSTATE_SETG1 = 8;
    private static final int TSTATE_SETG2 = 9;
    private static final int TSTATE_SETG3 = 10;
    private static final int TSTATE_CSI_DOLLAR = 11;
    private static final int TSTATE_CSI_EX = 12;
    private static final int TSTATE_ESCSPACE = 13;
    private static final int TSTATE_VT52X = 14;
    private static final int TSTATE_VT52Y = 15;
    private static final int TSTATE_CSI_TICKS = 16;
    private static final int TSTATE_CSI_EQUAL = 17;
    char[] gx = new char[]{'B', '0', 'B', 'B'};
    char gl = '\u0000';
    char gr = (char)2;
    int onegl = -1;
    private static final String scoansi_acs = "Tm7k3x4u?kZl@mYjEnB\u2566DqCtAvM\u2550:\u2551N\u2557I\u2554;\u2557H\u255a0a<\u255d";
    private static char[] DECSPECIAL = new char[]{'@', '\u2666', '\u2592', '\u2409', '\u240c', '\u240d', '\u240a', '\u00ba', '\u00b1', '\u2424', '\u240b', '\u2518', '\u2510', '\u250c', '\u2514', '\u253c', '\u2594', '\u2580', '\u2500', '\u25ac', '_', '\u251c', '\u2524', '\u2534', '\u252c', '\u2502', '\u2264', '\u2265', '\u00b6', '\u2260', '\u00a3', '\u00b7'};
    private String[] Numpad;
    private String[] FunctionKey;
    private String[] FunctionKeyShift;
    private String[] FunctionKeyCtrl;
    private String[] FunctionKeyAlt;
    private String[] TabKey;
    private String[] KeyUp;
    private String[] KeyDown;
    private String[] KeyLeft;
    private String[] KeyRight;
    private String KPMinus;
    private String KPComma;
    private String KPPeriod;
    private String KPEnter;
    private String PF1;
    private String PF2;
    private String PF3;
    private String PF4;
    private String Help;
    private String Do;
    private String Find;
    private String Select;
    private String[] KeyHome;
    private String[] KeyEnd;
    private String[] Insert;
    private String[] Remove;
    private String[] PrevScn;
    private String[] NextScn;
    private String[] Escape;
    private String[] BackSpace;
    private String[] NUMDot;
    private String[] NUMPlus;
    private String osc;
    private String dcs;
    private int term_state = 0;
    private boolean vms = false;
    private byte[] Tabs;
    private int[] DCEvars = new int[30];
    private int DCEvar;
    private static final char[] unimap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f', '\u00c7', '\u00fc', '\u00e9', '\u00e2', '\u00e4', '\u00e0', '\u00e5', '\u00e7', '\u00ea', '\u00eb', '\u00e8', '\u00ef', '\u00ee', '\u00ec', '\u00c4', '\u00c5', '\u00c9', '\u00e6', '\u00c6', '\u00f4', '\u00f6', '\u00f2', '\u00fb', '\u00f9', '\u00ff', '\u00d6', '\u00dc', '\u00a2', '\u00a3', '\u00a5', '\u20a7', '\u0192', '\u00e1', '\u00ed', '\u00f3', '\u00fa', '\u00f1', '\u00d1', '\u00aa', '\u00ba', '\u00bf', '\u2310', '\u00ac', '\u00bd', '\u00bc', '\u00a1', '\u00ab', '\u00bb', '\u2591', '\u2592', '\u2593', '\u2502', '\u2524', '\u2561', '\u2562', '\u2556', '\u2555', '\u2563', '\u2551', '\u2557', '\u255d', '\u255c', '\u255b', '\u2510', '\u2514', '\u2534', '\u252c', '\u251c', '\u2500', '\u253c', '\u255e', '\u255f', '\u255a', '\u2554', '\u2569', '\u2566', '\u2560', '\u2550', '\u256c', '\u2567', '\u2568', '\u2564', '\u2565', '\u2559', '\u2558', '\u2552', '\u2553', '\u256b', '\u256a', '\u2518', '\u250c', '\u2588', '\u2584', '\u258c', '\u2590', '\u2580', '\u03b1', '\u00df', '\u0393', '\u03c0', '\u03a3', '\u03c3', '\u00b5', '\u03c4', '\u03a6', '\u0398', '\u03a9', '\u03b4', '\u221e', '\u03c6', '\u03b5', '\u2229', '\u2261', '\u00b1', '\u2265', '\u2264', '\u2320', '\u2321', '\u00f7', '\u2248', '\u00b0', '\u2219', '\u00b7', '\u221a', '\u207f', '\u00b2', '\u25a0', '\u00a0'};

    public abstract void write(byte[] var1);

    public void beep() {
    }

    public void putString(String string) {
        int n = string.length();
        if (n > 0) {
            this.markLine(this.R, 1);
            for (int i = 0; i < n; ++i) {
                this.putChar(string.charAt(i), false);
            }
            this.setCursorPosition(this.C, this.R);
            this.redraw();
        }
    }

    protected void sendTelnetCommand(byte by) {
    }

    protected void setWindowSize(int n, int n2) {
    }

    public void setScreenSize(int n, int n2, boolean bl) {
        int n3 = this.getRows();
        int n4 = this.getColumns();
        super.setScreenSize(n, n2, false);
        if (n2 > n3) {
            this.setCursorPosition(this.C, this.R + (n2 - n3));
            this.redraw();
        }
        if (bl) {
            this.setWindowSize(n, n2);
        }
    }

    public vt320(int n, int n2) {
        super(n, n2);
        int n3;
        this.setVMS(false);
        this.setIBMCharset(false);
        this.setTerminalID("vt320");
        this.setBufferSize(100);
        int n4 = this.getColumns();
        if (n4 < 132) {
            n4 = 132;
        }
        this.Tabs = new byte[n4];
        for (n3 = 0; n3 < n4; n3 += 8) {
            this.Tabs[n3] = 1;
        }
        this.PF1 = "\u001bOP";
        this.PF2 = "\u001bOQ";
        this.PF3 = "\u001bOR";
        this.PF4 = "\u001bOS";
        this.Insert = new String[4];
        this.Remove = new String[4];
        this.KeyHome = new String[4];
        this.KeyEnd = new String[4];
        this.NextScn = new String[4];
        this.PrevScn = new String[4];
        this.Escape = new String[4];
        this.BackSpace = new String[4];
        this.TabKey = new String[4];
        this.Insert[3] = "\u001b[2~";
        this.Insert[2] = "\u001b[2~";
        this.Insert[1] = "\u001b[2~";
        this.Insert[0] = "\u001b[2~";
        this.Remove[3] = "\u001b[3~";
        this.Remove[2] = "\u001b[3~";
        this.Remove[1] = "\u001b[3~";
        this.Remove[0] = "\u001b[3~";
        this.PrevScn[3] = "\u001b[5~";
        this.PrevScn[2] = "\u001b[5~";
        this.PrevScn[1] = "\u001b[5~";
        this.PrevScn[0] = "\u001b[5~";
        this.NextScn[3] = "\u001b[6~";
        this.NextScn[2] = "\u001b[6~";
        this.NextScn[1] = "\u001b[6~";
        this.NextScn[0] = "\u001b[6~";
        this.KeyHome[3] = "\u001b[H";
        this.KeyHome[2] = "\u001b[H";
        this.KeyHome[1] = "\u001b[H";
        this.KeyHome[0] = "\u001b[H";
        this.KeyEnd[3] = "\u001b[F";
        this.KeyEnd[2] = "\u001b[F";
        this.KeyEnd[1] = "\u001b[F";
        this.KeyEnd[0] = "\u001b[F";
        this.Escape[3] = "\u001b";
        this.Escape[2] = "\u001b";
        this.Escape[1] = "\u001b";
        this.Escape[0] = "\u001b";
        if (this.vms) {
            this.BackSpace[1] = "\n";
            this.BackSpace[2] = "\u0018";
            this.BackSpace[3] = "\u007f";
            this.BackSpace[0] = "\u007f";
        } else {
            this.BackSpace[3] = "\b";
            this.BackSpace[2] = "\b";
            this.BackSpace[1] = "\b";
            this.BackSpace[0] = "\b";
        }
        this.Find = "\u001b[1~";
        this.Select = "\u001b[4~";
        this.Help = "\u001b[28~";
        this.Do = "\u001b[29~";
        this.FunctionKey = new String[21];
        this.FunctionKey[0] = "";
        this.FunctionKey[1] = this.PF1;
        this.FunctionKey[2] = this.PF2;
        this.FunctionKey[3] = this.PF3;
        this.FunctionKey[4] = this.PF4;
        this.FunctionKey[5] = "\u001b[15~";
        this.FunctionKey[6] = "\u001b[17~";
        this.FunctionKey[7] = "\u001b[18~";
        this.FunctionKey[8] = "\u001b[19~";
        this.FunctionKey[9] = "\u001b[20~";
        this.FunctionKey[10] = "\u001b[21~";
        this.FunctionKey[11] = "\u001b[23~";
        this.FunctionKey[12] = "\u001b[24~";
        this.FunctionKey[13] = "\u001b[25~";
        this.FunctionKey[14] = "\u001b[26~";
        this.FunctionKey[15] = this.Help;
        this.FunctionKey[16] = this.Do;
        this.FunctionKey[17] = "\u001b[31~";
        this.FunctionKey[18] = "\u001b[32~";
        this.FunctionKey[19] = "\u001b[33~";
        this.FunctionKey[20] = "\u001b[34~";
        this.FunctionKeyShift = new String[21];
        this.FunctionKeyAlt = new String[21];
        this.FunctionKeyCtrl = new String[21];
        for (n3 = 0; n3 < 20; ++n3) {
            this.FunctionKeyShift[n3] = "";
            this.FunctionKeyAlt[n3] = "";
            this.FunctionKeyCtrl[n3] = "";
        }
        this.FunctionKeyShift[15] = this.Find;
        this.FunctionKeyShift[16] = this.Select;
        this.TabKey[0] = "\t";
        this.TabKey[1] = "\u001bOP\t";
        this.TabKey[3] = "";
        this.TabKey[2] = "";
        this.KeyUp = new String[4];
        this.KeyUp[0] = "\u001b[A";
        this.KeyDown = new String[4];
        this.KeyDown[0] = "\u001b[B";
        this.KeyRight = new String[4];
        this.KeyRight[0] = "\u001b[C";
        this.KeyLeft = new String[4];
        this.KeyLeft[0] = "\u001b[D";
        this.Numpad = new String[10];
        this.Numpad[0] = "\u001bOp";
        this.Numpad[1] = "\u001bOq";
        this.Numpad[2] = "\u001bOr";
        this.Numpad[3] = "\u001bOs";
        this.Numpad[4] = "\u001bOt";
        this.Numpad[5] = "\u001bOu";
        this.Numpad[6] = "\u001bOv";
        this.Numpad[7] = "\u001bOw";
        this.Numpad[8] = "\u001bOx";
        this.Numpad[9] = "\u001bOy";
        this.KPMinus = this.PF4;
        this.KPComma = "\u001bOl";
        this.KPPeriod = "\u001bOn";
        this.KPEnter = "\u001bOM";
        this.NUMPlus = new String[4];
        this.NUMPlus[0] = "+";
        this.NUMDot = new String[4];
        this.NUMDot[0] = ".";
    }

    public vt320() {
        this(80, 24);
    }

    public void mousePressed(int n, int n2, int n3) {
        if (this.mouserpt == 0) {
            return;
        }
        int n4 = n3;
        this.mousebut = (byte)3;
        if ((n4 & 0x10) == 16) {
            this.mousebut = 0;
        }
        if ((n4 & 8) == 8) {
            this.mousebut = 1;
        }
        if ((n4 & 4) == 4) {
            this.mousebut = (byte)2;
        }
        int n5 = this.mouserpt == 9 ? 0x20 | this.mousebut : this.mousebut | 0x20 | (n4 & 7) << 2;
        byte[] byArray = new byte[]{27, 91, 77, (byte)n5, (byte)(32 + n + 1), (byte)(32 + n2 + 1)};
        this.write(byArray);
    }

    public void mouseReleased(int n, int n2, int n3) {
        if (this.mouserpt == 0) {
            return;
        }
        int n4 = this.mouserpt == 9 ? 32 + this.mousebut : 35;
        byte[] byArray = new byte[]{27, 91, 77, (byte)n4, (byte)(32 + n + 1), (byte)(32 + n2 + 1)};
        this.write(byArray);
        this.mousebut = 0;
    }

    public void setLocalEcho(boolean bl) {
        this.localecho = bl;
    }

    public void setVMS(boolean bl) {
        this.vms = bl;
    }

    public void setIBMCharset(boolean bl) {
        this.useibmcharset = bl;
    }

    public void setKeyCodes(Properties properties) {
        String string;
        int n;
        String[] stringArray = new String[]{"", "S", "C", "A"};
        for (n = 0; n < 10; ++n) {
            string = properties.getProperty("NUMPAD" + n);
            if (string == null) continue;
            this.Numpad[n] = vt320.unEscape(string);
        }
        for (n = 1; n < 20; ++n) {
            string = properties.getProperty("F" + n);
            if (string != null) {
                this.FunctionKey[n] = vt320.unEscape(string);
            }
            if ((string = properties.getProperty("SF" + n)) != null) {
                this.FunctionKeyShift[n] = vt320.unEscape(string);
            }
            if ((string = properties.getProperty("CF" + n)) != null) {
                this.FunctionKeyCtrl[n] = vt320.unEscape(string);
            }
            if ((string = properties.getProperty("AF" + n)) == null) continue;
            this.FunctionKeyAlt[n] = vt320.unEscape(string);
        }
        for (n = 0; n < 4; ++n) {
            string = properties.getProperty(stringArray[n] + "PGUP");
            if (string != null) {
                this.PrevScn[n] = vt320.unEscape(string);
            }
            if ((string = properties.getProperty(stringArray[n] + "PGDOWN")) != null) {
                this.NextScn[n] = vt320.unEscape(string);
            }
            if ((string = properties.getProperty(stringArray[n] + "END")) != null) {
                this.KeyEnd[n] = vt320.unEscape(string);
            }
            if ((string = properties.getProperty(stringArray[n] + "HOME")) != null) {
                this.KeyHome[n] = vt320.unEscape(string);
            }
            if ((string = properties.getProperty(stringArray[n] + "INSERT")) != null) {
                this.Insert[n] = vt320.unEscape(string);
            }
            if ((string = properties.getProperty(stringArray[n] + "REMOVE")) != null) {
                this.Remove[n] = vt320.unEscape(string);
            }
            if ((string = properties.getProperty(stringArray[n] + "UP")) != null) {
                this.KeyUp[n] = vt320.unEscape(string);
            }
            if ((string = properties.getProperty(stringArray[n] + "DOWN")) != null) {
                this.KeyDown[n] = vt320.unEscape(string);
            }
            if ((string = properties.getProperty(stringArray[n] + "LEFT")) != null) {
                this.KeyLeft[n] = vt320.unEscape(string);
            }
            if ((string = properties.getProperty(stringArray[n] + "RIGHT")) != null) {
                this.KeyRight[n] = vt320.unEscape(string);
            }
            if ((string = properties.getProperty(stringArray[n] + "ESCAPE")) != null) {
                this.Escape[n] = vt320.unEscape(string);
            }
            if ((string = properties.getProperty(stringArray[n] + "BACKSPACE")) != null) {
                this.BackSpace[n] = vt320.unEscape(string);
            }
            if ((string = properties.getProperty(stringArray[n] + "TAB")) != null) {
                this.TabKey[n] = vt320.unEscape(string);
            }
            if ((string = properties.getProperty(stringArray[n] + "NUMPLUS")) != null) {
                this.NUMPlus[n] = vt320.unEscape(string);
            }
            if ((string = properties.getProperty(stringArray[n] + "NUMDECIMAL")) == null) continue;
            this.NUMDot[n] = vt320.unEscape(string);
        }
    }

    public void setTerminalID(String string) {
        this.terminalID = string;
        if (string.equals("scoansi")) {
            this.FunctionKey[1] = "\u001b[M";
            this.FunctionKey[2] = "\u001b[N";
            this.FunctionKey[3] = "\u001b[O";
            this.FunctionKey[4] = "\u001b[P";
            this.FunctionKey[5] = "\u001b[Q";
            this.FunctionKey[6] = "\u001b[R";
            this.FunctionKey[7] = "\u001b[S";
            this.FunctionKey[8] = "\u001b[T";
            this.FunctionKey[9] = "\u001b[U";
            this.FunctionKey[10] = "\u001b[V";
            this.FunctionKey[11] = "\u001b[W";
            this.FunctionKey[12] = "\u001b[X";
            this.FunctionKey[13] = "\u001b[Y";
            this.FunctionKey[14] = "?";
            this.FunctionKey[15] = "\u001b[a";
            this.FunctionKey[16] = "\u001b[b";
            this.FunctionKey[17] = "\u001b[c";
            this.FunctionKey[18] = "\u001b[d";
            this.FunctionKey[19] = "\u001b[e";
            this.FunctionKey[20] = "\u001b[f";
            this.PrevScn[3] = "\u001b[I";
            this.PrevScn[2] = "\u001b[I";
            this.PrevScn[1] = "\u001b[I";
            this.PrevScn[0] = "\u001b[I";
            this.NextScn[3] = "\u001b[G";
            this.NextScn[2] = "\u001b[G";
            this.NextScn[1] = "\u001b[G";
            this.NextScn[0] = "\u001b[G";
        }
    }

    public void setAnswerBack(String string) {
        this.answerBack = vt320.unEscape(string);
    }

    public String getTerminalID() {
        return this.terminalID;
    }

    private boolean write(String string, boolean bl) {
        if (string == null) {
            return true;
        }
        byte[] byArray = new byte[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            byArray[i] = (byte)string.charAt(i);
        }
        this.write(byArray);
        if (bl) {
            this.putString(string);
        }
        return true;
    }

    private boolean write(String string) {
        return this.write(string, this.localecho);
    }

    static String unEscape(String string) {
        int n = 0;
        int n2 = 0;
        String string2 = "";
        while ((n = string.indexOf(92, n2)) >= 0 && ++n <= string.length()) {
            string2 = string2 + string.substring(n2, n - 1);
            if (n == string.length()) {
                return string2;
            }
            switch (string.charAt(n)) {
                case 'b': {
                    string2 = string2 + "\b";
                    break;
                }
                case 'e': {
                    string2 = string2 + "\u001b";
                    break;
                }
                case 'n': {
                    string2 = string2 + "\n";
                    break;
                }
                case 'r': {
                    string2 = string2 + "\r";
                    break;
                }
                case 't': {
                    string2 = string2 + "\t";
                    break;
                }
                case 'v': {
                    string2 = string2 + "\u000b";
                    break;
                }
                case 'a': {
                    string2 = string2 + "\u0012";
                    break;
                }
                default: {
                    if (string.charAt(n) >= '0' && string.charAt(n) <= '9') {
                        int n3;
                        for (n3 = n; n3 < string.length() && string.charAt(n3) >= '0' && string.charAt(n3) <= '9'; ++n3) {
                        }
                        string2 = string2 + (char)Integer.parseInt(string.substring(n, n3));
                        n = n3 - 1;
                        break;
                    }
                    string2 = string2 + string.substring(n++, n);
                }
            }
            n2 = ++n;
        }
        if (n2 <= string.length()) {
            string2 = string2 + string.substring(n2);
        }
        return string2;
    }

    private boolean writeSpecial(String string) {
        if (string == null) {
            return true;
        }
        if (string.length() >= 3 && string.charAt(0) == '\u001b' && string.charAt(1) == 'O') {
            if (this.vt52mode) {
                string = string.charAt(2) >= 'P' && string.charAt(2) <= 'S' ? "\u001b" + string.substring(2) : "\u001b?" + string.substring(2);
            } else if (this.output8bit) {
                string = "\u008f" + string.substring(2);
            }
        }
        if (string.length() >= 3 && string.charAt(0) == '\u001b' && string.charAt(1) == '[' && this.output8bit) {
            string = "\u009b" + string.substring(2);
        }
        return this.write(string, false);
    }

    public void keyPressed(int n, char c, int n2) {
        boolean bl = (n2 & 1) != 0;
        boolean bl2 = (n2 & 2) != 0;
        boolean bl3 = (n2 & 4) != 0;
        int n3 = 0;
        String[] stringArray = this.FunctionKey;
        if (bl2) {
            stringArray = this.FunctionKeyShift;
            n3 = 1;
        }
        if (bl) {
            stringArray = this.FunctionKeyCtrl;
            n3 = 2;
        }
        if (bl3) {
            stringArray = this.FunctionKeyAlt;
            n3 = 3;
        }
        switch (n) {
            case 19: {
                if (!bl2 && !bl) break;
                this.sendTelnetCommand((byte)-13);
                break;
            }
            case 112: {
                this.writeSpecial(stringArray[1]);
                break;
            }
            case 113: {
                this.writeSpecial(stringArray[2]);
                break;
            }
            case 114: {
                this.writeSpecial(stringArray[3]);
                break;
            }
            case 115: {
                this.writeSpecial(stringArray[4]);
                break;
            }
            case 116: {
                this.writeSpecial(stringArray[5]);
                break;
            }
            case 117: {
                this.writeSpecial(stringArray[6]);
                break;
            }
            case 118: {
                this.writeSpecial(stringArray[7]);
                break;
            }
            case 119: {
                this.writeSpecial(stringArray[8]);
                break;
            }
            case 120: {
                this.writeSpecial(stringArray[9]);
                break;
            }
            case 121: {
                this.writeSpecial(stringArray[10]);
                break;
            }
            case 122: {
                this.writeSpecial(stringArray[11]);
                break;
            }
            case 123: {
                this.writeSpecial(stringArray[12]);
                break;
            }
            case 38: {
                this.writeSpecial(this.KeyUp[n3]);
                break;
            }
            case 40: {
                this.writeSpecial(this.KeyDown[n3]);
                break;
            }
            case 37: {
                this.writeSpecial(this.KeyLeft[n3]);
                break;
            }
            case 39: {
                this.writeSpecial(this.KeyRight[n3]);
                break;
            }
            case 34: {
                this.writeSpecial(this.NextScn[n3]);
                break;
            }
            case 33: {
                this.writeSpecial(this.PrevScn[n3]);
                break;
            }
            case 155: {
                this.writeSpecial(this.Insert[n3]);
                break;
            }
            case 127: {
                this.writeSpecial(this.Remove[n3]);
                break;
            }
            case 8: {
                this.writeSpecial(this.BackSpace[n3]);
                if (!this.localecho) break;
                if (this.BackSpace[n3] == "\b") {
                    this.putString("\b \b");
                    break;
                }
                this.putString(this.BackSpace[n3]);
                break;
            }
            case 36: {
                this.writeSpecial(this.KeyHome[n3]);
                break;
            }
            case 35: {
                this.writeSpecial(this.KeyEnd[n3]);
                break;
            }
            case 144: {
                if (this.vms && bl) {
                    this.writeSpecial(this.PF1);
                }
                if (bl) break;
                this.numlock = !this.numlock;
                break;
            }
            case 20: {
                this.capslock = !this.capslock;
                return;
            }
            case 16: 
            case 17: 
            case 18: {
                return;
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(int n, char c, int n2) {
        boolean bl;
        boolean bl2 = (n2 & 1) != 0;
        boolean bl3 = (n2 & 2) != 0;
        boolean bl4 = bl = (n2 & 4) != 0;
        if (c == '\t') {
            if (bl3) {
                this.write(this.TabKey[1], false);
            } else if (bl2) {
                this.write(this.TabKey[2], false);
            } else if (bl) {
                this.write(this.TabKey[3], false);
            } else {
                this.write(this.TabKey[0], false);
            }
            return;
        }
        if (bl) {
            this.write("" + (char)(c | 0x80));
            return;
        }
        if (!(n != 10 && c != '\n' || bl2)) {
            this.write("\r", false);
            if (this.localecho) {
                this.putString("\r\n");
            }
            return;
        }
        if (n == 10 && !bl2) {
            System.out.println("Sending \\r");
            this.write("\r", false);
            return;
        }
        if ((!this.vms && c == '2' || c == ' ') && bl2) {
            this.write("\u0000");
        }
        if (this.vms) {
            if (c == '\u007f' && !bl2) {
                if (bl3) {
                    this.writeSpecial(this.Insert[0]);
                } else {
                    this.writeSpecial(this.Remove[0]);
                }
                return;
            }
            if (bl2) {
                switch (c) {
                    case '0': {
                        this.writeSpecial(this.Numpad[0]);
                        return;
                    }
                    case '1': {
                        this.writeSpecial(this.Numpad[1]);
                        return;
                    }
                    case '2': {
                        this.writeSpecial(this.Numpad[2]);
                        return;
                    }
                    case '3': {
                        this.writeSpecial(this.Numpad[3]);
                        return;
                    }
                    case '4': {
                        this.writeSpecial(this.Numpad[4]);
                        return;
                    }
                    case '5': {
                        this.writeSpecial(this.Numpad[5]);
                        return;
                    }
                    case '6': {
                        this.writeSpecial(this.Numpad[6]);
                        return;
                    }
                    case '7': {
                        this.writeSpecial(this.Numpad[7]);
                        return;
                    }
                    case '8': {
                        this.writeSpecial(this.Numpad[8]);
                        return;
                    }
                    case '9': {
                        this.writeSpecial(this.Numpad[9]);
                        return;
                    }
                    case '.': {
                        this.writeSpecial(this.KPPeriod);
                        return;
                    }
                    case '\u001f': 
                    case '-': {
                        this.writeSpecial(this.KPMinus);
                        return;
                    }
                    case '+': {
                        this.writeSpecial(this.KPComma);
                        return;
                    }
                    case '\n': {
                        this.writeSpecial(this.KPEnter);
                        return;
                    }
                    case '/': {
                        this.writeSpecial(this.PF2);
                        return;
                    }
                    case '*': {
                        this.writeSpecial(this.PF3);
                        return;
                    }
                }
            }
        }
        int n3 = 0;
        String[] stringArray = this.FunctionKey;
        if (bl3) {
            stringArray = this.FunctionKeyShift;
            n3 = 1;
        }
        if (bl2) {
            stringArray = this.FunctionKeyCtrl;
            n3 = 2;
        }
        if (bl) {
            stringArray = this.FunctionKeyAlt;
            n3 = 3;
        }
        if (n == 27) {
            this.writeSpecial(this.Escape[n3]);
            return;
        }
        if ((n2 & 8) != 0) {
            switch (n) {
                case 96: {
                    this.writeSpecial(this.Numpad[0]);
                    return;
                }
                case 97: {
                    this.writeSpecial(this.Numpad[1]);
                    return;
                }
                case 98: {
                    this.writeSpecial(this.Numpad[2]);
                    return;
                }
                case 99: {
                    this.writeSpecial(this.Numpad[3]);
                    return;
                }
                case 100: {
                    this.writeSpecial(this.Numpad[4]);
                    return;
                }
                case 101: {
                    this.writeSpecial(this.Numpad[5]);
                    return;
                }
                case 102: {
                    this.writeSpecial(this.Numpad[6]);
                    return;
                }
                case 103: {
                    this.writeSpecial(this.Numpad[7]);
                    return;
                }
                case 104: {
                    this.writeSpecial(this.Numpad[8]);
                    return;
                }
                case 105: {
                    this.writeSpecial(this.Numpad[9]);
                    return;
                }
                case 110: {
                    this.writeSpecial(this.NUMDot[n3]);
                    return;
                }
                case 107: {
                    this.writeSpecial(this.NUMPlus[n3]);
                    return;
                }
            }
        }
        if (c != '\b' && c != '\u007f' && c != '\r' && c != '\n') {
            this.write("" + c);
            return;
        }
    }

    private void handle_dcs(String string) {
        System.out.println("DCS: " + string);
    }

    private void handle_osc(String string) {
        System.out.println("OSC: " + string);
    }

    public char map_cp850_unicode(char c) {
        if (c >= '\u0100') {
            return c;
        }
        return unimap[c];
    }

    private void _SetCursor(int n, int n2) {
        int n3 = this.getRows();
        int n4 = this.getTopMargin();
        this.R = n < 0 ? 0 : n;
        int n5 = this.C = n2 < 0 ? 0 : n2;
        if (!this.moveoutsidemargins) {
            this.R += n4;
            n3 = this.getBottomMargin();
        }
        if (this.R > n3) {
            this.R = n3;
        }
    }

    private void putChar(char c, boolean bl) {
        int n = this.getRows();
        int n2 = this.getColumns();
        int n3 = this.getTopMargin();
        int n4 = this.getBottomMargin();
        boolean bl2 = false;
        this.markLine(this.R, 1);
        if (c > '\u00ff') {
            // empty if block
        }
        block0 : switch (this.term_state) {
            case 0: {
                int n5;
                if (!this.useibmcharset) {
                    n5 = 1;
                    switch (c) {
                        case '\u009d': {
                            this.osc = "";
                            this.term_state = 6;
                            break;
                        }
                        case '\u008d': {
                            if (this.R > n3) {
                                --this.R;
                                break;
                            }
                            this.insertLine(this.R, 1, true);
                            break;
                        }
                        case '\u0084': {
                            if (this.R == n4 || this.R == n - 1) {
                                this.insertLine(this.R, 1, false);
                                break;
                            }
                            ++this.R;
                            break;
                        }
                        case '\u0085': {
                            if (this.R == n4 || this.R == n - 1) {
                                this.insertLine(this.R, 1, false);
                            } else {
                                ++this.R;
                            }
                            this.C = 0;
                            break;
                        }
                        case '\u0088': {
                            this.Tabs[this.C] = 1;
                            break;
                        }
                        case '\u0090': {
                            this.dcs = "";
                            this.term_state = 3;
                            break;
                        }
                        default: {
                            n5 = 0;
                        }
                    }
                    if (n5 != 0) break;
                }
                switch (c) {
                    case '\u008f': {
                        this.onegl = 3;
                        break;
                    }
                    case '\u008e': {
                        this.onegl = 2;
                        break;
                    }
                    case '\u009b': {
                        this.DCEvar = 0;
                        this.DCEvars[0] = 0;
                        this.DCEvars[1] = 0;
                        this.DCEvars[2] = 0;
                        this.DCEvars[3] = 0;
                        this.term_state = 2;
                        break;
                    }
                    case '\u001b': {
                        this.term_state = 1;
                        this.lastwaslf = 0;
                        break;
                    }
                    case '\u0005': {
                        this.write(this.answerBack, false);
                        break;
                    }
                    case '\f': {
                        this.deleteArea(0, 0, n2, n, this.attributes);
                        this.R = 0;
                        this.C = 0;
                        break;
                    }
                    case '\b': {
                        --this.C;
                        if (this.C < 0) {
                            this.C = 0;
                        }
                        this.lastwaslf = 0;
                        break;
                    }
                    case '\t': {
                        do {
                            ++this.C;
                        } while (this.C < n2 && this.Tabs[this.C] == 0);
                        this.lastwaslf = 0;
                        break;
                    }
                    case '\r': {
                        this.C = 0;
                        break;
                    }
                    case '\n': {
                        if (!this.vms) {
                            if (this.lastwaslf != 0 && this.lastwaslf != c) break;
                            this.lastwaslf = c;
                        }
                        if (this.R == n4 || this.R >= n - 1) {
                            this.insertLine(this.R, 1, false);
                            break;
                        }
                        ++this.R;
                        break;
                    }
                    case '\u0007': {
                        this.beep();
                        break;
                    }
                    case '\u000e': {
                        this.gl = '\u0001';
                        this.usedcharsets = true;
                        break;
                    }
                    case '\u000f': {
                        this.gl = '\u0000';
                        this.usedcharsets = true;
                        break;
                    }
                    default: {
                        n5 = this.gl;
                        if (this.onegl >= 0) {
                            n5 = this.onegl;
                            this.onegl = -1;
                        }
                        this.lastwaslf = 0;
                        if (c < ' ') {
                            if (c != '\u0000') {
                                // empty if block
                            }
                            if (c == '\u0000') break;
                        }
                        if (this.C >= n2) {
                            if (this.wraparound) {
                                if (this.R == n4 || this.R >= n - 1) {
                                    this.insertLine(this.R, 1, false);
                                } else {
                                    ++this.R;
                                }
                                this.C = 0;
                            } else {
                                this.C = n2 - 1;
                            }
                        }
                        if (this.usedcharsets) {
                            if (c >= ' ' && c <= '\u007f') {
                                switch (this.gx[n5]) {
                                    case '0': {
                                        if (this.terminalID.equals("scoansi") || this.terminalID.equals("ansi")) {
                                            for (int i = 0; i < scoansi_acs.length(); i += 2) {
                                                if (c != scoansi_acs.charAt(i)) continue;
                                                c = scoansi_acs.charAt(i + 1);
                                                break;
                                            }
                                        }
                                        if (c < '_' || c > '~') break;
                                        c = DECSPECIAL[(short)c - 95];
                                        bl2 = true;
                                        break;
                                    }
                                    case '<': {
                                        c = (char)(c & 0x7F | 0x80);
                                        bl2 = true;
                                        break;
                                    }
                                    case 'A': 
                                    case 'B': {
                                        bl2 = true;
                                        break;
                                    }
                                    default: {
                                        System.out.println("Unsupported GL mapping: " + this.gx[n5]);
                                    }
                                }
                            }
                            if (!bl2 && c >= '\u0080' && c <= '\u00ff') {
                                switch (this.gx[this.gr]) {
                                    case '0': {
                                        if (c < '\u00df' || c > '\u00fe') break;
                                        c = DECSPECIAL[c - 223];
                                        bl2 = true;
                                        break;
                                    }
                                    case '<': 
                                    case 'A': 
                                    case 'B': {
                                        bl2 = true;
                                        break;
                                    }
                                    default: {
                                        System.out.println("Unsupported GR mapping: " + this.gx[this.gr]);
                                    }
                                }
                            }
                        }
                        if (!bl2 && this.useibmcharset) {
                            c = this.map_cp850_unicode(c);
                        }
                        if (this.insertmode == 1) {
                            this.insertChar(this.C, this.R, c, this.attributes);
                        } else {
                            this.putChar(this.C, this.R, c, this.attributes);
                        }
                        ++this.C;
                        break;
                    }
                }
                break;
            }
            case 6: {
                if (c < ' ' && c != '\u001b') {
                    this.handle_osc(this.osc);
                    this.term_state = 0;
                    break;
                }
                if (c == '\\' && this.osc.charAt(this.osc.length() - 1) == '\u001b') {
                    this.handle_osc(this.osc);
                    this.term_state = 0;
                    break;
                }
                this.osc = this.osc + c;
                break;
            }
            case 13: {
                this.term_state = 0;
                switch (c) {
                    case 'F': {
                        this.output8bit = false;
                        break block0;
                    }
                    case 'G': {
                        this.output8bit = true;
                        break block0;
                    }
                }
                System.out.println("ESC <space> " + c + " unhandled.");
                break;
            }
            case 1: {
                this.term_state = 0;
                switch (c) {
                    case ' ': {
                        this.term_state = 13;
                        break;
                    }
                    case '#': {
                        this.term_state = 5;
                        break;
                    }
                    case 'c': {
                        this.gx[0] = 66;
                        this.gx[1] = 48;
                        this.gx[2] = 66;
                        this.gx[3] = 66;
                        this.gl = '\u0000';
                        this.gr = '\u0001';
                        int n6 = this.getColumns();
                        if (n6 < 132) {
                            n6 = 132;
                        }
                        this.Tabs = new byte[n6];
                        for (int i = 0; i < n6; i += 8) {
                            this.Tabs[i] = 1;
                        }
                        break block0;
                    }
                    case '[': {
                        this.DCEvar = 0;
                        this.DCEvars[0] = 0;
                        this.DCEvars[1] = 0;
                        this.DCEvars[2] = 0;
                        this.DCEvars[3] = 0;
                        this.term_state = 2;
                        break;
                    }
                    case ']': {
                        this.osc = "";
                        this.term_state = 6;
                        break;
                    }
                    case 'P': {
                        this.dcs = "";
                        this.term_state = 3;
                        break;
                    }
                    case 'A': {
                        --this.R;
                        if (this.R >= 0) break block0;
                        this.R = 0;
                        break;
                    }
                    case 'B': {
                        ++this.R;
                        if (this.R <= n - 1) break block0;
                        this.R = n - 1;
                        break;
                    }
                    case 'C': {
                        ++this.C;
                        if (this.C < n2) break block0;
                        this.C = n2 - 1;
                        break;
                    }
                    case 'I': {
                        this.insertLine(this.R, 1, true);
                        break;
                    }
                    case 'E': {
                        if (this.R == n4 || this.R == n - 1) {
                            this.insertLine(this.R, 1, false);
                        } else {
                            ++this.R;
                        }
                        this.C = 0;
                        break;
                    }
                    case 'D': {
                        if (this.R == n4 || this.R == n - 1) {
                            this.insertLine(this.R, 1, false);
                            break;
                        }
                        ++this.R;
                        break;
                    }
                    case 'J': {
                        if (this.R < n - 1) {
                            this.deleteArea(0, this.R + 1, n2, n - this.R - 1, this.attributes);
                        }
                        if (this.C >= n2 - 1) break block0;
                        this.deleteArea(this.C, this.R, n2 - this.C, 1, this.attributes);
                        break;
                    }
                    case 'K': {
                        if (this.C >= n2 - 1) break block0;
                        this.deleteArea(this.C, this.R, n2 - this.C, 1, this.attributes);
                        break;
                    }
                    case 'M': {
                        System.out.println("ESC M : R is " + this.R + ", tm is " + n3 + ", bm is " + n4);
                        if (this.R > n4) break;
                        if (this.R > n3) {
                            --this.R;
                            break;
                        }
                        this.insertLine(this.R, 1, true);
                        break;
                    }
                    case 'H': {
                        if (this.C >= n2) {
                            this.C = n2 - 1;
                        }
                        this.Tabs[this.C] = 1;
                        break;
                    }
                    case 'N': {
                        this.onegl = 2;
                        break;
                    }
                    case 'O': {
                        this.onegl = 3;
                        break;
                    }
                    case '=': {
                        this.keypadmode = true;
                        break;
                    }
                    case '<': {
                        this.vt52mode = false;
                        break;
                    }
                    case '>': {
                        this.keypadmode = false;
                        break;
                    }
                    case '7': {
                        this.Sc = this.C;
                        this.Sr = this.R;
                        this.Sgl = this.gl;
                        this.Sgr = this.gr;
                        this.Sa = this.attributes;
                        this.Sgx = new char[4];
                        for (int i = 0; i < 4; ++i) {
                            this.Sgx[i] = this.gx[i];
                        }
                        this.Stm = this.getTopMargin();
                        this.Sbm = this.getBottomMargin();
                        break;
                    }
                    case '8': {
                        this.C = this.Sc;
                        this.R = this.Sr;
                        this.gl = this.Sgl;
                        this.gr = this.Sgr;
                        for (int i = 0; i < 4; ++i) {
                            this.gx[i] = this.Sgx[i];
                        }
                        this.setTopMargin(this.Stm);
                        this.setBottomMargin(this.Sbm);
                        this.attributes = this.Sa;
                        break;
                    }
                    case '(': {
                        this.term_state = 7;
                        this.usedcharsets = true;
                        break;
                    }
                    case ')': {
                        this.term_state = 8;
                        this.usedcharsets = true;
                        break;
                    }
                    case '*': {
                        this.term_state = 9;
                        this.usedcharsets = true;
                        break;
                    }
                    case '+': {
                        this.term_state = 10;
                        this.usedcharsets = true;
                        break;
                    }
                    case '~': {
                        this.gr = '\u0001';
                        this.usedcharsets = true;
                        break;
                    }
                    case 'n': {
                        this.gl = (char)2;
                        this.usedcharsets = true;
                        break;
                    }
                    case '}': {
                        this.gr = (char)2;
                        this.usedcharsets = true;
                        break;
                    }
                    case 'o': {
                        this.gl = (char)3;
                        this.usedcharsets = true;
                        break;
                    }
                    case '|': {
                        this.gr = (char)3;
                        this.usedcharsets = true;
                        break;
                    }
                    case 'Y': {
                        this.term_state = 15;
                        break;
                    }
                    default: {
                        System.out.println("ESC unknown letter: " + c + " (" + c + ")");
                        break;
                    }
                }
                break;
            }
            case 14: {
                this.C = c - 37;
                this.term_state = 15;
                break;
            }
            case 15: {
                this.R = c - 37;
                this.term_state = 0;
                break;
            }
            case 7: {
                if (c != '0' && c != 'A' && c != 'B' && c != '<') {
                    System.out.println("ESC ( " + c + ": G0 char set?  (" + c + ")");
                } else {
                    this.gx[0] = c;
                }
                this.term_state = 0;
                break;
            }
            case 8: {
                if (c != '0' && c != 'A' && c != 'B' && c != '<') {
                    System.out.println("ESC ) " + c + " (" + c + ") :G1 char set?");
                } else {
                    this.gx[1] = c;
                }
                this.term_state = 0;
                break;
            }
            case 9: {
                if (c != '0' && c != 'A' && c != 'B' && c != '<') {
                    System.out.println("ESC*:G2 char set?  (" + c + ")");
                } else {
                    this.gx[2] = c;
                }
                this.term_state = 0;
                break;
            }
            case 10: {
                if (c != '0' && c != 'A' && c != 'B' && c != '<') {
                    System.out.println("ESC+:G3 char set?  (" + c + ")");
                } else {
                    this.gx[3] = c;
                }
                this.term_state = 0;
                break;
            }
            case 5: {
                switch (c) {
                    case '8': {
                        for (int i = 0; i < n2; ++i) {
                            for (int j = 0; j < n; ++j) {
                                this.putChar(i, j, 'E', 0);
                            }
                        }
                        break;
                    }
                    default: {
                        System.out.println("ESC # " + c + " not supported.");
                    }
                }
                this.term_state = 0;
                break;
            }
            case 3: {
                if (c == '\\' && this.dcs.charAt(this.dcs.length() - 1) == '\u001b') {
                    this.handle_dcs(this.dcs);
                    this.term_state = 0;
                    break;
                }
                this.dcs = this.dcs + c;
                break;
            }
            case 4: {
                this.term_state = 0;
                block94 : switch (c) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        this.DCEvars[this.DCEvar] = this.DCEvars[this.DCEvar] * 10 + c - 48;
                        this.term_state = 4;
                        break;
                    }
                    case ';': {
                        ++this.DCEvar;
                        this.DCEvars[this.DCEvar] = 0;
                        this.term_state = 4;
                        break;
                    }
                    case 's': {
                        System.out.println("ESC [ ? " + this.DCEvars[0] + " s unimplemented!");
                        break;
                    }
                    case 'r': {
                        System.out.println("ESC [ ? " + this.DCEvars[0] + " r");
                        block250: for (int i = 0; i <= this.DCEvar; ++i) {
                            switch (this.DCEvars[i]) {
                                case 3: {
                                    this.setScreenSize(80, this.getRows(), true);
                                    continue block250;
                                }
                                case 4: {
                                    continue block250;
                                }
                                case 5: {
                                    continue block250;
                                }
                                case 6: {
                                    this.moveoutsidemargins = true;
                                    continue block250;
                                }
                                case 7: {
                                    this.wraparound = false;
                                    continue block250;
                                }
                                case 12: {
                                    continue block250;
                                }
                                case 9: 
                                case 1000: 
                                case 1001: 
                                case 1002: 
                                case 1003: {
                                    this.mouserpt = this.DCEvars[i];
                                    continue block250;
                                }
                                default: {
                                    System.out.println("ESC [ ? " + this.DCEvars[0] + " r, unimplemented!");
                                }
                            }
                        }
                        break block0;
                    }
                    case 'h': {
                        block251: for (int i = 0; i <= this.DCEvar; ++i) {
                            switch (this.DCEvars[i]) {
                                case 1: {
                                    this.KeyUp[0] = "\u001bOA";
                                    this.KeyDown[0] = "\u001bOB";
                                    this.KeyRight[0] = "\u001bOC";
                                    this.KeyLeft[0] = "\u001bOD";
                                    continue block251;
                                }
                                case 2: {
                                    this.vt52mode = false;
                                    continue block251;
                                }
                                case 3: {
                                    this.setScreenSize(132, this.getRows(), true);
                                    continue block251;
                                }
                                case 6: {
                                    this.moveoutsidemargins = false;
                                    continue block251;
                                }
                                case 7: {
                                    this.wraparound = true;
                                    continue block251;
                                }
                                case 25: {
                                    this.showCursor(true);
                                    continue block251;
                                }
                                case 9: 
                                case 1000: 
                                case 1001: 
                                case 1002: 
                                case 1003: {
                                    this.mouserpt = this.DCEvars[i];
                                    continue block251;
                                }
                                default: {
                                    System.out.println("ESC [ ? " + this.DCEvars[0] + " h, unsupported.");
                                }
                            }
                        }
                        break block0;
                    }
                    case 'i': {
                        switch (this.DCEvars[0]) {
                            case 1: {
                                break block94;
                            }
                            case 4: {
                                break block94;
                            }
                        }
                        break;
                    }
                    case 'l': {
                        block252: for (int i = 0; i <= this.DCEvar; ++i) {
                            switch (this.DCEvars[i]) {
                                case 1: {
                                    this.KeyUp[0] = "\u001b[A";
                                    this.KeyDown[0] = "\u001b[B";
                                    this.KeyRight[0] = "\u001b[C";
                                    this.KeyLeft[0] = "\u001b[D";
                                    continue block252;
                                }
                                case 2: {
                                    this.vt52mode = true;
                                    continue block252;
                                }
                                case 3: {
                                    this.setScreenSize(80, this.getRows(), true);
                                    continue block252;
                                }
                                case 6: {
                                    this.moveoutsidemargins = true;
                                    continue block252;
                                }
                                case 7: {
                                    this.wraparound = false;
                                    continue block252;
                                }
                                case 25: {
                                    this.showCursor(false);
                                    continue block252;
                                }
                                case 9: 
                                case 1000: 
                                case 1001: 
                                case 1002: 
                                case 1003: {
                                    this.mouserpt = 0;
                                    continue block252;
                                }
                                default: {
                                    System.out.println("ESC [ ? " + this.DCEvars[0] + " l, unsupported.");
                                }
                            }
                        }
                        break block0;
                    }
                    case 'n': {
                        switch (this.DCEvars[0]) {
                            case 15: {
                                this.write("\u001b[?13n", false);
                                System.out.println("ESC[5n");
                                break block94;
                            }
                        }
                        System.out.println("ESC [ ? " + this.DCEvars[0] + " n, unsupported.");
                        break;
                    }
                    default: {
                        System.out.println("ESC [ ? " + this.DCEvars[0] + " " + c + ", unsupported.");
                        break;
                    }
                }
                break;
            }
            case 12: {
                this.term_state = 0;
                switch (c) {
                    case '\u001b': {
                        this.term_state = 1;
                        break block0;
                    }
                }
                System.out.println("Unknown character ESC[! character is " + c);
                break;
            }
            case 16: {
                this.term_state = 0;
                switch (c) {
                    case 'p': {
                        System.out.println("Conformance level: " + this.DCEvars[0] + " (unsupported)," + this.DCEvars[1]);
                        if (this.DCEvars[0] == 61) {
                            this.output8bit = false;
                            break block0;
                        }
                        if (this.DCEvars[1] == 1) {
                            this.output8bit = false;
                            break block0;
                        }
                        this.output8bit = true;
                        break block0;
                    }
                }
                System.out.println("Unknown ESC [...  \"" + c);
                break;
            }
            case 17: {
                this.term_state = 0;
                switch (c) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        this.DCEvars[this.DCEvar] = this.DCEvars[this.DCEvar] * 10 + c - 48;
                        this.term_state = 17;
                        break block0;
                    }
                    case ';': {
                        ++this.DCEvar;
                        this.DCEvars[this.DCEvar] = 0;
                        this.term_state = 17;
                        break block0;
                    }
                    case 'F': {
                        System.out.println("ESC [ = " + this.DCEvars[0] + " F");
                        this.attributes &= 0xFFFFFE1F;
                        int n7 = (this.DCEvars[0] & 1) << 2 | this.DCEvars[0] & 2 | (this.DCEvars[0] & 4) >> 2;
                        this.attributes |= n7 + 1 << 5;
                        break block0;
                    }
                    case 'G': {
                        System.out.println("ESC [ = " + this.DCEvars[0] + " G");
                        this.attributes &= 0xFFFFE1FF;
                        int n8 = (this.DCEvars[0] & 1) << 2 | this.DCEvars[0] & 2 | (this.DCEvars[0] & 4) >> 2;
                        this.attributes |= n8 + 1 << 9;
                        break block0;
                    }
                }
                System.out.print("Unknown ESC [ = ");
                for (int i = 0; i <= this.DCEvar; ++i) {
                    System.out.print(this.DCEvars[i] + ",");
                }
                System.out.println("" + c);
                break;
            }
            case 11: {
                this.term_state = 0;
                switch (c) {
                    case '}': {
                        System.out.println("Active Status Display now " + this.DCEvars[0]);
                        this.statusmode = this.DCEvars[0];
                        break block0;
                    }
                    case '~': {
                        System.out.println("Status Line mode now " + this.DCEvars[0]);
                        break block0;
                    }
                }
                System.out.println("UNKNOWN Status Display code " + c + ", with Pn=" + this.DCEvars[0]);
                break;
            }
            case 2: {
                this.term_state = 0;
                block154 : switch (c) {
                    case '\"': {
                        this.term_state = 16;
                        break;
                    }
                    case '$': {
                        this.term_state = 11;
                        break;
                    }
                    case '=': {
                        this.term_state = 17;
                        break;
                    }
                    case '!': {
                        this.term_state = 12;
                        break;
                    }
                    case '?': {
                        this.DCEvar = 0;
                        this.DCEvars[0] = 0;
                        this.term_state = 4;
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        this.DCEvars[this.DCEvar] = this.DCEvars[this.DCEvar] * 10 + c - 48;
                        this.term_state = 2;
                        break;
                    }
                    case ';': {
                        ++this.DCEvar;
                        this.DCEvars[this.DCEvar] = 0;
                        this.term_state = 2;
                        break;
                    }
                    case 'c': {
                        String string = "";
                        if (this.terminalID.equals("vt320")) {
                            string = "63;";
                        }
                        if (this.terminalID.equals("vt220")) {
                            string = "62;";
                        }
                        if (this.terminalID.equals("vt100")) {
                            string = "61;";
                        }
                        this.write("\u001b[?" + string + "1;2c", false);
                        break;
                    }
                    case 'q': {
                        break;
                    }
                    case 'g': {
                        switch (this.DCEvars[0]) {
                            case 3: {
                                this.Tabs = new byte[this.getColumns()];
                                break block154;
                            }
                            case 0: {
                                this.Tabs[this.C] = 0;
                            }
                        }
                        break;
                    }
                    case 'h': {
                        switch (this.DCEvars[0]) {
                            case 4: {
                                this.insertmode = 1;
                                break block154;
                            }
                            case 20: {
                                System.out.println("Setting CRLF to TRUE");
                                this.sendcrlf = true;
                                break block154;
                            }
                        }
                        System.out.println("unsupported: ESC [ " + this.DCEvars[0] + " h");
                        break;
                    }
                    case 'i': {
                        switch (this.DCEvars[0]) {
                            case 0: {
                                break block154;
                            }
                            case 4: {
                                break block154;
                            }
                            case 5: {
                                break block154;
                            }
                        }
                        System.out.println("ESC [ " + this.DCEvars[0] + " i, unimplemented!");
                        break;
                    }
                    case 'l': {
                        switch (this.DCEvars[0]) {
                            case 4: {
                                this.insertmode = 0;
                                break block154;
                            }
                            case 20: {
                                System.out.println("Setting CRLF to FALSE");
                                this.sendcrlf = false;
                                break block154;
                            }
                        }
                        System.out.println("ESC [ " + this.DCEvars[0] + " l, unimplemented!");
                        break;
                    }
                    case 'A': {
                        int n9 = this.R > n4 ? n4 + 1 : (this.R >= n3 ? n3 : 0);
                        this.R = this.DCEvars[0] == 0 ? --this.R : (this.R -= this.DCEvars[0]);
                        if (this.R >= n9) break block0;
                        this.R = n9;
                        break;
                    }
                    case 'B': {
                        int n10 = this.R < n3 ? n3 - 1 : (this.R <= n4 ? n4 : n - 1);
                        this.R = this.DCEvars[0] == 0 ? ++this.R : (this.R += this.DCEvars[0]);
                        if (this.R <= n10) break block0;
                        this.R = n10;
                        break;
                    }
                    case 'C': {
                        this.C = this.DCEvars[0] == 0 ? ++this.C : (this.C += this.DCEvars[0]);
                        if (this.C <= n2 - 1) break block0;
                        this.C = n2 - 1;
                        break;
                    }
                    case 'd': {
                        this.R = this.DCEvars[0];
                        break;
                    }
                    case 'D': {
                        this.C = this.DCEvars[0] == 0 ? --this.C : (this.C -= this.DCEvars[0]);
                        if (this.C >= 0) break block0;
                        this.C = 0;
                        break;
                    }
                    case 'r': {
                        if (this.DCEvar > 0) {
                            this.R = this.DCEvars[1] - 1;
                            if (this.R < 0) {
                                this.R = n - 1;
                            } else if (this.R >= n) {
                                this.R = n - 1;
                            }
                        } else {
                            this.R = n - 1;
                        }
                        this.setBottomMargin(this.R);
                        if (this.R >= this.DCEvars[0]) {
                            this.R = this.DCEvars[0] - 1;
                            if (this.R < 0) {
                                this.R = 0;
                            }
                        }
                        this.setTopMargin(this.R);
                        this._SetCursor(0, 0);
                        break;
                    }
                    case 'G': {
                        this.C = this.DCEvars[0];
                        break;
                    }
                    case 'H': {
                        this._SetCursor(this.DCEvars[0] - 1, this.DCEvars[1] - 1);
                        break;
                    }
                    case 'f': {
                        this.R = this.DCEvars[0] - 1;
                        this.C = this.DCEvars[1] - 1;
                        if (this.C < 0) {
                            this.C = 0;
                        }
                        if (this.R >= 0) break block0;
                        this.R = 0;
                        break;
                    }
                    case 'S': {
                        if (this.DCEvars[0] == 0) {
                            this.insertLine(n - 1, false);
                            break;
                        }
                        this.insertLine(n - 1, this.DCEvars[0], false);
                        break;
                    }
                    case 'L': {
                        if (this.DCEvars[0] == 0) {
                            this.insertLine(this.R, true);
                            break;
                        }
                        this.insertLine(this.R, this.DCEvars[0], true);
                        break;
                    }
                    case 'T': {
                        if (this.DCEvars[0] == 0) {
                            this.insertLine(0, true);
                            break;
                        }
                        this.insertLine(0, this.DCEvars[0], true);
                        break;
                    }
                    case 'M': {
                        if (this.DCEvars[0] == 0) {
                            this.deleteLine(this.R);
                            break;
                        }
                        for (int i = 0; i < this.DCEvars[0]; ++i) {
                            this.deleteLine(this.R);
                        }
                        break block0;
                    }
                    case 'K': {
                        switch (this.DCEvars[0]) {
                            case 0: 
                            case 6: {
                                if (this.C >= n2 - 1) break;
                                this.deleteArea(this.C, this.R, n2 - this.C, 1, this.attributes);
                                break block154;
                            }
                            case 1: {
                                if (this.C <= 0) break;
                                this.deleteArea(0, this.R, this.C + 1, 1, this.attributes);
                                break block154;
                            }
                            case 2: {
                                this.deleteArea(0, this.R, n2, 1, this.attributes);
                            }
                        }
                        break;
                    }
                    case 'J': {
                        switch (this.DCEvars[0]) {
                            case 0: {
                                if (this.R < n - 1) {
                                    this.deleteArea(0, this.R + 1, n2, n - this.R - 1, this.attributes);
                                }
                                if (this.C >= n2 - 1) break;
                                this.deleteArea(this.C, this.R, n2 - this.C, 1, this.attributes);
                                break block154;
                            }
                            case 1: {
                                if (this.R > 0) {
                                    this.deleteArea(0, 0, n2, this.R, this.attributes);
                                }
                                if (this.C <= 0) break;
                                this.deleteArea(0, this.R, this.C + 1, 1, this.attributes);
                                break block154;
                            }
                            case 2: {
                                this.deleteArea(0, 0, n2, n, this.attributes);
                            }
                        }
                        break;
                    }
                    case '@': {
                        for (int i = 0; i < this.DCEvars[0]; ++i) {
                            this.insertChar(this.C, this.R, ' ', this.attributes);
                        }
                        break block0;
                    }
                    case 'X': {
                        int n11 = this.DCEvars[0];
                        if (n11 == 0) {
                            n11 = 1;
                        }
                        if (n11 + this.C > n2) {
                            n11 = n2 - this.C;
                        }
                        this.deleteArea(this.C, this.R, n11, 1, this.attributes);
                        break;
                    }
                    case 'P': {
                        if (this.DCEvars[0] == 0) {
                            this.DCEvars[0] = 1;
                        }
                        for (int i = 0; i < this.DCEvars[0]; ++i) {
                            this.deleteChar(this.C, this.R);
                        }
                        break block0;
                    }
                    case 'n': {
                        switch (this.DCEvars[0]) {
                            case 5: {
                                this.writeSpecial("\u001b[0n");
                                break block154;
                            }
                            case 6: {
                                this.writeSpecial("\u001b[" + this.R + ";" + this.C + "R");
                                break block154;
                            }
                        }
                        break;
                    }
                    case 's': {
                        this.Sc = this.C;
                        this.Sr = this.R;
                        this.Sa = this.attributes;
                        break;
                    }
                    case 'u': {
                        this.C = this.Sc;
                        this.R = this.Sr;
                        this.attributes = this.Sa;
                        break;
                    }
                    case 'm': {
                        if (this.DCEvar == 0 && this.DCEvars[0] == 0) {
                            this.attributes = 0;
                        }
                        block257: for (int i = 0; i <= this.DCEvar; ++i) {
                            switch (this.DCEvars[i]) {
                                case 0: {
                                    if (this.DCEvar <= 0) continue block257;
                                    if (this.terminalID.equals("scoansi")) {
                                        this.attributes &= 0x1FE0;
                                        continue block257;
                                    }
                                    this.attributes = 0;
                                    continue block257;
                                }
                                case 1: {
                                    this.attributes |= 1;
                                    this.attributes &= 0xFFFFFFF7;
                                    continue block257;
                                }
                                case 2: {
                                    if (this.terminalID.equals("scoansi") && this.DCEvar - i >= 2) {
                                        this.attributes &= 0xFFFFE01E;
                                        int n12 = this.DCEvars[i + 1];
                                        if ((n12 & 8) == 8) {
                                            this.attributes |= 1;
                                        }
                                        n12 = (n12 & 1) << 2 | n12 & 2 | (n12 & 4) >> 2;
                                        this.attributes |= n12 + 1 << 5;
                                        n12 = this.DCEvars[i + 2];
                                        n12 = (n12 & 1) << 2 | n12 & 2 | (n12 & 4) >> 2;
                                        this.attributes |= n12 + 1 << 9;
                                        i += 2;
                                        continue block257;
                                    }
                                    this.attributes |= 8;
                                    continue block257;
                                }
                                case 4: {
                                    this.attributes |= 2;
                                    continue block257;
                                }
                                case 7: {
                                    this.attributes |= 4;
                                    continue block257;
                                }
                                case 8: {
                                    this.attributes |= 0x10;
                                    continue block257;
                                }
                                case 5: {
                                    continue block257;
                                }
                                case 10: {
                                    this.gl = '\u0000';
                                    this.usedcharsets = true;
                                    continue block257;
                                }
                                case 11: 
                                case 12: {
                                    this.gl = '\u0001';
                                    this.usedcharsets = true;
                                    continue block257;
                                }
                                case 21: {
                                    this.attributes &= 0xFFFFFFF6;
                                    continue block257;
                                }
                                case 25: {
                                    continue block257;
                                }
                                case 27: {
                                    this.attributes &= 0xFFFFFFFB;
                                    continue block257;
                                }
                                case 28: {
                                    this.attributes &= 0xFFFFFFEF;
                                    continue block257;
                                }
                                case 24: {
                                    this.attributes &= 0xFFFFFFFD;
                                    continue block257;
                                }
                                case 22: {
                                    this.attributes &= 0xFFFFFFFE;
                                    continue block257;
                                }
                                case 30: 
                                case 31: 
                                case 32: 
                                case 33: 
                                case 34: 
                                case 35: 
                                case 36: 
                                case 37: {
                                    this.attributes &= 0xFFFFFE1F;
                                    this.attributes |= this.DCEvars[i] - 30 + 1 << 5;
                                    continue block257;
                                }
                                case 39: {
                                    this.attributes &= 0xFFFFFE1F;
                                    continue block257;
                                }
                                case 40: 
                                case 41: 
                                case 42: 
                                case 43: 
                                case 44: 
                                case 45: 
                                case 46: 
                                case 47: {
                                    this.attributes &= 0xFFFFE1FF;
                                    this.attributes |= this.DCEvars[i] - 40 + 1 << 9;
                                    continue block257;
                                }
                                case 49: {
                                    this.attributes &= 0xFFFFE1FF;
                                    continue block257;
                                }
                                default: {
                                    System.out.println("ESC [ " + this.DCEvars[i] + " m unknown...");
                                }
                            }
                        }
                        break block0;
                    }
                    default: {
                        System.out.println("ESC [ unknown letter:" + c + " (" + c + ")");
                        break;
                    }
                }
                break;
            }
            default: {
                this.term_state = 0;
            }
        }
        if (this.C > n2) {
            this.C = n2;
        }
        if (this.R > n) {
            this.R = n;
        }
        if (this.C < 0) {
            this.C = 0;
        }
        if (this.R < 0) {
            this.R = 0;
        }
        if (bl) {
            this.setCursorPosition(this.C, this.R);
        }
        this.markLine(this.R, 1);
    }

    public void reset() {
        this.gx[0] = 66;
        this.gx[1] = 48;
        this.gx[2] = 66;
        this.gx[3] = 66;
        this.gl = '\u0000';
        this.gr = '\u0001';
        int n = this.getColumns();
        if (n < 132) {
            n = 132;
        }
        this.Tabs = new byte[n];
        for (int i = 0; i < n; i += 8) {
            this.Tabs[i] = 1;
        }
        this.term_state = 0;
    }
}

