/*
 * Decompiled with CFR 0.152.
 */
package de.mud.telnet;

import de.mud.jta.Wrapper;
import de.mud.telnet.TelnetProtocolHandler;
import java.awt.Dimension;
import java.io.IOException;

public class TelnetWrapper
extends Wrapper {
    protected TelnetProtocolHandler handler = new TelnetProtocolHandler(){

        public String getTerminalType() {
            return "vt320";
        }

        public Dimension getWindowSize() {
            return new Dimension(80, 25);
        }

        public void setLocalEcho(boolean bl) {
        }

        public void write(byte[] byArray) throws IOException {
            TelnetWrapper.this.out.write(byArray);
        }

        public void notifyEndOfRecord() {
        }
    };
    private static final int debug = 0;

    public TelnetProtocolHandler getHandler() {
        return this.handler;
    }

    public void connect(String string, int n) throws IOException {
        super.connect(string, n);
        this.handler.reset();
    }

    public String send(String string) throws IOException {
        byte[] byArray = (string + "\n").getBytes();
        this.handler.transpose(byArray);
        if (this.getPrompt() != null) {
            return this.waitfor(this.getPrompt());
        }
        return null;
    }

    public int read(byte[] byArray) throws IOException {
        int n;
        do {
            if ((n = this.handler.negotiate(byArray)) <= 0) continue;
            return n;
        } while (n == 0);
        while (n <= 0) {
            do {
                if ((n = this.handler.negotiate(byArray)) <= 0) continue;
                return n;
            } while (n == 0);
            n = this.in.read(byArray);
            if (n < 0) {
                return n;
            }
            this.handler.inputfeed(byArray, n);
            n = this.handler.negotiate(byArray);
        }
        return n;
    }
}

