/*
 * Decompiled with CFR 0.152.
 */
package de.mud.telnet;

import java.awt.Dimension;
import java.io.IOException;

public abstract class TelnetProtocolHandler {
    public static final String ID = "$Id: TelnetProtocolHandler.java 503 2005-10-24 07:34:13Z marcus $";
    private static final int debug = 0;
    private byte[] tempbuf = new byte[0];
    private byte[] crlf = new byte[2];
    private byte[] cr = new byte[2];
    private static byte[] one = new byte[1];
    private byte neg_state = 0;
    private static final byte STATE_DATA = 0;
    private static final byte STATE_IAC = 1;
    private static final byte STATE_IACSB = 2;
    private static final byte STATE_IACWILL = 3;
    private static final byte STATE_IACDO = 4;
    private static final byte STATE_IACWONT = 5;
    private static final byte STATE_IACDONT = 6;
    private static final byte STATE_IACSBIAC = 7;
    private static final byte STATE_IACSBDATA = 8;
    private static final byte STATE_IACSBDATAIAC = 9;
    private byte current_sb;
    private byte[] sbbuf;
    private static final byte IAC = -1;
    private static final byte EOR = -17;
    private static final byte WILL = -5;
    private static final byte WONT = -4;
    private static final byte DO = -3;
    private static final byte DONT = -2;
    private static final byte SB = -6;
    private static final byte SE = -16;
    private static final byte TELOPT_BINARY = 0;
    private static final byte TELOPT_ECHO = 1;
    private static final byte TELOPT_SGA = 3;
    private static final byte TELOPT_EOR = 25;
    private static final byte TELOPT_NAWS = 31;
    private static final byte TELOPT_TTYPE = 24;
    private static final byte[] IACWILL = new byte[]{-1, -5};
    private static final byte[] IACWONT = new byte[]{-1, -4};
    private static final byte[] IACDO = new byte[]{-1, -3};
    private static final byte[] IACDONT = new byte[]{-1, -2};
    private static final byte[] IACSB = new byte[]{-1, -6};
    private static final byte[] IACSE = new byte[]{-1, -16};
    private static final byte TELQUAL_IS = 0;
    private static final byte TELQUAL_SEND = 1;
    private byte[] receivedDX;
    private byte[] receivedWX;
    private byte[] sentDX;
    private byte[] sentWX;

    public TelnetProtocolHandler() {
        this.reset();
        this.crlf[0] = 13;
        this.crlf[1] = 10;
        this.cr[0] = 13;
        this.cr[1] = 0;
    }

    protected abstract String getTerminalType();

    protected abstract Dimension getWindowSize();

    protected abstract void setLocalEcho(boolean var1);

    protected abstract void notifyEndOfRecord();

    protected abstract void write(byte[] var1) throws IOException;

    private void write(byte by) throws IOException {
        TelnetProtocolHandler.one[0] = by;
        this.write(one);
    }

    public void reset() {
        this.neg_state = 0;
        this.receivedDX = new byte[256];
        this.sentDX = new byte[256];
        this.receivedWX = new byte[256];
        this.sentWX = new byte[256];
    }

    public void sendTelnetControl(byte by) throws IOException {
        byte[] byArray = new byte[]{-1, by};
        this.write(byArray);
    }

    public void setWindowSize(int n, int n2) throws IOException {
        if (this.receivedDX[31] != -3) {
            System.err.println("not allowed to send NAWS? (DONT NAWS)");
            return;
        }
        this.write((byte)-1);
        this.write((byte)-6);
        this.write((byte)31);
        this.write((byte)(n >> 8));
        this.write((byte)(n & 0xFF));
        this.write((byte)(n2 >> 8));
        this.write((byte)(n2 & 0xFF));
        this.write((byte)-1);
        this.write((byte)-16);
    }

    private void handle_sb(byte by, byte[] byArray) throws IOException {
        switch (by) {
            case 24: {
                if (byArray.length <= 0 || byArray[0] != 1) break;
                this.write(IACSB);
                this.write((byte)24);
                this.write((byte)0);
                String string = this.getTerminalType();
                if (string == null) {
                    string = "dumb";
                }
                this.write(string.getBytes());
                this.write(IACSE);
            }
        }
    }

    public void startup() throws IOException {
    }

    public void transpose(byte[] byArray) throws IOException {
        byte[] byArray2;
        int n = 0;
        byte[] byArray3 = new byte[byArray.length * 2];
        block5: for (int i = 0; i < byArray.length; ++i) {
            switch (byArray[i]) {
                case -1: {
                    byArray3[n++] = -1;
                    byArray3[n++] = -1;
                    continue block5;
                }
                case 10: {
                    int n2;
                    if (this.receivedDX[128] != -3) {
                        while (byArray3.length - n < this.crlf.length) {
                            byArray2 = new byte[byArray3.length * 2];
                            System.arraycopy(byArray3, 0, byArray2, 0, n);
                            byArray3 = byArray2;
                        }
                        for (n2 = 0; n2 < this.crlf.length; ++n2) {
                            byArray3[n++] = this.crlf[n2];
                        }
                        continue block5;
                    }
                    byArray3[n++] = byArray[i];
                    continue block5;
                }
                case 13: {
                    int n2;
                    if (this.receivedDX[128] != -3) {
                        while (byArray3.length - n < this.cr.length) {
                            byArray2 = new byte[byArray3.length * 2];
                            System.arraycopy(byArray3, 0, byArray2, 0, n);
                            byArray3 = byArray2;
                        }
                        for (n2 = 0; n2 < this.cr.length; ++n2) {
                            byArray3[n++] = this.cr[n2];
                        }
                        continue block5;
                    }
                    byArray3[n++] = byArray[i];
                    continue block5;
                }
                default: {
                    byArray3[n++] = byArray[i];
                }
            }
        }
        byArray2 = new byte[n];
        System.arraycopy(byArray3, 0, byArray2, 0, n);
        this.write(byArray2);
    }

    public void setCRLF(String string) {
        this.crlf = string.getBytes();
    }

    public void setCR(String string) {
        this.cr = string.getBytes();
    }

    public int negotiate(byte[] byArray) throws IOException {
        Object object;
        int n = this.tempbuf.length;
        byte[] byArray2 = this.tempbuf;
        byte[] byArray3 = new byte[3];
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        if (n == 0) {
            return -1;
        }
        block57: while (!bl && n2 < n && n3 < byArray.length) {
            byte by;
            if ((by = byArray2[n2++]) >= 128) {
                by = (byte)(by - 256);
            }
            switch (this.neg_state) {
                case 0: {
                    if (by == -1) {
                        this.neg_state = 1;
                        bl = true;
                        continue block57;
                    }
                    byArray[n3++] = by;
                    continue block57;
                }
                case 1: {
                    switch (by) {
                        case -1: {
                            this.neg_state = 0;
                            byArray[n3++] = -1;
                            continue block57;
                        }
                        case -5: {
                            this.neg_state = (byte)3;
                            continue block57;
                        }
                        case -4: {
                            this.neg_state = (byte)5;
                            continue block57;
                        }
                        case -2: {
                            this.neg_state = (byte)6;
                            continue block57;
                        }
                        case -3: {
                            this.neg_state = (byte)4;
                            continue block57;
                        }
                        case -17: {
                            this.notifyEndOfRecord();
                            bl = true;
                            this.neg_state = 0;
                            continue block57;
                        }
                        case -6: {
                            this.neg_state = (byte)2;
                            continue block57;
                        }
                    }
                    this.neg_state = 0;
                    continue block57;
                }
                case 3: {
                    byte by2;
                    switch (by) {
                        case 1: {
                            by2 = -3;
                            this.setLocalEcho(false);
                            break;
                        }
                        case 3: {
                            by2 = -3;
                            break;
                        }
                        case 25: {
                            by2 = -3;
                            break;
                        }
                        case 0: {
                            by2 = -3;
                            break;
                        }
                        default: {
                            by2 = -2;
                        }
                    }
                    if (by2 != this.sentDX[by + 128] || -5 != this.receivedWX[by + 128]) {
                        byArray3[0] = -1;
                        byArray3[1] = by2;
                        byArray3[2] = by;
                        this.write(byArray3);
                        this.sentDX[by + 128] = by2;
                        this.receivedWX[by + 128] = -5;
                    }
                    this.neg_state = 0;
                    continue block57;
                }
                case 5: {
                    byte by2;
                    switch (by) {
                        case 1: {
                            this.setLocalEcho(true);
                            by2 = -2;
                            break;
                        }
                        case 3: {
                            by2 = -2;
                            break;
                        }
                        case 25: {
                            by2 = -2;
                            break;
                        }
                        case 0: {
                            by2 = -2;
                            break;
                        }
                        default: {
                            by2 = -2;
                        }
                    }
                    if (by2 != this.sentDX[by + 128] || -4 != this.receivedWX[by + 128]) {
                        byArray3[0] = -1;
                        byArray3[1] = by2;
                        byArray3[2] = by;
                        this.write(byArray3);
                        this.sentDX[by + 128] = by2;
                        this.receivedWX[by + 128] = -5;
                    }
                    this.neg_state = 0;
                    continue block57;
                }
                case 4: {
                    byte by2;
                    switch (by) {
                        case 1: {
                            by2 = -5;
                            this.setLocalEcho(true);
                            break;
                        }
                        case 3: {
                            by2 = -5;
                            break;
                        }
                        case 24: {
                            by2 = -5;
                            break;
                        }
                        case 0: {
                            by2 = -5;
                            break;
                        }
                        case 31: {
                            object = this.getWindowSize();
                            this.receivedDX[by] = -3;
                            if (object == null) {
                                this.write((byte)-1);
                                this.write((byte)-4);
                                this.write((byte)31);
                                by2 = -4;
                                this.sentWX[by] = -4;
                                break;
                            }
                            by2 = -5;
                            this.sentWX[by] = -5;
                            byArray3[0] = -1;
                            byArray3[1] = -5;
                            byArray3[2] = 31;
                            this.write(byArray3);
                            this.write((byte)-1);
                            this.write((byte)-6);
                            this.write((byte)31);
                            this.write((byte)(object.width >> 8));
                            this.write((byte)(object.width & 0xFF));
                            this.write((byte)(object.height >> 8));
                            this.write((byte)(object.height & 0xFF));
                            this.write((byte)-1);
                            this.write((byte)-16);
                            break;
                        }
                        default: {
                            by2 = -4;
                        }
                    }
                    if (by2 != this.sentWX[128 + by] || -3 != this.receivedDX[128 + by]) {
                        byArray3[0] = -1;
                        byArray3[1] = by2;
                        byArray3[2] = by;
                        this.write(byArray3);
                        this.sentWX[by + 128] = by2;
                        this.receivedDX[by + 128] = -3;
                    }
                    this.neg_state = 0;
                    continue block57;
                }
                case 6: {
                    byte by2;
                    switch (by) {
                        case 1: {
                            by2 = -4;
                            this.setLocalEcho(false);
                            break;
                        }
                        case 3: {
                            by2 = -4;
                            break;
                        }
                        case 31: {
                            by2 = -4;
                            break;
                        }
                        case 0: {
                            by2 = -4;
                            break;
                        }
                        default: {
                            by2 = -4;
                        }
                    }
                    if (by2 != this.sentWX[by + 128] || -2 != this.receivedDX[by + 128]) {
                        this.write((byte)-1);
                        this.write(by2);
                        this.write(by);
                        this.sentWX[by + 128] = by2;
                        this.receivedDX[by + 128] = -2;
                    }
                    this.neg_state = 0;
                    continue block57;
                }
                case 7: {
                    if (by == -1) {
                        this.sbbuf = new byte[0];
                        this.current_sb = by;
                        this.neg_state = (byte)8;
                        continue block57;
                    }
                    System.err.println("(bad) " + by + " ");
                    this.neg_state = 0;
                    continue block57;
                }
                case 2: {
                    switch (by) {
                        case -1: {
                            this.neg_state = (byte)7;
                            continue block57;
                        }
                    }
                    this.current_sb = by;
                    this.sbbuf = new byte[0];
                    this.neg_state = (byte)8;
                    continue block57;
                }
                case 8: {
                    switch (by) {
                        case -1: {
                            this.neg_state = (byte)9;
                            continue block57;
                        }
                    }
                    object = new byte[this.sbbuf.length + 1];
                    System.arraycopy(this.sbbuf, 0, object, 0, this.sbbuf.length);
                    this.sbbuf = object;
                    this.sbbuf[this.sbbuf.length - 1] = by;
                    continue block57;
                }
                case 9: {
                    switch (by) {
                        case -1: {
                            this.neg_state = (byte)8;
                            object = new byte[this.sbbuf.length + 1];
                            System.arraycopy(this.sbbuf, 0, object, 0, this.sbbuf.length);
                            this.sbbuf = object;
                            this.sbbuf[this.sbbuf.length - 1] = -1;
                            continue block57;
                        }
                        case -16: {
                            this.handle_sb(this.current_sb, this.sbbuf);
                            this.current_sb = 0;
                            this.neg_state = 0;
                            continue block57;
                        }
                        case -6: {
                            this.handle_sb(this.current_sb, this.sbbuf);
                            this.neg_state = (byte)2;
                            continue block57;
                        }
                    }
                    this.neg_state = 0;
                    continue block57;
                }
            }
            this.neg_state = 0;
        }
        object = new byte[n - n2];
        System.arraycopy(this.tempbuf, n2, object, 0, n - n2);
        this.tempbuf = object;
        return n3;
    }

    public void inputfeed(byte[] byArray, int n) {
        byte[] byArray2 = new byte[this.tempbuf.length + n];
        System.arraycopy(this.tempbuf, 0, byArray2, 0, this.tempbuf.length);
        System.arraycopy(byArray, 0, byArray2, this.tempbuf.length, n);
        this.tempbuf = byArray2;
    }
}

