/*
 * Decompiled with CFR 0.152.
 */
package de.mud.ssh;

import de.mud.jta.Wrapper;
import de.mud.ssh.SshIO;
import java.awt.Dimension;
import java.io.IOException;

public class SshWrapper
extends Wrapper {
    protected SshIO handler = new SshIO(){

        public String getTerminalType() {
            return "vt320";
        }

        public Dimension getWindowSize() {
            return new Dimension(80, 25);
        }

        public void setLocalEcho(boolean bl) {
        }

        public void write(byte[] byArray) throws IOException {
            SshWrapper.this.out.write(byArray);
        }
    };
    private static final int debug = 0;
    private byte[] buffer;
    private int pos;

    public String send(String string) throws IOException {
        byte[] byArray = (string + "\n").getBytes();
        for (int i = 0; i < byArray.length; ++i) {
            switch (byArray[i]) {
                case 10: {
                    byArray[i] = 13;
                }
            }
        }
        this.handler.sendData(new String(byArray));
        if (this.getPrompt() != null) {
            return this.waitfor(this.getPrompt());
        }
        return null;
    }

    public int read(byte[] byArray) throws IOException {
        if (this.buffer != null) {
            int n = this.buffer.length - this.pos <= byArray.length ? this.buffer.length - this.pos : byArray.length;
            System.arraycopy(this.buffer, this.pos, byArray, 0, n);
            if (this.pos + n < this.buffer.length) {
                this.pos += n;
            } else {
                this.buffer = null;
            }
            return n;
        }
        int n = this.in.read(byArray);
        if (n > 0) {
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, n);
            this.pos = 0;
            this.buffer = this.handler.handleSSH(byArray2);
            if (this.buffer != null && this.buffer.length > 0) {
                int n2 = this.buffer.length <= byArray.length ? this.buffer.length : byArray.length;
                System.arraycopy(this.buffer, 0, byArray, 0, n2);
                this.pos = n = n2;
                if (n2 == this.buffer.length) {
                    this.buffer = null;
                    this.pos = 0;
                }
            } else {
                return 0;
            }
        }
        return n;
    }
}

