/*
 * Decompiled with CFR 0.152.
 */
package de.mud.ssh;

import de.mud.ssh.SshCrypto;
import de.mud.ssh.SshMisc;
import de.mud.ssh.SshPacket;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class SshPacket2
extends SshPacket {
    private static final boolean debug = true;
    private byte[] packet_length_array = new byte[5];
    private int packet_length = 0;
    private int padlen = 0;
    private byte[] crc_array = new byte[4];
    private int position = 0;
    private int phase_packet = 0;
    private final int PHASE_packet_length = 0;
    private final int PHASE_block = 1;
    private SshCrypto crypto = null;
    private byte[] block;

    public SshPacket2(SshCrypto sshCrypto) {
        this.position = 0;
        this.phase_packet = 0;
        this.crypto = sshCrypto;
    }

    public SshPacket2(byte by) {
        this.setType(by);
    }

    public BigInteger getMpInt() {
        return new BigInteger(1, this.getBytes(this.getInt32()));
    }

    public void putMpInt(BigInteger bigInteger) {
        int n;
        byte[] byArray = bigInteger.toByteArray();
        for (n = 0; n < byArray.length && byArray[n] == 0; ++n) {
        }
        byte[] byArray2 = new byte[byArray.length - n];
        System.arraycopy(byArray, n, byArray2, 0, byArray.length - n);
        this.putInt32(byArray.length - n);
        this.putBytes(byArray2);
    }

    public byte[] getPayLoad(SshCrypto sshCrypto, long l) throws IOException {
        byte[] byArray;
        Object object;
        int n;
        int n2;
        byte[] byArray2 = this.getData();
        int n3 = 8;
        this.packet_length = 6;
        if (byArray2 != null) {
            this.packet_length += byArray2.length;
        }
        if ((n2 = n3 - this.packet_length % n3) < 4) {
            n2 += n3;
        }
        byte[] byArray3 = new byte[n2];
        System.out.println("packet length is " + this.packet_length + ", padlen is " + n2);
        if (sshCrypto == null) {
            for (n = 0; n < n2; ++n) {
                byArray3[n] = 0;
            }
        } else {
            for (n = 0; n < n2; ++n) {
                byArray3[n] = SshMisc.getNotZeroRandomByte();
            }
        }
        byte[] byArray4 = new byte[this.packet_length + n2];
        int n4 = n2 + this.packet_length - 4;
        byArray4[3] = (byte)(n4 & 0xFF);
        byArray4[2] = (byte)(n4 >> 8 & 0xFF);
        byArray4[1] = (byte)(n4 >> 16 & 0xFF);
        byArray4[0] = (byte)(n4 >> 24 & 0xFF);
        byArray4[4] = (byte)n2;
        byArray4[5] = this.getType();
        System.arraycopy(byArray2, 0, byArray4, 6, byArray2.length);
        System.arraycopy(byArray3, 0, byArray4, 6 + byArray2.length, n2);
        if (sshCrypto != null) {
            object = null;
            try {
                object = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                System.err.println("SshPacket2: unable to load message digest algorithm: " + noSuchAlgorithmException);
            }
            byte[] byArray5 = new byte[]{(byte)(l >> 24 & 0xFFL), (byte)(l >> 16 & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l & 0xFFL)};
            ((MessageDigest)object).update(byArray5, 0, 4);
            ((MessageDigest)object).update(byArray4, 0, byArray4.length);
            byArray = ((MessageDigest)object).digest();
        } else {
            byArray = new byte[]{};
        }
        if (sshCrypto != null) {
            byArray4 = sshCrypto.encrypt(byArray4);
        }
        object = new byte[byArray4.length + byArray.length];
        System.arraycopy(byArray4, 0, object, 0, byArray4.length);
        System.arraycopy(byArray, 0, object, byArray4.length, byArray.length);
        return object;
    }

    public byte[] addPayload(byte[] byArray) {
        int n = 0;
        byte[] byArray2 = null;
        int n2 = 0;
        if (this.crypto != null) {
            n2 = 16;
        }
        System.out.println("addPayload2 " + byArray.length);
        while (n < byArray.length) {
            switch (this.phase_packet) {
                case 0: {
                    this.packet_length_array[this.position++] = byArray[n++];
                    if (this.position != 5) break;
                    this.packet_length = (this.packet_length_array[3] & 0xFF) + ((this.packet_length_array[2] & 0xFF) << 8) + ((this.packet_length_array[1] & 0xFF) << 16) + ((this.packet_length_array[0] & 0xFF) << 24);
                    this.padlen = this.packet_length_array[4];
                    this.position = 0;
                    System.out.println("SSH2: packet length " + this.packet_length);
                    System.out.println("SSH2: padlen " + this.padlen);
                    this.packet_length += n2;
                    this.block = new byte[this.packet_length - 1];
                    ++this.phase_packet;
                    break;
                }
                case 1: {
                    int n3;
                    if (this.position < this.block.length && (n3 = byArray.length - n) > 0) {
                        if (n3 > this.block.length - this.position) {
                            n3 = this.block.length - this.position;
                        }
                        System.arraycopy(byArray, n, this.block, this.position, n3);
                        n += n3;
                        this.position += n3;
                    }
                    if (this.position != this.block.length) break;
                    if (byArray.length > n) {
                        byArray2 = new byte[byArray.length - n];
                        System.arraycopy(byArray, n, byArray2, 0, byArray.length - n);
                    }
                    byte[] byArray3 = new byte[this.block.length - n2];
                    this.packet_length -= n2;
                    System.arraycopy(this.block, 0, byArray3, 0, this.block.length - n2);
                    if (this.crypto != null) {
                        byArray3 = this.crypto.decrypt(byArray3);
                    }
                    for (int i = 0; i < byArray3.length; ++i) {
                        System.out.print(" " + byArray3[i]);
                    }
                    System.out.println("");
                    this.setType(byArray3[0]);
                    System.err.println("Packet type: " + this.getType());
                    System.err.println("Packet len: " + this.packet_length);
                    if (this.packet_length > this.padlen + 1 + 1) {
                        byte[] byArray4 = new byte[this.packet_length - 1 - this.padlen - 1];
                        System.arraycopy(byArray3, 1, byArray4, 0, byArray4.length);
                        this.putData(byArray4);
                    } else {
                        this.putData(null);
                    }
                    return byArray2;
                }
            }
        }
        return null;
    }
}

