/*
 * Decompiled with CFR 0.152.
 */
package de.mud.ssh;

import de.mud.ssh.SshCrypto;
import de.mud.ssh.SshMisc;
import de.mud.ssh.SshPacket;
import java.math.BigInteger;

public class SshPacket1
extends SshPacket {
    private static final boolean debug = false;
    private byte[] packet_length_array = new byte[4];
    private int packet_length = 0;
    private byte[] padding = null;
    private byte[] crc_array = new byte[4];
    private byte[] block = null;
    private byte[] encryptedBlock = null;
    private byte[] decryptedBlock = null;
    private SshCrypto crypto = null;
    private int position = 0;
    private int phase_packet = 0;
    private final int PHASE_packet_length = 0;
    private final int PHASE_block = 1;

    public SshPacket1(SshCrypto sshCrypto) {
        this.position = 0;
        this.phase_packet = 0;
        this.crypto = sshCrypto;
    }

    public SshPacket1(byte by) {
        this.setType(by);
    }

    public byte[] getMpInt() {
        return this.getBytes((this.getInt16() + 7) / 8);
    }

    public void putMpInt(BigInteger bigInteger) {
        int n;
        byte[] byArray = bigInteger.toByteArray();
        for (n = 0; n < byArray.length && byArray[n] == 0; ++n) {
        }
        byte[] byArray2 = new byte[byArray.length - n];
        System.arraycopy(byArray, n, byArray2, 0, byArray.length - n);
        this.putInt16(byArray2.length * 8);
        this.putBytes(byArray2);
    }

    byte[] getPayLoad(SshCrypto sshCrypto) {
        int n;
        byte[] byArray = this.getData();
        this.packet_length = byArray != null ? byArray.length + 5 : 5;
        this.packet_length_array[3] = (byte)(this.packet_length & 0xFF);
        this.packet_length_array[2] = (byte)(this.packet_length >> 8 & 0xFF);
        this.packet_length_array[1] = (byte)(this.packet_length >> 16 & 0xFF);
        this.packet_length_array[0] = (byte)(this.packet_length >> 24 & 0xFF);
        this.padding = new byte[8 - this.packet_length % 8];
        if (sshCrypto == null) {
            for (n = 0; n < this.padding.length; ++n) {
                this.padding[n] = 0;
            }
        } else {
            for (n = 0; n < this.padding.length; ++n) {
                this.padding[n] = SshMisc.getNotZeroRandomByte();
            }
        }
        this.block = new byte[this.packet_length + this.padding.length];
        System.arraycopy(this.padding, 0, this.block, 0, this.padding.length);
        n = this.padding.length;
        this.block[n++] = this.getType();
        if (this.packet_length > 5) {
            System.arraycopy(byArray, 0, this.block, n, byArray.length);
            n += byArray.length;
        }
        long l = SshMisc.crc32(this.block, n);
        this.crc_array[3] = (byte)(l & 0xFFL);
        this.crc_array[2] = (byte)(l >> 8 & 0xFFL);
        this.crc_array[1] = (byte)(l >> 16 & 0xFFL);
        this.crc_array[0] = (byte)(l >> 24 & 0xFFL);
        System.arraycopy(this.crc_array, 0, this.block, n, 4);
        if (sshCrypto != null) {
            this.block = sshCrypto.encrypt(this.block);
        }
        byte[] byArray2 = new byte[this.block.length + 4];
        System.arraycopy(this.packet_length_array, 0, byArray2, 0, 4);
        System.arraycopy(this.block, 0, byArray2, 4, this.block.length);
        return byArray2;
    }

    public byte[] addPayload(byte[] byArray) {
        int n = 0;
        byte[] byArray2 = null;
        while (n < byArray.length) {
            switch (this.phase_packet) {
                case 0: {
                    this.packet_length_array[this.position++] = byArray[n++];
                    if (this.position < 4) break;
                    this.packet_length = (this.packet_length_array[3] & 0xFF) + ((this.packet_length_array[2] & 0xFF) << 8) + ((this.packet_length_array[1] & 0xFF) << 16) + ((this.packet_length_array[0] & 0xFF) << 24);
                    this.position = 0;
                    ++this.phase_packet;
                    this.block = new byte[8 * (this.packet_length / 8 + 1)];
                    break;
                }
                case 1: {
                    byte[] byArray3;
                    int n2;
                    if (this.block.length > this.position && n < byArray.length) {
                        n2 = byArray.length - n;
                        if (n2 > this.block.length - this.position) {
                            n2 = this.block.length - this.position;
                        }
                        System.arraycopy(byArray, n, this.block, this.position, n2);
                        n += n2;
                        this.position += n2;
                    }
                    if (this.position != this.block.length) break;
                    if (byArray.length > n) {
                        byArray2 = new byte[byArray.length - n];
                        System.arraycopy(byArray, n, byArray2, 0, byArray.length - n);
                    }
                    n2 = 0;
                    int n3 = 8 - this.packet_length % 8;
                    this.padding = new byte[n3];
                    this.decryptedBlock = this.crypto != null ? this.crypto.decrypt(this.block) : this.block;
                    if (this.decryptedBlock.length != n3 + this.packet_length) {
                        System.out.println("???");
                    }
                    for (int i = 0; i < this.padding.length; ++i) {
                        this.padding[i] = this.decryptedBlock[n2++];
                    }
                    this.setType(this.decryptedBlock[n2++]);
                    if (this.packet_length > 5) {
                        byArray3 = new byte[this.packet_length - 5];
                        System.arraycopy(this.decryptedBlock, n2, byArray3, 0, this.packet_length - 5);
                        n2 += this.packet_length - 5;
                    } else {
                        byArray3 = null;
                    }
                    this.putData(byArray3);
                    for (int i = 0; i < this.crc_array.length; ++i) {
                        this.crc_array[i] = this.decryptedBlock[n2++];
                    }
                    if (!this.checkCrc()) {
                        System.err.println("SshPacket1: CRC wrong in received packet!");
                    }
                    return byArray2;
                }
            }
        }
        return null;
    }

    private boolean checkCrc() {
        byte[] byArray = new byte[4];
        long l = SshMisc.crc32(this.decryptedBlock, this.decryptedBlock.length - 4);
        byArray[3] = (byte)(l & 0xFFL);
        byArray[2] = (byte)(l >> 8 & 0xFFL);
        byArray[1] = (byte)(l >> 16 & 0xFFL);
        byArray[0] = (byte)(l >> 24 & 0xFFL);
        if (byArray[3] != this.crc_array[3]) {
            return false;
        }
        if (byArray[2] != this.crc_array[2]) {
            return false;
        }
        if (byArray[1] != this.crc_array[1]) {
            return false;
        }
        return byArray[0] == this.crc_array[0];
    }
}

