/*
 * Decompiled with CFR 0.152.
 */
package de.mud.jta.plugin;

import de.mud.jta.FilterPlugin;
import de.mud.jta.Plugin;
import de.mud.jta.PluginBus;
import de.mud.jta.PluginConfig;
import de.mud.jta.VisualPlugin;
import de.mud.jta.event.AppletListener;
import de.mud.jta.event.ConfigurationListener;
import java.applet.AppletContext;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.StreamTokenizer;
import java.net.URL;
import java.util.Vector;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class URLFilter
extends Plugin
implements FilterPlugin,
VisualPlugin,
Runnable {
    private static final int debug = 0;
    protected Vector protocols = new Vector();
    protected JList urlList = new JList();
    protected JPanel urlPanel;
    protected JMenu urlMenu;
    protected PipedInputStream pin;
    protected PipedOutputStream pout;
    protected AppletContext context;
    private Vector urlCache = new Vector();
    protected FilterPlugin source;

    public URLFilter(PluginBus pluginBus, final String string) {
        super(pluginBus, string);
        this.urlPanel = new JPanel(new BorderLayout());
        this.urlList.setVisibleRowCount(4);
        this.urlList.setSelectionMode(0);
        this.urlList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                URLFilter.this.showURL((String)((JList)listSelectionEvent.getSource()).getSelectedValue());
            }
        });
        this.urlPanel.add("Center", this.urlList);
        JPanel jPanel = new JPanel(new GridLayout(3, 1));
        JButton jButton = new JButton("Clear List");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                URLFilter.this.urlCache.removeAllElements();
                URLFilter.this.urlList.removeAll();
            }
        });
        jPanel.add(jButton);
        jButton = new JButton("Remove URL");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)URLFilter.this.urlList.getSelectedValue();
                if (string != null) {
                    URLFilter.this.urlCache.removeElement(string);
                    URLFilter.this.urlList.remove(URLFilter.this.urlList.getSelectedIndex());
                }
            }
        });
        jPanel.add(jButton);
        jButton = new JButton("Show URL");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)URLFilter.this.urlList.getSelectedValue();
                if (string != null) {
                    URLFilter.this.showURL(string);
                }
            }
        });
        jPanel.add(jButton);
        this.urlPanel.add("East", jPanel);
        pluginBus.registerPluginListener(new AppletListener(){

            public void setApplet(JApplet jApplet) {
                URLFilter.this.context = jApplet.getAppletContext();
            }
        });
        pluginBus.registerPluginListener(new ConfigurationListener(){

            public void setConfiguration(PluginConfig pluginConfig) {
                String string2 = pluginConfig.getProperty("URLFilter", string, "protocols");
                if (string2 != null) {
                    int n = -1;
                    int n2 = string2.indexOf(44);
                    while (n2 >= 0) {
                        System.out.println("URLFilter: adding protocol '" + string2.substring(n + 1, n2) + "'");
                        URLFilter.this.protocols.addElement(string2.substring(n + 1, n2));
                        n = n2;
                        n2 = string2.indexOf(44, n + 1);
                    }
                    System.out.println("URLFilter: adding protocol '" + string2.substring(n + 1) + "'");
                    URLFilter.this.protocols.addElement(string2.substring(n + 1));
                } else {
                    URLFilter.this.protocols.addElement("http");
                    URLFilter.this.protocols.addElement("ftp");
                    URLFilter.this.protocols.addElement("gopher");
                    URLFilter.this.protocols.addElement("file");
                }
            }
        });
        this.pin = new PipedInputStream();
        this.pout = new PipedOutputStream();
        try {
            this.pout.connect(this.pin);
        }
        catch (IOException iOException) {
            System.err.println("URLFilter: error installing recognizer: " + iOException);
        }
        Thread thread = new Thread(this);
        thread.start();
    }

    public void run() {
        try {
            int n;
            StreamTokenizer streamTokenizer = new StreamTokenizer(new BufferedReader(new InputStreamReader(this.pin)));
            streamTokenizer.eolIsSignificant(true);
            streamTokenizer.slashSlashComments(false);
            streamTokenizer.slashStarComments(false);
            streamTokenizer.whitespaceChars(0, 31);
            streamTokenizer.ordinaryChar(34);
            streamTokenizer.ordinaryChar(60);
            streamTokenizer.ordinaryChar(62);
            streamTokenizer.ordinaryChar(47);
            streamTokenizer.ordinaryChar(58);
            while ((n = streamTokenizer.nextToken()) != -1) {
                String string;
                if (n != -3 || !this.protocols.contains(string = streamTokenizer.sval.toLowerCase()) || streamTokenizer.nextToken() != 58 || streamTokenizer.nextToken() != 47) continue;
                String string2 = string + ":/";
                while ((n = streamTokenizer.nextToken()) == -3 || n == 47) {
                    if (n == -3) {
                        string2 = string2 + streamTokenizer.sval;
                        continue;
                    }
                    string2 = string2 + (char)n;
                }
                if (string2.endsWith(".")) {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                if (this.urlCache.contains(string2)) continue;
                this.urlCache.addElement(string2);
                this.urlList.add(string2, new JLabel(string2));
                System.out.println("URLFilter: found \"" + string2 + "\"");
            }
        }
        catch (IOException iOException) {
            System.err.println("URLFilter: recognition aborted: " + iOException);
        }
    }

    protected void showURL(String string) {
        if (this.context == null) {
            System.err.println("URLFilter: no url-viewer available\n");
            return;
        }
        try {
            this.context.showDocument(new URL(string), "URLFilter");
        }
        catch (Exception exception) {
            System.err.println("URLFilter: cannot load url: " + exception);
        }
    }

    public void setFilterSource(FilterPlugin filterPlugin) {
        this.source = filterPlugin;
    }

    public FilterPlugin getFilterSource() {
        return this.source;
    }

    public int read(byte[] byArray) throws IOException {
        int n = this.source.read(byArray);
        if (n > 0) {
            this.pout.write(byArray, 0, n);
        }
        return n;
    }

    public void write(byte[] byArray) throws IOException {
        this.source.write(byArray);
    }

    public JComponent getPluginVisual() {
        return this.urlPanel;
    }

    public JMenu getPluginMenu() {
        return this.urlMenu;
    }
}

