/*
 * Decompiled with CFR 0.152.
 */
package de.mud.jta.plugin;

import de.mud.jta.FilterPlugin;
import de.mud.jta.Plugin;
import de.mud.jta.PluginBus;
import de.mud.jta.PluginConfig;
import de.mud.jta.event.ConfigurationListener;
import de.mud.jta.event.SocketListener;
import de.mud.jta.event.SocketRequest;
import java.io.IOException;

public class Timeout
extends Plugin
implements FilterPlugin,
SocketListener,
Runnable {
    private static final int debug = 0;
    protected int timeout = 0;
    protected String timeoutCommand = null;
    protected String timeoutWarning = null;
    protected Thread timeoutThread = null;
    private PluginBus pluginBus;
    FilterPlugin source;

    public Timeout(PluginBus pluginBus, final String string) {
        super(pluginBus, string);
        pluginBus.registerPluginListener(this);
        pluginBus.registerPluginListener(new ConfigurationListener(){

            public void setConfiguration(PluginConfig pluginConfig) {
                String string2 = pluginConfig.getProperty("Timeout", string, "seconds");
                if (string2 != null) {
                    try {
                        Timeout.this.timeout = Integer.parseInt(string2);
                    }
                    catch (Exception exception) {
                        Timeout.this.error("timeout (" + Timeout.this.timeout + ") " + "is not an integer, timeout disabled");
                    }
                    Timeout.this.timeoutCommand = pluginConfig.getProperty("Timeout", string, "command");
                    Timeout.this.timeoutWarning = pluginConfig.getProperty("Timeout", string, "warning");
                }
            }
        });
        this.pluginBus = pluginBus;
    }

    public void run() {
        boolean bl = false;
        while (this.timeoutThread != null) {
            try {
                bl = false;
                Thread.sleep(1000 * this.timeout);
            }
            catch (InterruptedException interruptedException) {
                bl = true;
            }
            if (bl) continue;
            this.error("data connection timeout, shutting down");
            if (this.timeoutCommand != null) {
                this.error("sending graceful exit command ...");
                try {
                    this.write(this.timeoutCommand.getBytes());
                }
                catch (IOException iOException) {
                    this.error("could not send exit command");
                }
                this.timeoutThread = null;
                Thread thread = new Thread(new Runnable(){

                    public void run() {
                        try {
                            Thread.currentThread();
                            Thread.sleep(1000 * Timeout.this.timeout);
                            Timeout.this.pluginBus.broadcast(new SocketRequest());
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                });
                thread.start();
                continue;
            }
            this.bus.broadcast(new SocketRequest());
        }
    }

    public void connect(String string, int n) throws IOException {
        if (this.timeout > 0) {
            this.timeoutThread = new Thread(this);
            this.timeoutThread.start();
        }
    }

    public void disconnect() throws IOException {
        if (this.timeoutThread != null) {
            Thread thread = this.timeoutThread;
            this.timeoutThread = null;
            thread.interrupt();
        }
    }

    public void setFilterSource(FilterPlugin filterPlugin) {
        this.source = filterPlugin;
    }

    public FilterPlugin getFilterSource() {
        return this.source;
    }

    public int read(byte[] byArray) throws IOException {
        int n = this.source.read(byArray);
        if (n > 0 && this.timeoutThread != null) {
            this.timeoutThread.interrupt();
        }
        return n;
    }

    public void write(byte[] byArray) throws IOException {
        this.source.write(byArray);
        if (this.timeoutThread != null) {
            this.timeoutThread.interrupt();
        }
    }
}

