/*
 * Decompiled with CFR 0.152.
 */
package de.mud.jta.plugin;

import de.mud.jta.FilterPlugin;
import de.mud.jta.Plugin;
import de.mud.jta.PluginBus;
import de.mud.jta.PluginConfig;
import de.mud.jta.VisualTransferPlugin;
import de.mud.jta.event.ConfigurationListener;
import de.mud.jta.event.FocusStatus;
import de.mud.jta.event.LocalEchoListener;
import de.mud.jta.event.OnlineStatusListener;
import de.mud.jta.event.ReturnFocusListener;
import de.mud.jta.event.SetWindowSizeRequest;
import de.mud.jta.event.SoundRequest;
import de.mud.jta.event.TelnetCommandRequest;
import de.mud.jta.event.TerminalTypeListener;
import de.mud.jta.event.WindowSizeListener;
import de.mud.terminal.SwingTerminal;
import de.mud.terminal.vt320;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollBar;

public class Terminal
extends Plugin
implements FilterPlugin,
VisualTransferPlugin,
ClipboardOwner,
Runnable {
    private static final boolean personalJava = false;
    private static final int debug = 0;
    protected SwingTerminal terminal;
    protected vt320 emulation;
    protected String encoding = "latin1";
    protected SoundRequest audioBeep = null;
    protected JPanel tPanel;
    protected JMenu menu;
    private Thread reader = null;
    private Hashtable colors = new Hashtable();
    private boolean localecho_overridden = false;
    private Clipboard clipboard = null;
    protected FilterPlugin source;

    private Color codeToColor(String string) {
        if (this.colors.get(string) != null) {
            return (Color)this.colors.get(string);
        }
        try {
            if (Color.getColor(string) != null) {
                return Color.getColor(string);
            }
            return Color.decode(string);
        }
        catch (Exception exception) {
            try {
                return Color.decode(string);
            }
            catch (Exception exception2) {
                this.error("ignoring unknown color code: " + string);
                return null;
            }
        }
    }

    public Terminal(final PluginBus pluginBus, String string) {
        super(pluginBus, string);
        JMenuItem jMenuItem;
        this.emulation = new vt320(){

            public void write(byte[] byArray) {
                try {
                    Terminal.this.write(byArray);
                }
                catch (IOException iOException) {
                    Terminal.this.reader = null;
                }
            }

            public void beep() {
                if (Terminal.this.audioBeep != null) {
                    pluginBus.broadcast(Terminal.this.audioBeep);
                }
            }

            public void sendTelnetCommand(byte by) {
                pluginBus.broadcast(new TelnetCommandRequest(by));
            }

            public void setWindowSize(int n, int n2) {
                pluginBus.broadcast(new SetWindowSizeRequest(n, n2));
            }
        };
        this.terminal = new SwingTerminal(this.emulation);
        this.colors.put("black", Color.black);
        this.colors.put("red", Color.red);
        this.colors.put("green", Color.green);
        this.colors.put("yellow", Color.yellow);
        this.colors.put("blue", Color.blue);
        this.colors.put("magenta", Color.magenta);
        this.colors.put("orange", Color.orange);
        this.colors.put("pink", Color.pink);
        this.colors.put("cyan", Color.cyan);
        this.colors.put("white", Color.white);
        this.colors.put("gray", Color.gray);
        this.colors.put("darkgray", Color.darkGray);
        this.menu = new JMenu("Terminal");
        JMenu jMenu = new JMenu("Foreground");
        JMenu jMenu2 = new JMenu("Background");
        Enumeration enumeration = this.colors.keys();
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Terminal.this.terminal.setForeground((Color)Terminal.this.colors.get(actionEvent.getActionCommand()));
                Terminal.this.tPanel.repaint();
            }
        };
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Terminal.this.terminal.setBackground((Color)Terminal.this.colors.get(actionEvent.getActionCommand()));
                Terminal.this.tPanel.repaint();
            }
        };
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            jMenuItem = new JMenuItem(string2);
            jMenu.add(jMenuItem);
            jMenuItem.addActionListener(actionListener);
            jMenuItem = new JMenuItem(string2);
            jMenu2.add(jMenuItem);
            jMenuItem.addActionListener(actionListener2);
        }
        this.menu.add(jMenu);
        this.menu.add(jMenu2);
        jMenuItem = new JMenuItem("Smaller Font");
        this.menu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Font font = Terminal.this.terminal.getFont();
                Terminal.this.terminal.setFont(new Font(font.getName(), font.getStyle(), font.getSize() - 1));
                if (Terminal.this.tPanel.getParent() != null) {
                    Container container = Terminal.this.tPanel;
                    while ((container = container.getParent()) != null && !(container instanceof JFrame)) {
                    }
                    if (container instanceof JFrame) {
                        ((Frame)container).pack();
                    }
                    Terminal.this.tPanel.getParent().doLayout();
                    Terminal.this.tPanel.getParent().validate();
                }
            }
        });
        jMenuItem = new JMenuItem("Larger Font");
        this.menu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Font font = Terminal.this.terminal.getFont();
                Terminal.this.terminal.setFont(new Font(font.getName(), font.getStyle(), font.getSize() + 1));
                if (Terminal.this.tPanel.getParent() != null) {
                    Container container = Terminal.this.tPanel;
                    while ((container = container.getParent()) != null && !(container instanceof JFrame)) {
                    }
                    if (container instanceof JFrame) {
                        ((Frame)container).pack();
                    }
                    Terminal.this.tPanel.getParent().doLayout();
                    Terminal.this.tPanel.getParent().validate();
                }
            }
        });
        jMenuItem = new JMenuItem("Buffer +50");
        this.menu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Terminal.this.emulation.setBufferSize(Terminal.this.emulation.getBufferSize() + 50);
            }
        });
        jMenuItem = new JMenuItem("Buffer -50");
        this.menu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Terminal.this.emulation.setBufferSize(Terminal.this.emulation.getBufferSize() - 50);
            }
        });
        this.menu.addSeparator();
        jMenuItem = new JMenuItem("Reset Terminal");
        this.menu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Terminal.this.emulation.reset();
            }
        });
        this.tPanel = new JPanel(new BorderLayout()){

            public void update(Graphics graphics) {
                this.paint(graphics);
            }

            public void print(Graphics graphics) {
                Terminal.this.terminal.print(graphics);
            }
        };
        this.tPanel.add("Center", this.terminal);
        this.terminal.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                Terminal.this.terminal.setCursor(Cursor.getPredefinedCursor(2));
                pluginBus.broadcast(new FocusStatus(Terminal.this, focusEvent));
            }

            public void focusLost(FocusEvent focusEvent) {
                Terminal.this.terminal.setCursor(Cursor.getDefaultCursor());
                pluginBus.broadcast(new FocusStatus(Terminal.this, focusEvent));
            }
        });
        try {
            this.clipboard = this.tPanel.getToolkit().getSystemClipboard();
            System.out.println("Got the clipboard reference ok - copy & paste enabled");
        }
        catch (Exception exception) {
            System.out.println("Failed to get clipboard - copy and paste will not work");
        }
        this.terminal.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 3 && Terminal.this.clipboard != null) {
                    Terminal.this.paste(Terminal.this.clipboard);
                }
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                String string;
                if (mouseEvent.getButton() == 1 && Terminal.this.clipboard != null && (string = Terminal.this.terminal.getSelection()) != null && string.trim().length() > 0) {
                    Terminal.this.copy(Terminal.this.clipboard);
                }
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }
        });
        pluginBus.registerPluginListener(new OnlineStatusListener(){

            public void online() {
                if (Terminal.this.reader == null) {
                    Terminal.this.reader = new Thread(Terminal.this);
                    Terminal.this.reader.start();
                }
            }

            public void offline() {
                if (Terminal.this.reader != null) {
                    Terminal.this.reader = null;
                }
            }
        });
        pluginBus.registerPluginListener(new TerminalTypeListener(){

            public String getTerminalType() {
                return Terminal.this.emulation.getTerminalID();
            }
        });
        pluginBus.registerPluginListener(new WindowSizeListener(){

            public Dimension getWindowSize() {
                return new Dimension(Terminal.this.emulation.getColumns(), Terminal.this.emulation.getRows());
            }
        });
        pluginBus.registerPluginListener(new LocalEchoListener(){

            public void setLocalEcho(boolean bl) {
                if (!Terminal.this.localecho_overridden) {
                    Terminal.this.emulation.setLocalEcho(bl);
                }
            }
        });
        pluginBus.registerPluginListener(new ConfigurationListener(){

            public void setConfiguration(PluginConfig pluginConfig) {
                Terminal.this.configure(pluginConfig);
            }
        });
        pluginBus.registerPluginListener(new ReturnFocusListener(){

            public void returnFocus() {
                Terminal.this.terminal.requestFocus();
            }
        });
    }

    private void configure(PluginConfig pluginConfig) {
        int n;
        int n2;
        Object object;
        Color[] colorArray;
        Object object2;
        String string = pluginConfig.getProperty("Terminal", this.id, "foreground");
        if (string != null) {
            this.terminal.setForeground(Color.decode(string));
        }
        if ((string = pluginConfig.getProperty("Terminal", this.id, "background")) != null) {
            this.terminal.setBackground(Color.decode(string));
        }
        if ((string = pluginConfig.getProperty("Terminal", this.id, "print.color")) != null) {
            try {
                this.terminal.setColorPrinting(Boolean.valueOf(string));
            }
            catch (Exception exception) {
                this.error("Terminal.color.print: must be either true or false, not " + string);
            }
        }
        System.err.print("colorSet: ");
        string = pluginConfig.getProperty("Terminal", this.id, "colorSet");
        if (string != null) {
            System.err.println(string);
            object2 = new Properties();
            try {
                ((Properties)object2).load(this.getClass().getResourceAsStream(string));
            }
            catch (Exception exception) {
                try {
                    ((Properties)object2).load(new URL(string).openStream());
                }
                catch (Exception exception2) {
                    this.error("cannot find colorSet: " + string);
                    this.error("resource access failed: " + exception);
                    this.error("URL access failed: " + exception2);
                    object2 = null;
                }
            }
            if (object2 != null) {
                colorArray = this.terminal.getColorSet();
                object = null;
                for (n2 = 0; n2 < 8; ++n2) {
                    string = ((Properties)object2).getProperty("color" + n2);
                    if (string == null || (object = this.codeToColor(string)) == null) continue;
                    colorArray[n2] = object;
                }
                string = ((Properties)object2).getProperty("bold");
                if (string != null && (object = this.codeToColor(string)) != null) {
                    colorArray[8] = object;
                }
                if ((string = ((Properties)object2).getProperty("invert")) != null && (object = this.codeToColor(string)) != null) {
                    colorArray[9] = object;
                }
                this.terminal.setColorSet(colorArray);
            }
        }
        object2 = pluginConfig.getProperty("Terminal", this.id, "cursor.foreground");
        colorArray = pluginConfig.getProperty("Terminal", this.id, "cursor.background");
        if (object2 != null || colorArray != null) {
            try {
                Object object3 = object2 == null ? this.terminal.getBackground() : (object = Color.getColor((String)object2) != null ? Color.getColor((String)object2) : Color.decode((String)object2));
                Color color = colorArray == null ? this.terminal.getForeground() : (Color.getColor((String)colorArray) != null ? Color.getColor((String)colorArray) : Color.decode((String)colorArray));
                this.terminal.setCursorColors((Color)object, color);
            }
            catch (Exception exception) {
                this.error("ignoring unknown cursor color code: " + string);
            }
        }
        if ((string = pluginConfig.getProperty("Terminal", this.id, "border")) != null) {
            object = string;
            n2 = 0;
            string = pluginConfig.getProperty("Terminal", this.id, "borderRaised");
            if (string != null) {
                n2 = Boolean.valueOf(string).booleanValue() ? 1 : 0;
            }
            this.terminal.setBorder(Integer.parseInt((String)object), n2 != 0);
        }
        if ((string = pluginConfig.getProperty("Terminal", this.id, "localecho")) != null) {
            this.emulation.setLocalEcho(Boolean.valueOf(string));
            this.localecho_overridden = true;
        }
        if ((string = pluginConfig.getProperty("Terminal", this.id, "scrollBar")) != null && !((String)(object = string)).equals("none")) {
            if (!((String)object).equals("East") && !((String)object).equals("West")) {
                object = "East";
            }
            JScrollBar jScrollBar = new JScrollBar();
            this.tPanel.add((String)object, jScrollBar);
            this.terminal.setScrollbar(jScrollBar);
        }
        if ((string = pluginConfig.getProperty("Terminal", this.id, "id")) != null) {
            this.emulation.setTerminalID(string);
        }
        if ((string = pluginConfig.getProperty("Terminal", this.id, "answerback")) != null) {
            this.emulation.setAnswerBack(string);
        }
        if ((string = pluginConfig.getProperty("Terminal", this.id, "buffer")) != null) {
            this.emulation.setBufferSize(Integer.parseInt(string));
        }
        if ((string = pluginConfig.getProperty("Terminal", this.id, "size")) != null) {
            try {
                int n3 = string.indexOf(44);
                int n4 = Integer.parseInt(string.substring(1, n3).trim());
                n = Integer.parseInt(string.substring(n3 + 1, string.length() - 1).trim());
                this.emulation.setScreenSize(n4, n, false);
            }
            catch (Exception exception) {
                this.error("screen size is wrong: " + string);
                this.error("error: " + exception);
            }
        }
        if ((string = pluginConfig.getProperty("Terminal", this.id, "resize")) != null) {
            if (string.equals("font")) {
                this.terminal.setResizeStrategy(1);
            } else if (string.equals("screen")) {
                this.terminal.setResizeStrategy(2);
            } else {
                this.terminal.setResizeStrategy(0);
            }
        }
        if ((string = pluginConfig.getProperty("Terminal", this.id, "font")) != null) {
            String string2;
            String string3 = string;
            int n5 = 0;
            n = 12;
            string = pluginConfig.getProperty("Terminal", this.id, "fontSize");
            if (string != null) {
                n = Integer.parseInt(string);
            }
            if ((string2 = pluginConfig.getProperty("Terminal", this.id, "fontStyle")) == null || string2.equals("plain")) {
                n5 = 0;
            } else if (string2.equals("bold")) {
                n5 = 1;
            } else if (string2.equals("italic")) {
                n5 = 2;
            } else if (string2.equals("bold+italic")) {
                n5 = 3;
            }
            this.terminal.setFont(new Font(string3, n5, n));
        }
        if ((string = pluginConfig.getProperty("Terminal", this.id, "keyCodes")) != null) {
            Properties properties = new Properties();
            try {
                properties.load(this.getClass().getResourceAsStream(string));
            }
            catch (Exception exception) {
                try {
                    properties.load(new URL(string).openStream());
                }
                catch (Exception exception3) {
                    this.error("cannot find keyCodes: " + string);
                    this.error("resource access failed: " + exception);
                    this.error("URL access failed: " + exception3);
                    properties = null;
                }
            }
            if (properties != null) {
                this.emulation.setKeyCodes(properties);
            }
        }
        if ((string = pluginConfig.getProperty("Terminal", this.id, "VMS")) != null) {
            this.emulation.setVMS(Boolean.valueOf(string));
        }
        if ((string = pluginConfig.getProperty("Terminal", this.id, "IBM")) != null) {
            this.emulation.setIBMCharset(Boolean.valueOf(string));
        }
        if ((string = pluginConfig.getProperty("Terminal", this.id, "encoding")) != null) {
            this.encoding = string;
        }
        if ((string = pluginConfig.getProperty("Terminal", this.id, "beep")) != null) {
            try {
                this.audioBeep = new SoundRequest(new URL(string));
            }
            catch (MalformedURLException malformedURLException) {
                this.error("incorrect URL for audio ping: " + malformedURLException);
            }
        }
        this.tPanel.setBackground(this.terminal.getBackground());
    }

    public void run() {
        byte[] byArray = new byte[256];
        int n = 0;
        while (n >= 0) {
            try {
                n = this.read(byArray);
                if (n > 0) {
                    this.emulation.putString(new String(byArray, 0, n, this.encoding));
                }
                this.tPanel.repaint();
            }
            catch (IOException iOException) {
                this.reader = null;
                break;
            }
        }
    }

    public void setFilterSource(FilterPlugin filterPlugin) {
        this.source = filterPlugin;
    }

    public FilterPlugin getFilterSource() {
        return this.source;
    }

    public int read(byte[] byArray) throws IOException {
        return this.source.read(byArray);
    }

    public void write(byte[] byArray) throws IOException {
        this.source.write(byArray);
    }

    public JComponent getPluginVisual() {
        return this.tPanel;
    }

    public JMenu getPluginMenu() {
        return this.menu;
    }

    public void copy(Clipboard clipboard) {
        String string = this.terminal.getSelection();
        if (string == null) {
            return;
        }
        StringSelection stringSelection = new StringSelection(string);
        clipboard.setContents(stringSelection, this);
    }

    public void paste(Clipboard clipboard) {
        if (clipboard == null) {
            return;
        }
        Transferable transferable = clipboard.getContents(this);
        try {
            byte[] byArray = ((String)transferable.getTransferData(DataFlavor.stringFlavor)).getBytes();
            try {
                this.write(byArray);
            }
            catch (IOException iOException) {
                this.reader = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        this.terminal.clearSelection();
    }
}

