/*
 * Decompiled with CFR 0.152.
 */
package de.mud.jta.plugin;

import de.mud.jta.Plugin;
import de.mud.jta.PluginBus;
import de.mud.jta.PluginConfig;
import de.mud.jta.VisualPlugin;
import de.mud.jta.event.ConfigurationListener;
import de.mud.jta.event.OnlineStatusListener;
import de.mud.jta.event.SocketListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;

public class Status
extends Plugin
implements VisualPlugin,
Runnable {
    private static final int debug = 0;
    private JLabel status;
    private JLabel host;
    private JPanel sPanel;
    private String address;
    private String port;
    private String infoURL;
    private int interval;
    private Thread infoThread;
    private Hashtable ports = new Hashtable();

    public Status(PluginBus pluginBus, final String string) {
        super(pluginBus, string);
        pluginBus.registerPluginListener(new ConfigurationListener(){

            public void setConfiguration(PluginConfig pluginConfig) {
                String string4;
                Status.this.infoURL = pluginConfig.getProperty("Status", string, "info");
                if (Status.this.infoURL != null) {
                    Status.this.host.setAlignmentX(0.0f);
                }
                if ((string4 = pluginConfig.getProperty("Status", string, "font")) != null) {
                    String string2;
                    String string3 = string4;
                    int n = 0;
                    int n2 = 12;
                    string4 = pluginConfig.getProperty("Status", string, "fontSize");
                    if (string4 != null) {
                        n2 = Integer.parseInt(string4);
                    }
                    if ((string2 = pluginConfig.getProperty("Status", string, "fontStyle")) == null || string2.equals("plain")) {
                        n = 0;
                    } else if (string2.equals("bold")) {
                        n = 1;
                    } else if (string2.equals("italic")) {
                        n = 2;
                    } else if (string2.equals("bold+italic")) {
                        n = 3;
                    }
                    Status.this.host.setFont(new Font(string3, n, n2));
                }
                if ((string4 = pluginConfig.getProperty("Status", string, "foreground")) != null) {
                    Status.this.host.setForeground(Color.decode(string4));
                }
                if ((string4 = pluginConfig.getProperty("Status", string, "background")) != null) {
                    Status.this.host.setBackground(Color.decode(string4));
                }
                if (pluginConfig.getProperty("Status", string, "interval") != null) {
                    try {
                        Status.this.interval = Integer.parseInt(pluginConfig.getProperty("Status", string, "interval"));
                        Status.this.infoThread = new Thread(Status.this);
                        Status.this.infoThread.start();
                    }
                    catch (NumberFormatException numberFormatException) {
                        Status.this.error("interval is not a number");
                    }
                }
            }
        });
        this.ports.put("22", "ssh");
        this.ports.put("23", "telnet");
        this.ports.put("25", "smtp");
        this.sPanel = new JPanel(new BorderLayout());
        this.host = new JLabel("Not connected.", 2);
        pluginBus.registerPluginListener(new SocketListener(){

            public void connect(String string, int n) {
                Status.this.address = string;
                if (Status.this.address == null || Status.this.address.length() == 0) {
                    Status.this.address = "<unknown host>";
                }
                if (Status.this.ports.get("" + n) != null) {
                    Status.this.port = (String)Status.this.ports.get("" + n);
                } else {
                    Status.this.port = "" + n;
                }
                if (Status.this.infoURL == null) {
                    Status.this.host.setText("Trying " + Status.this.address + " " + Status.this.port + " ...");
                }
            }

            public void disconnect() {
                if (Status.this.infoURL == null) {
                    Status.this.host.setText("Not connected.");
                }
            }
        });
        this.sPanel.add("Center", this.host);
        this.status = new JLabel("offline", 0);
        pluginBus.registerPluginListener(new OnlineStatusListener(){

            public void online() {
                Status.this.status.setText("online");
                Status.this.status.setForeground(Color.green);
                if (Status.this.infoURL == null) {
                    Status.this.host.setText("Connected to " + Status.this.address + " " + Status.this.port);
                }
                Status.this.status.repaint();
            }

            public void offline() {
                Status.this.status.setText("offline");
                Status.this.status.setForeground(Color.red);
                if (Status.this.infoURL == null) {
                    Status.this.host.setText("Not connected.");
                }
                Status.this.status.repaint();
            }
        });
        this.sPanel.add("East", this.status);
    }

    public void run() {
        URL uRL = null;
        try {
            uRL = new URL(this.infoURL);
        }
        catch (Exception exception) {
            this.error("infoURL is not valid: " + exception);
            this.infoURL = null;
            return;
        }
        while (uRL != null && this.infoThread != null) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
                try {
                    String string;
                    while ((string = bufferedReader.readLine()) != null) {
                        if (string.startsWith("#")) {
                            String string2 = string.substring(1, 7);
                            string = string.substring(8);
                            this.host.setForeground(Color.decode("#" + string2));
                        }
                        this.host.setText(string);
                        Thread.sleep(10 * this.interval);
                    }
                }
                catch (IOException iOException) {
                    this.error("error while loading info ...");
                }
                Thread.sleep(100 * this.interval);
            }
            catch (Exception exception) {
                this.error("error retrieving info content: " + exception);
                exception.printStackTrace();
                this.host.setForeground(Color.red);
                this.host.setText("error retrieving info content");
                this.infoURL = null;
                return;
            }
        }
    }

    public JComponent getPluginVisual() {
        return this.sPanel;
    }

    public JMenu getPluginMenu() {
        return null;
    }
}

