/*
 * Decompiled with CFR 0.152.
 */
package de.mud.jta.plugin;

import de.mud.jta.FilterPlugin;
import de.mud.jta.Plugin;
import de.mud.jta.PluginBus;
import de.mud.jta.PluginConfig;
import de.mud.jta.event.ConfigurationListener;
import de.mud.jta.event.OnlineStatus;
import de.mud.jta.event.SocketListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Socket
extends Plugin
implements FilterPlugin,
SocketListener {
    private static final int debug = 0;
    protected java.net.Socket socket;
    protected InputStream in;
    protected OutputStream out;
    protected String relay = null;
    protected int relayPort = 31415;
    private String error = null;

    public Socket(PluginBus pluginBus, final String string) {
        super(pluginBus, string);
        pluginBus.registerPluginListener(this);
        pluginBus.registerPluginListener(new ConfigurationListener(){

            public void setConfiguration(PluginConfig pluginConfig) {
                Socket.this.relay = pluginConfig.getProperty("Socket", string, "relay");
                if (Socket.this.relay != null && pluginConfig.getProperty("Socket", string, "relayPort") != null) {
                    try {
                        Socket.this.relayPort = Integer.parseInt(pluginConfig.getProperty("Socket", string, "relayPort"));
                    }
                    catch (NumberFormatException numberFormatException) {
                        Socket.this.error("relayPort is not a number");
                    }
                }
            }
        });
    }

    public void connect(String string, int n) throws IOException {
        if (string == null) {
            return;
        }
        try {
            this.socket = this.relay == null ? new java.net.Socket(string, n) : new java.net.Socket(this.relay, this.relayPort);
            this.in = this.socket.getInputStream();
            this.out = this.socket.getOutputStream();
            if (this.relay != null) {
                this.write(("relay " + string + " " + n + "\n").getBytes());
            }
        }
        catch (Exception exception) {
            this.error = "Sorry, Could not connect to: " + string + " " + n + "\r\n" + "Reason: " + exception + "\r\n\r\n";
            this.error("can't connect: " + exception);
        }
        this.bus.broadcast(new OnlineStatus(true));
    }

    public void disconnect() throws IOException {
        this.bus.broadcast(new OnlineStatus(false));
        if (this.socket != null) {
            this.socket.close();
            this.in = null;
            this.out = null;
        }
    }

    public void setFilterSource(FilterPlugin filterPlugin) {
    }

    public FilterPlugin getFilterSource() {
        return null;
    }

    public int read(byte[] byArray) throws IOException {
        if (this.error != null && this.error.length() > 0) {
            int n = this.error.length() < byArray.length ? this.error.length() : byArray.length;
            System.arraycopy(this.error.getBytes(), 0, byArray, 0, n);
            this.error = this.error.substring(n);
            return n;
        }
        if (this.in == null) {
            this.disconnect();
            return -1;
        }
        int n = this.in.read(byArray);
        if (n < 0) {
            this.disconnect();
        }
        return n;
    }

    public void write(byte[] byArray) throws IOException {
        if (this.out == null) {
            return;
        }
        try {
            this.out.write(byArray);
        }
        catch (IOException iOException) {
            this.disconnect();
        }
    }
}

