/*
 * Decompiled with CFR 0.152.
 */
package de.mud.jta.plugin;

import de.mud.jta.FilterPlugin;
import de.mud.jta.Plugin;
import de.mud.jta.PluginBus;
import de.mud.jta.PluginConfig;
import de.mud.jta.event.ConfigurationListener;
import de.mud.jta.event.OnlineStatus;
import de.mud.jta.event.SocketListener;
import de.mud.jta.plugin.HandlerPTY;
import java.io.IOException;

public class Shell
extends Plugin
implements FilterPlugin {
    protected String shellCommand;
    private HandlerPTY pty;

    public Shell(final PluginBus pluginBus, final String string) {
        super(pluginBus, string);
        pluginBus.registerPluginListener(new ConfigurationListener(){

            public void setConfiguration(PluginConfig pluginConfig) {
                String string2 = pluginConfig.getProperty("Shell", string, "command");
                Shell.this.shellCommand = string2 != null ? string2 : "/bin/sh";
            }
        });
        pluginBus.registerPluginListener(new SocketListener(){

            public void connect(String string, int n) {
                Shell.this.pty = new HandlerPTY();
                if (Shell.this.pty.start(Shell.this.shellCommand) == 0) {
                    pluginBus.broadcast(new OnlineStatus(true));
                } else {
                    pluginBus.broadcast(new OnlineStatus(false));
                }
            }

            public void disconnect() {
                pluginBus.broadcast(new OnlineStatus(false));
                Shell.this.pty = null;
            }
        });
    }

    public void setFilterSource(FilterPlugin filterPlugin) {
    }

    public FilterPlugin getFilterSource() {
        return null;
    }

    public int read(byte[] byArray) throws IOException {
        if (this.pty == null) {
            return 0;
        }
        int n = this.pty.read(byArray);
        if (n <= 0) {
            throw new IOException("EOF on PTY");
        }
        return n;
    }

    public void write(byte[] byArray) throws IOException {
        if (this.pty != null) {
            this.pty.write(byArray);
        }
    }
}

