/*
 * Decompiled with CFR 0.152.
 */
package de.mud.jta.plugin;

import de.mud.jta.Plugin;
import de.mud.jta.PluginBus;
import de.mud.jta.PluginConfig;
import de.mud.jta.VisualPlugin;
import de.mud.jta.event.ConfigurationListener;
import de.mud.jta.event.ReturnFocusListener;
import de.mud.jta.event.SocketRequest;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MudConnector
extends Plugin
implements VisualPlugin,
Runnable,
ActionListener {
    private static final int debug = 0;
    protected URL listURL = null;
    protected int step;
    protected Map mudList = null;
    protected JList mudListSelector = new JList();
    protected JTextField mudName;
    protected JTextField mudAddr;
    protected JTextField mudPort;
    protected JButton connect;
    protected JPanel mudListPanel;
    protected CardLayout layouter;
    protected ProgressBar progress;
    protected JLabel errorLabel;
    protected JMenu MCMenu;

    public MudConnector(PluginBus pluginBus, final String string) {
        super(pluginBus, string);
        pluginBus.registerPluginListener(new ConfigurationListener(){

            public void setConfiguration(PluginConfig pluginConfig) {
                String string3 = pluginConfig.getProperty("MudConnector", string, "listURL");
                if (string3 != null) {
                    try {
                        MudConnector.this.listURL = new URL(string3);
                    }
                    catch (Exception exception) {
                        MudConnector.this.error("" + exception);
                        MudConnector.this.errorLabel.setText("Error: " + exception);
                    }
                } else {
                    MudConnector.this.error("no listURL specified");
                    MudConnector.this.errorLabel.setText("Missing list URL");
                    MudConnector.this.layouter.show(MudConnector.this.mudListPanel, "ERROR");
                }
                String string2 = pluginConfig.getProperty("MudConnector", string, "step");
                try {
                    MudConnector.this.step = Integer.parseInt(string2);
                }
                catch (Exception exception) {
                    if (string2 != null) {
                        MudConnector.this.error("warning: " + string2 + " is not a number");
                    }
                    MudConnector.this.step = 10;
                }
            }
        });
        pluginBus.registerPluginListener(new ReturnFocusListener(){

            public void returnFocus() {
                MudConnector.this.setup();
            }
        });
        this.layouter = new CardLayout();
        this.mudListPanel = new JPanel(this.layouter){

            public void update(Graphics graphics) {
                this.paint(graphics);
            }
        };
        this.errorLabel = new JLabel("Loading ...");
        this.mudListPanel.add("ERROR", this.errorLabel);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add("North", new JLabel("Loading mud list ... please wait"));
        this.progress = new ProgressBar();
        jPanel.add("Center", this.progress);
        this.mudListPanel.add("PROGRESS", jPanel);
        jPanel = new JPanel(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.mudListSelector);
        jPanel.add("Center", jScrollPane);
        this.mudListPanel.add("MUDLIST", jPanel);
        JPanel jPanel2 = jPanel;
        jPanel = new JPanel(new GridLayout(3, 1));
        jPanel2.add("East", jPanel);
        this.mudName = new JTextField(20);
        jPanel.add(this.mudName);
        this.mudName.setEditable(false);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        this.mudAddr = new JTextField(20);
        jPanel3.add("Center", this.mudAddr);
        this.mudAddr.setEditable(false);
        this.mudPort = new JTextField(6);
        jPanel3.add("East", this.mudPort);
        this.mudPort.setEditable(false);
        jPanel.add(jPanel3);
        this.connect = new JButton("Connect");
        jPanel.add(this.connect);
        this.connect.addActionListener(this);
        this.mudListSelector.setVisibleRowCount(3);
        this.mudListSelector.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                JList jList = (JList)listSelectionEvent.getSource();
                jList.ensureIndexIsVisible(jList.getSelectedIndex());
                String string = (String)jList.getSelectedValue();
                MudConnector.this.mudName.setText(string);
                Object[] objectArray = (Object[])MudConnector.this.mudList.get(string);
                MudConnector.this.mudAddr.setText((String)objectArray[0]);
                MudConnector.this.mudPort.setText(((Integer)objectArray[1]).toString());
            }
        });
        this.layouter.show(this.mudListPanel, "PROGRESS");
        this.MCMenu = new JMenu("MudConnector");
    }

    private void setup() {
        if (this.mudList == null && this.listURL != null) {
            new Thread(this).start();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        try {
            var1_1 = new HashMap<Object, JMenu>();
            this.mudList = new HashMap<K, V>();
            var2_3 = new BufferedReader(new InputStreamReader(this.listURL.openStream()));
            var3_4 = var2_3.readLine();
            var4_5 = 0;
            try {
                var4_5 = Integer.parseInt(var3_4);
            }
            catch (NumberFormatException var5_6) {
                this.error("number of muds: " + var5_6);
            }
            System.out.println("MudConnector: expecting " + var4_5 + " mud entries");
            this.progress.setMax(var4_5);
            var5_7 = new StreamTokenizer(var2_3);
            var5_7.resetSyntax();
            var5_7.whitespaceChars(0, 9);
            var5_7.ordinaryChars(32, 255);
            var5_7.wordChars(32, 255);
            var10_8 = 0;
            var11_9 = 0;
            block6: while (true) {
                var9_13 = var5_7.nextToken();
                if (var9_13 == -1) break;
                var6_10 = var5_7.sval;
                var9_13 = var5_7.nextToken();
                if (var9_13 != -1) {
                    if (var9_13 == 10) {
                        this.error(var6_10 + ": unexpected end of line" + ", missing host and port");
                    }
                    var7_11 = var5_7.sval;
                    var8_12 = new Integer(23);
                    var9_13 = var5_7.nextToken();
                    if (var9_13 != -1) {
                        try {
                            if (var9_13 == 10) {
                                this.error(var6_10 + ": default port 23");
                            }
                            var8_12 = new Integer(var5_7.sval);
                        }
                        catch (NumberFormatException var12_15) {
                            this.error("port for " + var6_10 + ": " + var12_15);
                        }
                    }
                    this.mudList.put(var6_10, new Object[]{var7_11, var8_12, new Integer(var11_9++)});
                    this.progress.adjust(++var10_8, var6_10);
                    this.mudListPanel.repaint();
                    var12_14 = ("" + var6_10.charAt(0)).toUpperCase();
                    var13_16 = (JMenu)var1_1.get(var12_14);
                    if (var13_16 == null) {
                        var13_16 = new JMenu((String)var12_14);
                        this.MCMenu.add(var13_16);
                        var1_1.put(var12_14, var13_16);
                    }
                    var14_17 = new JMenuItem(var6_10);
                    var14_17.addActionListener(this);
                    var13_16.add(var14_17);
                }
                while (true) {
                    if (var9_13 == -1) continue block6;
                    if (var9_13 != 10) ** break;
                    continue block6;
                    var9_13 = var5_7.nextToken();
                }
                break;
            }
            var12_14 = new ArrayList<K>(this.mudList.keySet());
            Collections.sort(var12_14);
            this.mudListSelector.setListData(var12_14.toArray());
            System.out.println("MudConnector: found " + this.mudList.size() + " entries");
        }
        catch (Exception var1_2) {
            this.error("error: " + var1_2);
            this.errorLabel.setText("Error: " + var1_2);
            this.layouter.show(this.mudListPanel, "ERROR");
        }
        this.layouter.show(this.mudListPanel, "MUDLIST");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        if (actionEvent.getSource() instanceof MenuItem) {
            string = actionEvent.getActionCommand();
            int n = (Integer)((Object[])this.mudList.get(string))[2];
            this.mudListSelector.setSelectedIndex(n);
            this.mudName.setText(string);
            Object[] objectArray = (Object[])this.mudList.get(string);
            this.mudAddr.setText((String)objectArray[0]);
            this.mudPort.setText(((Integer)objectArray[1]).toString());
        }
        string = this.mudAddr.getText();
        String string2 = this.mudPort.getText();
        if (string != null) {
            this.bus.broadcast(new SocketRequest());
            if (string2 == null || string2.length() <= 0) {
                string2 = "23";
            }
            this.bus.broadcast(new SocketRequest(string, Integer.parseInt(string2)));
        }
    }

    public JComponent getPluginVisual() {
        return this.mudListPanel;
    }

    public JMenu getPluginMenu() {
        return this.MCMenu;
    }

    class ProgressBar
    extends JComponent {
        int max;
        int current;
        String text;
        Dimension size = new Dimension(250, 20);
        Image backingStore;

        ProgressBar() {
        }

        public void setMax(int n) {
            this.max = n;
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        public void paint(Graphics graphics) {
            if (this.backingStore == null) {
                this.backingStore = this.createImage(this.getSize().width, this.getSize().height);
                this.redraw();
            }
            graphics.drawImage(this.backingStore, 0, 0, this);
        }

        private void redraw() {
            if (this.backingStore == null || this.text == null) {
                return;
            }
            Graphics graphics = this.backingStore.getGraphics();
            int n = (int)((float)this.current / (float)this.max * (float)this.getSize().width);
            graphics.fill3DRect(0, 0, this.getSize().width, this.getSize().height, false);
            graphics.setColor(this.getBackground());
            graphics.fill3DRect(0, 0, n, this.getSize().height, true);
            graphics.setColor(this.getForeground());
            graphics.setXORMode(this.getBackground());
            String string = "" + this.current * 100 / (this.max > 0 ? this.max : 1) + "% / " + this.current + " of " + this.max;
            graphics.drawString(string, this.getSize().width / 2 - this.getFontMetrics(this.getFont()).stringWidth(string) / 2, this.getSize().height / 2);
            graphics.drawString(this.text, this.getSize().width / 2 - this.getFontMetrics(this.getFont()).stringWidth(this.text) / 2, this.getSize().height / 2 + 12);
            this.paint(this.getGraphics());
        }

        public void adjust(int n, String string) {
            this.current = n;
            if (this.current > this.max) {
                this.current = this.max;
            }
            this.text = string;
            if ((float)this.current / (float)MudConnector.this.step == (float)(this.current / MudConnector.this.step)) {
                this.redraw();
            }
        }

        public void setSize(int n, int n2) {
            this.size = new Dimension(n, n2);
        }

        public Dimension getPreferredSize() {
            return this.size;
        }

        public Dimension getMinimumSize() {
            return this.size;
        }
    }
}

