/*
 * Decompiled with CFR 0.152.
 */
package de.mud.jta.plugin;

import de.mud.jta.FilterPlugin;
import de.mud.jta.Plugin;
import de.mud.jta.PluginBus;
import de.mud.jta.PluginConfig;
import de.mud.jta.VisualPlugin;
import de.mud.jta.event.ConfigurationListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class Capture
extends Plugin
implements FilterPlugin,
VisualPlugin,
ActionListener {
    private static final boolean personalJava = false;
    private static final int debug = 0;
    protected Hashtable remoteUrlList = new Hashtable();
    protected JMenu menu;
    protected JDialog errorDialog;
    protected JDialog fileDialog;
    protected JDialog doneDialog;
    protected boolean captureEnabled = false;
    private JMenuItem start;
    private JMenuItem stop;
    private JMenuItem clear;
    private JFrame frame = new JFrame("Java Telnet Applet: Captured Text");
    private JTextArea textArea;
    private JTextField fileName;
    protected FilterPlugin source;

    public Capture(PluginBus pluginBus, final String string) {
        super(pluginBus, string);
        this.frame.getContentPane().setLayout(new BorderLayout());
        this.textArea = new JTextArea(24, 80);
        this.frame.getContentPane().add((Component)this.textArea, "Center");
        this.textArea.setFont(new Font("Monospaced", 0, 12));
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Capture.this.frame.setVisible(false);
            }
        });
        this.frame.pack();
        this.errorDialog = new JDialog(this.frame, "Error", true);
        this.errorDialog.getContentPane().setLayout(new BorderLayout());
        this.errorDialog.getContentPane().add((Component)new JLabel("Cannot store data on remote server!"), "North");
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton("Close Dialog");
        jPanel.add(jButton);
        this.errorDialog.getContentPane().add((Component)jPanel, "South");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Capture.this.errorDialog.setVisible(false);
            }
        });
        this.doneDialog = new JDialog(this.frame, "Success", true);
        this.doneDialog.getContentPane().setLayout(new BorderLayout());
        this.doneDialog.getContentPane().add((Component)new JLabel("Successfully saved data!"), "North");
        jPanel = new JPanel();
        jButton = new JButton("Close Dialog");
        jPanel.add(jButton);
        this.doneDialog.getContentPane().add((Component)jPanel, "South");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Capture.this.errorDialog.setVisible(false);
            }
        });
        this.fileDialog = new JDialog(this.frame, "Enter File Name", true);
        this.fileDialog.getContentPane().setLayout(new BorderLayout());
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)Capture.this.remoteUrlList.get("URL.file.params.orig");
                string = string == null ? "" : string + "&";
                Capture.this.remoteUrlList.put("URL.file.params", string + "file=" + URLEncoder.encode(Capture.this.fileName.getText()));
                Capture.this.saveFile("URL.file");
                Capture.this.fileDialog.setVisible(false);
            }
        };
        jPanel = new JPanel();
        jPanel.add(new JLabel("File Name: "));
        this.fileName = new JTextField(30);
        jPanel.add(this.fileName);
        this.fileName.addActionListener(actionListener);
        this.fileDialog.getContentPane().add((Component)jPanel, "Center");
        jPanel = new JPanel();
        jButton = new JButton("Cancel");
        jPanel.add(jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Capture.this.fileDialog.setVisible(false);
            }
        });
        jButton = new JButton("Save File");
        jPanel.add(jButton);
        jButton.addActionListener(actionListener);
        this.fileDialog.getContentPane().add((Component)jPanel, "South");
        this.fileDialog.pack();
        this.menu = new JMenu("Capture");
        this.start = new JMenuItem("Start");
        this.start.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Capture.this.captureEnabled = true;
                Capture.this.start.setEnabled(false);
                Capture.this.stop.setEnabled(true);
            }
        });
        this.menu.add(this.start);
        this.stop = new JMenuItem("Stop");
        this.stop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Capture.this.captureEnabled = false;
                Capture.this.start.setEnabled(true);
                Capture.this.stop.setEnabled(false);
            }
        });
        this.stop.setEnabled(false);
        this.menu.add(this.stop);
        this.clear = new JMenuItem("Clear");
        this.clear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Capture.this.textArea.setText("");
            }
        });
        this.menu.add(this.clear);
        this.menu.addSeparator();
        JMenuItem jMenuItem = new JMenuItem("View/Hide Text");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (Capture.this.frame.isVisible()) {
                    Capture.this.frame.setVisible(false);
                    Capture.this.frame.hide();
                } else {
                    Capture.this.frame.setVisible(true);
                    Capture.this.frame.show();
                }
            }
        });
        this.menu.add(jMenuItem);
        pluginBus.registerPluginListener(new ConfigurationListener(){

            public void setConfiguration(PluginConfig pluginConfig) {
                JMenuItem jMenuItem = new JMenuItem("Save As File");
                Capture.this.menu.add(jMenuItem);
                String string3 = pluginConfig.getProperty("Capture", string, "file.url");
                if (string3 != null) {
                    try {
                        Capture.this.remoteUrlList.put("URL.file", new URL(string3));
                        string3 = pluginConfig.getProperty("Capture", string, "file.params");
                        if (string3 != null) {
                            Capture.this.remoteUrlList.put("URL.file.params.orig", string3);
                        }
                        jMenuItem.addActionListener(new ActionListener(this){
                            private final /* synthetic */ 10 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void actionPerformed(ActionEvent actionEvent) {
                                10.access$600(this.this$1).fileDialog.setVisible(true);
                            }
                        });
                        jMenuItem.setActionCommand("URL.file");
                    }
                    catch (MalformedURLException malformedURLException) {
                        System.err.println("capture url invalid: " + malformedURLException);
                    }
                } else {
                    jMenuItem.setEnabled(false);
                }
                int n = 1;
                while ((string3 = pluginConfig.getProperty("Capture", string, n + ".url")) != null) {
                    try {
                        String string2 = "URL." + n;
                        URL uRL = new URL(string3);
                        Capture.this.remoteUrlList.put(string2, uRL);
                        string3 = pluginConfig.getProperty("Capture", string, n + ".params");
                        if (string3 != null) {
                            Capture.this.remoteUrlList.put(string2 + ".params", string3);
                        }
                        jMenuItem = (string3 = pluginConfig.getProperty("Capture", string, n + ".name")) != null ? new JMenuItem("Save As " + string3) : new JMenuItem("Save As " + uRL.toString());
                        jMenuItem.setEnabled(true);
                        jMenuItem.addActionListener(Capture.this);
                        jMenuItem.setActionCommand(string2);
                        Capture.this.menu.add(jMenuItem);
                        ++n;
                    }
                    catch (MalformedURLException malformedURLException) {
                        System.err.println("capture url invalid: " + malformedURLException);
                    }
                }
            }

            static /* synthetic */ Capture access$600(10 var0) {
                return var0.Capture.this;
            }
        });
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        this.saveFile(string);
    }

    private void saveFile(String string) {
        URL uRL = (URL)this.remoteUrlList.get(string);
        try {
            String string2;
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setDoInput(true);
            uRLConnection.setDoOutput(true);
            uRLConnection.setUseCaches(false);
            uRLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            DataOutputStream dataOutputStream = new DataOutputStream(uRLConnection.getOutputStream());
            String string3 = (String)this.remoteUrlList.get(string + ".params");
            string3 = (string3 == null ? "" : string3 + "&") + "content=" + URLEncoder.encode(this.textArea.getText());
            dataOutputStream.writeBytes(string3);
            dataOutputStream.flush();
            dataOutputStream.close();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
            while (null != (string2 = bufferedReader.readLine())) {
                System.out.println("Capture: " + string2);
            }
            bufferedReader.close();
            this.doneDialog.pack();
            this.doneDialog.setVisible(true);
        }
        catch (IOException iOException) {
            System.err.println("Capture: cannot store text on remote server: " + uRL);
            iOException.printStackTrace();
            JTextArea jTextArea = new JTextArea(iOException.toString(), 5, 30);
            jTextArea.setEditable(false);
            this.errorDialog.add((Component)jTextArea, "Center");
            this.errorDialog.pack();
            this.errorDialog.setVisible(true);
        }
    }

    public void setFilterSource(FilterPlugin filterPlugin) {
        this.source = filterPlugin;
    }

    public FilterPlugin getFilterSource() {
        return this.source;
    }

    public int read(byte[] byArray) throws IOException {
        int n = this.source.read(byArray);
        if (this.captureEnabled && n > 0) {
            String string = new String(byArray, 0, n);
            this.textArea.append(string);
        }
        return n;
    }

    public void write(byte[] byArray) throws IOException {
        if (this.captureEnabled) {
            this.textArea.append(new String(byArray));
        }
        this.source.write(byArray);
    }

    public JComponent getPluginVisual() {
        return null;
    }

    public JMenu getPluginMenu() {
        return this.menu;
    }
}

