/*
 * Decompiled with CFR 0.152.
 */
package de.mud.jta;

import de.mud.jta.Common;
import de.mud.jta.Help;
import de.mud.jta.Plugin;
import de.mud.jta.VisualTransferPlugin;
import de.mud.jta.event.FocusStatusListener;
import de.mud.jta.event.OnlineStatusListener;
import de.mud.jta.event.ReturnFocusRequest;
import de.mud.jta.event.SocketRequest;
import java.awt.PrintJob;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

public class TelnetFrame
extends JFrame {
    private static final int debug = 0;
    private static final boolean personalJava = false;
    private Common setup;
    private Plugin focussedPlugin;
    private Clipboard clipboard;
    private String host;
    private String port;
    static /* synthetic */ Class class$de$mud$jta$Main;

    public static void main(String[] stringArray) {
        TelnetFrame telnetFrame = new TelnetFrame(stringArray);
        telnetFrame.setVisible(true);
    }

    public TelnetFrame(String[] stringArray) {
        Object object;
        JComponent jComponent;
        Object object2;
        String string;
        this.setResizable(false);
        final Properties properties = new Properties();
        try {
            properties.load((class$de$mud$jta$Main == null ? (class$de$mud$jta$Main = TelnetFrame.class$("de.mud.jta.Main")) : class$de$mud$jta$Main).getResourceAsStream("/de/mud/jta/default.conf"));
        }
        catch (IOException iOException) {
            System.err.println("jta: cannot load default.conf");
        }
        String string2 = this.parseOptions(properties, stringArray);
        if (string2 != null) {
            System.err.println(string2);
            System.err.println("usage: de.mud.jta.Main [-plugins pluginlist] [-addplugin plugin] [-config url_or_file] [-term id] [host [port]]");
        }
        if ((string = properties.getProperty("Main.config")) != null) {
            try {
                properties.load(new URL(string).openStream());
            }
            catch (IOException iOException) {
                try {
                    properties.load(new FileInputStream(string));
                }
                catch (Exception exception) {
                    System.err.println("jta: cannot load " + string);
                }
            }
        }
        this.host = properties.getProperty("Socket.host");
        this.port = properties.getProperty("Socket.port");
        this.setTitle("Telnet " + this.host + (this.port.equals("23") ? "" : " " + this.port));
        try {
            this.clipboard = this.getToolkit().getSystemClipboard();
        }
        catch (Exception exception) {
            System.err.println("jta: system clipboard access denied");
            System.err.println("jta: copy & paste only within the JTA");
            this.clipboard = new Clipboard("de.mud.jta.Main");
        }
        final Common common = new Common(properties);
        if (this.port == null || this.port.length() == 0) {
            this.port = common.getPlugins().containsKey("SSH") ? "22" : "23";
        }
        common.registerPluginListener(new OnlineStatusListener(){

            public void online() {
                TelnetFrame.this.setTitle("Telnet " + TelnetFrame.this.host + (TelnetFrame.this.port.equals("23") ? "" : " " + TelnetFrame.this.port));
            }

            public void offline() {
                TelnetFrame.this.setTitle("Telnet: offline");
            }
        });
        common.registerPluginListener(new FocusStatusListener(){

            public void pluginGainedFocus(Plugin plugin) {
                TelnetFrame.this.focussedPlugin = plugin;
            }

            public void pluginLostFocus(Plugin plugin) {
            }
        });
        Map map = common.getComponents();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            object2 = (String)iterator.next();
            jComponent = (JComponent)map.get(object2);
            if (properties.getProperty("layout." + (String)object2) == null) {
                System.err.println("jta: no layout property set for '" + (String)object2 + "'");
                this.add("South", jComponent);
                continue;
            }
            this.getContentPane().add(properties.getProperty("layout." + (String)object2), jComponent);
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                common.broadcast(new SocketRequest());
                TelnetFrame.this.setVisible(false);
                TelnetFrame.this.dispose();
            }
        });
        object2 = new JMenuBar();
        jComponent = new JMenu("File");
        ((AbstractButton)jComponent).setMnemonic(70);
        JMenuItem jMenuItem = new JMenuItem("Connect");
        ((JMenu)jComponent).add(jMenuItem);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 3));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = JOptionPane.showInputDialog(TelnetFrame.this, new JLabel("Enter your destination host (host[:port])"), "Connect", 3);
                if (string != null) {
                    int n = 0;
                    n = string.indexOf(32);
                    if (n > 0 || (n = string.indexOf(58)) > 0) {
                        TelnetFrame.this.host = string.substring(0, n);
                        TelnetFrame.this.port = string.substring(n + 1);
                    } else {
                        TelnetFrame.this.host = string;
                    }
                    common.broadcast(new SocketRequest());
                    common.broadcast(new SocketRequest(TelnetFrame.this.host, Integer.parseInt(TelnetFrame.this.port)));
                }
            }
        });
        jMenuItem = new JMenuItem("Disconnect");
        ((JMenu)jComponent).add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                common.broadcast(new SocketRequest());
            }
        });
        ((JMenu)jComponent).addSeparator();
        if (common.getComponents().get("Terminal") != null) {
            jMenuItem = new JMenuItem("Print");
            ((JMenu)jComponent).add(jMenuItem);
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, 2));
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PrintJob printJob = TelnetFrame.this.getToolkit().getPrintJob(TelnetFrame.this, "JTA Terminal", null);
                    if (printJob == null) {
                        return;
                    }
                    ((JComponent)common.getComponents().get("Terminal")).print(printJob.getGraphics());
                    printJob.end();
                }
            });
            ((JMenu)jComponent).addSeparator();
        }
        jMenuItem = new JMenuItem("Exit");
        ((JMenu)jComponent).add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TelnetFrame.this.dispose();
            }
        });
        JMenu jMenu = new JMenu("Edit");
        jMenuItem = new JMenuItem("Copy");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (TelnetFrame.this.focussedPlugin instanceof VisualTransferPlugin) {
                    ((VisualTransferPlugin)((Object)TelnetFrame.this.focussedPlugin)).copy(TelnetFrame.this.clipboard);
                }
            }
        });
        jMenuItem = new JMenuItem("Paste");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (TelnetFrame.this.focussedPlugin instanceof VisualTransferPlugin) {
                    ((VisualTransferPlugin)((Object)TelnetFrame.this.focussedPlugin)).paste(TelnetFrame.this.clipboard);
                }
            }
        });
        ((JMenuBar)object2).add(jMenu);
        Map map2 = common.getMenus();
        iterator = map2.keySet().iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
        }
        object = new JMenu("Help");
        ((AbstractButton)object).setMnemonic(156);
        jMenuItem = new JMenuItem("General");
        ((JMenu)object).add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Help.show(TelnetFrame.this, properties.getProperty("Help.url"));
            }
        });
        this.setJMenuBar((JMenuBar)object2);
        this.pack();
        if (new Boolean(properties.getProperty("Applet.detach.fullscreen")).booleanValue()) {
            this.setSize(this.getToolkit().getScreenSize());
        } else {
            this.pack();
        }
        if (this.host != null && this.host.length() > 0) {
            common.broadcast(new SocketRequest(this.host, Integer.parseInt(this.port)));
        }
        common.broadcast(new ReturnFocusRequest());
    }

    private String parseOptions(Properties properties, String[] stringArray) {
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-config")) {
                if (!stringArray[i + 1].startsWith("-")) {
                    properties.put("Main.config", stringArray[++i]);
                    continue;
                }
                return "missing parameter for -config";
            }
            if (stringArray[i].equals("-plugins")) {
                if (!stringArray[i + 1].startsWith("-")) {
                    properties.put("plugins", stringArray[++i]);
                    continue;
                }
                return "missing parameter for -plugins";
            }
            if (stringArray[i].equals("-addplugin")) {
                if (!stringArray[i + 1].startsWith("-")) {
                    properties.put("plugins", stringArray[++i] + "," + properties.get("plugins"));
                    continue;
                }
                return "missing parameter for -addplugin";
            }
            if (stringArray[i].equals("-term")) {
                if (!stringArray[i + 1].startsWith("-")) {
                    properties.put("Terminal.id", stringArray[++i]);
                    continue;
                }
                return "missing parameter for -term";
            }
            if (!bl) {
                properties.put("Socket.host", stringArray[i]);
                bl = true;
                continue;
            }
            if (bl && !bl2) {
                properties.put("Socket.port", stringArray[i]);
                bl2 = true;
                continue;
            }
            return "unknown parameter '" + stringArray[i] + "'";
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

