/*
 * Decompiled with CFR 0.152.
 */
package de.mud.jta;

import de.mud.telnet.TelnetProtocolHandler;
import de.mud.terminal.SwingTerminal;
import de.mud.terminal.vt320;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Graphics;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class SmallApplet
extends Applet
implements Runnable {
    private static final int debug = 0;
    private String host;
    private String port;
    private Socket socket;
    private InputStream is;
    private OutputStream os;
    private Thread reader;
    private vt320 emulation;
    private SwingTerminal terminal;
    private TelnetProtocolHandler telnet;
    private boolean localecho = false;
    boolean running = false;

    public void init() {
        this.host = this.getParameter("host");
        this.port = this.getParameter("port");
        this.emulation = new vt320(){

            public void write(byte[] byArray) {
                try {
                    if (SmallApplet.this.localecho) {
                        SmallApplet.this.emulation.putString(new String(byArray));
                    }
                    SmallApplet.this.telnet.transpose(byArray);
                }
                catch (IOException iOException) {
                    System.err.println("jta: error sending data: " + iOException);
                }
            }
        };
        this.terminal = new SwingTerminal(this.emulation);
        this.setLayout(new BorderLayout());
        this.add("Center", this.terminal);
        this.telnet = new TelnetProtocolHandler(){

            public String getTerminalType() {
                return SmallApplet.this.emulation.getTerminalID();
            }

            public Dimension getWindowSize() {
                return new Dimension(SmallApplet.this.emulation.getColumns(), SmallApplet.this.emulation.getRows());
            }

            public void setLocalEcho(boolean bl) {
                SmallApplet.this.localecho = true;
            }

            public void notifyEndOfRecord() {
            }

            public void write(byte[] byArray) throws IOException {
                SmallApplet.this.os.write(byArray);
            }
        };
    }

    public void start() {
        if (this.socket != null) {
            this.stop();
        }
        try {
            this.socket = new Socket(this.host, Integer.parseInt(this.port));
            this.is = this.socket.getInputStream();
            this.os = this.socket.getOutputStream();
            this.reader = new Thread(this);
            this.running = true;
            this.reader.start();
        }
        catch (Exception exception) {
            System.err.println("jta: error connecting: " + exception);
            this.stop();
        }
    }

    public void stop() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                System.err.println("jta: could not cleanly disconnect: " + exception);
            }
            this.socket = null;
            try {
                this.running = false;
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.reader = null;
        }
    }

    public void run() {
        byte[] byArray = new byte[256];
        int n = 0;
        while (this.running && n >= 0) {
            try {
                do {
                    if ((n = this.telnet.negotiate(byArray)) <= 0) continue;
                    this.emulation.putString(new String(byArray, 0, n));
                } while (this.running && n > 0);
                n = this.is.read(byArray);
                this.telnet.inputfeed(byArray, n);
            }
            catch (IOException iOException) {
                this.stop();
                break;
            }
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

