/*
 * Decompiled with CFR 0.152.
 */
package de.mud.jta;

import de.mud.jta.Plugin;
import de.mud.jta.PluginConfig;
import de.mud.jta.PluginLoader;
import de.mud.jta.Version;
import de.mud.jta.VisualPlugin;
import de.mud.jta.event.ConfigurationRequest;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JMenu;

public class Common
extends PluginLoader {
    public static final String DEFAULT_PATH = "de.mud.jta.plugin";

    public Common(Properties properties) {
        super(Common.getPluginPath(properties.getProperty("pluginPath")));
        Object object;
        System.out.println("** JTA - Telnet/SSH for the JAVA(tm) platform");
        System.out.println("** Version 2.6 for Java 2+");
        System.out.println("** Copyright (c) 1996-2005 Matthias L. Jugel, Marcus Meissner");
        try {
            object = (Version)Class.forName("de.mud.jta.Build").newInstance();
            System.out.println("** Build: " + object.getDate());
        }
        catch (Exception exception) {
            System.out.println("** Build: patched or selfmade, no date");
            System.err.println(exception);
        }
        object = Common.split(properties.getProperty("plugins"), ',');
        if (object == null) {
            System.err.println("jta: no plugins found! aborting ...");
            return;
        }
        Enumeration enumeration = ((Vector)object).elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = null;
            int n = string.indexOf("(");
            if (n > 1) {
                if (string.indexOf(")", n) > n) {
                    string2 = string.substring(n + 1, string.indexOf(")", n));
                } else {
                    System.err.println("jta: missing ')' for plugin '" + string + "'");
                }
                string = string.substring(0, n);
            }
            System.out.println("jta: loading plugin '" + string + "'" + (string2 != null && string2.length() > 0 ? ", ID: '" + string2 + "'" : ""));
            Plugin plugin = this.addPlugin(string, string2);
            if (plugin != null) continue;
            System.err.println("jta: ignoring plugin '" + string + "'" + (string2 != null && string2.length() > 0 ? ", ID: '" + string2 + "'" : ""));
        }
        this.broadcast(new ConfigurationRequest(new PluginConfig(properties)));
    }

    public Map getComponents() {
        Map map = this.getPlugins();
        Iterator iterator = map.keySet().iterator();
        HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
        while (iterator.hasNext()) {
            JComponent jComponent;
            String string = (String)iterator.next();
            Plugin plugin = (Plugin)map.get(string);
            if (!(plugin instanceof VisualPlugin) || (jComponent = ((VisualPlugin)((Object)plugin)).getPluginVisual()) == null) continue;
            String string2 = plugin.getId();
            hashMap.put(string + (string2 != null ? "(" + string2 + ")" : ""), jComponent);
        }
        return hashMap;
    }

    public Map getMenus() {
        Map map = this.getPlugins();
        Iterator iterator = map.keySet().iterator();
        HashMap<String, JMenu> hashMap = new HashMap<String, JMenu>();
        while (iterator.hasNext()) {
            JMenu jMenu;
            String string = (String)iterator.next();
            Plugin plugin = (Plugin)map.get(string);
            if (!(plugin instanceof VisualPlugin) || (jMenu = ((VisualPlugin)((Object)plugin)).getPluginMenu()) == null) continue;
            String string2 = plugin.getId();
            hashMap.put(string + (string2 != null ? "(" + string2 + ")" : ""), jMenu);
        }
        return hashMap;
    }

    private static Vector getPluginPath(String string) {
        if (string == null) {
            string = DEFAULT_PATH;
        }
        return Common.split(string, ':');
    }

    public static Vector split(String string, char c) {
        if (string == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        int n = -1;
        int n2 = string.indexOf(c);
        while (n2 >= 0) {
            vector.addElement(string.substring(n + 1, n2));
            n = n2;
            n2 = string.indexOf(c, n + 1);
        }
        vector.addElement(string.substring(n + 1));
        return vector;
    }
}

