/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.util;

import com.sanrad.util.BundleKeysInterface;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.security.AccessControlException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.UIManager;

public class Util {
    private static final double JDK_1_1_VERSION = 45.3;
    private static final double JDK_1_2_VERSION = 46.0;
    private static final double JDK_1_3_VERSION = 47.0;
    private static final double JDK_1_4_VERSION = 48.0;
    private static final double JDK_1_5_VERSION = 49.0;
    private static final String TEMPLATE_DEFAULT_GROUP_REGEX = "\\{\\d+\\}";
    private static final String TEMPLATE_DEFAULT_START_GROUP_REGEX = "\\{";
    private static final String TEMPLATE_DEFAULT_END_GROUP_REGEX = "\\}";
    private static final String CVS_DIR_NAME = "CVS/";
    private static final String CVS_TAG_FILE_NAME = "Tag";
    private static final String CVS_DEFAULT_TAG = "Head";
    static /* synthetic */ Class class$java$lang$String;

    public URL getURL(String filename) {
        URLClassLoader cl = (URLClassLoader)this.getClass().getClassLoader();
        URL url = cl.findResource(filename);
        if (url == null) {
            System.err.println("Failed to find url of " + filename);
        }
        return url;
    }

    public ImageIcon loadImage(String imagename) {
        URL url = this.getURL(imagename);
        if (url == null) {
            return null;
        }
        return new ImageIcon(url);
    }

    public static BigInteger bytesToBlocks(BigInteger size, int blockSize) {
        BigInteger blkSize = new BigInteger(Integer.toString(blockSize));
        return size.divide(blkSize);
    }

    public static BigInteger blocksToBytes(BigInteger numberOfBlocks, int blockSize) {
        if (numberOfBlocks != null) {
            BigInteger blkSize = new BigInteger(Integer.toString(blockSize));
            return numberOfBlocks.multiply(blkSize);
        }
        return null;
    }

    public static boolean isJavaVersion11Compatible() {
        return 45.3 <= Util.getJDKClassVersion();
    }

    public static boolean isJavaVersion12Compatible() {
        return 46.0 <= Util.getJDKClassVersion();
    }

    public static boolean isJavaVersion13Compatible() {
        return 47.0 <= Util.getJDKClassVersion();
    }

    public static boolean isJavaVersion14Compatible() {
        return 48.0 <= Util.getJDKClassVersion();
    }

    public static boolean isJavaVersion15Compatible() {
        return 49.0 <= Util.getJDKClassVersion();
    }

    public static boolean isJavaVersion14() {
        return 48.0 == Util.getJDKClassVersion();
    }

    public static double getJDKClassVersion() {
        return Double.parseDouble(System.getProperty("java.class.version"));
    }

    public static String getCurrentJavaVersion() {
        return System.getProperty("java.version");
    }

    public static String getCurrentJVMVersion() {
        return System.getProperty("java.vm.version");
    }

    public static String getOSName() {
        return System.getProperty("os.name");
    }

    public static String getOSVersion() {
        return System.getProperty("os.version");
    }

    public static String getLocalDir() {
        return System.getProperty("user.dir");
    }

    public static void initBundleKeys(Class bundleClass, ArrayList keySet) {
        Field[] fields = bundleClass.getFields();
        for (int i = 0; i < fields.length; ++i) {
            BundleKeysInterface object = (BundleKeysInterface)keySet.get(i);
            object.setKey(fields[i].getName());
        }
        keySet.clear();
        keySet = null;
    }

    public static void setLookAndFeel() {
        try {
            System.setProperty("swing.noxp", "true");
        }
        catch (AccessControlException ace) {
            System.out.println(ace.getMessage());
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isNumbersAndDotsSeries(String oid) {
        boolean prevCharWasDot = false;
        int i = oid.length();
        while (i-- > 0) {
            char c = oid.charAt(i);
            if (!Character.isDigit(c) && (c == '.' && prevCharWasDot || c != '.')) {
                return false;
            }
            prevCharWasDot = c == '.';
        }
        return true;
    }

    public static long[] stringToLongArray(String oid) {
        StringTokenizer tokens = new StringTokenizer(oid, ".");
        long[] comps = new long[tokens.countTokens()];
        int i = 0;
        while (tokens.hasMoreTokens()) {
            comps[i++] = Long.parseLong(tokens.nextToken());
        }
        return comps;
    }

    public static String longArrayToString(long[] array) {
        if (array == null) {
            return null;
        }
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < array.length - 1; ++i) {
            buff.append(array[i]).append('.');
        }
        buff.append(array[array.length - 1]);
        return buff.toString();
    }

    public static boolean isElementInArray(Object[] array, Object obj) {
        if (obj != null && array != null) {
            for (int i = 0; i < array.length; ++i) {
                if (!obj.equals(array[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static String resolveTemplate(String template, String[] itemToResolve) {
        return MessageFormat.format(template, itemToResolve);
    }

    public static String toHexStringFormat(byte[] bs, String delimiter) {
        StringBuffer ret = new StringBuffer(bs.length);
        for (int i = 0; i < bs.length; ++i) {
            String hex = Integer.toHexString(bs[i] < 0 ? bs[i] + 256 : bs[i]);
            ret.append(hex.length() < 2 ? "0" : "").append(hex).append(delimiter);
        }
        return ret.substring(0, ret.length() - delimiter.length()).toString().toUpperCase();
    }

    public static String getCVSTagVersionString() {
        String cvsTag = Util.getCVSTag();
        return cvsTag == null ? "unkown" : "CVS tag: " + Util.getCVSTag();
    }

    private static String getCVSTag() {
        String tag = null;
        String cvsDirPath = CVS_DIR_NAME;
        File cvsDir = new File(cvsDirPath);
        if (cvsDir.isDirectory()) {
            tag = CVS_DEFAULT_TAG;
            String cvsTagPath = cvsDirPath + CVS_TAG_FILE_NAME;
            File cvsTag = new File(cvsTagPath);
            if (cvsTag.isFile()) {
                try {
                    FileInputStream fis = new FileInputStream(cvsTag);
                    BufferedInputStream bis = new BufferedInputStream(fis);
                    InputStreamReader isr = new InputStreamReader(bis);
                    BufferedReader br = new BufferedReader(isr);
                    String line = br.readLine();
                    if (line != null) {
                        tag = line.substring(1);
                    }
                }
                catch (FileNotFoundException e) {
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            System.err.println("CVS directory not found in " + Util.getLocalDir());
        }
        return tag;
    }

    public static String getLocale() {
        Locale locale = Locale.getDefault();
        return locale.toString();
    }

    public static synchronized void printHashMap(Map map, int indenticationLevel, PrintStream out) {
        StringBuffer indentication = new StringBuffer();
        int i = indenticationLevel;
        while (i-- > 0) {
            indentication.append('\t');
        }
        if (map.isEmpty()) {
            out.println(indentication.toString() + "empty HashMap");
        }
        Iterator i2 = map.keySet().iterator();
        while (i2.hasNext()) {
            Object key = i2.next();
            out.print(indentication.toString() + key + "=");
            Object value = map.get(key);
            if (value instanceof HashMap) {
                out.println();
                Util.printHashMap((HashMap)value, indenticationLevel + 1, out);
                continue;
            }
            out.println(value);
        }
    }

    public static synchronized String getMapAsString(Map map, int indenticationLevel, StringBuffer sb) {
        StringBuffer indentication = new StringBuffer();
        int i = indenticationLevel;
        while (i-- > 0) {
            indentication.append('\t');
        }
        if (map.isEmpty()) {
            sb.append(indentication).append("empty Map");
            sb.append('\n');
        }
        Iterator i2 = map.keySet().iterator();
        while (i2.hasNext()) {
            Object key = i2.next();
            sb.append(indentication).append(key).append('=');
            Object value = map.get(key);
            if (value instanceof Map) {
                sb.append('\n');
                Util.getMapAsString((Map)value, indenticationLevel + 1, sb);
                continue;
            }
            sb.append(value);
            sb.append('\n');
        }
        return sb.toString();
    }

    public static synchronized String getListAsString(List list) {
        if (list != null) {
            StringBuffer sb = new StringBuffer();
            sb.append('{');
            Iterator i = list.iterator();
            while (i.hasNext()) {
                sb.append('[');
                sb.append(i.next());
                sb.append(']');
                sb.append(',');
            }
            if (!list.isEmpty()) {
                sb.deleteCharAt(sb.length() - 1);
            }
            sb.append('}');
            return sb.toString();
        }
        return "null";
    }

    public static void openURL(String url) throws Exception {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Mac OS")) {
            Class<?> macUtils = Class.forName("com.apple.mrj.MRJFileUtils");
            Method openURL = macUtils.getDeclaredMethod("openURL", class$java$lang$String == null ? (class$java$lang$String = Util.class$("java.lang.String")) : class$java$lang$String);
            openURL.invoke(null, url);
        } else if (osName.startsWith("Windows")) {
            Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
        } else {
            String[] browsers = new String[]{"firefox", "opera", "konqueror", "mozilla", "netscape"};
            String browser = null;
            for (int count = 0; count < browsers.length && browser == null; ++count) {
                if (Runtime.getRuntime().exec(new String[]{"which", browsers[count]}).waitFor() != 0) continue;
                browser = browsers[count];
            }
            if (browser == null) {
                throw new Exception("Could not find web browser.");
            }
            Runtime.getRuntime().exec(new String[]{browser, url});
        }
    }

    public static boolean lockApplicationInstanceIfNotActive(String filaname) {
        FileChannel channel = null;
        FileLock lock = null;
        File file = new File(System.getProperty("user.dir"), filaname);
        file.deleteOnExit();
        try {
            channel = new RandomAccessFile(file, "rw").getChannel();
            lock = channel.tryLock();
        }
        catch (OverlappingFileLockException ofe) {
            Util.closeLock(lock, channel);
            return true;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return true;
        }
        if (lock == null) {
            Util.closeLock(lock, channel);
            return true;
        }
        return false;
    }

    private static void closeLock(FileLock lock, FileChannel channel) {
        if (lock != null) {
            try {
                lock.release();
                lock = null;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        if (channel != null) {
            try {
                channel.close();
                channel = null;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public static String getStackTraceOutput(Throwable th) {
        return Util.getStackTraceOutput(th, 0);
    }

    public static String getStackTraceOutput(Throwable th, int indentation) {
        if (indentation < 0) {
            throw new IllegalArgumentException("Non-positive indentation");
        }
        StringBuffer tabs = new StringBuffer();
        int i = indentation;
        while (i-- > 0) {
            tabs.append('\t');
        }
        StackTraceElement[] trace = th.getStackTrace();
        StringBuffer sb = new StringBuffer();
        sb.append(tabs).append(String.valueOf(th)).append('\n');
        for (int i2 = 0; i2 < trace.length; ++i2) {
            sb.append(tabs).append("\tat " + trace[i2]).append('\n');
        }
        Throwable ourCause = th.getCause();
        if (ourCause != null) {
            sb.append("Caused by: ");
            sb.append(Util.getStackTraceOutput(ourCause, indentation));
        }
        return sb.toString();
    }

    public static Double round(Double aDouble, int digitsAfterDecimalPoint) {
        if (aDouble == null) {
            throw new NullPointerException("Null double parameter");
        }
        if (digitsAfterDecimalPoint < 0) {
            throw new IllegalArgumentException("Negative number of digits after the decimal point");
        }
        double multiplier = Math.pow(10.0, digitsAfterDecimalPoint);
        double multiplyDouble = aDouble * multiplier;
        double roundedMultiplyDouble = Math.round(multiplyDouble);
        double roundedDouble = roundedMultiplyDouble / multiplier;
        return new Double(roundedDouble);
    }

    public static boolean equalsWithNull(Object obj1, Object obj2) {
        if (obj1 == null && obj2 == null) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        return obj1.equals(obj2);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

