/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.util;

import com.sanrad.util.Constants;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;

public class StorageSize {
    private BigInteger value;
    private String extension;
    public static final StorageSize MEGA = new StorageSize(Constants.MEGA_BYTES, "MB");
    public static final StorageSize GIGA = new StorageSize(Constants.GIGA_BYTES, "GB");
    public static final StorageSize TERA = new StorageSize(Constants.TERA_BYTES, "TB");
    public static final StorageSize KILO = new StorageSize(Constants.KILO_BYTES, "KB");
    public static final StorageSize BYTE = new StorageSize(1.0, "Bytes");

    private StorageSize(double value, String extension) {
        Double doubleValue = new Double(value);
        String strValue = Long.toString(doubleValue.longValue());
        this.value = new BigInteger(strValue);
        this.extension = extension;
    }

    public BigInteger getValue() {
        return this.value;
    }

    public static String getSizeAsString(BigInteger size) {
        if (size == null || size.compareTo(BigInteger.ZERO) == 0) {
            return "0";
        }
        StorageSize[] arr = new StorageSize[]{TERA, GIGA, MEGA, KILO, BYTE};
        BigDecimal decimalSize = new BigDecimal(size);
        for (int i = 0; i < arr.length; ++i) {
            BigDecimal temp = new BigDecimal(arr[i].getValue());
            if ((temp = decimalSize.divide(temp, 200, 7)).longValue() <= 0L) continue;
            try {
                StringBuffer sb = new StringBuffer();
                DecimalFormat format = new DecimalFormat("###.##");
                double doubleValue = new Double(temp.toString());
                sb.append(format.format(doubleValue));
                sb.append(" ");
                sb.append(arr[i].toString());
                return sb.toString();
            }
            catch (Exception e) {
                e.printStackTrace();
                return temp.toString();
            }
        }
        return null;
    }

    public String toString() {
        return this.extension;
    }
}

