/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.util;

import com.sanrad.util.Queue;
import java.util.TreeMap;

public class SrThreadPool {
    QueueThread[] m_workers = new QueueThread[10];
    private static int threadID = 0;
    private DelayedTasksManager m_delayedTasksManager = new DelayedTasksManager();
    private static SrThreadPool m_instance;

    private SrThreadPool() {
        int i = this.m_workers.length;
        while (i-- > 0) {
            this.m_workers[i] = new QueueThread();
            this.m_workers[i].start();
        }
    }

    public static SrThreadPool getInstance() {
        if (m_instance == null) {
            m_instance = new SrThreadPool();
        }
        return m_instance;
    }

    public void addTask(Runnable task) {
        this.getLeastOccupied().addTask(task);
    }

    public void addTask(Runnable task, int delay) {
        if (delay > 0) {
            this.m_delayedTasksManager.addDelayedTask(System.currentTimeMillis() + (long)delay, task);
        } else {
            this.getLeastOccupied().addTask(task);
        }
    }

    private QueueThread getLeastOccupied() {
        QueueThread minTaskThread = this.m_workers[0];
        for (int i = 1; i < this.m_workers.length; ++i) {
            if (this.m_workers[i].taskCount() >= minTaskThread.taskCount()) continue;
            minTaskThread = this.m_workers[i];
        }
        return minTaskThread;
    }

    private class DelayedTasksManager
    extends Thread {
        Object lock = new Object();
        TreeMap taskSortedMap = new TreeMap();

        private DelayedTasksManager() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addDelayedTask(long executeTime, Runnable task) {
            Object object = this.lock;
            synchronized (object) {
                this.taskSortedMap.put(new Long(executeTime), task);
                this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            long timeToWait = 0L;
            while (true) {
                try {
                    while (true) {
                        Object object = this.lock;
                        synchronized (object) {
                            long currTime = System.currentTimeMillis();
                            Long executeTime = (Long)this.taskSortedMap.firstKey();
                            if (executeTime == null) {
                                this.lock.wait();
                                continue;
                            }
                            timeToWait = executeTime - currTime;
                            if (timeToWait > 0L) {
                                this.lock.wait(timeToWait);
                            } else {
                                SrThreadPool.this.addTask((Runnable)this.taskSortedMap.remove(executeTime));
                                Long nextExecuteTime = (Long)this.taskSortedMap.firstKey();
                                if (nextExecuteTime == null) {
                                    continue;
                                }
                                timeToWait = nextExecuteTime - currTime;
                            }
                        }
                    }
                }
                catch (Throwable th) {
                    th.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    private class QueueThread
    extends Thread {
        Queue taskQueue = new Queue();

        public QueueThread() {
            super("SrThreadPool" + ++threadID);
        }

        public void run() {
            while (true) {
                Object task = this.taskQueue.removeHead();
                try {
                    ((Runnable)task).run();
                    continue;
                }
                catch (Throwable th) {
                    th.printStackTrace();
                    continue;
                }
                break;
            }
        }

        public int taskCount() {
            return this.taskQueue.size();
        }

        public void addTask(Runnable task) {
            this.taskQueue.addElement(task);
        }
    }
}

