/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.util;

import com.sanrad.util.BundleKeysInterface;
import com.sanrad.util.Util;
import java.awt.Color;
import java.awt.Font;
import java.io.InputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.StringTokenizer;

public class SrResourceBundle {
    private static final HashMap m_instanceMap = new HashMap();
    private static final String BUNDLE_PREFIX_PATH = "resources/";
    private static final String UNDERSCORE = "_";
    private static final String BUNDLE_FILE_SUFFIX = ".properties";
    public static final String DEFAULT_CLIENT_BUNDLE_NAME = "product_client";
    public static final String DEFAULT_SERVER_BUNDLE_NAME = "product_server";
    public static final String DEFAULT_UI_BUNDLE_NAME = "defaultUI";
    public static final String CONSTANTS_BUNDLE_NAME = "constants";
    public static final String CLIENT_DATA_VALIDATION_BUNDLE_NAME = "client_data_validation";
    private PropertyResourceBundle m_bundle;
    private SimpleDateFormat m_dateFromat;
    private GregorianCalendar m_calendar = new GregorianCalendar();
    private URL bundleURL;

    private SrResourceBundle(String bundleName, Locale loc) {
        this.m_dateFromat = new SimpleDateFormat("yy", loc);
        Util util = new Util();
        try {
            this.bundleURL = util.getURL(BUNDLE_PREFIX_PATH + bundleName + UNDERSCORE + loc.toString() + BUNDLE_FILE_SUFFIX);
            InputStream is = this.bundleURL.openStream();
            this.m_bundle = new PropertyResourceBundle(is);
        }
        catch (Exception e1) {
            try {
                URL bundleURL = util.getURL(BUNDLE_PREFIX_PATH + bundleName + BUNDLE_FILE_SUFFIX);
                InputStream is = bundleURL.openStream();
                this.m_bundle = new PropertyResourceBundle(is);
            }
            catch (Exception e2) {
                this.m_bundle = null;
            }
        }
    }

    public static SrResourceBundle getInstance(String bundleName, Locale loc) {
        SrResourceBundle instance = null;
        if (!m_instanceMap.containsKey(bundleName + loc)) {
            instance = new SrResourceBundle(bundleName, loc);
            m_instanceMap.put(bundleName + loc, instance);
        } else {
            instance = (SrResourceBundle)m_instanceMap.get(bundleName + loc);
        }
        return instance;
    }

    public String getString(BundleKeysInterface key) {
        try {
            return this.m_bundle.getString(key.getKey());
        }
        catch (MissingResourceException mre) {
            if (key.isMandatory()) {
                System.err.println(mre.getMessage() + " (Bundle URL is " + this.bundleURL + ")");
            }
            return null;
        }
    }

    public String getString(BundleKeysInterface key, String[] resolvedItems) {
        String initialString = this.m_bundle.getString(key.getKey());
        return Util.resolveTemplate(initialString, resolvedItems);
    }

    public String getDateFormatString(BundleKeysInterface key, Date date) {
        this.m_dateFromat.applyPattern(this.getString(key));
        return this.m_dateFromat.format(date);
    }

    public String getDateFormatString(BundleKeysInterface key, long timeMillis) {
        this.m_calendar.setTimeInMillis(timeMillis);
        this.m_dateFromat.applyPattern(this.getString(key));
        return this.m_dateFromat.format(this.m_calendar.getTime());
    }

    public Color getColorResource(BundleKeysInterface key) {
        String colorStr = this.getString(key);
        try {
            return new Color(Integer.parseInt(colorStr));
        }
        catch (NumberFormatException e) {
            try {
                StringTokenizer st = new StringTokenizer(colorStr, ",");
                if (st.countTokens() != 3) {
                    return null;
                }
                int[] rgb = new int[3];
                for (int i = 0; i < rgb.length; ++i) {
                    rgb[i] = Integer.parseInt(st.nextToken().trim());
                }
                return new Color(rgb[0], rgb[1], rgb[2]);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
    }

    public Font getFontResource(BundleKeysInterface key) {
        return Font.decode(this.getString(key));
    }
}

