/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.util;

import java.util.Vector;

public class Queue {
    protected Vector queue;

    public Queue() {
        this.queue = new Vector();
    }

    public Queue(int initialCapacity) {
        this.queue = new Vector(initialCapacity);
    }

    public synchronized void addElement(Object value) {
        this.queue.addElement(value);
        this.notifyAll();
    }

    public synchronized void addElementToHead(Object value) {
        this.insertElementAt(value, 0);
    }

    public synchronized void clear() {
        this.queue.clear();
        this.notifyAll();
    }

    public synchronized void clearNoNotify() {
        this.queue.clear();
    }

    public synchronized void insertElementAt(Object value, int index) {
        this.queue.insertElementAt(value, index);
        this.notifyAll();
    }

    public synchronized Object removeHead() {
        while (this.queue.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
        }
        Object value = this.queue.remove(0);
        return value;
    }

    public synchronized Object getHead() {
        while (this.queue.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
        }
        Object value = this.queue.elementAt(0);
        return value;
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public int size() {
        return this.queue.size();
    }
}

