/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.util;

import java.io.IOException;
import java.net.BindException;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.net.SocketException;
import java.util.StringTokenizer;

public class NetUtil {
    public static final String LOOPBACK_IP = "127.0.0.0";
    public static final String DEFAULT_BROADCAST_IP = "0.0.0.0";
    public static final int MULTICAST_IP_PREFIX_MIN = 224;
    public static final int MULTICAST_IP_PREFIX_MAX = 239;
    public static final int RESERVED_IP_PREFIX_MIN = 240;
    public static final int RESERVED_IP_PREFIX_MAX = 255;

    private NetUtil() {
    }

    private static synchronized String booleanAnd(String op1, String op2) {
        StringBuffer result = new StringBuffer();
        char[] op1Array = op1.toCharArray();
        char[] op2Array = op2.toCharArray();
        for (int i = 0; i < op1Array.length; ++i) {
            int op1int = Integer.parseInt(String.valueOf(op1Array[i]));
            int op2int = Integer.parseInt(String.valueOf(op2Array[i]));
            result.append(op1int * op2int);
        }
        return result.toString();
    }

    public static synchronized boolean isValidRoute(String ip, String mask) {
        String ipBin = NetUtil.ipToBinary(ip);
        String maskBin = NetUtil.ipToBinary(mask);
        String resultBin = NetUtil.booleanAnd(ipBin, maskBin);
        String result = NetUtil.binaryToIp(resultBin);
        return result.equals(ip);
    }

    public static synchronized String getSubnet(String ip, String mask) {
        String ipBin = NetUtil.ipToBinary(ip);
        String maskBin = NetUtil.ipToBinary(mask);
        StringBuffer subnet = new StringBuffer();
        for (int i = 0; i < 4; ++i) {
            Integer ipBinByteVal = Integer.valueOf(ipBin.substring(i * 8, (i + 1) * 8), 2);
            Integer maskBinByteVal = Integer.valueOf(maskBin.substring(i * 8, (i + 1) * 8), 2);
            if (maskBinByteVal == 0) break;
            if (i > 0) {
                subnet.append(".");
            }
            subnet.append(ipBinByteVal & maskBinByteVal);
        }
        return subnet.toString();
    }

    private static synchronized String binaryToIp(String ipBin) {
        StringBuffer ipRetVal = new StringBuffer();
        for (int i = 0; i < 4; ++i) {
            Integer byteVal = Integer.valueOf(ipBin.substring(i * 8, (i + 1) * 8), 2);
            if (i > 0) {
                ipRetVal.append(".");
            }
            ipRetVal.append(byteVal.toString());
        }
        return ipRetVal.toString();
    }

    private static synchronized String ipToBinary(String ip) {
        StringBuffer ipIntByteBuffer = new StringBuffer();
        StringTokenizer tokens = new StringTokenizer(ip, ".");
        while (tokens.hasMoreTokens()) {
            String ipByte = tokens.nextToken();
            int ipIntByte = Integer.parseInt(ipByte);
            String ipBinByte = Integer.toBinaryString(ipIntByte);
            int ipBinByteLength = ipBinByte.length();
            for (int i = 0; i < 8 - ipBinByteLength; ++i) {
                ipIntByteBuffer.append(0);
            }
            ipIntByteBuffer.append(ipBinByte);
        }
        return ipIntByteBuffer.toString();
    }

    public static synchronized boolean isIPBelongsToSubnet(String ip, String mask, String subnet) {
        String refSubnet = NetUtil.getSubnet(ip, mask);
        return refSubnet.equals(subnet);
    }

    public static synchronized boolean onSameSubnet(String[] ips, String mask) {
        String maskBin = NetUtil.ipToBinary(mask);
        int indexZero = maskBin.indexOf(48);
        int indexOfMaskEnd = indexZero >= 0 ? indexZero : maskBin.length();
        String sample = null;
        int i = ips.length;
        while (i-- > 0) {
            if (sample == null) {
                sample = NetUtil.ipToBinary(ips[i]).substring(0, indexOfMaskEnd);
                continue;
            }
            if (sample.equals(NetUtil.ipToBinary(ips[i]).substring(0, indexOfMaskEnd))) continue;
            return false;
        }
        return true;
    }

    public static synchronized boolean isNetworkIpValid(String ip) {
        if (ip.equals(LOOPBACK_IP) || ip.equals(DEFAULT_BROADCAST_IP)) {
            return false;
        }
        int start = ip.indexOf(".");
        int firstByte = Integer.parseInt(ip.substring(0, start));
        if (firstByte >= 224 && firstByte <= 239) {
            return false;
        }
        return firstByte < 240 || firstByte > 255;
    }

    public static synchronized boolean isMaskValid(String mask) {
        String binMask = NetUtil.ipToBinary(mask);
        int index0 = binMask.indexOf("0");
        if (index0 == -1) {
            return true;
        }
        String tail = binMask.substring(index0);
        int index1 = tail.indexOf("1");
        return index1 == -1;
    }

    public static boolean isUDPPortBusy(int port) {
        try {
            DatagramSocket socket = new DatagramSocket(port);
            socket.close();
        }
        catch (SocketException e) {
            return true;
        }
        return false;
    }

    public static boolean isPortBusy(int port) {
        try {
            ServerSocket socket = new ServerSocket(port);
            socket.close();
        }
        catch (BindException be) {
            return true;
        }
        catch (IOException e) {
            return true;
        }
        return false;
    }

    public static int getRandomFreePort() throws IOException {
        ServerSocket socket = new ServerSocket(0);
        int port = socket.getLocalPort();
        socket.close();
        return port;
    }

    public static byte[] getMacBytes(String macStr) throws IllegalArgumentException {
        byte[] bytes = new byte[6];
        String[] hex = macStr.split("(\\:|\\-)");
        if (hex.length != 6) {
            throw new IllegalArgumentException("Invalid MAC address " + macStr);
        }
        try {
            for (int i = 0; i < 6; ++i) {
                bytes[i] = (byte)Integer.parseInt(hex[i], 16);
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid hex digit in MAC address " + macStr);
        }
        return bytes;
    }

    public static void main(String[] args) {
        String[] ips = new String[]{"172.17.200.153", "172.17.200.156"};
        String mask = "255.255.255.0";
        System.out.println(NetUtil.onSameSubnet(ips, mask));
    }
}

