/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.util;

import com.sanrad.log.LogMgr;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Date;
import java.util.Properties;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class MailSender {
    protected Message msg;

    public void initMessage(String smtpHost, String smtpUser, String smtpPassword, String from, String to, String subject) {
        Properties props = new Properties(System.getProperties());
        if (smtpHost != null) {
            props.put("mail.smtp.host", smtpHost);
            props.put("mail.smtp.auth", "true");
        }
        Session session = Session.getInstance((Properties)props, (Authenticator)new SMTPAuthenticator(smtpUser, smtpPassword));
        this.msg = new MimeMessage(session);
        try {
            if (from != null) {
                this.msg.setFrom((Address)this.getAddress(from));
            } else {
                this.msg.setFrom();
            }
            this.msg.setRecipients(Message.RecipientType.TO, (Address[])this.parseAddress(to));
            if (subject != null) {
                this.msg.setSubject(subject);
            }
        }
        catch (MessagingException e) {
            LogMgr.getServerLog().debug((Exception)((Object)e));
        }
    }

    public void sendMail(String message, String[] attachments) {
        try {
            MimeBodyPart part = new MimeBodyPart();
            part.setContent((Object)message, "text/html");
            MimeMultipart mp = new MimeMultipart();
            mp.addBodyPart((BodyPart)part);
            for (int i = 0; i < attachments.length; ++i) {
                this.addAttachment((Multipart)mp, attachments[i]);
            }
            this.msg.setContent((Multipart)mp);
            this.msg.setSentDate(new Date());
            Thread thread = new Thread("sendMail-" + this.getClass()){

                public void run() {
                    try {
                        Transport.send((Message)MailSender.this.msg);
                    }
                    catch (MessagingException me) {
                        LogMgr.getServerLog().debug((Exception)((Object)me));
                    }
                }
            };
            thread.start();
        }
        catch (MessagingException me) {
            LogMgr.getServerLog().debug(me.getMessage(), (Exception)((Object)me));
        }
    }

    public void sendMail(String message, Vector attachments) {
        this.sendMail(message, (String[])attachments.toArray());
    }

    public void sendMail(String message) {
        String LOG = "log";
        File logDirectory = new File("log");
        String[] files = logDirectory.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.indexOf(".html") != -1;
            }
        });
        for (int i = 0; i < files.length; ++i) {
            files[i] = "log" + File.separator + files[i];
        }
        this.sendMail(message, new String[0]);
    }

    private void addAttachment(Multipart mp, String file) throws MessagingException {
        String fileAttachment = file;
        MimeBodyPart part = new MimeBodyPart();
        FileDataSource source = new FileDataSource(fileAttachment);
        part.setDataHandler(new DataHandler((DataSource)source));
        part.setFileName(fileAttachment);
        mp.addBodyPart((BodyPart)part);
    }

    private InternetAddress getAddress(String addressStr) {
        try {
            return new InternetAddress(addressStr);
        }
        catch (AddressException e) {
            return null;
        }
    }

    private InternetAddress[] parseAddress(String addressStr) {
        try {
            return InternetAddress.parse((String)addressStr);
        }
        catch (AddressException e) {
            LogMgr.getServerLog().debug((Exception)((Object)e));
            return null;
        }
    }

    class SMTPAuthenticator
    extends Authenticator {
        private String user = "";
        private String password = "";

        public SMTPAuthenticator(String user, String password) {
            this.user = user;
            this.password = password;
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.user, this.password);
        }
    }
}

