/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.util.types.constants;

import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.constants.MibItemConstant;
import java.util.Iterator;
import java.util.Vector;

public class TCPConStateConstant
extends MibItemConstant {
    private static Vector valuesList;
    public static final TCPConStateConstant CLOSED;
    public static final TCPConStateConstant LISTEN;
    public static final TCPConStateConstant SYN_SENT;
    public static final TCPConStateConstant SYN_RECIEVE;
    public static final TCPConStateConstant ESTABLISHED;
    public static final TCPConStateConstant FIN_WAIT1;
    public static final TCPConStateConstant FIN_WAIT2;
    public static final TCPConStateConstant CLOSE_WAIT;
    public static final TCPConStateConstant LAST_ACK;
    public static final TCPConStateConstant CLOSING;
    public static final TCPConStateConstant TIME_WAIT;
    public static final TCPConStateConstant DELETE_TCB;

    protected TCPConStateConstant(int value, String description, Object userVal) {
        super(value, description, userVal);
    }

    private TCPConStateConstant(int value, String descriptionName, String userVal) {
        super(value, descriptionName, userVal);
        if (valuesList == null) {
            valuesList = new Vector();
        }
        valuesList.add(this);
    }

    public static TCPConStateConstant getTCPConState(Integer intVal) {
        Iterator valIter = valuesList.iterator();
        while (valIter.hasNext()) {
            TCPConStateConstant currnt = (TCPConStateConstant)valIter.next();
            if (!currnt.intValue().equals(intVal)) continue;
            return currnt;
        }
        return null;
    }

    public static TCPConStateConstant getTCPConStateStat(SrInteger intVal) {
        return TCPConStateConstant.getTCPConState((Integer)intVal.value());
    }

    public static TCPConStateConstant getTCPConStateStat(int intVal) {
        return TCPConStateConstant.getTCPConStateStat(new SrInteger(intVal));
    }

    public String toString() {
        return (String)this.userVal();
    }

    static {
        CLOSED = new TCPConStateConstant(1, "CLOSED", "Closed");
        LISTEN = new TCPConStateConstant(2, "LISTEN", "Listen");
        SYN_SENT = new TCPConStateConstant(3, "SynSent", "Syn Sent");
        SYN_RECIEVE = new TCPConStateConstant(4, "SynRecieve", "Syn Recieve");
        ESTABLISHED = new TCPConStateConstant(5, "Established", "Established");
        FIN_WAIT1 = new TCPConStateConstant(6, "FinWait1", "fin wait1");
        FIN_WAIT2 = new TCPConStateConstant(7, "FinWait2", "fin wait2");
        CLOSE_WAIT = new TCPConStateConstant(8, "CloseWait", "close wait");
        LAST_ACK = new TCPConStateConstant(9, "LastAck", "last ack");
        CLOSING = new TCPConStateConstant(10, "CLOSING", "Closing");
        TIME_WAIT = new TCPConStateConstant(11, "TimeWait", "time wait");
        DELETE_TCB = new TCPConStateConstant(12, "DeleteTCB", "delete TCB");
    }
}

