/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.util.types.constants;

import com.sanrad.nms.server.util.types.SrBITS;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class SrBITSConstant
extends SrBITS {
    private static HashMap allBitsConstants = new HashMap();
    private String m_display;
    private ArrayList m_mibStrings;
    private int m_bitNumber;

    protected SrBITSConstant(int nBits, int turnedOnBit, String mibString, String display) {
        super(nBits);
        this.m_bitNumber = turnedOnBit;
        if (turnedOnBit >= 0) {
            ((BitSet)this.value).set(turnedOnBit);
        }
        this.m_display = display;
        this.m_mibStrings = new ArrayList();
        if (mibString != null && mibString.length() > 0) {
            this.m_mibStrings.add(mibString);
        }
        this.addToBitsConstantsHashMap();
    }

    public int getBitNumber() {
        return this.m_bitNumber;
    }

    protected static SrBITSConstant createBITSConstant(String formattedMibString, Class c) {
        ArrayList mibStringsList = SrBITSConstant.parseMibStrings(formattedMibString);
        ArrayList allBitsConstantList = (ArrayList)allBitsConstants.get(c);
        ArrayList<SrBITSConstant> bitsConstantSet = new ArrayList<SrBITSConstant>();
        int nBits = 0;
        Iterator i = allBitsConstantList.iterator();
        while (i.hasNext()) {
            SrBITSConstant nextBit = (SrBITSConstant)i.next();
            if (!nextBit.containedIn(mibStringsList)) continue;
            mibStringsList.removeAll(nextBit.m_mibStrings);
            bitsConstantSet.add(nextBit);
            nBits = Math.max(nBits, ((BitSet)nextBit.value).length());
        }
        if (mibStringsList.isEmpty()) {
            SrBITSConstant created = new SrBITSConstant(nBits);
            created.m_mibStrings = SrBITSConstant.parseMibStrings(formattedMibString);
            created.m_display = formattedMibString;
            Iterator i2 = bitsConstantSet.iterator();
            while (i2.hasNext()) {
                SrBITSConstant nextBit = (SrBITSConstant)i2.next();
                ((BitSet)created.value).or((BitSet)nextBit.value);
            }
            return created;
        }
        return null;
    }

    private SrBITSConstant(int nBits) {
        super(nBits);
    }

    protected SrBITSConstant(int nBits, int[] turnedOnBits, String[] mibStrings, String display) {
        super(nBits);
        if (turnedOnBits.length != mibStrings.length) {
            throw new IllegalArgumentException("Inconsistent parameters");
        }
        for (int i = 0; i < turnedOnBits.length; ++i) {
            ((BitSet)this.value).set(turnedOnBits[i]);
        }
        this.m_display = display;
        this.m_mibStrings = new ArrayList<String>(Arrays.asList(mibStrings));
        this.addToBitsConstantsHashMap();
    }

    protected static SrBITSConstant valueOf(String monfoxFormattedString, Class c) {
        ArrayList list = (ArrayList)allBitsConstants.get(c);
        if (list != null) {
            ArrayList valMibStrings = SrBITSConstant.parseMibStrings(monfoxFormattedString);
            for (int i = 0; i < list.size(); ++i) {
                SrBITSConstant bitConstant = (SrBITSConstant)list.get(i);
                if (!bitConstant.equivalent(valMibStrings)) continue;
                return bitConstant;
            }
        }
        return null;
    }

    protected static SrBITSConstant[] valuesOf(String monfoxFormattedString, Class c) {
        ArrayList list = (ArrayList)allBitsConstants.get(c);
        ArrayList<SrBITSConstant> valuesOfList = new ArrayList<SrBITSConstant>();
        if (list != null) {
            ArrayList valMibStrings = SrBITSConstant.parseMibStrings(monfoxFormattedString);
            for (int i = 0; i < list.size(); ++i) {
                SrBITSConstant bitConstant = (SrBITSConstant)list.get(i);
                if (!bitConstant.equivalent(valMibStrings)) continue;
                valuesOfList.add(bitConstant);
            }
        }
        return valuesOfList.toArray(new SrBITSConstant[valuesOfList.size()]);
    }

    protected static SrBITSConstant[] getValues(Class c) {
        ArrayList list = (ArrayList)allBitsConstants.get(c);
        if (list != null && list.size() != 0) {
            SrBITSConstant[] objs = new SrBITSConstant[list.size()];
            return list.toArray(objs);
        }
        return null;
    }

    private void addToBitsConstantsHashMap() {
        Class<?> key = this.getClass();
        ArrayList<SrBITSConstant> values = (ArrayList<SrBITSConstant>)allBitsConstants.get(key);
        if (values == null) {
            values = new ArrayList<SrBITSConstant>();
            allBitsConstants.put(key, values);
        }
        values.add(this);
    }

    public String toString() {
        return this.m_display;
    }

    public static ArrayList parseMibStrings(String str) {
        StringBuffer buff = new StringBuffer(str);
        buff.deleteCharAt(buff.indexOf("{"));
        buff.deleteCharAt(buff.indexOf("}"));
        int i = buff.length();
        while (i-- > 0) {
            if (!Character.isWhitespace(buff.charAt(i))) continue;
            buff.deleteCharAt(i);
        }
        StringTokenizer tokens = new StringTokenizer(buff.toString(), ",");
        ArrayList<Object> list = new ArrayList<Object>();
        while (tokens.hasMoreElements()) {
            list.add(tokens.nextElement());
        }
        return list;
    }

    private boolean equivalent(ArrayList valMibStrings) {
        if (valMibStrings.size() == this.m_mibStrings.size()) {
            int i = valMibStrings.size();
            while (i-- > 0) {
                if (this.m_mibStrings.contains(valMibStrings.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean containedIn(List valMibStrings) {
        return valMibStrings.containsAll(this.m_mibStrings);
    }

    public boolean contains(SrBITSConstant other) {
        return this.m_mibStrings.containsAll(other.m_mibStrings);
    }
}

