/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.util.types.constants;

import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public abstract class MibItemConstant
extends SrType {
    protected static HashMap allMibConst = new HashMap();
    private String descriptionName;
    private Object userValue;
    protected Integer constValue;

    protected MibItemConstant(int value, String description, Object userVal) {
        super("MibItemConstant");
        this.constValue = new Integer(value);
        this.descriptionName = description;
        this.userValue = userVal;
        this.addValueToMibConstsHashMap();
    }

    protected MibItemConstant(String description, Object userVal) {
        super("MibItemConstant");
        this.descriptionName = description;
        this.userValue = userVal;
    }

    public String toString() {
        return this.descriptionName;
    }

    public String toDisplayString() {
        return this.descriptionName;
    }

    public Integer intValue() {
        return this.constValue;
    }

    public Object userVal() {
        return this.userValue;
    }

    public Object value() {
        return this.constValue;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (this.getClass().equals(obj.getClass())) {
                return this.constValue.equals(((MibItemConstant)obj).intValue());
            }
            if (obj instanceof Integer) {
                return this.constValue.equals((Integer)obj);
            }
            if (obj instanceof SrInteger) {
                return this.constValue.equals((Integer)((SrInteger)obj).value());
            }
        }
        return false;
    }

    public String errorDisplayString() {
        return ": " + this.toString();
    }

    public String getDescriptionName() {
        return this.descriptionName;
    }

    public int getTypeNumber() {
        return 9;
    }

    public static Object[] getValues() {
        throw new UnsupportedOperationException("The getValues method is not implemented this MIB constant");
    }

    public static MibItemConstant valueOf(Class c, int mibValue) {
        return (MibItemConstant)((ArrayList)allMibConst.get(c)).get(mibValue);
    }

    private void addValueToMibConstsHashMap() {
        Class<?> key = this.getClass();
        ArrayList<MibItemConstant> values = (ArrayList<MibItemConstant>)allMibConst.get(key);
        if (values == null) {
            values = new ArrayList<MibItemConstant>();
            allMibConst.put(key, values);
        }
        int indexInArray = this.constValue;
        this.ensureCapacity(values, indexInArray + 1);
        if (indexInArray >= 0) {
            values.set(indexInArray, this);
        } else {
            values.add(this);
        }
    }

    protected void ensureCapacity(ArrayList list, int newCapacity) {
        if (list.size() < newCapacity) {
            int i = list.size();
            while (i++ < newCapacity) {
                list.add(null);
            }
        }
    }

    protected static MibItemConstant[] getValues(Class class_) {
        ArrayList list = (ArrayList)allMibConst.get(class_);
        ArrayList newList = new ArrayList();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (element == null) continue;
            newList.add(element);
        }
        MibItemConstant[] array = new MibItemConstant[newList.size()];
        return newList.toArray(array);
    }
}

