/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.util.types.constants;

import com.sanrad.nms.server.exception.TypeMismatchException;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.constants.MibItemConstant;
import java.util.Iterator;
import java.util.Vector;

public class BlockSizeConstant
extends MibItemConstant {
    private static Vector valuesList;
    public static final BlockSizeConstant BLOCK_SIZE_NONE;
    public static final BlockSizeConstant BLOCK_SIZE_ONE;
    public static final BlockSizeConstant BLOCK_SIZE_512;
    public static final BlockSizeConstant BLOCK_SIZE_1024;
    public static final BlockSizeConstant BLOCK_SIZE_2048;
    public static final BlockSizeConstant BLOCK_SIZE_4096;
    public static final BlockSizeConstant BLOCK_SIZE_8192;

    private BlockSizeConstant(int value, String descriptionName, Object userVal) {
        super(value, descriptionName, userVal);
        if (valuesList == null) {
            valuesList = new Vector();
        }
        valuesList.add(this);
    }

    public static BlockSizeConstant getType(Integer intVal) {
        Iterator valIter = valuesList.iterator();
        while (valIter.hasNext()) {
            BlockSizeConstant currnt = (BlockSizeConstant)valIter.next();
            if (!currnt.intValue().equals(intVal)) continue;
            return currnt;
        }
        return null;
    }

    public static BlockSizeConstant getType(SrInteger intVal) {
        return BlockSizeConstant.getType((Integer)intVal.value());
    }

    public static BlockSizeConstant getType(int intVal) {
        return BlockSizeConstant.getType(new Integer(intVal));
    }

    public int getBlockSize() {
        switch (this.constValue) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 512;
            }
            case 3: {
                return 1024;
            }
            case 4: {
                return 2048;
            }
            case 5: {
                return 4096;
            }
            case 6: {
                return 8192;
            }
        }
        throw new TypeMismatchException("Block Size Constat value is unknown");
    }

    static {
        BLOCK_SIZE_NONE = new BlockSizeConstant(0, "None", "Not defined");
        BLOCK_SIZE_ONE = new BlockSizeConstant(1, "1Byte", "1Byte");
        BLOCK_SIZE_512 = new BlockSizeConstant(2, "sr512Bytes", "512Bytes");
        BLOCK_SIZE_1024 = new BlockSizeConstant(3, "sr1024Bytes", "1024Bytes");
        BLOCK_SIZE_2048 = new BlockSizeConstant(4, "sr2048Bytes", "2048Bytes");
        BLOCK_SIZE_4096 = new BlockSizeConstant(5, "sr4096Bytes", "4096Bytes");
        BLOCK_SIZE_8192 = new BlockSizeConstant(6, "sr8192Bytes", "8192Bytes");
    }
}

