/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.util.types;

import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrIpAddress;
import com.sanrad.nms.server.util.types.SrType;

public class SrTAddress
extends SrType {
    SrIpAddress myIp = null;
    SrInteger myPort = null;

    public SrTAddress(String tAddress) {
        super("SrTAddress");
        this.myIp = new SrIpAddress(tAddress.substring(0, 9) + "'H");
        String portInHex = tAddress.substring(9, 13);
        this.myPort = new SrInteger(Integer.parseInt(portInHex, 16));
    }

    public SrTAddress(SrIpAddress ip, SrInteger port) {
        super("SrTAddress");
        this.myIp = ip;
        this.myPort = port;
    }

    public SrIpAddress getIp() {
        return this.myIp;
    }

    public SrInteger getPort() {
        return this.myPort;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SrTAddress) {
            return this.myPort.equals(((SrTAddress)obj).getPort()) && this.myIp.equals(((SrTAddress)obj).getIp());
        }
        return false;
    }

    public String toString() {
        String ip = this.myIp.toInetAddressSnmpString().substring(1, 9);
        String port = Integer.toHexString(this.myPort.intValue());
        while (port.length() < 4) {
            port = "0" + port;
        }
        return "'" + ip + port + "'H";
    }

    public String errorDisplayString() {
        return "IP is: " + this.myIp.toDisplayString() + " port: " + this.myPort;
    }

    public int getTypeNumber() {
        return 13;
    }
}

