/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.util.types;

import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.util.Util;

public class SrOidType
extends SrType {
    public static final SrOidType NULL_OID = new SrOidType("0.0");

    public SrOidType() {
        super("SrOidType");
    }

    public SrOidType(String oid) {
        this();
        this.value = Util.stringToLongArray(oid);
    }

    public SrOidType(SrOidType oid) {
        this();
        this.value = oid.value();
    }

    public SrOidType(long[] oid) {
        this();
        this.value = oid;
    }

    private void init() {
    }

    public String toDisplayString() {
        return Util.longArrayToString((long[])this.value);
    }

    public String toString() {
        if (this.value == null) {
            return "";
        }
        return Util.longArrayToString((long[])this.value);
    }

    public Object value() {
        return this.value;
    }

    public Object clone() {
        return new SrOidType((long[])this.value);
    }

    public void setVal(SrOidType oid) {
        this.value = oid.value();
        this.init();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof SrOidType) {
            SrOidType other = (SrOidType)obj;
            return String.valueOf(Util.longArrayToString((long[])this.value)).equals(String.valueOf(Util.longArrayToString((long[])other.value)));
        }
        if (obj instanceof Long[]) {
            Long[] array = (Long[])obj;
            StringBuffer buff = new StringBuffer();
            for (int i = 0; i < array.length - 1; ++i) {
                buff.append(array[i]).append('.');
            }
            buff.append(array[array.length - 1]);
            return this.toString().equals(buff.toString());
        }
        if (obj instanceof String) {
            return this.toString().equals(obj);
        }
        return false;
    }

    public int hashCode() {
        if (this.value != null) {
            return String.valueOf(Util.longArrayToString((long[])this.value)).hashCode();
        }
        return super.hashCode();
    }

    public String errorDisplayString() {
        return "SrOidType: " + this.toDisplayString();
    }

    public int getTypeNumber() {
        return 8;
    }

    public String getIndexFromOidType(SrOidType oidPrefix) {
        String displayString = this.toDisplayString();
        String index = displayString.substring(oidPrefix.toDisplayString().length() + 1);
        return index;
    }
}

