/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.util.types;

import com.sanrad.nms.server.exception.TypeMismatchException;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.SrType;
import java.math.BigInteger;
import java.util.Vector;

public abstract class SrOctetStringFormat
extends SrType {
    int myLength = 0;

    public SrOctetStringFormat(int len) {
        super(new BigInteger("0"), "SrOctetStringFormat");
        this.myLength = len;
    }

    public SrOctetStringFormat(int len, BigInteger val) {
        super(val, "SrOctetStringFormat");
        this.myLength = len;
        if (((BigInteger)this.value).toString(16).length() > 2 * this.myLength) {
            throw new TypeMismatchException("Value is too big");
        }
        if (((BigInteger)this.value).signum() == -1) {
            throw new TypeMismatchException("Value can not be negative");
        }
    }

    public SrOctetStringFormat(int len, byte[] val) {
        this(len, new BigInteger(1, val));
        this.myLength = len;
    }

    public SrOctetStringFormat(int len, SrString val) {
        this(len, (String)val.value());
    }

    public SrOctetStringFormat(int len, String strVal) {
        this(len);
        if (strVal.length() == 0) {
            return;
        }
        int strLen = strVal.length();
        int radix = 0;
        String valStr = "";
        if (strVal.charAt(0) == '\'') {
            if (strVal.charAt(strLen - 2) == '\'') {
                if (strVal.charAt(strLen - 1) == 'h' || strVal.charAt(strLen - 1) == 'H') {
                    radix = 16;
                } else if (strVal.charAt(strLen - 1) == 'o' || strVal.charAt(strLen - 1) == 'O') {
                    radix = 8;
                } else if (strVal.charAt(strLen - 1) == 'b' || strVal.charAt(strLen - 1) == 'B') {
                    radix = 2;
                }
            }
            valStr = strVal.substring(1, strVal.length() - 2);
        } else if (strVal.indexOf(":") != -1) {
            String tmpStr = strVal;
            int lastIndexOfDots = strLen;
            while (lastIndexOfDots > 0) {
                tmpStr = tmpStr.substring(0, lastIndexOfDots);
                lastIndexOfDots = tmpStr.lastIndexOf(":");
                String lastVal = tmpStr.substring(lastIndexOfDots + 1);
                valStr = lastVal + valStr;
            }
            radix = 16;
        } else {
            radix = 10;
        }
        if (valStr.equals("")) {
            throw new TypeMismatchException("Unsupported OctetStringFormat " + strVal);
        }
        this.value = new BigInteger(valStr, radix);
        if (((BigInteger)this.value).toString(16).length() > 2 * this.myLength) {
            throw new TypeMismatchException("Value is too big");
        }
        if (((BigInteger)this.value).signum() == -1) {
            throw new TypeMismatchException("Value can not be negative");
        }
    }

    public void setValWithHexDotString(String strVal) {
        int strLen = strVal.length();
        String tmpStr = strVal;
        String hexStr = "";
        int lastIndexOfDot = strLen;
        while (lastIndexOfDot > 0) {
            String lastVal = (tmpStr = tmpStr.substring(0, lastIndexOfDot)).substring((lastIndexOfDot = tmpStr.lastIndexOf(":")) + 1);
            if (lastVal.length() == 1) {
                lastVal = "0" + lastVal;
            } else if (lastVal.length() == 0) {
                lastVal = "00";
            }
            hexStr = lastVal + hexStr;
        }
        this.value = new BigInteger(hexStr, 16);
        if (((BigInteger)this.value).toString(16).length() > 2 * this.myLength) {
            throw new TypeMismatchException("Value is too big");
        }
        if (((BigInteger)this.value).signum() == -1) {
            throw new TypeMismatchException("Value can not be negative");
        }
    }

    public void setValWithIntDotString(String strVal) {
        String tmpStr = strVal;
        Vector<Integer> intArray = new Vector<Integer>();
        int firstDotIndex = strVal.indexOf(".");
        while (firstDotIndex > 0) {
            String firstVal = tmpStr.substring(0, firstDotIndex);
            int intVal = Integer.parseInt(firstVal);
            intArray.add(new Integer(intVal));
            tmpStr = tmpStr.substring(firstDotIndex + 1);
            firstDotIndex = tmpStr.indexOf(".");
        }
        intArray.add(new Integer(tmpStr));
        byte[] byteArray = new byte[intArray.size()];
        for (int i = 0; i < byteArray.length; ++i) {
            byteArray[i] = ((Integer)intArray.get(i)).byteValue();
        }
        this.value = new BigInteger(1, byteArray);
        if (((BigInteger)this.value).toString(16).length() > 2 * this.myLength) {
            throw new TypeMismatchException("Value is too big");
        }
    }

    public int getLen() {
        return this.myLength;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SrOctetStringFormat) {
            return this.value.equals(((SrOctetStringFormat)obj).value);
        }
        if (obj instanceof BigInteger) {
            return this.value.equals(obj);
        }
        return false;
    }

    public BigInteger add(SrOctetStringFormat val) {
        return ((BigInteger)this.value).add((BigInteger)val.value());
    }

    protected int positiveByte(byte b) {
        if (b >= 0) {
            return b;
        }
        return 256 + b;
    }

    public String toHexNumber() {
        return ((BigInteger)this.value).toString(16);
    }

    public String displayString(int displayLen, String delimiter) {
        int i;
        if (this.myLength == 0) {
            return "";
        }
        byte[] bytesArray = ((BigInteger)this.value).toByteArray();
        StringBuffer strVal = new StringBuffer();
        int start = 0;
        if (bytesArray.length >= displayLen) {
            start = bytesArray.length - displayLen;
        } else {
            for (i = 0; i < displayLen - bytesArray.length; ++i) {
                strVal.append("00").append(delimiter);
            }
        }
        for (i = start; i < bytesArray.length; ++i) {
            int intVal = this.positiveByte(bytesArray[i]);
            String hexStr = Integer.toHexString(intVal);
            if (hexStr.length() == 1) {
                hexStr = "0" + hexStr;
            }
            strVal.append(hexStr);
            strVal.append(delimiter);
        }
        if (strVal.substring(strVal.length() - 1).equals(delimiter)) {
            strVal.deleteCharAt(strVal.length() - 1);
        }
        return new String(strVal);
    }

    public String toString() {
        return this.displayString(this.myLength, "");
    }

    public String toSNMPIndexString() {
        int i;
        byte[] bytesArray = ((BigInteger)this.value).toByteArray();
        StringBuffer strVal = new StringBuffer();
        int start = 0;
        if (bytesArray.length >= this.myLength) {
            start = bytesArray.length - this.myLength;
        } else {
            for (i = 0; i < this.myLength - bytesArray.length; ++i) {
                strVal.append("0.");
            }
        }
        for (i = start; i < bytesArray.length; ++i) {
            int intVal = this.positiveByte(bytesArray[i]);
            String intStr = Integer.toString(intVal);
            strVal.append(intStr);
            strVal.append(".");
        }
        strVal.deleteCharAt(strVal.length() - 1);
        return new String(strVal);
    }

    public Integer toInt() {
        BigInteger val = (BigInteger)this.value;
        byte[] bytes = val.toByteArray();
        int evaluationByte = bytes[0];
        for (int i = 0; i < bytes.length; ++i) {
            if (evaluationByte != 0) continue;
            evaluationByte = bytes[i];
        }
        return new Integer(evaluationByte >= 0 ? evaluationByte : evaluationByte + 256);
    }

    public String toDisplayString() {
        return this.displayString(8, ":");
    }

    public String errorDisplayString() {
        return "SrOctetStringFormat: " + this.toDisplayString();
    }

    public int getTypeNumber() {
        return 10;
    }
}

