/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.util.types;

import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.util.Util;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class SrEntityNameFormat
extends SrType {
    int length = 0;

    private SrEntityNameFormat() {
        super("SrEntityNameFormat");
    }

    public SrEntityNameFormat(SrString srString) {
        this();
        if (srString != null) {
            this.setValue(this.parseString(srString.toString()));
            this.length = ((byte[])this.value).length;
        }
    }

    public SrEntityNameFormat(byte[] value) {
        this();
        this.setValue(value);
        if (value != null) {
            this.length = value.length;
        }
    }

    public SrEntityNameFormat(String str) {
        this();
        if (str != null) {
            this.setValue(this.parseString(str));
            this.length = ((byte[])this.value).length;
        }
    }

    public int length() {
        return this.value != null ? Math.max(this.length, ((byte[])this.value).length) : this.length;
    }

    public byte[] getBytes() {
        return (byte[])this.value;
    }

    public byte getByteAt(int index) {
        try {
            return ((byte[])this.value)[index];
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            return 0;
        }
    }

    public String errorDisplayString() {
        return "SrEntityNameFormat: " + (this.value != null ? this.toHexStringFormat() : "null");
    }

    public boolean equals(Object obj) {
        if (obj instanceof SrEntityNameFormat) {
            SrEntityNameFormat otherObj = (SrEntityNameFormat)obj;
            byte[] val = (byte[])this.value;
            byte[] otherVal = (byte[])otherObj.value;
            if (val.length == otherVal.length && this.length == otherObj.length) {
                int i = val.length;
                while (i-- > 0 && val[i] == otherVal[i]) {
                }
                return i == -1;
            }
        }
        return false;
    }

    public int getTypeNumber() {
        return 10;
    }

    private void setValue(Object value) {
        if (value == null) {
            throw new NullPointerException("value shouldn't be null");
        }
        this.value = value;
    }

    public String toString() {
        byte[] ret = new byte[this.length];
        System.arraycopy(this.value, 0, ret, 0, Math.min(ret.length, ((byte[])this.value).length));
        for (int i = ((byte[])this.value).length; i < ret.length; ++i) {
            ret[i] = 0;
        }
        return Util.toHexStringFormat(ret, "");
    }

    public String toHexStringFormat() {
        return Util.toHexStringFormat((byte[])this.value, ":");
    }

    private byte[] parseString(String str) {
        if (this.isMonfoxHexaString(str)) {
            return this.parseMonfoxHexaString(str);
        }
        if (this.isMonfoxOctalString(str)) {
            throw new UnsupportedOperationException("Parsing monfox's octal String is not implemented");
        }
        return str.getBytes();
    }

    private boolean isMonfoxHexaString(String str) {
        if (str == null || str.length() < 5) {
            return false;
        }
        int len = str.length();
        if (str.charAt(0) == '\'' && str.charAt(len - 2) == '\'' && (str.charAt(len - 1) == 'H' || str.charAt(len - 1) == 'h') && (len - 1) % 2 == 0) {
            String hexStr = str.substring(1, len - 2).toLowerCase();
            return this.isHexa(hexStr);
        }
        return false;
    }

    private boolean isMonfoxOctalString(String str) {
        if (str == null || str.length() < 5) {
            return false;
        }
        int len = str.length();
        if (str.charAt(0) == '\'' && str.charAt(len - 2) == '\'' && (str.charAt(len - 1) == 'O' || str.charAt(len - 1) == 'o')) {
            int i = len - 3;
            while (i-- > 1 && Character.isDigit(str.charAt(i))) {
            }
            return i == 0;
        }
        return false;
    }

    private byte[] parseMonfoxHexaString(String str) {
        String hexStr = str.substring(1, str.length() - 2);
        ArrayList<String> strList = new ArrayList<String>();
        int i = 0;
        while (i + 1 < hexStr.length()) {
            strList.add(hexStr.substring(i, i + 2));
            i += 2;
        }
        byte[] ret = new byte[strList.size()];
        int i2 = strList.size();
        while (i2-- > 0) {
            int intval = Integer.parseInt((String)strList.get(i2), 16);
            ret[i2] = intval > 127 ? (byte)(intval - 256) : (byte)intval;
        }
        return ret;
    }

    private byte[] parseHexaStringFormat(String str) {
        StringTokenizer tokens = new StringTokenizer(str, ":");
        byte[] ret = new byte[tokens.countTokens()];
        int i = 0;
        while (tokens.hasMoreTokens()) {
            int intval = Integer.parseInt(tokens.nextToken(), 16);
            ret[i++] = intval > 127 ? (byte)(intval - 256) : (byte)intval;
        }
        return ret;
    }

    private boolean isHexa(String str) {
        char c;
        String hexStr = str.toLowerCase();
        int i = hexStr.length();
        while (i-- > 0 && (Character.isDigit(c = str.charAt(i)) || c >= 'a' && c <= 'f')) {
        }
        return i == -1;
    }
}

