/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.util.types;

import com.sanrad.nms.server.util.types.SrType;
import java.util.BitSet;

public class SrBITS
extends SrType {
    public SrBITS() {
        super("SrBITS");
        this.value = new BitSet(8);
    }

    public SrBITS(int nBits) {
        this();
        this.value = new BitSet(nBits);
    }

    public SrBITS(int nBits, int val) {
        this();
        this.value = new BitSet(nBits);
        this.setIntVal(val);
    }

    public SrBITS(String str) {
        this();
        int strLen = str.length();
        String newStr = "";
        newStr = this.isMonfoxHexaString(str) ? str.substring(1, strLen - 2) : str;
        this.value = new BitSet(newStr.length());
        int intVal = Integer.parseInt(newStr, 2);
        this.setIntVal(intVal);
    }

    public int getHighBit() {
        return ((BitSet)this.value).length() - 1;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SrBITS) {
            return ((SrBITS)obj).value().equals(this.value);
        }
        if (obj instanceof BitSet) {
            return obj.equals(this.value);
        }
        return false;
    }

    public Integer intVal() {
        int val = 0;
        for (int i = 7; i >= 0; --i) {
            if (((BitSet)this.value).get(i)) {
                val = val * 2 + 1;
                continue;
            }
            val *= 2;
        }
        return new Integer(val);
    }

    protected void setIntVal(int intVal) {
        String str = Integer.toBinaryString(intVal);
        for (int i = 0; i < 8 && i < str.length(); ++i) {
            if (str.charAt(str.length() - i - 1) != '1') continue;
            ((BitSet)this.value).set(i);
        }
    }

    public void setBit(int bitNumber) {
        ((BitSet)this.value).set(bitNumber);
    }

    public void clearBit(int bitNumber) {
        ((BitSet)this.value).clear(bitNumber);
    }

    public String toString() {
        int intval;
        String hexVal;
        String bitString = "";
        for (int i = ((BitSet)this.value).length() - 1; i >= 0; --i) {
            bitString = ((BitSet)this.value).get(i) ? bitString + "1" : bitString + "0";
        }
        if (((BitSet)this.value).length() == 0) {
            bitString = "00";
        }
        if ((hexVal = Integer.toHexString(intval = Integer.parseInt(bitString, 2))).length() < 2) {
            hexVal = "0" + hexVal;
        }
        return hexVal;
    }

    public boolean getBit(int bitIndex) {
        return ((BitSet)this.value).get(bitIndex);
    }

    public boolean getBit(SrBITS bitConstant) {
        return ((BitSet)this.value).get(bitConstant.getHighBit());
    }

    public String errorDisplayString() {
        return "SrCBITS: " + this.value.toString();
    }

    public int getTypeNumber() {
        return 12;
    }

    private boolean isMonfoxHexaString(String str) {
        if (str == null || str.length() < 5) {
            return false;
        }
        int len = str.length();
        return str.charAt(0) == '\'' && str.charAt(len - 2) == '\'' && (str.charAt(len - 1) == 'H' || str.charAt(len - 1) == 'h');
    }
}

