/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.util.table;

import java.util.HashMap;

public class SelectionResult {
    private HashMap columnNameToIndex = new HashMap();
    private Class[] m_columnClasses = null;
    private Object[] result;

    SelectionResult(Object[] result, String[] columns, Class[] colClasses) {
        int i = columns.length;
        while (i-- > 0) {
            this.columnNameToIndex.put(columns[i], new Integer(i));
        }
        this.m_columnClasses = colClasses;
        this.result = result;
    }

    public int getRowCount() {
        return this.result.length;
    }

    public Object getValueAt(int row, String colName) {
        Integer col = (Integer)this.columnNameToIndex.get(colName);
        if (col == null) {
            throw new IllegalArgumentException("Column not found");
        }
        return this.getValueAt(row, col);
    }

    public Object getValueAt(int row, int col) {
        Object[] line = (Object[])this.result[row];
        return line[col];
    }

    public void setValueAt(int row, String colName, Object value) {
        Integer col = (Integer)this.columnNameToIndex.get(colName);
        if (col != null) {
            if (value != null && !this.m_columnClasses[col].isAssignableFrom(value.getClass())) {
                throw new IllegalArgumentException("Wrong type");
            }
        } else {
            throw new IllegalArgumentException("Column not found");
        }
        this.setValueAt(row, col, value);
    }

    public void setValueAt(int row, int col, Object value) {
        Object[] line = (Object[])this.result[row];
        line[col] = value;
    }
}

