/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.util.table;

import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.util.table.MultiKey;
import com.sanrad.nms.server.util.table.MultiKeyHashMap;
import com.sanrad.nms.server.util.table.SelectionResult;
import java.util.HashMap;

public class MultiKeyTable
extends MultiKeyHashMap {
    private Class[] m_columnClasses = null;
    private HashMap m_columnNameToIndex = new HashMap();
    private String[] m_colNames;

    public MultiKeyTable(int numberOFKeys) {
        super(numberOFKeys);
    }

    public MultiKeyTable(Class[] classes, Class[] tableTypes) {
        super(classes);
        this.m_columnClasses = tableTypes;
    }

    public MultiKeyTable(int numberOFKeys, String[] colNames, Class[] colClasses) {
        super(numberOFKeys);
        this.m_colNames = colNames;
        this.m_columnClasses = colClasses;
        int i = colNames.length;
        while (i-- > 0) {
            this.m_columnNameToIndex.put(colNames[i], new Integer(i));
        }
    }

    public Object put(MultiKey multiKey, Object value) {
        throw new UnsupportedOperationException();
    }

    public Object put(MultiKey multiKey, Object[] values) {
        if (this.m_columnClasses != null) {
            this.checkValueTypesEnforcement(values);
        }
        Object result = super.put(multiKey, values);
        return result;
    }

    public void put(MultiKey multiKey, boolean[] columnsToWrite, Object[] values) throws IllegalValueException {
        if (columnsToWrite == null || columnsToWrite.length != this.m_columnClasses.length || values == null) {
            throw new IllegalValueException();
        }
        this.checkNumberOfColumnsToWriteValidity(columnsToWrite, values.length);
        Object[] row = (Object[])this.get(multiKey)[0];
        Object[] newRow = new Object[row.length];
        int valuesIndex = 0;
        for (int i = 0; i < columnsToWrite.length; ++i) {
            if (columnsToWrite[i]) {
                newRow[i] = values[valuesIndex];
                ++valuesIndex;
                continue;
            }
            newRow[i] = row[i];
        }
        this.put(multiKey, newRow);
    }

    private void checkNumberOfColumnsToWriteValidity(boolean[] columnsToWrite, int numberOfValues) throws IllegalValueException {
        int numberOfColumnsToWrite = 0;
        for (int i = 0; i < columnsToWrite.length; ++i) {
            if (!columnsToWrite[i]) continue;
            ++numberOfColumnsToWrite;
        }
        if (numberOfColumnsToWrite != numberOfValues) {
            throw new IllegalValueException();
        }
    }

    private void checkValueTypesEnforcement(Object[] values) {
        if (values == null || values.length > this.m_columnClasses.length) {
            throw new ArrayIndexOutOfBoundsException("Checking values types in MultiKeyTable");
        }
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null || this.m_columnClasses[i].isAssignableFrom(values[i].getClass())) continue;
            throw new ClassCastException("Checking values types in MultiKeyTable");
        }
    }

    public String toString() {
        StringBuffer stringValue = new StringBuffer("");
        MultiKey[] allKeys = this.getMatchingKeys(this.getKeyToAll());
        for (int i = 0; i < allKeys.length; ++i) {
            Object[] currRow = (Object[])this.get(allKeys[i])[0];
            stringValue.append(allKeys[i].toString() + " ");
            for (int j = 0; j < currRow.length; ++j) {
                Object currVal = currRow[j];
                if (currVal != null) {
                    stringValue.append(currVal.toString() + " ");
                    continue;
                }
                stringValue.append("N/A ");
            }
            stringValue.append("\n");
        }
        return stringValue.toString();
    }

    private SelectionResult getSelectionResult(MultiKey key, String[] colNames) {
        Class[] colClasses = new Class[colNames.length];
        int i = colNames.length;
        while (i-- > 0) {
            int colIndex = (Integer)this.m_columnNameToIndex.get(colNames[i]);
            colClasses[i] = this.m_columnClasses[colIndex];
        }
        Object[] lines = this.get(key);
        return new SelectionResult(lines, colNames, colClasses);
    }

    public SelectionResult getSelectionResult(MultiKey key) {
        return this.getSelectionResult(key, this.m_colNames);
    }

    public void setValuesAt(MultiKey key, String[] columns, Object[] values) {
        Object[][] bulk = (Object[][])this.get(key);
        int[] colIndices = new int[columns.length];
        int i = columns.length;
        while (i-- > 0) {
            int columnIndex = (Integer)this.m_columnNameToIndex.get(columns[i]);
            if (!this.m_columnClasses[columnIndex].isAssignableFrom(values[i].getClass())) {
                throw new ClassCastException("Trying to set a value to MultiKeyTable");
            }
            colIndices[i] = columnIndex;
        }
        int row = bulk.length;
        while (row-- > 0) {
            int col = colIndices.length;
            while (col-- > 0) {
                bulk[row][col] = values[col];
            }
        }
    }

    public void setValueAt(MultiKey key, String column, Object value) {
        this.setValuesAt(key, new String[]{column}, new Object[]{value});
    }

    public void setValuesAt(MultiKey key, Object[] values) {
        this.setValuesAt(key, this.m_colNames, values);
    }

    public void addRow(MultiKey key, Object[] values) {
        this.put(key, values);
    }
}

