/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.util;

import com.sanrad.nms.server.exception.TypeMismatchException;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementDataList;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterCodes;
import com.sanrad.nms.server.util.Parameters;
import com.sanrad.nms.server.util.types.SrType;

public class Parameter
implements Parameters {
    ParameterCode code;
    Object value;

    public Parameter(ParameterCode code) {
        this(code, null);
    }

    public Parameter(ParameterCode code, Object value) {
        this.code = code;
        if (!(value == null || value instanceof SrType || value instanceof SrType[] || value instanceof ConfigElementData || value instanceof ConfigElementDataList)) {
            throw new TypeMismatchException("Parameter should be set only with StType or SrType[]");
        }
        this.value = value;
    }

    public ParameterCode getCode() {
        return this.code;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        if (value != null && !(value instanceof SrType) && !(value instanceof SrType[])) {
            throw new TypeMismatchException("Parameter should be set only with StType or SrType[]");
        }
        this.value = value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Parameter) {
            if (!this.code.equals(((Parameter)obj).getCode())) {
                return false;
            }
            if (this.value == null && ((Parameter)obj).value == null) {
                return true;
            }
            if (this.value != null && ((Parameter)obj).value != null) {
                return this.value.equals(((Parameter)obj).value);
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer str = new StringBuffer("Param: ");
        str.append(this.code.toString());
        str.append(" Value: ");
        str.append(String.valueOf(this.value));
        return str.toString();
    }

    public int hashCode() {
        return this.code.hashCode();
    }

    public ParameterCodes getCode(GeneralLogicObject source) {
        return this.getCode();
    }
}

