/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.user;

import com.sanrad.nms.server.AbstractBoundedStub;
import com.sanrad.nms.server.Server;
import com.sanrad.nms.server.alarm.AlarmMgr;
import com.sanrad.nms.server.alarm.AlarmMgrImpl;
import com.sanrad.nms.server.alarm.DrAlarmMgrImpl;
import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.logic.ElementEventImpl;
import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.EventService;
import com.sanrad.nms.server.logic.EventServiceImpl;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.SystemRoot;
import com.sanrad.nms.server.logic.SystemRootImpl;
import com.sanrad.nms.server.mgr.DataMgr;
import com.sanrad.nms.server.user.User;
import com.sanrad.nms.server.user.UserEvent;
import com.sanrad.nms.server.user.UserImpl;
import com.sanrad.nms.server.user.UserListener;
import com.sanrad.nms.server.user.UserManager;
import com.sanrad.util.SrConstantsBundleKeys;
import java.io.InvalidClassException;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class UserManagerImpl
extends AbstractBoundedStub
implements UserManager,
UserListener {
    public static String DEFAULT_USER = Server.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.NMS_DEFAULT_USER_NAME);
    private static final String DEFAULT_PASSWORD;
    private static UserManagerImpl theInstance;
    private HashMap users = new HashMap();

    private UserManagerImpl() throws RemoteException {
        this.loadUsers();
    }

    public static UserManagerImpl getInstance() throws RemoteException {
        if (theInstance == null) {
            theInstance = new UserManagerImpl();
        }
        return theInstance;
    }

    private static String getFileCodecKey() {
        String codecKey = ErrorMessage.ALIAS_ALREADY_IN_USE.getMessage();
        return codecKey;
    }

    public String getCodecKey() throws RemoteException {
        return UserImpl.getCodecKey();
    }

    public void addUser(String username, String password) throws RemoteException, IllegalValueException {
        Object user = this.users.get(username);
        if (user != null) {
            String msg = "User " + username + " already exists.";
            logger.debug(msg);
            throw new IllegalValueException(msg);
        }
        UserImpl newUser = new UserImpl(username, password);
        newUser.addUserListener(this);
        this.users.put(username, newUser);
        this.saveUsers();
        ElementEventImpl event = new ElementEventImpl(newUser, newUser);
        EventServiceImpl.getInstance().fireElementCreate(event);
    }

    public void removeUsers(Vector users) throws RemoteException, IllegalValueException {
        Enumeration e = users.elements();
        while (e.hasMoreElements()) {
            User user = (User)e.nextElement();
            this.removeUser(user);
        }
    }

    public void removeUser(User user) throws RemoteException, IllegalValueException {
        Object oldUser = this.users.remove(user.getUsername());
        if (oldUser == null) {
            String msg = "User " + user.getUsername() + " not found.";
            logger.debug(msg);
            throw new IllegalValueException(msg);
        }
        this.saveUsers();
        ElementEventImpl event = new ElementEventImpl(user, user);
        EventServiceImpl.getInstance().fireElementRemove(event);
    }

    public User getUser(String username) throws RemoteException, IllegalValueException {
        if (this.users == null) {
            String msg = "User " + username + " not found.";
            logger.debug(msg + " probably users file was corrupted.");
            throw new IllegalValueException(msg);
        }
        User user = (User)this.users.get(username);
        if (user == null) {
            String msg = "User " + username + " not found.";
            logger.debug(msg);
            throw new IllegalValueException(msg);
        }
        return user;
    }

    public void login(String username, String password) throws RemoteException, IllegalValueException {
        UserImpl user = null;
        UserImpl loginUser = new UserImpl(username, password);
        if (this.users.size() == 0) {
            if (username.equals(DEFAULT_USER)) {
                user = new UserImpl(DEFAULT_USER, DEFAULT_PASSWORD);
            }
        } else {
            user = (UserImpl)this.getUser(username);
        }
        if (user == null) {
            String msg = "User " + username + ": not found.";
            logger.debug(msg);
            throw new IllegalValueException(msg);
        }
        if (!user.equals(loginUser)) {
            String msg = "User " + username + ": the password is incorrect. Please retype your password.";
            logger.debug(msg);
            throw new IllegalValueException(msg);
        }
        ElementEventImpl event = new ElementEventImpl(user, user);
        EventServiceImpl.getInstance().fireLoginSucceed(event);
    }

    public HashMap getAllUsers() throws RemoteException, IllegalValueException {
        return this.users;
    }

    public void userChanged(UserEvent e) {
        this.saveUsers();
    }

    private void saveUsers() {
        try {
            Vector<UserImpl> usersVector = new Vector<UserImpl>(this.users.size());
            Set usernames = this.users.keySet();
            Iterator i = usernames.iterator();
            while (i.hasNext()) {
                UserImpl decodeUser = (UserImpl)this.users.get(i.next());
                String username = decodeUser.getUsername();
                String password = UserImpl.getCodePassword(UserManagerImpl.getFileCodecKey(), decodeUser.getPassword());
                UserImpl codeUser = new UserImpl(username, password, false);
                usersVector.addElement(codeUser);
            }
            DataMgr.getInstance().setToFile("users.dat", usersVector);
        }
        catch (RemoteException re) {
            logger.error(re.getMessage(), re);
        }
        catch (SrCommunicationException sce) {
            logger.error(sce.getMessage(), sce);
        }
    }

    private void loadUsers() throws RemoteException {
        try {
            Vector usersVector = (Vector)DataMgr.getInstance().loadFromFile("users.dat");
            if (usersVector != null) {
                this.users = new HashMap(usersVector.size());
                Enumeration e = usersVector.elements();
                while (e.hasMoreElements()) {
                    UserImpl codeUser = (UserImpl)e.nextElement();
                    String password = UserImpl.getDecodePassword(UserManagerImpl.getFileCodecKey(), codeUser.getPassword());
                    UserImpl decodeUser = new UserImpl(codeUser.getUsername(), password, false);
                    decodeUser.addUserListener(this);
                    this.users.put(decodeUser.getUsername(), decodeUser);
                }
            }
        }
        catch (InvalidClassException ice) {
            logger.debug("Users file is not valid.", ice);
        }
        catch (SrCommunicationException sce) {
            logger.debug(sce.getMessage(), sce);
        }
    }

    public void checkConnectivity() throws RemoteException {
    }

    public SystemRoot getSystemRoot() throws RemoteException {
        return SystemRootImpl.getInstance();
    }

    public EventService getEventService() throws RemoteException {
        return EventServiceImpl.getInstance();
    }

    public AlarmMgr getAlarmMgr() throws RemoteException {
        return AlarmMgrImpl.getInstance();
    }

    public AlarmMgr getDrAlarmMgr() throws RemoteException {
        return DrAlarmMgrImpl.getInstance();
    }

    public String toString() {
        return "UserManager";
    }

    static {
        DEFAULT_USER = DEFAULT_USER == null || DEFAULT_USER.equals("") ? "sanrad" : DEFAULT_USER;
        DEFAULT_PASSWORD = UserImpl.getCodePassword(DEFAULT_USER);
        theInstance = null;
    }
}

