/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.user;

import com.sanrad.log.Log;
import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.user.User;
import com.sanrad.nms.server.user.UserEvent;
import com.sanrad.nms.server.user.UserListener;
import com.sanrad.nms.server.user.UserManagerImpl;
import com.sanrad.security.StringCodec;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Enumeration;
import java.util.Vector;

public class UserImpl
extends UnicastRemoteObject
implements User {
    private String username;
    private String password;
    private Vector listeners = new Vector();
    private static Log logger = LogMgr.getServerLog();

    public UserImpl(String username, String password) throws RemoteException {
        this(username, password, true);
    }

    public UserImpl(String username, String password, boolean decrypt) throws RemoteException {
        this.username = username;
        if (decrypt) {
            this.setPassword(password);
        } else {
            this.password = password;
        }
    }

    public static String getCodecKey() {
        String codecKey = ErrorMessage.ALIAS_ALREADY_IN_USE.getMessage(UserManagerImpl.DEFAULT_USER);
        return codecKey;
    }

    public static String getCodePassword(String codeKey, String password) {
        return StringCodec.encryptString(codeKey, password);
    }

    public static String getCodePassword(String password) {
        return UserImpl.getCodePassword(UserImpl.getCodecKey(), password);
    }

    public static String getDecodePassword(String codeKey, String password) {
        return StringCodec.decryptString(codeKey, password);
    }

    public static String getDecodePassword(String password) {
        return UserImpl.getDecodePassword(UserImpl.getCodecKey(), password);
    }

    public void changePassword(String oldPassword, String newPassword) throws RemoteException, IllegalValueException {
        String decodeNewPassword = UserImpl.getDecodePassword(newPassword);
        String decodeOldPassword = UserImpl.getDecodePassword(oldPassword);
        if (!decodeOldPassword.equals(this.password)) {
            String msg = "User " + this.username + ": wrong password.";
            logger.debug(msg);
            throw new IllegalValueException(msg);
        }
        if (decodeOldPassword.equals(decodeNewPassword)) {
            String msg = "User " + this.username + ": new password should be different from old password.";
            logger.debug(msg);
            throw new IllegalValueException(msg);
        }
        this.setPassword(newPassword);
        this.fireUserChanged();
    }

    private void setPassword(String password) throws RemoteException {
        this.password = UserImpl.getDecodePassword(password);
    }

    public void addUserListener(UserListener listener) {
        this.listeners.addElement(listener);
    }

    public void removeUserListener(UserListener listener) {
        this.listeners.removeElement(listener);
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() throws RemoteException {
        return this.username;
    }

    private void fireUserChanged() {
        UserEvent event = new UserEvent(this);
        Enumeration e = this.listeners.elements();
        while (e.hasMoreElements()) {
            ((UserListener)e.nextElement()).userChanged(event);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof UserImpl) {
            String objUsername = ((UserImpl)obj).username;
            String objPassword = ((UserImpl)obj).password;
            return objUsername.equals(this.username) && objPassword.equals(this.password);
        }
        return false;
    }
}

