/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.volume;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.comm.CommItem;
import com.sanrad.nms.server.comm.CommMgr;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.comm.snmp.trap.SrTrap;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.exception.SrElementOperationException;
import com.sanrad.nms.server.mgr.CheckListConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementDataList;
import com.sanrad.nms.server.mgr.DataMgr;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.mgr.discover.DiscoverMgr;
import com.sanrad.nms.server.mgr.volume.MirrVolConfigElementData;
import com.sanrad.nms.server.mgr.volume.MirrorVolumeSyncConfigurator;
import com.sanrad.nms.server.mgr.volume.VolumeConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.SrTimeTicks;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.VolumeOperationAdminStatusConstant;
import com.sanrad.nms.server.util.types.constants.VolumeOperationOperStatusConstant;
import com.sanrad.nms.server.util.types.constants.VolumeOperationType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class VolumeOperationConfigurator
extends ElementConfigurator {
    static Integer[] lastOperIndex = new Integer[0];
    private static final List copyOperAdminStatusList = new ArrayList();

    public VolumeOperationConfigurator() {
        super(ClassID.COPY_OPERATION, "srVirtVolOperTable", MibItem.VOLUME_OPERATION_RS, MibItem.VOLUME_OPERATION_TBL_LAST_UPDATE);
    }

    public HashMap getListOfParams() {
        HashMap<ParameterCode, Object> paramList = new HashMap<ParameterCode, Object>(5);
        paramList.put(ParameterCode.VOLUME_OPERATION_ADMIN_STATUS, null);
        paramList.put(ParameterCode.VOLUME_OPERATION_DST, null);
        paramList.put(ParameterCode.VOLUME_OPERATION_OPER_STATUS, null);
        paramList.put(ParameterCode.VOLUME_OPERATION_PERCENTAGE_COPIED, null);
        paramList.put(ParameterCode.VOLUME_OPERATION_SRC, null);
        return paramList;
    }

    private synchronized void setOperIndex(Integer operIndex, char agentIndex) {
        if (lastOperIndex.length <= agentIndex) {
            Integer[] newArray = new Integer[agentIndex + '\u0001'];
            System.arraycopy(lastOperIndex, 0, newArray, 0, lastOperIndex.length);
            newArray[agentIndex] = operIndex;
            lastOperIndex = newArray;
        } else if (lastOperIndex[agentIndex] == null || operIndex > lastOperIndex[agentIndex]) {
            VolumeOperationConfigurator.lastOperIndex[agentIndex] = operIndex;
        }
    }

    private synchronized int getNextOperIndex(char agentIndex) throws SrCommunicationException {
        if (lastOperIndex.length <= agentIndex) {
            Integer[] newArray = new Integer[agentIndex + '\u0001'];
            System.arraycopy(lastOperIndex, 0, newArray, 0, lastOperIndex.length);
            lastOperIndex = newArray;
        }
        VolumeOperationConfigurator.lastOperIndex[agentIndex] = new Integer(0);
        this.getAllAndRemoveIfNeed(agentIndex, false);
        Integer lastIndex = lastOperIndex[agentIndex];
        return lastIndex + 1;
    }

    public ConfigElementDataList getAll(char agentIndex, SrTimeTicks lastUpdate, CheckListConfigElementData allCommKeysList) throws SrCommunicationException {
        return this.getAllAndRemoveIfNeed(agentIndex, true);
    }

    public ConfigElementDataList getAllAndRemoveIfNeed(char agentIndex, boolean removeIfNeed) throws SrCommunicationException {
        CommVarBindList[] table = CommMgr.getInstance(agentIndex).getAll(this.myTableName, agentIndex);
        if (table != null) {
            ConfigElementDataList tableOfElements = new ConfigElementDataList();
            int numOfRows = table.length;
            for (int i = 0; i < numOfRows; ++i) {
                ConfigElementData element = this.createConfigElementFromTableRow(table[i], agentIndex);
                if (element == null) continue;
                Object operType = element.getValue(ParameterCode.VOLUME_OPERATION_ADMIN_STATUS);
                if (operType == VolumeOperationAdminStatusConstant.VOLUME_OPERATION_ADMIN_STATUS_ABORT_COPY || operType == VolumeOperationAdminStatusConstant.VOLUME_OPERATION_ADMIN_STATUS_COPY_VOLUME || operType == VolumeOperationAdminStatusConstant.VOLUME_OPERATION_ADMIN_STATUS_RESTORE || operType == VolumeOperationAdminStatusConstant.VOLUME_OPERATION_ADMIN_STATUS_ABORT_RESTORE) {
                    tableOfElements.add(element);
                    continue;
                }
                if (!removeIfNeed) continue;
                this.internalRemove(element);
            }
            return tableOfElements;
        }
        return null;
    }

    public void discover(CommKeyClassId vSwitchData) throws SrCommunicationException {
        ConfigElementDataList elementsList = this.getAllExtended(vSwitchData.getMyFirstSnmpAgentIndex(), null, null);
        this.sendDiscoveredElementsToEventMgr(elementsList, vSwitchData);
    }

    public ConfigElementDataList getAllExtended(char snmpAgentIndex, SrTimeTicks lastUpdate, CheckListConfigElementData checkListElement) throws SrCommunicationException {
        ConfigElementDataList elementsList = this.getAll(snmpAgentIndex, lastUpdate, checkListElement);
        if (elementsList != null) {
            Iterator itr = elementsList.iterator();
            while (itr.hasNext()) {
                ConfigElementData copyOper = (ConfigElementData)itr.next();
                CommKeyClassId src = (CommKeyClassId)copyOper.getValue(ParameterCode.VOLUME_OPERATION_SRC);
                CommKeyClassId dst = (CommKeyClassId)copyOper.getValue(ParameterCode.VOLUME_OPERATION_DST);
                VolumeOperationOperStatusConstant copyOperStatus = (VolumeOperationOperStatusConstant)copyOper.getValue(ParameterCode.VOLUME_OPERATION_OPER_STATUS);
                boolean isOperOperatingOrWaiting = copyOperStatus.equals(VolumeOperationOperStatusConstant.VOLUME_OPERATION_OPER_OPERATING) || copyOperStatus.equals(VolumeOperationOperStatusConstant.VOLUME_OPERATION_WAITING);
                VolumeOperationAdminStatusConstant adminStatus = (VolumeOperationAdminStatusConstant)copyOper.getValue(ParameterCode.VOLUME_OPERATION_ADMIN_STATUS);
                boolean isOperAbortedAndEndedOk = adminStatus.equals(VolumeOperationAdminStatusConstant.VOLUME_OPERATION_ADMIN_STATUS_ABORT_COPY) && copyOperStatus.equals(VolumeOperationOperStatusConstant.VOLUME_OPERATION_OPER_END_OK);
                char agentIndex = copyOper.getSnmpAgentFromParameter();
                if (src != null && src.getClassID().isStorage() && (isOperOperatingOrWaiting || isOperAbortedAndEndedOk)) {
                    DiscoverMgr.getInstance().addVolumeToInvolvedList(src, agentIndex);
                }
                if (dst != null && dst.getClassID().isStorage() && (isOperOperatingOrWaiting || isOperAbortedAndEndedOk)) {
                    DiscoverMgr.getInstance().addVolumeToInvolvedList(dst, agentIndex);
                }
                if (copyOperAdminStatusList.contains(adminStatus)) continue;
                itr.remove();
            }
            MirrorVolumeSyncConfigurator mirrSyncConfig = new MirrorVolumeSyncConfigurator();
            elementsList.addAll((Collection)mirrSyncConfig.getAllExtended(snmpAgentIndex, lastUpdate, checkListElement));
        }
        return elementsList;
    }

    protected void readDiscoverPostOperation(ConfigElementData element, CommVarBindList list) throws SrCommunicationException {
        SrType srcVolId;
        String key = element.getSnmpKey().toString();
        int index = key.indexOf(".");
        if (index > -1) {
            logger.warning("readDiscoverPostOperation of VolumeOperationConfigurator - snmp key is not a number! key is: " + key);
            key = key.substring(index + 1);
            logger.warning("readDiscoverPostOperation of VolumeOperationConfigurator - snmp key is not a number! manipulated key is: " + key);
        }
        Integer operIndex = new Integer(key);
        char agentIndex = element.getMyFirstSnmpAgentIndex();
        this.setOperIndex(operIndex, agentIndex);
        VolumeOperationAdminStatusConstant adminStat = (VolumeOperationAdminStatusConstant)list.getValue(ParameterCode.VOLUME_OPERATION_ADMIN_STATUS);
        if (adminStat == null) {
            adminStat = (VolumeOperationAdminStatusConstant)element.getValue(ParameterCode.VOLUME_OPERATION_ADMIN_STATUS);
        }
        VolumeOperationType operType = null;
        if (adminStat != null) {
            operType = this.getVolOperFromAdminStat(adminStat);
            element.setValue(ParameterCode.COPY_OPERATION_TYPE, operType);
        }
        if ((srcVolId = this.getVarBindValueFromList(list, MibItem.VOLUME_OPERATION_FROM)) != null) {
            CommKeyClassId srcVolData = DiscoverMgr.getInstance().getPhysStorOfVolId("1." + ((Object)srcVolId).toString(), list.getSnmpAgentIndex());
            if (srcVolData == null) {
                srcVolData = new CommKeyClassId(new SnmpCommKey("1." + ((Object)srcVolId).toString(), list.getSnmpAgentIndex()), ClassID.GENERAL_VOLUME);
            }
            element.setValue(ParameterCode.VOLUME_OPERATION_SRC, srcVolData);
        }
        SrType dstVolId = this.getVarBindValueFromList(list, MibItem.VOLUME_OPERATION_TO);
        if (srcVolId != null) {
            CommKeyClassId dstVolData = DiscoverMgr.getInstance().getPhysStorOfVolId("1." + ((Object)dstVolId).toString(), list.getSnmpAgentIndex());
            if (dstVolData == null) {
                dstVolData = new CommKeyClassId(new SnmpCommKey("1." + ((Object)dstVolId).toString(), list.getSnmpAgentIndex()), ClassID.GENERAL_VOLUME);
            }
            element.setValue(ParameterCode.VOLUME_OPERATION_DST, dstVolData);
        }
    }

    public void internalChange(ConfigElementData element) throws SrCommunicationException, SrElementOperationException {
        VolumeOperationType operType = (VolumeOperationType)element.getValue(ParameterCode.VOLUME_OPERATION_ADMIN_STATUS);
        if (operType.equals(VolumeOperationType.VOL_OPER_ABORT_MIRROR_SYNC) || operType.equals(VolumeOperationType.VOL_OPER_MIRROR_SYNC)) {
            element.removeParameter(ParameterCode.VOLUME_OPERATION_ADMIN_STATUS);
            MirrorVolumeSyncConfigurator mirrConfig = new MirrorVolumeSyncConfigurator();
            mirrConfig.internalChange(element);
            mirrConfig.readAfterCreate(element);
        } else if (operType.isAbortRestore()) {
            ConfigElementData readElement = new ConfigElementData(element.getCommKeyClassId());
            readElement.addParameter(new Parameter(ParameterCode.VOLUME_OPERATION_OPER_STATUS));
            this.internalReadFields(readElement);
            VolumeOperationOperStatusConstant operStatus = (VolumeOperationOperStatusConstant)readElement.getValue(ParameterCode.VOLUME_OPERATION_OPER_STATUS);
            if (operStatus != null && operStatus.isActive()) {
                element.setValue(ParameterCode.VOLUME_OPERATION_ADMIN_STATUS, this.getAdminStatFromOperType(operType));
                super.internalChange(element);
                DataMgr.getInstance().waitForDataUpdatesInVSwitches(3000L);
                this.readAfterChange(element);
            } else {
                element.removeAll();
                this.readAfterChange(readElement);
                element.addParameter(readElement.getParametersList());
            }
        } else {
            element.setValue(ParameterCode.VOLUME_OPERATION_ADMIN_STATUS, this.getAdminStatFromOperType(operType));
            super.internalChange(element);
            DataMgr.getInstance().waitForDataUpdatesInVSwitches(3000L);
            this.readAfterChange(element);
        }
        LogMgr.getServerLog().info("Operation was Changed " + operType.toString());
        SrEventHandler.getEventMgr().sendChangeElementEvent(element);
    }

    public void internalRemove(ConfigElementData element) throws SrCommunicationException {
        VolumeOperationType operType = (VolumeOperationType)element.getValue(ParameterCode.COPY_OPERATION_TYPE);
        if (operType != null) {
            if (operType.isMirrSyncOper()) {
                MirrorVolumeSyncConfigurator mirrSyncConfig = new MirrorVolumeSyncConfigurator();
                mirrSyncConfig.internalRemove(element);
                return;
            }
            if (operType.isOfflineCopy()) {
                this.removeCopyOper(element);
                return;
            }
            if (operType.isRestore()) {
                this.removeRestoreOper(element);
                return;
            }
        }
        super.internalRemove(element);
    }

    private void removeCopyOper(ConfigElementData element) throws SrCommunicationException {
        char agentIndex = element.getSnmpAgentFromParameter();
        CommKeyClassId srcVol = (CommKeyClassId)element.getValue(ParameterCode.VOLUME_OPERATION_SRC);
        CommKeyClassId dstVol = (CommKeyClassId)element.getValue(ParameterCode.VOLUME_OPERATION_DST);
        CommKeyClassId vSwitch = (CommKeyClassId)element.getValue(ParameterCode.VSWITCH_ID);
        super.internalRemove(element);
        DiscoverMgr.getInstance().removeVolumeFromInvolvedList(srcVol, agentIndex);
        DiscoverMgr.getInstance().removeVolumeFromInvolvedList(dstVol, agentIndex);
        this.removeSimpleVolumeIfNeed(srcVol, vSwitch);
        this.removeSimpleVolumeIfNeed(dstVol, vSwitch);
    }

    public void removeRestoreOper(ConfigElementData element) throws SrCommunicationException {
        char agentIndex = element.getSnmpAgentFromParameter();
        CommKeyClassId srcVol = (CommKeyClassId)element.getValue(ParameterCode.VOLUME_OPERATION_SRC);
        CommKeyClassId dstVol = (CommKeyClassId)element.getValue(ParameterCode.VOLUME_OPERATION_DST);
        CommKeyClassId vSwitch = (CommKeyClassId)element.getValue(ParameterCode.VSWITCH_ID);
        super.internalRemove(element);
        DiscoverMgr.getInstance().removeVolumeFromInvolvedList(srcVol, agentIndex);
        DiscoverMgr.getInstance().removeVolumeFromInvolvedList(dstVol, agentIndex);
    }

    private CommKeyClassId getVolumeData(CommKeyClassId volOrStorage, char agentIndex) {
        if (volOrStorage.getClassID().equals(ClassID.DIRECT_ACCESS_DEVICE) || volOrStorage.getClassID().equals(ClassID.SUB_DIRECT_ACCESS_DEVICE)) {
            String volId = DiscoverMgr.getInstance().getVolIdForPhysStor(volOrStorage, agentIndex);
            if (volId == null) {
                return null;
            }
            if (volId.indexOf(".") < 0) {
                volId = "1." + volId;
            }
            return new CommKeyClassId(new SnmpCommKey(volId, agentIndex), ClassID.GENERAL_VOLUME);
        }
        return CommKeyUtil.getSpecificCommKeyClassId(volOrStorage, agentIndex);
    }

    public void internalCreate(ConfigElementData element) throws SrCommunicationException, SrElementOperationException {
        Object operType = element.getValue(ParameterCode.VOLUME_OPERATION_ADMIN_STATUS);
        if (operType.equals(VolumeOperationType.VOL_OPER_ABORT_MIRROR_SYNC) || operType.equals(VolumeOperationType.VOL_OPER_MIRROR_SYNC)) {
            MirrorVolumeSyncConfigurator mirrSyncConfig = new MirrorVolumeSyncConfigurator();
            element.removeParameter(ParameterCode.VOLUME_OPERATION_ADMIN_STATUS);
            mirrSyncConfig.internalCreate(element);
            return;
        }
        char agentIndex = element.getSnmpAgentFromParameter();
        Integer newIndex = new Integer(this.getNextOperIndex(agentIndex));
        element.setCommKey(new SnmpCommKey(newIndex.toString(), agentIndex));
        CommKeyClassId src = (CommKeyClassId)element.getValue(ParameterCode.VOLUME_OPERATION_SRC);
        CommKeyClassId dst = (CommKeyClassId)element.getValue(ParameterCode.VOLUME_OPERATION_DST);
        CommKeyClassId vSwitch = (CommKeyClassId)element.getValue(ParameterCode.VSWITCH_ID);
        String srcVolId = null;
        String dstVolId = null;
        boolean srcSimpleWasCreated = false;
        boolean dstSimpleWasCreated = false;
        if (src.getClassID().equals(ClassID.DIRECT_ACCESS_DEVICE) || src.getClassID().equals(ClassID.SUB_DIRECT_ACCESS_DEVICE)) {
            srcVolId = DiscoverMgr.getInstance().getVolIdForPhysStor(src, agentIndex);
            if (srcVolId == null) {
                CommKey srcCommKey = this.createSimpleVolume(src, vSwitch)[0];
                srcVolId = srcCommKey.getKey();
                srcSimpleWasCreated = true;
            }
        } else {
            srcVolId = CommKeyUtil.getSpecificSnmpKey(src, agentIndex).getKey();
        }
        if (srcVolId.indexOf(".") >= 0) {
            srcVolId = srcVolId.substring(srcVolId.indexOf(".") + 1);
        }
        element.setValue(ParameterCode.VOLUME_OPERATION_SRC, new SrInteger(srcVolId));
        if (dst != null) {
            if (dst.getClassID().equals(ClassID.DIRECT_ACCESS_DEVICE) || dst.getClassID().equals(ClassID.SUB_DIRECT_ACCESS_DEVICE)) {
                dstVolId = DiscoverMgr.getInstance().getVolIdForPhysStor(dst, agentIndex);
                if (dstVolId == null) {
                    CommKey dstCommKey = this.createSimpleVolume(dst, vSwitch)[0];
                    dstVolId = dstCommKey.getKey();
                    dstSimpleWasCreated = true;
                }
            } else {
                dstVolId = CommKeyUtil.getSpecificSnmpKey(dst, agentIndex).getKey();
            }
            if (dstVolId.indexOf(".") >= 0) {
                dstVolId = dstVolId.substring(dstVolId.indexOf(".") + 1);
            }
            element.setValue(ParameterCode.VOLUME_OPERATION_DST, new SrInteger(dstVolId));
        }
        try {
            super.internalCreate(element);
        }
        catch (SrCommunicationException e) {
            logger.debug(e);
            if (srcSimpleWasCreated) {
                this.removeSimpleVolume(srcVolId, agentIndex);
            }
            if (dstSimpleWasCreated) {
                this.removeSimpleVolume(dstVolId, agentIndex);
            }
            e.setElement(element);
            throw e;
        }
    }

    public void operate(ConfigElementData element, VolumeOperationType operType) throws SrCommunicationException, SrElementOperationException {
        element.setValue(ParameterCode.VOLUME_OPERATION_ADMIN_STATUS, operType);
        if (element.getClassId().equals(ClassID.COPY_OPERATION)) {
            element.setValue(ParameterCode.COPY_OPERATION_TYPE, operType);
            this.internalChange(element);
            return;
        }
        if (operType.equals(VolumeOperationType.VOL_OPER_ADD_MIRROR)) {
            this.addMirror(element);
        } else if (operType.equals(VolumeOperationType.VOL_OPER_ABORT_COPY)) {
            this.abortCopy(element);
        } else if (operType.equals(VolumeOperationType.VOL_OPER_BREAK_MIRROR)) {
            this.breakMirror(element);
        } else if (operType.equals(VolumeOperationType.VOL_OPER_EXPAND)) {
            this.expandVolume(element);
        } else if (operType.equals(VolumeOperationType.VOL_OPER_OFFLINE_COPY)) {
            this.offlineCopy(element);
        } else if (operType.equals(VolumeOperationType.VOL_OPER_REPLACE_VOLUME)) {
            this.replaceVolume(element);
        } else if (operType.equals(VolumeOperationType.VOL_OPER_RESIZE)) {
            this.resizeVolume(element);
        } else if (operType.equals(VolumeOperationType.VOL_OPER_RETRACT)) {
            this.retractVolume(element);
        } else if (operType.equals(VolumeOperationType.VOL_OPER_ADD_CHILD)) {
            this.addChild(element, element.getClassId());
        } else if (operType.equals(VolumeOperationType.VOL_OPER_ABORT_MIRROR_SYNC) || operType.equals(VolumeOperationType.VOL_OPER_MIRROR_SYNC)) {
            MirrorVolumeSyncConfigurator mirrSyncConfig = new MirrorVolumeSyncConfigurator();
            mirrSyncConfig.operate(element, operType);
        } else if (operType.equals(VolumeOperationType.VOL_OPER_RESTORE)) {
            this.restore(element);
        } else if (operType.equals(VolumeOperationType.VOL_OPER_ABORT_RESTORE)) {
            this.abortRestore(element);
        }
    }

    public void postOperate(ConfigElementData element, VolumeOperationType operType) throws SrCommunicationException, SrElementOperationException {
        if (operType.equals(VolumeOperationType.VOL_OPER_BREAK_MIRROR)) {
            char snmpAgent = element.getMyFirstSnmpAgentIndex();
            CommKeyClassId vswitchData = CommKeyUtil.getVSwitchData(snmpAgent);
            CheckListConfigElementData checkList = new CheckListConfigElementData(ClassID.COPY_OPERATION, new Vector());
            checkList.setValue(ParameterCode.VSWITCH_ID, vswitchData);
            MirrorVolumeSyncConfigurator mirrVolOperationConfigurator = new MirrorVolumeSyncConfigurator();
            ConfigElementDataList elements = mirrVolOperationConfigurator.refreshTable(snmpAgent, null, checkList);
            SrEventHandler.getEventMgr().sendRefreshElementEvent(elements);
            SrEventHandler.getEventMgr().sendCheckListEvent(checkList);
        } else if (operType.equals(VolumeOperationType.VOL_OPER_EXPAND) && element.getClassId().equals(ClassID.MIRROR_VOLUME)) {
            ConfigElementData newElement = new ConfigElementData(element.getCommKeyClassId());
            newElement.setValue(ParameterCode.VIRTUAL_VOLUME_ACTUAL_NUM_OF_BLOCKS, (SrType)null);
            newElement.setValue(ParameterCode.VIRTUAL_VOLUME_POTENTIAL_NUM_OF_BLOCKS, (SrType)null);
            this.internalReadFields(newElement);
            SrEventHandler.getEventMgr().sendReadElementEvent(newElement);
        }
    }

    private ConfigElementData upgradeVolume(ConfigElementData element, ClassID newVolType) throws SrCommunicationException, SrElementOperationException {
        ConfigElementData newVol;
        CommKeyClassId vSwitchData = (CommKeyClassId)element.getValue(ParameterCode.VSWITCH_ID);
        SrString newVolAlias = (SrString)element.getValue(ParameterCode.VOLUME_ALIAS);
        if (element instanceof MirrVolConfigElementData) {
            newVol = new MirrVolConfigElementData(newVolType);
            ((MirrVolConfigElementData)newVol).setAutoSync(((MirrVolConfigElementData)element).getAutoSync());
        } else {
            newVol = new ConfigElementData(newVolType);
        }
        newVol.setValue(ParameterCode.VSWITCH_ID, vSwitchData);
        newVol.setValue(ParameterCode.VOLUME_ALIAS, newVolAlias);
        ElementConfigurator volConfig = DataMgr.getElementConfigFromClassID(newVolType);
        try {
            volConfig.internalCreate(newVol);
        }
        catch (SrCommunicationException e) {
            logger.debug(e);
            e.setElement(element);
            throw e;
        }
        CommKeyClassId newVolData = new CommKeyClassId(newVol.getCommKey(), newVolType);
        CommKeyClassId oldVolData = new CommKeyClassId(element.getCommKey(), element.getClassId());
        ConfigElementData oper = new ConfigElementData(ClassID.VOLUME_OPERATION);
        oper.setValue(ParameterCode.VOLUME_OPERATION_SRC, oldVolData);
        oper.setValue(ParameterCode.VOLUME_OPERATION_DST, newVolData);
        oper.setValue(ParameterCode.VSWITCH_ID, vSwitchData);
        oper.setValue(ParameterCode.VOLUME_OPERATION_ADMIN_STATUS, VolumeOperationAdminStatusConstant.VOLUME_OPERATION_ADMIN_STATUS_UPGRADE);
        try {
            this.internalCreate(oper);
        }
        catch (SrCommunicationException e) {
            logger.debug(e);
            volConfig.internalRemove(newVol);
        }
        try {
            volConfig.readAfterCreate(newVol);
            this.internalRemove(oper);
        }
        catch (SrCommunicationException e) {
            logger.debug(e);
        }
        Parameter parentsChildren = null;
        Parameter newVolParent = null;
        CommKeyClassId parentData = (CommKeyClassId)element.getValue(ParameterCode.VIRTUAL_VOLUME_PARENT);
        if (parentData != null) {
            CommKeyClassId[] parentChildren = (CommKeyClassId[])element.getValue(ParameterCode.VIRTUAL_VOLUME_MY_PARENTS_CHILDREN);
            CommKeyClassId[] newChildrenList = new CommKeyClassId[parentChildren.length];
            for (int i = 0; i < parentChildren.length; ++i) {
                newChildrenList[i] = parentChildren[i].equals(oldVolData) ? newVolData : parentChildren[i];
            }
            parentsChildren = new Parameter(ParameterCode.VOLUME_CHILDREN, newChildrenList);
            newVolParent = new Parameter(ParameterCode.VIRTUAL_VOLUME_PARENT, parentData);
        } else {
            parentData = (CommKeyClassId)element.getValue(ParameterCode.VIRTUAL_VOLUME_LU);
            if (parentData != null) {
                parentsChildren = new Parameter(ParameterCode.LU_VOLUME_ID, newVolData);
            }
            newVolParent = new Parameter(ParameterCode.VIRTUAL_VOLUME_LU, parentData);
        }
        CommKeyClassId[] childData = new CommKeyClassId[]{oldVolData};
        newVol.addParameter(new Parameter(ParameterCode.VOLUME_CHILDREN, childData));
        newVol.addParameter(newVolParent);
        SrEventHandler.getEventMgr().sendAddElementEvent(newVol);
        ConfigElementData oldVol = new ConfigElementData(oldVolData);
        oldVol.setValue(ParameterCode.VIRTUAL_VOLUME_PARENT, newVolData);
        oldVol.setValue(ParameterCode.VSWITCH_ID, vSwitchData);
        SrEventHandler.getEventMgr().sendChangeElementEvent(oldVol);
        this.readVolumePosition(childData, newVolData);
        if (parentData != null) {
            ConfigElementData parentElement = new ConfigElementData(parentData.getCommKeys(), parentData.getClassID());
            parentElement.setValue(ParameterCode.VSWITCH_ID, vSwitchData);
            parentElement.addParameter(parentsChildren);
            SrEventHandler.getEventMgr().sendChangeElementEvent(parentElement);
        }
        LogMgr.getServerLog().info("Volume " + oldVolData.getClassID().toString() + " Was upgraded to " + newVolAlias);
        DiscoverMgr.getInstance().replaceVolInInvolvedList(oldVolData, newVolData, vSwitchData.getMyFirstSnmpAgentIndex());
        return newVol;
    }

    private void resizeVolume(ConfigElementData element) throws SrCommunicationException, SrElementOperationException {
        if (element.getClassId().equals(ClassID.CONCAT_VOLUME)) {
            this.addChild(element, ClassID.CONCAT_VOLUME);
        } else {
            this.addChild(element, ClassID.CUBE_VOLUME);
        }
    }

    private void addMirror(ConfigElementData element) throws SrCommunicationException, SrElementOperationException {
        this.addChild(element, ClassID.MIRROR_VOLUME);
    }

    private void addChild(ConfigElementData element, ClassID parentType) throws SrCommunicationException, SrElementOperationException {
        CommKeyClassId[] parentVolChildren;
        char agentIndex = element.getSnmpAgentFromParameter();
        CommKeyClassId vSwitchData = (CommKeyClassId)element.getValue(ParameterCode.VSWITCH_ID);
        CommKeyClassId parentVol = null;
        ConfigElementData parentVolElement = null;
        if (!element.getClassId().equals(parentType)) {
            parentVolElement = this.upgradeVolume(element, parentType);
            parentVol = new CommKeyClassId(parentVolElement.getCommKey(), parentVolElement.getClassId());
        } else {
            parentVol = new CommKeyClassId(element.getCommKey(), element.getClassId());
            parentVolElement = element;
        }
        CommKeyClassId newChild = (CommKeyClassId)element.getValue(ParameterCode.VOLUME_OPERATION_DST);
        ConfigElementData oper = new ConfigElementData(ClassID.VOLUME_OPERATION);
        oper.setValue(ParameterCode.VOLUME_OPERATION_SRC, parentVol);
        oper.setValue(ParameterCode.VOLUME_OPERATION_DST, newChild);
        oper.setValue(ParameterCode.VSWITCH_ID, vSwitchData);
        oper.setValue(ParameterCode.VOLUME_OPERATION_ADMIN_STATUS, VolumeOperationAdminStatusConstant.VOLUME_OPERATION_ADMIN_STATUS_ADD_CHILD);
        try {
            this.internalCreate(oper);
        }
        catch (SrCommunicationException e) {
            logger.debug(e);
            e.setElement(element);
            throw e;
        }
        try {
            this.internalRemove(oper);
        }
        catch (SrCommunicationException e) {
            logger.debug(e);
        }
        CommKeyClassId childVolData = this.getVolumeData(newChild, agentIndex);
        ConfigElementData chilVolElement = new ConfigElementData(childVolData);
        ElementConfigurator config = DataMgr.getElementConfigFromClassID(childVolData.getClassID());
        chilVolElement.addParameter(config.getListOfParams());
        chilVolElement.setValue(ParameterCode.VSWITCH_ID, vSwitchData);
        config.internalRead(chilVolElement);
        chilVolElement.setValue(ParameterCode.VIRTUAL_VOLUME_PARENT, parentVol);
        chilVolElement.setCommKeyClassId(newChild);
        SrEventHandler.getEventMgr().sendChangeElementEvent(chilVolElement);
        ConfigElementData volElement = new ConfigElementData(parentVol.getCommKeys(), parentVol.getClassID());
        volElement.setValue(ParameterCode.VSWITCH_ID, vSwitchData);
        CommKeyClassId[] parentVolNewChildrenList = parentVolChildren = (CommKeyClassId[])parentVolElement.getValue(ParameterCode.VOLUME_CHILDREN);
        boolean alreadyExist = false;
        for (int i = 0; i < parentVolChildren.length; ++i) {
            if (!newChild.equals(parentVolChildren[i])) continue;
            alreadyExist = true;
            break;
        }
        if (!alreadyExist) {
            parentVolNewChildrenList = new CommKeyClassId[parentVolChildren.length + 1];
            System.arraycopy(parentVolChildren, 0, parentVolNewChildrenList, 0, parentVolChildren.length);
            parentVolNewChildrenList[parentVolChildren.length] = newChild;
        }
        volElement.addParameter(new Parameter(ParameterCode.VOLUME_CHILDREN, parentVolNewChildrenList));
        LogMgr.getServerLog().info("Add Child:  " + newChild.getClassID().toString() + " to: " + parentVol.getClassID().toString());
        SrEventHandler.getEventMgr().sendChangeElementEvent(volElement);
        this.readVolumePosition(parentVolNewChildrenList, parentVolElement.getCommKeyClassId());
    }

    private void breakMirror(ConfigElementData element) throws SrCommunicationException, SrElementOperationException {
        this.removeChildren(element);
    }

    private void retractVolume(ConfigElementData element) throws SrCommunicationException, SrElementOperationException {
        this.removeChildren(element);
    }

    private void removeChildren(ConfigElementData element) throws SrCommunicationException, SrElementOperationException {
        CommKeyClassId parentVolData = new CommKeyClassId(element.getCommKey(), element.getClassId());
        CommKeyClassId vSwitch = (CommKeyClassId)element.getValue(ParameterCode.VSWITCH_ID);
        CommKeyClassId[] childrenToRemove = (CommKeyClassId[])element.getValue(ParameterCode.VOLUME_OPERATION_DST);
        CommKeyClassId[] allVolumeChildren = (CommKeyClassId[])element.getValue(ParameterCode.VOLUME_CHILDREN);
        List<CommKeyClassId> allVolChildren = Arrays.asList(allVolumeChildren);
        Vector<CommKeyClassId> allChildren = new Vector<CommKeyClassId>(allVolChildren);
        ConfigElementDataList childrenToRemoveElements = new ConfigElementDataList();
        for (int i = 0; i < childrenToRemove.length; ++i) {
            CommKeyClassId currentChild = childrenToRemove[i];
            allChildren.remove(currentChild);
            ConfigElementData oper = new ConfigElementData(ClassID.VOLUME_OPERATION);
            oper.setValue(ParameterCode.VOLUME_OPERATION_ADMIN_STATUS, VolumeOperationAdminStatusConstant.VOLUME_OPERATION_ADMIN_STATUS_REMOVE_CHILD);
            oper.setValue(ParameterCode.VOLUME_OPERATION_SRC, parentVolData);
            oper.setValue(ParameterCode.VOLUME_OPERATION_DST, currentChild);
            oper.setValue(ParameterCode.VSWITCH_ID, vSwitch);
            try {
                this.internalCreate(oper);
            }
            catch (SrCommunicationException e) {
                logger.debug(e);
                e.setElement(element);
                throw e;
            }
            try {
                this.internalRemove(oper);
            }
            catch (SrCommunicationException e) {
                logger.debug(e);
            }
            this.removeSimpleVolumeIfNeed(currentChild, vSwitch);
            ConfigElementData currChildElement = new ConfigElementData(currentChild);
            currChildElement.setValue(ParameterCode.VOLUME_POSITION, (SrType)null);
            currChildElement.setValue(ParameterCode.VIRTUAL_VOLUME_PARENT, (SrType)null);
            currChildElement.setValue(ParameterCode.VSWITCH_ID, vSwitch);
            childrenToRemoveElements.add(currChildElement);
        }
        ConfigElementData parentNewData = new ConfigElementData(parentVolData.getCommKeys(), parentVolData.getClassID());
        CommKeyClassId[] childrenNewList = new CommKeyClassId[allChildren.size()];
        allChildren.toArray(childrenNewList);
        parentNewData.addParameter(new Parameter(ParameterCode.VOLUME_CHILDREN, childrenNewList));
        parentNewData.setValue(ParameterCode.VSWITCH_ID, vSwitch);
        SrEventHandler.getEventMgr().sendChangeElementEvent(parentNewData);
        SrEventHandler.getEventMgr().sendChangeElementEvent(childrenToRemoveElements);
        boolean elementWasRemoved = false;
        if (allChildren.size() == 1) {
            element.setValue(ParameterCode.VOLUME_CHILDREN, allChildren.get(0));
            elementWasRemoved = this.downgrade(element);
        }
        if (!elementWasRemoved) {
            this.readVolumePosition(childrenNewList, parentVolData);
        }
        LogMgr.getServerLog().info("Remove Child to:  " + parentVolData.getClassID().toString());
    }

    private boolean downgrade(ConfigElementData element) throws SrCommunicationException, SrElementOperationException {
        boolean wasRemoved = false;
        CommKeyClassId lastChild = (CommKeyClassId)element.getValue(ParameterCode.VOLUME_CHILDREN);
        CommKeyClassId volData = new CommKeyClassId(element.getCommKey(), element.getClassId());
        CommKeyClassId vSwitch = (CommKeyClassId)element.getValue(ParameterCode.VSWITCH_ID);
        ConfigElementData downgrade = new ConfigElementData(ClassID.VOLUME_OPERATION);
        downgrade.setValue(ParameterCode.VOLUME_OPERATION_ADMIN_STATUS, VolumeOperationAdminStatusConstant.VOLUME_OPERATION_ADMIN_STATUS_DOWNGRADE);
        downgrade.setValue(ParameterCode.VSWITCH_ID, vSwitch);
        downgrade.setValue(ParameterCode.VOLUME_OPERATION_SRC, lastChild);
        downgrade.setValue(ParameterCode.VOLUME_OPERATION_DST, volData);
        try {
            this.internalCreate(downgrade);
        }
        catch (SrCommunicationException e) {
            logger.debug(e);
            e.setElement(element);
            throw e;
        }
        try {
            this.internalRemove(downgrade);
        }
        catch (SrCommunicationException e) {
            logger.debug(e);
        }
        Parameter parentsChildren = null;
        Parameter lastChildNewParent = new Parameter(ParameterCode.LU_VOLUME_ID, null);
        CommKeyClassId parentData = (CommKeyClassId)element.getValue(ParameterCode.VIRTUAL_VOLUME_PARENT);
        if (parentData != null) {
            CommKeyClassId[] parentChildren = (CommKeyClassId[])element.getValue(ParameterCode.VIRTUAL_VOLUME_MY_PARENTS_CHILDREN);
            CommKeyClassId[] newChildrenList = new CommKeyClassId[parentChildren.length];
            for (int i = 0; i < parentChildren.length; ++i) {
                newChildrenList[i] = parentChildren[i].equals(volData) ? lastChild : parentChildren[i];
            }
            parentsChildren = new Parameter(ParameterCode.VOLUME_CHILDREN, newChildrenList);
            lastChildNewParent = new Parameter(ParameterCode.VIRTUAL_VOLUME_PARENT, parentData);
        } else {
            parentData = (CommKeyClassId)element.getValue(ParameterCode.VIRTUAL_VOLUME_LU);
            if (parentData != null) {
                parentsChildren = new Parameter(ParameterCode.LU_VOLUME_ID, lastChild);
                lastChildNewParent = new Parameter(ParameterCode.VIRTUAL_VOLUME_LU, parentData);
            }
        }
        DiscoverMgr.getInstance().replaceVolInInvolvedList(volData, lastChild, vSwitch.getMyFirstSnmpAgentIndex());
        ConfigElementData lastChildElement = new ConfigElementData(lastChild);
        lastChildElement.setValue(ParameterCode.VSWITCH_ID, vSwitch);
        if (parentData != null) {
            ConfigElementData parentElement = new ConfigElementData(parentData.getCommKeys(), parentData.getClassID());
            parentElement.setValue(ParameterCode.VSWITCH_ID, vSwitch);
            parentElement.addParameter(parentsChildren);
            SrEventHandler.getEventMgr().sendChangeElementEvent(parentElement);
            lastChildElement.addParameter(lastChildNewParent);
        } else {
            lastChildElement.setValue(ParameterCode.VIRTUAL_VOLUME_LU, (SrType)null);
            lastChildElement.setValue(ParameterCode.VIRTUAL_VOLUME_PARENT, (SrType)null);
            wasRemoved = this.removeSimpleVolumeIfNeed(lastChild, vSwitch);
        }
        SrEventHandler.getEventMgr().sendChangeElementEvent(lastChildElement);
        SrEventHandler.getEventMgr().sendRemoveElementEvent(element);
        LogMgr.getServerLog().info("Downgrade from:  " + volData.getClassID().toString() + "to: " + lastChild.getClassID().toString());
        return wasRemoved;
    }

    private void replaceVolume(ConfigElementData element) throws SrCommunicationException, SrElementOperationException {
        CommKeyClassId volParent;
        char snmpAgentIndex = element.getMyFirstSnmpAgentIndex();
        CommKeyClassId oldVol = new CommKeyClassId(element.getCommKey(), element.getClassId());
        CommKeyClassId newVol = (CommKeyClassId)element.getValue(ParameterCode.VOLUME_OPERATION_DST);
        CommKeyClassId vSwitchData = (CommKeyClassId)element.getValue(ParameterCode.VSWITCH_ID);
        ConfigElementData operation = new ConfigElementData(ClassID.VOLUME_OPERATION);
        operation.setValue(ParameterCode.VOLUME_OPERATION_SRC, oldVol);
        operation.setValue(ParameterCode.VOLUME_OPERATION_DST, newVol);
        operation.setValue(ParameterCode.VSWITCH_ID, vSwitchData);
        operation.setValue(ParameterCode.VOLUME_OPERATION_ADMIN_STATUS, VolumeOperationAdminStatusConstant.VOLUME_OPERATION_ADMIN_STATUS_REPLACE_VOLUME);
        try {
            this.internalCreate(operation);
        }
        catch (SrCommunicationException e) {
            e.setElement(element);
            throw e;
        }
        try {
            this.internalRemove(operation);
        }
        catch (SrCommunicationException e) {
            logger.debug(e);
        }
        if (oldVol.getClassID().equals(ClassID.DIRECT_ACCESS_DEVICE) || oldVol.getClassID().equals(ClassID.SUB_DIRECT_ACCESS_DEVICE)) {
            SrInteger oldVolId = (SrInteger)operation.getValue(ParameterCode.VOLUME_OPERATION_SRC);
            this.removeSimpleVolume(oldVolId.toString(), snmpAgentIndex);
        }
        if ((volParent = (CommKeyClassId)element.getValue(ParameterCode.VIRTUAL_VOLUME_PARENT)) == null) {
            throw new UnsupportedOperationException("Replace volume is Not supported to a head of volume's tree");
        }
        volParent = CommKeyUtil.getSpecificCommKeyClassId(volParent, snmpAgentIndex);
        ConfigElementData parent = new ConfigElementData(volParent);
        CommKeyClassId[] parentChildrenList = (CommKeyClassId[])element.getValue(ParameterCode.VIRTUAL_VOLUME_MY_PARENTS_CHILDREN);
        SrType[] newParentChildrenList = new CommKeyClassId[parentChildrenList.length];
        for (int i = 0; i < parentChildrenList.length; ++i) {
            newParentChildrenList[i] = oldVol.equals(parentChildrenList[i]) ? newVol : parentChildrenList[i];
        }
        parent.setValue(ParameterCode.VSWITCH_ID, vSwitchData);
        parent.setValues(ParameterCode.VOLUME_CHILDREN, newParentChildrenList);
        SrEventHandler.getEventMgr().sendChangeElementEvent(parent);
        ConfigElementData oldChildElement = new ConfigElementData(oldVol);
        oldChildElement.setValue(ParameterCode.VSWITCH_ID, vSwitchData);
        oldChildElement.setValue(ParameterCode.VIRTUAL_VOLUME_PARENT, (SrType)null);
        oldChildElement.setValue(ParameterCode.VOLUME_POSITION, (SrType)null);
        SrEventHandler.getEventMgr().sendChangeElementEvent(oldChildElement);
        ConfigElementData newChildElement = new ConfigElementData(newVol);
        newChildElement.setValue(ParameterCode.VSWITCH_ID, vSwitchData);
        newChildElement.setValue(ParameterCode.VIRTUAL_VOLUME_PARENT, volParent);
        SrEventHandler.getEventMgr().sendChangeElementEvent(newChildElement);
        CommKeyClassId[] newChildData = new CommKeyClassId[]{newVol};
        this.readVolumePosition(newChildData, volParent);
    }

    private void offlineCopy(ConfigElementData element) throws SrCommunicationException, SrElementOperationException {
        element.setClassId(ClassID.COPY_OPERATION);
        element.setCommKeys(null);
        element.setValue(ParameterCode.VOLUME_OPERATION_ADMIN_STATUS, VolumeOperationAdminStatusConstant.VOLUME_OPERATION_ADMIN_STATUS_COPY_VOLUME);
        this.internalCreate(element);
        this.readAfterCreate(element);
        CommKeyClassId src = (CommKeyClassId)element.getValue(ParameterCode.VOLUME_OPERATION_SRC);
        CommKeyClassId dst = (CommKeyClassId)element.getValue(ParameterCode.VOLUME_OPERATION_DST);
        char agentIndex = element.getSnmpAgentFromParameter();
        if (src != null && src.getClassID().isStorage()) {
            DiscoverMgr.getInstance().addVolumeToInvolvedList(src, agentIndex);
        }
        if (dst != null && dst.getClassID().isStorage()) {
            DiscoverMgr.getInstance().addVolumeToInvolvedList(dst, agentIndex);
        }
        SrEventHandler.getEventMgr().sendAddElementEvent(element);
    }

    private void restore(ConfigElementData element) throws SrCommunicationException, SrElementOperationException {
        element.setClassId(ClassID.COPY_OPERATION);
        element.setCommKeys(null);
        element.setValue(ParameterCode.VOLUME_OPERATION_ADMIN_STATUS, VolumeOperationAdminStatusConstant.VOLUME_OPERATION_ADMIN_STATUS_RESTORE);
        this.internalCreate(element);
        DataMgr.getInstance().waitForDataUpdatesInVSwitches(3000L);
        this.readAfterCreate(element);
        CommKeyClassId dst = (CommKeyClassId)element.getValue(ParameterCode.VOLUME_OPERATION_DST);
        char agentIndex = element.getSnmpAgentFromParameter();
        if (dst != null && dst.getClassID().isStorage()) {
            DiscoverMgr.getInstance().addVolumeToInvolvedList(dst, agentIndex);
        }
        SrEventHandler.getEventMgr().sendAddElementEvent(element);
    }

    private void abortCopy(ConfigElementData element) {
    }

    private void abortRestore(ConfigElementData element) {
    }

    private void expandVolume(ConfigElementData element) throws SrCommunicationException, SrElementOperationException {
        ConfigElementData oper = new ConfigElementData(ClassID.VOLUME_OPERATION);
        oper.setValue(ParameterCode.VSWITCH_ID, (SrType)element.getValue(ParameterCode.VSWITCH_ID));
        CommKeyClassId srcData = new CommKeyClassId(element.getCommKey(), element.getClassId());
        oper.setValue(ParameterCode.VOLUME_OPERATION_SRC, srcData);
        oper.setValue(ParameterCode.VOLUME_OPERATION_ADMIN_STATUS, VolumeOperationAdminStatusConstant.VOLUME_OPERATION_ADMIN_STATUS_EXPAND_VOLUME);
        try {
            this.internalCreate(oper);
        }
        catch (SrCommunicationException ex) {
            logger.debug(ex);
            ex.setElement(element);
            throw ex;
        }
        try {
            this.internalRemove(oper);
        }
        catch (SrCommunicationException e) {
            e.printStackTrace();
        }
    }

    protected CommItem getCommItemForTrapCommKey(SrTrap trap) {
        switch (trap.getTrapType().getTrapId()) {
            case 5: {
                return MibItem.VOLUME_OPERATION_OPER_STATUS;
            }
            case 4: {
                return MibItem.VIRTUAL_VOLUME_MIRROR_SYNC_OPER_STATUS;
            }
        }
        throw new UnsupportedOperationException("Operation not supported for trap " + trap.toString());
    }

    protected void trapProccessingPostOperation(ConfigElementData element, SrTrap trap) {
        switch (trap.getTrapType().getTrapId()) {
            case 4: 
            case 5: {
                element.setClassId(ClassID.COPY_OPERATION);
                try {
                    this.readDiscoverPostOperation(element, trap.getVarBindList());
                }
                catch (SrCommunicationException e) {
                    LogMgr.getServerLog().warning(e);
                    return;
                }
                LogMgr.getServerLog().debug("Changed by Trap for " + element.getClassId().toString() + " CommKey is: " + CommKeyUtil.getKeyForMessage(element.getCommKey()));
                SrEventHandler.getEventMgr().sendChangeElementEvent(element);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Operation not supported for trap ID " + trap.getTrapType().getTrapId());
            }
        }
    }

    private VolumeOperationAdminStatusConstant getAdminStatFromOperType(VolumeOperationType operType) {
        VolumeOperationAdminStatusConstant val = null;
        if (operType.equals(VolumeOperationType.VOL_OPER_ABORT_COPY)) {
            val = VolumeOperationAdminStatusConstant.VOLUME_OPERATION_ADMIN_STATUS_ABORT_COPY;
        } else if (operType.equals(VolumeOperationType.VOL_OPER_ADD_MIRROR)) {
            val = VolumeOperationAdminStatusConstant.VOLUME_OPERATION_ADMIN_STATUS_ADD_CHILD;
        } else if (operType.equals(VolumeOperationType.VOL_OPER_BREAK_MIRROR)) {
            val = VolumeOperationAdminStatusConstant.VOLUME_OPERATION_ADMIN_STATUS_REMOVE_CHILD;
        } else if (operType.equals(VolumeOperationType.VOL_OPER_EXPAND)) {
            val = VolumeOperationAdminStatusConstant.VOLUME_OPERATION_ADMIN_STATUS_EXPAND_VOLUME;
        } else if (operType.equals(VolumeOperationType.VOL_OPER_OFFLINE_COPY)) {
            val = VolumeOperationAdminStatusConstant.VOLUME_OPERATION_ADMIN_STATUS_COPY_VOLUME;
        } else if (operType.equals(VolumeOperationType.VOL_OPER_REPLACE_VOLUME)) {
            val = VolumeOperationAdminStatusConstant.VOLUME_OPERATION_ADMIN_STATUS_REPLACE_VOLUME;
        } else if (operType.equals(VolumeOperationType.VOL_OPER_RESTORE)) {
            val = VolumeOperationAdminStatusConstant.VOLUME_OPERATION_ADMIN_STATUS_RESTORE;
        } else if (operType.equals(VolumeOperationType.VOL_OPER_ABORT_RESTORE)) {
            val = VolumeOperationAdminStatusConstant.VOLUME_OPERATION_ADMIN_STATUS_ABORT_RESTORE;
        }
        return val;
    }

    private VolumeOperationType getVolOperFromAdminStat(VolumeOperationAdminStatusConstant adminStat) {
        if (adminStat == null) {
            return null;
        }
        if (adminStat.equals(VolumeOperationAdminStatusConstant.VOLUME_OPERATION_ADMIN_STATUS_COPY_VOLUME)) {
            return VolumeOperationType.VOL_OPER_OFFLINE_COPY;
        }
        if (adminStat.equals(VolumeOperationAdminStatusConstant.VOLUME_OPERATION_ADMIN_STATUS_ABORT_COPY)) {
            return VolumeOperationType.VOL_OPER_ABORT_COPY;
        }
        if (adminStat.equals(VolumeOperationAdminStatusConstant.VOLUME_OPERATION_ADMIN_STATUS_IDLE)) {
            return VolumeOperationType.VOL_OPER_NONE;
        }
        if (adminStat.equals(VolumeOperationAdminStatusConstant.VOLUME_OPERATION_ADMIN_STATUS_RESTORE)) {
            return VolumeOperationType.VOL_OPER_RESTORE;
        }
        if (adminStat.equals(VolumeOperationAdminStatusConstant.VOLUME_OPERATION_ADMIN_STATUS_ABORT_RESTORE)) {
            return VolumeOperationType.VOL_OPER_ABORT_RESTORE;
        }
        return null;
    }

    public ConfigElementDataList refreshTableFields(ConfigElementData fieldsData) throws SrCommunicationException {
        MirrorVolumeSyncConfigurator mirrSyncConfig = new MirrorVolumeSyncConfigurator();
        ConfigElementDataList mirrSyncData = mirrSyncConfig.refreshTableFields(fieldsData);
        ConfigElementDataList tableOfElements = super.refreshTableFields(fieldsData);
        tableOfElements.addAll((Collection)mirrSyncData);
        return tableOfElements;
    }

    public void postCreateOperation(ConfigElementData element) throws SrCommunicationException {
        VolumeOperationAdminStatusConstant adminStatus = (VolumeOperationAdminStatusConstant)element.getValue(ParameterCode.VOLUME_OPERATION_ADMIN_STATUS);
        if (adminStatus != null) {
            VolumeConfigurator volumeConfigurator = new VolumeConfigurator();
            VolumeOperationType operType = this.getVolOperFromAdminStat(adminStatus);
            if (operType.isRestore()) {
                CommKeyClassId src = (CommKeyClassId)element.getValue(ParameterCode.VOLUME_OPERATION_SRC);
                ConfigElementData srcVolumeElement = new ConfigElementData(src);
                volumeConfigurator.internalRead(srcVolumeElement);
                CommKeyClassId dst = (CommKeyClassId)element.getValue(ParameterCode.VOLUME_OPERATION_DST);
                ConfigElementData dstVolumeElement = new ConfigElementData(dst);
                volumeConfigurator.internalRead(dstVolumeElement);
                ConfigElementDataList list = new ConfigElementDataList();
                list.addElement(srcVolumeElement);
                list.addElement(dstVolumeElement);
                SrEventHandler.getEventMgr().sendRefreshElementEvent(element);
            }
        }
    }

    public ConfigElementDataList refreshTable(char snmpAgentIndex, SrTimeTicks lastUpdate, CheckListConfigElementData checkListElement) throws SrCommunicationException {
        ConfigElementDataList elements = this.getAllExtended(snmpAgentIndex, lastUpdate, checkListElement);
        if (checkListElement == null) {
            checkListElement = new CheckListConfigElementData(ClassID.COPY_OPERATION);
        }
        this.buildCheckListElement(elements, checkListElement, snmpAgentIndex, null);
        checkListElement.setCheckList(elements.getAllCommkeyClassIDsInList());
        SrEventHandler.getEventMgr().sendRefreshElementEvent(elements);
        SrEventHandler.getEventMgr().sendCheckListEvent(checkListElement);
        return elements;
    }

    static {
        copyOperAdminStatusList.add(VolumeOperationAdminStatusConstant.VOLUME_OPERATION_ADMIN_STATUS_ABORT_COPY);
        copyOperAdminStatusList.add(VolumeOperationAdminStatusConstant.VOLUME_OPERATION_ADMIN_STATUS_COPY_VOLUME);
    }
}

