/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.volume;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.comm.CommItem;
import com.sanrad.nms.server.comm.CommMgr;
import com.sanrad.nms.server.comm.CommVarBind;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.comm.snmp.SrOid;
import com.sanrad.nms.server.comm.snmp.SrSnmpVarBind;
import com.sanrad.nms.server.comm.snmp.trap.SrTrap;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.exception.SrElementOperationException;
import com.sanrad.nms.server.mgr.CheckListConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementDataList;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.mgr.discover.DiscoverMgr;
import com.sanrad.nms.server.mgr.volume.JournalVolumeConfigurator;
import com.sanrad.nms.server.mgr.volume.SnapshotVolConfigElementData;
import com.sanrad.nms.server.mgr.volume.SnapshotVolumeConfigurator;
import com.sanrad.nms.server.mgr.volume.StripeVolumeConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.SrGauge;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrTimeTicks;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.BlockSizeConstant;
import com.sanrad.nms.server.util.types.constants.VolumeTypeConstants;
import java.util.HashMap;
import java.util.Iterator;

public class VolumeConfigurator
extends ElementConfigurator {
    VolumeTypeConstants volumeType;

    public VolumeConfigurator() {
        super(ClassID.GENERAL_VOLUME, "srVirtVolTable", MibItem.VIRTUAL_VOLUME_RS, MibItem.VIRTUAL_VOLUME_TBL_LAST_UPDATE, true);
    }

    protected VolumeConfigurator(ClassID classId, String tableName, MibItem rs, VolumeTypeConstants volType) {
        super(classId, tableName, rs, MibItem.VIRTUAL_VOLUME_TBL_LAST_UPDATE, true);
        this.volumeType = volType;
    }

    protected VolumeConfigurator(ClassID classId, String tableName, MibItem rs, MibItem lastUpdateMib, VolumeTypeConstants volType) {
        super(classId, tableName, rs, lastUpdateMib, true);
        this.volumeType = volType;
    }

    public void internalCreate(ConfigElementData element) throws SrCommunicationException, SrElementOperationException {
        char snmpAgentIndex = element.getSnmpAgentFromParameter();
        SnmpCommKey key = null;
        if (element.getSnmpKey() == null || element.getSnmpKey().getKey().equals("0")) {
            Integer nextIndex = (Integer)this.getScalarFromComm(MibItem.VIRTUAL_VOLUME_INDEX_NEXT, snmpAgentIndex).value();
            key = new SnmpCommKey("1." + nextIndex.toString(), snmpAgentIndex);
            element.setCommKey(key);
        }
        super.internalCreate(element);
    }

    protected void addCommVarBindsToCreateList(CommVarBindList list, ConfigElementData element) {
        SnmpCommKey key = element.getSnmpKey();
        SrOid typeOid = new SrOid(MibItem.VIRTUAL_VOLUME_TYPE.toString(), key.toString());
        list.add(new SrSnmpVarBind(typeOid, (SrType)this.volumeType));
        int numOfChildren = 0;
        Object tmp = element.getValue(ParameterCode.VOLUME_CHILDREN);
        numOfChildren = this.volumeType.equals(VolumeTypeConstants.VOLUME_TYPE_SIMPLE) || this.volumeType.equals(VolumeTypeConstants.VOLUME_TYPE_TRANSPARENT) ? 0 : (tmp == null ? 1 : ((CommKeyClassId[])tmp).length);
        SrOid oid = new SrOid(MibItem.VIRTUAL_VOLUME_NUM_OF_CHILDREN.toString(), key.toString());
        SrSnmpVarBind snmpVB = new SrSnmpVarBind(oid, (SrType)new SrGauge(numOfChildren));
        list.add(snmpVB);
    }

    public HashMap getListOfParams() {
        HashMap<ParameterCode, Object> paramList = new HashMap<ParameterCode, Object>(10);
        paramList.put(ParameterCode.VOLUME_ALIAS, null);
        paramList.put(ParameterCode.VIRTUAL_VOLUME_BLOCK_SIZE, null);
        paramList.put(ParameterCode.VIRTUAL_VOLUME_ACTUAL_NUM_OF_BLOCKS, null);
        paramList.put(ParameterCode.VIRTUAL_VOLUME_POTENTIAL_NUM_OF_BLOCKS, null);
        paramList.put(ParameterCode.VOLUME_STATE, null);
        paramList.put(ParameterCode.VIRTUAL_VOLUME_TYPE, null);
        paramList.put(ParameterCode.VIRTUAL_VOLUME_LU_ID, null);
        return paramList;
    }

    protected void readDiscoverPostOperation(ConfigElementData element, CommVarBindList rowList) throws SrCommunicationException {
        SrInteger parentVolId;
        SrType volumeType = this.getVarBindValueFromList(rowList, MibItem.VIRTUAL_VOLUME_TYPE);
        if (volumeType != null) {
            ClassID volClassId = VolumeConfigurator.getClassIdFromVolumeType(volumeType);
            element.setClassId(volClassId);
        } else {
            logger.error("can't find volume type in list " + rowList + " in " + ClassID.VSWITCH + " " + element.getVswitchId() + " with commKeyClassId " + element.getCommKeyClassId());
        }
        SrInteger blockSize = (SrInteger)element.getValue(ParameterCode.DIRECT_ACCESS_DEVICE_BLOCK_SIZE);
        if (blockSize != null && blockSize.intValue() < 10) {
            SrInteger newSize = new SrInteger(BlockSizeConstant.getType(blockSize).getBlockSize());
            element.setValue(ParameterCode.DIRECT_ACCESS_DEVICE_BLOCK_SIZE, newSize);
        }
        if ((parentVolId = (SrInteger)this.getVarBindValueFromList(rowList, MibItem.VIRTUAL_VOLUME_PARENT_ID)) != null) {
            CommKeyClassId volData = new CommKeyClassId(new SnmpCommKey("1." + parentVolId.toString(), rowList.getSnmpAgentIndex()), ClassID.GENERAL_VOLUME);
            element.setValue(ParameterCode.VIRTUAL_VOLUME_PARENT, volData);
        }
        this.setVolumeChildren(element);
    }

    public static ClassID getClassIdFromVolumeType(SrType volumeType) {
        ClassID classId = null;
        if (volumeType == VolumeTypeConstants.VOLUME_TYPE_CONCAT) {
            classId = ClassID.CONCAT_VOLUME;
        } else if (volumeType == VolumeTypeConstants.VOLUME_TYPE_CUBE) {
            classId = ClassID.CUBE_VOLUME;
        } else if (volumeType == VolumeTypeConstants.VOLUME_TYPE_MIRROR) {
            classId = ClassID.MIRROR_VOLUME;
        } else if (volumeType == VolumeTypeConstants.VOLUME_TYPE_SIMPLE) {
            classId = ClassID.SIMPLE_VOLUME;
        } else if (volumeType == VolumeTypeConstants.VOLUME_TYPE_SNAPSHOT) {
            classId = ClassID.SNAPSHOT_VOLUME;
        } else if (volumeType == VolumeTypeConstants.VOLUME_TYPE_STRIPE) {
            classId = ClassID.STRIPE_VOLUME;
        } else if (volumeType == VolumeTypeConstants.VOLUME_TYPE_TRANSPARENT) {
            classId = ClassID.TRANSPARENT_VOLUME;
        } else if (volumeType == VolumeTypeConstants.VOLUME_TYPE_JOURNAL) {
            classId = ClassID.JOURNAL_VOLUME;
        } else {
            throw new UnsupportedOperationException("The volume type is not supported");
        }
        return classId;
    }

    private CommKeyClassId getPhysStorDataOrSubDiskOfVolId(String volId, char agentIndex) throws SrCommunicationException {
        SrType physStorVolId;
        String currCommKey;
        CommVarBindList rowList;
        int index;
        CommKeyClassId physStorData = null;
        CommVarBindList varBindsToGet = new CommVarBindList();
        SrOid oid = new SrOid(MibItem.PHYSICAL_STORAGE_VOL_ID.toString(), "0");
        SrSnmpVarBind varBind = new SrSnmpVarBind(oid, null);
        varBindsToGet.add(varBind);
        CommVarBindList[] physicalStorageVolIdList = CommMgr.getInstance(agentIndex).snmpGetBulk(varBindsToGet, agentIndex);
        for (index = 0; index < physicalStorageVolIdList.length; ++index) {
            rowList = physicalStorageVolIdList[index];
            currCommKey = ((CommVarBind)rowList.elementAt(0)).getIndexForCommKey();
            physStorVolId = this.getVarBindValueFromList(rowList, MibItem.PHYSICAL_STORAGE_VOL_ID);
            if (!volId.equalsIgnoreCase(physStorVolId.toString())) continue;
            physStorData = new CommKeyClassId(new SnmpCommKey(currCommKey, agentIndex), ClassID.GENERAL_PHYSICAL_STORAGE);
            break;
        }
        if (physStorData != null) {
            return physStorData;
        }
        varBindsToGet.removeAllElements();
        oid = new SrOid(MibItem.SUB_DIRECT_ACCESS_DEVICE_VOL_ID.toString(), "0");
        varBind = new SrSnmpVarBind(oid, null);
        varBindsToGet.add(varBind);
        physicalStorageVolIdList = CommMgr.getInstance(agentIndex).snmpGetBulk(varBindsToGet, agentIndex);
        for (index = 0; index < physicalStorageVolIdList.length; ++index) {
            rowList = physicalStorageVolIdList[index];
            currCommKey = ((CommVarBind)rowList.elementAt(0)).getIndexForCommKey();
            physStorVolId = this.getVarBindValueFromList(rowList, MibItem.SUB_DIRECT_ACCESS_DEVICE_VOL_ID);
            if (!volId.equalsIgnoreCase(physStorVolId.toString())) continue;
            physStorData = new CommKeyClassId(new SnmpCommKey(currCommKey, agentIndex), ClassID.SUB_DIRECT_ACCESS_DEVICE);
            break;
        }
        return physStorData;
    }

    protected void setVolumeChildren(ConfigElementData element) throws SrCommunicationException {
        ClassID classId = element.getClassId();
        char agentIndex = element.getMyFirstSnmpAgentIndex();
        SrType[] childrenData = null;
        if (classId.equals(ClassID.MIRROR_VOLUME) || classId.equals(ClassID.CONCAT_VOLUME) || classId.equals(ClassID.STRIPE_VOLUME) || classId.equals(ClassID.SNAPSHOT_VOLUME) || classId.equals(ClassID.JOURNAL_VOLUME) || classId.equals(ClassID.CUBE_VOLUME)) {
            CommVarBindList list = new CommVarBindList();
            list.add(new SrSnmpVarBind(MibItem.VIRTUAL_VOLUME_CHILDREN_RS.toString()));
            String keyPrefix = element.getSnmpKey().toString();
            CommVarBindList[] childrenList = CommMgr.getInstance(agentIndex).getListsByKeyPrefix(list, keyPrefix, agentIndex);
            childrenData = new CommKeyClassId[childrenList.length];
            for (int i = 0; i < childrenList.length; ++i) {
                String parentChildIndex = ((CommVarBind)childrenList[i].elementAt(0)).getIndexForCommKey();
                String childKey = "1." + parentChildIndex.substring(parentChildIndex.lastIndexOf(".") + 1);
                SnmpCommKey childCommKey = new SnmpCommKey(childKey, agentIndex);
                CommKeyClassId childData = DiscoverMgr.getInstance().getPhysStorOfVolId(childKey, agentIndex);
                if (childData == null) {
                    childData = new CommKeyClassId(childCommKey, ClassID.GENERAL_VOLUME);
                }
                childrenData[i] = childData;
            }
        } else if (classId.equals(ClassID.TRANSPARENT_VOLUME)) {
            CommVarBindList list = new CommVarBindList();
            list.add(new SrSnmpVarBind(MibItem.PHYSICAL_STORAGE_VOL_ID.toString()));
            CommVarBindList[] physStorVolIds = CommMgr.getInstance(agentIndex).snmpGetBulk(list, agentIndex);
            String volIdFromPrefix = element.getSnmpKey().toString();
            for (int index = 0; index < physStorVolIds.length; ++index) {
                CommVarBindList rowList = physStorVolIds[index];
                CommVarBind varBind = (CommVarBind)rowList.elementAt(0);
                String currCommKey = varBind.getIndexForCommKey();
                SrInteger volId = (SrInteger)varBind.getValue();
                String compareStr = "1." + volId.toString();
                if (!compareStr.equals(volIdFromPrefix)) continue;
                childrenData = new CommKeyClassId[]{new CommKeyClassId(new SnmpCommKey(currCommKey, agentIndex), ClassID.DIRECT_ACCESS_DEVICE)};
            }
        } else if (classId.equals(ClassID.SIMPLE_VOLUME)) {
            String volId = element.getSnmpKey().getKey();
            childrenData = new CommKeyClassId[]{DiscoverMgr.getInstance().getPhysStorOfVolId(volId, agentIndex)};
        }
        element.setValues(ParameterCode.VOLUME_CHILDREN, childrenData);
    }

    protected CommItem getCommItemForTrapCommKey(SrTrap trap) {
        switch (trap.getTrapType().getTrapId()) {
            case 3: 
            case 4: {
                return MibItem.VIRTUAL_VOLUME_TYPE;
            }
        }
        throw new UnsupportedOperationException("Operation not supported for trap " + trap.toString());
    }

    protected void trapProccessingPostOperation(ConfigElementData element, SrTrap trap) {
        try {
            this.readDiscoverPostOperation(element, trap.getVarBindList());
        }
        catch (SrCommunicationException ex) {
            LogMgr.getServerLog().debug(ex);
            throw new RuntimeException("Trap Proccessing Operation failed. " + trap.toString());
        }
        if (element.getClassId().equals(ClassID.SIMPLE_VOLUME)) {
            String volCommKey = element.getSnmpKey().getKey();
            CommKeyClassId physStorData = DiscoverMgr.getInstance().getPhysStorOfVolId(volCommKey, element.getMyFirstSnmpAgentIndex());
            if (physStorData != null) {
                element.setClassId(physStorData.getClassID());
                element.setCommKeys(physStorData.getCommKeys());
            } else {
                this.unknownElementTrapOperation(element, trap);
                return;
            }
        }
        switch (trap.getTrapType().getTrapId()) {
            case 3: 
            case 4: {
                LogMgr.getServerLog().debug("Changed by Trap for " + element.getClassId().toString() + " CommKey is: " + CommKeyUtil.getKeyForMessage(element.getCommKey()));
                SrEventHandler.getEventMgr().sendChangeElementEvent(element);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Operation not supported for trap " + trap.toString());
            }
        }
    }

    protected void addCommVarBindsToReadList(CommVarBindList list, ConfigElementData element) {
        super.addCommVarBindsToReadList(list, element);
        if (element.getSnmpKey() != null) {
            SrOid oid = null;
            oid = new SrOid(MibItem.VIRTUAL_VOLUME_STATE.toString(), element.getSnmpKey().toString());
            list.add(new SrSnmpVarBind(oid, null));
            oid = new SrOid(MibItem.VIRTUAL_VOLUME_TYPE.toString(), element.getSnmpKey().toString());
            list.add(new SrSnmpVarBind(oid, null));
            oid = new SrOid(MibItem.VIRTUAL_VOLUME_PARENT_ID.toString(), element.getSnmpKey().toString());
            list.add(new SrSnmpVarBind(oid, null));
        }
    }

    public HashMap getListOfParamsForMirror() {
        HashMap<ParameterCode, Object> paramList = new HashMap<ParameterCode, Object>(5);
        paramList.put(ParameterCode.VIRTUAL_VOLUME_MIRROR_SYNCH_ADMIN_STATUS, null);
        paramList.put(ParameterCode.VIRTUAL_VOLUME_MIRROR_SYNCH_PERCENTAGE_COPIED, null);
        paramList.put(ParameterCode.VIRTUAL_VOLUME_MIRROR_SYNCH_OPER_STATUS, null);
        paramList.put(ParameterCode.VIRTUAL_VOLUME_MIRROR_SYNCH_SRC, null);
        paramList.put(ParameterCode.VOLUME_LAST_UPDATE, null);
        return paramList;
    }

    public void postSendCreateEvent(ConfigElementData myElement) {
        CommKeyClassId[] children = (CommKeyClassId[])myElement.getValue(ParameterCode.VOLUME_CHILDREN);
        HashMap<ParameterCode, Object> parameters = new HashMap<ParameterCode, Object>(2);
        CommKeyClassId myCommKeyClassId = new CommKeyClassId(myElement.getCommKey(), myElement.getClassId());
        parameters.put(ParameterCode.VIRTUAL_VOLUME_PARENT, myCommKeyClassId);
        parameters.put(ParameterCode.VSWITCH_ID, myElement.getValue(ParameterCode.VSWITCH_ID));
        for (int i = 0; i < children.length; ++i) {
            ConfigElementData childElement = new ConfigElementData(children[i].getCommKeys(), children[i].getClassID(), parameters);
            SrEventHandler.getEventMgr().sendChangeElementEvent(childElement);
        }
    }

    protected ConfigElementData createConfigElementFromTableRow(CommVarBindList rowList, char agentIndex) throws SrCommunicationException {
        ConfigElementData element = super.createConfigElementFromTableRow(rowList, agentIndex);
        if (element.getClassId().equals(ClassID.SNAPSHOT_VOLUME)) {
            return new SnapshotVolConfigElementData(element);
        }
        return element;
    }

    protected boolean isFilteredElementForCheckList(CommKeyClassId elementData) {
        return elementData.getClassID().equals(ClassID.SIMPLE_VOLUME);
    }

    public void refreshAll(CommKeyClassId vSwitchData) throws SrCommunicationException {
        char snmpAgentIndex = vSwitchData.getMyFirstSnmpAgentIndex();
        ConfigElementDataList elementsList = this.getAllExtended(snmpAgentIndex, null, null);
        Iterator itr = elementsList.iterator();
        while (itr.hasNext()) {
            ConfigElementData current = (ConfigElementData)itr.next();
            if (!current.getClassId().equals(ClassID.SIMPLE_VOLUME)) continue;
            itr.remove();
            this.sendSimpleVolumeDataInPhysStor(current);
        }
        this.sendRefreshedElementsToEventMgr(elementsList, vSwitchData);
    }

    public ConfigElementDataList getAllExtended(char snmpAgentIndex, SrTimeTicks lastUpdate, CheckListConfigElementData checkListElement) throws SrCommunicationException {
        ConfigElementDataList virtVolList = this.getAll(snmpAgentIndex, lastUpdate, checkListElement);
        if (virtVolList.size() > 0) {
            StripeVolumeConfigurator stripeVolumeConfig = new StripeVolumeConfigurator();
            ConfigElementDataList stripeVolumeList = stripeVolumeConfig.getAll(snmpAgentIndex, lastUpdate, CheckListConfigElementData.NO_CHECK_LIST_NEEDED);
            stripeVolumeConfig.mergeElementLists(virtVolList, stripeVolumeList, true);
            SnapshotVolumeConfigurator snapshotVolumeConfig = new SnapshotVolumeConfigurator();
            ConfigElementDataList snapshotVolumeList = snapshotVolumeConfig.getAll(snmpAgentIndex, lastUpdate, CheckListConfigElementData.NO_CHECK_LIST_NEEDED);
            snapshotVolumeConfig.mergeElementLists(virtVolList, snapshotVolumeList, true);
            JournalVolumeConfigurator journalVolumeConfig = new JournalVolumeConfigurator();
            ConfigElementDataList journalVolumeList = journalVolumeConfig.getAll(snmpAgentIndex, lastUpdate, CheckListConfigElementData.NO_CHECK_LIST_NEEDED);
            journalVolumeConfig.mergeElementLists(virtVolList, journalVolumeList, true);
        }
        return virtVolList;
    }

    protected void internalReadExtentionTable(ConfigElementData element, ConfigElementDataList retrievedElements) throws SrCommunicationException {
        ClassID virtVolClassId = element.getClassId();
        SnmpCommKey virtVolumeCommKey = element.getSnmpKey();
        ConfigElementData newElement = new ConfigElementData(virtVolumeCommKey, virtVolClassId);
        if (virtVolClassId.equals(ClassID.STRIPE_VOLUME)) {
            StripeVolumeConfigurator stripeVolumeConfigurator = new StripeVolumeConfigurator();
            stripeVolumeConfigurator.internalRead(newElement);
        } else if (virtVolClassId.equals(ClassID.SNAPSHOT_VOLUME)) {
            SnapshotVolumeConfigurator snapshotVolumeConfigurator = new SnapshotVolumeConfigurator();
            snapshotVolumeConfigurator.internalRead(newElement);
        } else if (virtVolClassId.equals(ClassID.JOURNAL_VOLUME)) {
            JournalVolumeConfigurator journalVolumeConfigurator = new JournalVolumeConfigurator();
            journalVolumeConfigurator.internalRead(newElement);
        }
        if (!virtVolClassId.equals(ClassID.SIMPLE_VOLUME)) {
            element.addParameter(newElement.getParametersList());
        }
        if (retrievedElements != null && !retrievedElements.contains(element)) {
            retrievedElements.add(element);
        }
    }

    public void refreshElement(ConfigElementData element, ConfigElementDataList retrievedElementsList) throws SrCommunicationException {
        this.internalRead(element, retrievedElementsList);
        if (element.getClassId().equals(ClassID.SIMPLE_VOLUME)) {
            this.sendSimpleVolumeDataInPhysStor(element);
        }
    }

    public void sendSimpleVolumeDataInPhysStor(ConfigElementData simpleVol) throws SrCommunicationException {
        String volIndex = simpleVol.getSnmpKey().getKey();
        CommKeyClassId parentVol = (CommKeyClassId)simpleVol.getValue(ParameterCode.VIRTUAL_VOLUME_PARENT);
        if (parentVol != null) {
            String parentIndex = parentVol.getCommKeys()[0].getKey();
            String parentChildIndex = parentIndex + volIndex.substring(volIndex.indexOf("."));
            SrOid positionOid = new SrOid(MibItem.VIRTUAL_VOLUME_CHILDREN_POSITION.toString(), parentChildIndex);
            SrSnmpVarBind positionVb = new SrSnmpVarBind(positionOid, null);
            CommVarBindList vbList = new CommVarBindList();
            vbList.add(positionVb);
            char snmpAgentIndex = simpleVol.getMyFirstSnmpAgentIndex();
            CommMgr.getInstance(snmpAgentIndex).getList(vbList, snmpAgentIndex);
            int index = vbList.indexOf(positionVb);
            SrInteger position = (SrInteger)((SrSnmpVarBind)vbList.elementAt(index)).getValue();
            simpleVol.setValue(ParameterCode.VOLUME_POSITION, position);
        }
        char agentIndex = simpleVol.getSnmpAgentFromParameter();
        CommKeyClassId physStorData = DiscoverMgr.getInstance().getPhysStorOfVolId(volIndex, agentIndex);
        if (physStorData != null) {
            ConfigElementData physStor = new ConfigElementData(physStorData.getCommKeys(), physStorData.getClassID());
            physStor.setValue(ParameterCode.VOLUME_STATE, (SrType)simpleVol.getValue(ParameterCode.VOLUME_STATE));
            physStor.setValue(ParameterCode.VSWITCH_ID, (SrType)simpleVol.getValue(ParameterCode.VSWITCH_ID));
            physStor.setValue(ParameterCode.VIRTUAL_VOLUME_PARENT, (SrType)simpleVol.getValue(ParameterCode.VIRTUAL_VOLUME_PARENT));
            physStor.setValue(ParameterCode.VOLUME_POSITION, (SrType)simpleVol.getValue(ParameterCode.VOLUME_POSITION));
            LogMgr.getServerLog().debug("Update Simple Volume State in PhysStor. Vol: " + volIndex + physStorData);
            SrEventHandler.getEventMgr().sendChangeElementEvent(physStor);
        } else {
            LogMgr.getServerLog().debug("Failed to find physStor for volume: " + volIndex + " in VolumeConfigurator::sendSimpleVolumeDataInPhysStor()");
        }
    }
}

