/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.volume;

import com.sanrad.nms.server.comm.CommMgr;
import com.sanrad.nms.server.comm.CommVarBind;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrTimeTicks;
import java.util.HashMap;

public class VolumeChildrenConfigurator
extends ElementConfigurator {
    public VolumeChildrenConfigurator() {
        super(ClassID.GENERAL_VOLUME, "srVirtVolChildrenTable", MibItem.VIRTUAL_VOLUME_CHILDREN_RS, MibItem.VIRTUAL_VOLUME_CHILDREN_TBL_LAST_UPDATE);
    }

    public HashMap getListOfParams() {
        return null;
    }

    public Object[][] getAllForRebuild(char agentIndex, SrTimeTicks lastUpdate) throws SrCommunicationException {
        SrTimeTicks lastUpdateVal = lastUpdate;
        if (lastUpdateVal == null) {
            lastUpdateVal = (SrTimeTicks)this.getScalarFromComm(this.myLastUpdateMib, agentIndex);
        }
        CommMgr commMgr = CommMgr.getInstance(agentIndex);
        CommVarBindList[] volumeChildren = commMgr.getAll(this.myTableName, agentIndex);
        if (this.myLastUpdateMib != null) {
            SrTimeTicks newLastUpdateVal = (SrTimeTicks)this.getScalarFromComm(this.myLastUpdateMib, agentIndex);
            while (lastUpdateVal != null && newLastUpdateVal != null && !lastUpdateVal.equals(newLastUpdateVal)) {
                lastUpdateVal = newLastUpdateVal;
                volumeChildren = commMgr.getAll(this.myTableName, agentIndex);
                newLastUpdateVal = (SrTimeTicks)this.getScalarFromComm(this.myLastUpdateMib, agentIndex);
            }
        }
        Object[][] parentChildVolumesData = new Object[volumeChildren.length][3];
        for (int i = 0; i < volumeChildren.length; ++i) {
            String keyStr = ((CommVarBind)volumeChildren[i].elementAt(0)).getIndexForCommKey();
            String childId = keyStr.substring(keyStr.lastIndexOf(".") + 1);
            String parentId = keyStr.substring(keyStr.indexOf(".") + 1, keyStr.lastIndexOf("."));
            SrInteger position = (SrInteger)this.getVarBindValueFromList(volumeChildren[i], MibItem.VIRTUAL_VOLUME_CHILDREN_POSITION);
            parentChildVolumesData[i][0] = new String(parentId);
            parentChildVolumesData[i][1] = new String(childId);
            parentChildVolumesData[i][2] = position;
        }
        return parentChildVolumesData;
    }
}

