/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.volume;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.comm.CommMgr;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.comm.snmp.SrOid;
import com.sanrad.nms.server.comm.snmp.SrSnmpVarBind;
import com.sanrad.nms.server.comm.snmp.exception.SrSnmpTimeoutException;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.exception.MissingValueException;
import com.sanrad.nms.server.exception.SrElementOperationErrorException;
import com.sanrad.nms.server.exception.SrElementOperationException;
import com.sanrad.nms.server.mgr.CheckListConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementDataList;
import com.sanrad.nms.server.mgr.volume.VolumeConfigurator;
import com.sanrad.nms.server.mgr.volume.VolumeOperationConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.RowStatusConstants;
import com.sanrad.nms.server.util.types.constants.VolumeTypeConstants;

public class VirtualVolumeConfigurator
extends VolumeConfigurator {
    protected VirtualVolumeConfigurator(ClassID classId, String tableName, MibItem rs, VolumeTypeConstants volType) {
        super(classId, tableName, rs, volType);
    }

    protected VirtualVolumeConfigurator(ClassID classId, String tableName, MibItem rs, MibItem lastUpdateMib, VolumeTypeConstants volType) {
        super(classId, tableName, rs, lastUpdateMib, volType);
    }

    public void internalCreate(ConfigElementData element) throws SrCommunicationException, SrElementOperationException {
        this.updateCedAfterCreate(element);
        CommKey[][] allChildrenCommKey = this.createVolumeNoAttachVolume(element);
        if (allChildrenCommKey != null) {
            this.attachVolumeToChildren(element, allChildrenCommKey);
            CommKeyClassId[] children = (CommKeyClassId[])element.getValue(ParameterCode.VOLUME_CHILDREN);
            this.readVolumePosition(children, element.getCommKeyClassId());
        }
    }

    protected CommKey[][] createVolumeNoAttachVolume(ConfigElementData element) throws SrCommunicationException, SrElementOperationException {
        char snmpAgentIndex = element.getSnmpAgentFromParameter();
        CommKeyClassId[] children = (CommKeyClassId[])element.getValue(ParameterCode.VOLUME_CHILDREN);
        CommKey[][] allChildrenCommKey = null;
        if (children != null) {
            int child;
            for (int i = 0; i < children.length; ++i) {
                SnmpCommKey snmpKey = CommKeyUtil.getSpecificSnmpKey(children[i].getCommKeys(), snmpAgentIndex);
                if (snmpKey != null) continue;
                throw new MissingValueException(element.getClassId().toString() + " Create - Missing Data of Children for Agent: " + CommKeyUtil.getIpFromIndex(snmpAgentIndex));
            }
            allChildrenCommKey = new CommKey[children.length][];
            CommKeyClassId vSwithcData = (CommKeyClassId)element.getValue(ParameterCode.VSWITCH_ID);
            boolean error = false;
            SrCommunicationException commExp = null;
            for (child = 0; child < children.length && !error; ++child) {
                if (children[child].getClassID().equals(ClassID.DIRECT_ACCESS_DEVICE) || children[child].getClassID().equals(ClassID.SUB_DIRECT_ACCESS_DEVICE)) {
                    try {
                        allChildrenCommKey[child] = this.createSimpleVolume(children[child], vSwithcData);
                        continue;
                    }
                    catch (SrSnmpTimeoutException te) {
                        LogMgr.getServerLog().error(te.getMessage());
                        throw te;
                    }
                    catch (SrCommunicationException ce) {
                        LogMgr.getServerLog().debug(ce);
                        error = true;
                        commExp = ce;
                        break;
                    }
                }
                allChildrenCommKey[child] = children[child].getCommKeys();
            }
            if (error) {
                this.removeMySimpleVolumeChildren(children, snmpAgentIndex, child);
                throw commExp;
            }
        }
        try {
            super.internalCreate(element);
        }
        catch (SrElementOperationErrorException errEx) {
            LogMgr.getServerLog().debug(errEx);
            throw errEx;
        }
        catch (SrSnmpTimeoutException te) {
            LogMgr.getServerLog().error(te.getMessage());
            throw te;
        }
        catch (SrCommunicationException ex) {
            this.removeMySimpleVolumeChildren(children, element.getMyFirstSnmpAgentIndex(), -1);
            LogMgr.getServerLog().debug(ex);
            throw ex;
        }
        return allChildrenCommKey;
    }

    protected void attachVolumeToChildren(ConfigElementData element, CommKey[][] childrenData) throws SrCommunicationException {
        SnmpCommKey parentKey = element.getSnmpKey();
        String parentIndex = parentKey.toString();
        String allChildrenIds = "";
        CommVarBindList newChildrenList = new CommVarBindList();
        char snmpAgentIndex = element.getMyFirstSnmpAgentIndex();
        for (int i = 0; i < childrenData.length; ++i) {
            SnmpCommKey snmpKey = CommKeyUtil.getSpecificSnmpKey(childrenData[i], snmpAgentIndex);
            String childIndex = snmpKey.toString();
            allChildrenIds = allChildrenIds + childIndex + " ; ";
            String childId = childIndex.substring(childIndex.indexOf("."));
            SrOid oid = new SrOid(MibItem.VIRTUAL_VOLUME_CHILDREN_RS.toString(), parentIndex + childId);
            newChildrenList.add(new SrSnmpVarBind(oid, (SrType)RowStatusConstants.ROW_STATUS_CREATE_AND_GO));
        }
        try {
            CommMgr.getInstance(snmpAgentIndex).setList(newChildrenList, snmpAgentIndex);
        }
        catch (SrSnmpTimeoutException e) {
            e.setElement(element);
            LogMgr.getServerLog().error(e.getMessage());
            throw e;
        }
        catch (SrCommunicationException e) {
            LogMgr.getServerLog().error("Failed to attach volume to children: " + element.toString(), e);
            e.setElement(element);
            CommKeyClassId[] children = (CommKeyClassId[])element.getValue(ParameterCode.VOLUME_CHILDREN);
            this.internalRemove(element);
            this.removeMySimpleVolumeChildren(children, snmpAgentIndex, -1);
            throw e;
        }
    }

    public void internalRemove(ConfigElementData element) throws SrCommunicationException {
        CommKeyClassId[] children = (CommKeyClassId[])element.getValue(ParameterCode.VOLUME_CHILDREN);
        super.internalRemove(element);
        if (children != null) {
            ConfigElementDataList childrenData = new ConfigElementDataList();
            CommKeyClassId vSwitchData = (CommKeyClassId)element.getValue(ParameterCode.VSWITCH_ID);
            for (int i = 0; i < children.length; ++i) {
                ConfigElementData child = new ConfigElementData(children[i]);
                child.setValue(ParameterCode.VSWITCH_ID, vSwitchData);
                child.setValue(ParameterCode.VOLUME_POSITION, (SrType)null);
                childrenData.add(child);
            }
            SrEventHandler.getEventMgr().sendChangeElementEvent(childrenData);
            this.removeMySimpleVolumeChildren(children, element.getMyFirstSnmpAgentIndex(), -1);
        }
        VolumeOperationConfigurator volumeOperCfg = new VolumeOperationConfigurator();
        volumeOperCfg.refreshTable(element.getMyFirstSnmpAgentIndex(), null, new CheckListConfigElementData(ClassID.COPY_OPERATION));
    }

    protected void removeMySimpleVolumeChildren(CommKeyClassId[] children, char agentIndex, int endIndex) {
        int lastIndexToRemove = endIndex;
        if (children != null && (endIndex > children.length || endIndex < 0)) {
            lastIndexToRemove = children.length;
        }
        for (int i = 0; i < lastIndexToRemove; ++i) {
            CommKeyClassId child = children[i];
            try {
                this.removeSimpleVolume(child, agentIndex);
                continue;
            }
            catch (SrCommunicationException e) {
                LogMgr.getServerLog().debug(e);
            }
        }
    }

    protected void internalReadExtentionTable(ConfigElementData element, ConfigElementDataList retrievedElements) throws SrCommunicationException {
    }
}

