/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.volume;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.comm.CommMgr;
import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.comm.snmp.SrOid;
import com.sanrad.nms.server.comm.snmp.SrSnmpVarBind;
import com.sanrad.nms.server.exception.MissingValueException;
import com.sanrad.nms.server.exception.SrElementOperationException;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.volume.VirtualVolumeConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.VolumeTypeConstants;
import java.util.HashMap;

public class StripeVolumeConfigurator
extends VirtualVolumeConfigurator {
    public StripeVolumeConfigurator() {
        super(ClassID.STRIPE_VOLUME, "srVirtVolSpecStrippedTable", MibItem.VIRTUAL_VOLUME_RS, VolumeTypeConstants.VOLUME_TYPE_STRIPE);
    }

    public void internalCreate(ConfigElementData element) throws SrCommunicationException, SrElementOperationException {
        this.updateCedAfterCreate(element);
        Object stripSize = element.getValue(ParameterCode.VIRTUAL_VOLUME_STRIPE_SIZE);
        if (stripSize == null) {
            throw new MissingValueException("Stripe Size is missing for the new volume");
        }
        element.removeParameter(ParameterCode.VIRTUAL_VOLUME_STRIPE_SIZE);
        CommKey[][] allChildrenCommKey = this.createVolumeNoAttachVolume(element);
        element.addParameter(new Parameter(ParameterCode.VIRTUAL_VOLUME_STRIPE_SIZE, stripSize));
        SnmpCommKey volumeKey = element.getSnmpKey();
        SrOid stripOid = new SrOid(MibItem.VIRTUAL_VOLUME_STRIPE_SIZE.toString(), volumeKey.toString());
        SrSnmpVarBind stripeVarBind = new SrSnmpVarBind(stripOid, (SrType)stripSize);
        try {
            CommMgr.getInstance(element.getMyFirstSnmpAgentIndex()).set(stripeVarBind, element.getMyFirstSnmpAgentIndex());
        }
        catch (SrCommunicationException e) {
            LogMgr.getServerLog().error("Failed to set Strip Size to Volume " + volumeKey.toDisplayString(), e);
            super.internalRemove(element);
            throw e;
        }
        this.attachVolumeToChildren(element, allChildrenCommKey);
        CommKeyClassId[] children = (CommKeyClassId[])element.getValue(ParameterCode.VOLUME_CHILDREN);
        this.readVolumePosition(children, element.getCommKeyClassId());
    }

    public HashMap getListOfParams() {
        HashMap paramList = super.getListOfParams();
        paramList.put(ParameterCode.VIRTUAL_VOLUME_STRIPE_SIZE, null);
        return paramList;
    }
}

